/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.sdmlib.models.classes.ClassModel;
import org.sdmlib.models.classes.Enumeration;
import org.sdmlib.models.classes.Method;
import org.sdmlib.models.classes.util.ArrayListSet;
import org.sdmlib.models.classes.util.ClassModelSet;
import org.sdmlib.models.classes.util.EnumerationPO;
import org.sdmlib.models.classes.util.MethodSet;
import org.sdmlib.models.modelsets.ObjectSet;
import org.sdmlib.models.modelsets.SDMSet;
import org.sdmlib.models.modelsets.StringList;

public class EnumerationSet
extends SDMSet<Enumeration> {
    public static final EnumerationSet EMPTY_SET = (EnumerationSet)new EnumerationSet().withReadOnly(true);

    public EnumerationPO hasEnumerationPO() {
        return new EnumerationPO((Enumeration[])this.toArray(new Enumeration[this.size()]));
    }

    @Override
    public String getEntryType() {
        return "org.sdmlib.models.classes.Enumeration";
    }

    public EnumerationSet with(Object value) {
        if (value instanceof Collection) {
            this.addAll((Collection)value);
        } else if (value != null) {
            this.add((Enumeration)value);
        }
        return this;
    }

    public EnumerationSet without(Enumeration value) {
        this.remove(value);
        return this;
    }

    public ArrayListSet getValueNames() {
        ArrayListSet result = new ArrayListSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Enumeration obj = (Enumeration)iterator.next();
            result.addAll((Collection)((Object)obj.getValueNames()));
        }
        return result;
    }

    public EnumerationSet hasValueNames(ArrayListSet value) {
        EnumerationSet result = new EnumerationSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Enumeration obj = (Enumeration)iterator.next();
            if (value != obj.getValueNames()) continue;
            result.add(obj);
        }
        return result;
    }

    public EnumerationSet withValueNames(ArrayListSet value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Enumeration obj = (Enumeration)iterator.next();
            obj.setValueNames(value);
        }
        return this;
    }

    public StringList getName() {
        StringList result = new StringList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Enumeration obj = (Enumeration)iterator.next();
            result.add(obj.getName());
        }
        return result;
    }

    public EnumerationSet hasName(String value) {
        EnumerationSet result = new EnumerationSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Enumeration obj = (Enumeration)iterator.next();
            if (!value.equals(obj.getName())) continue;
            result.add(obj);
        }
        return result;
    }

    public EnumerationSet hasName(String lower, String upper) {
        EnumerationSet result = new EnumerationSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Enumeration obj = (Enumeration)iterator.next();
            if (lower.compareTo(obj.getName()) > 0 || obj.getName().compareTo(upper) > 0) continue;
            result.add(obj);
        }
        return result;
    }

    public EnumerationSet withName(String value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Enumeration obj = (Enumeration)iterator.next();
            obj.withName(value);
        }
        return this;
    }

    public ClassModelSet getClassModel() {
        ClassModelSet result = new ClassModelSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Enumeration obj = (Enumeration)iterator.next();
            result.add(obj.getClassModel());
        }
        return result;
    }

    public EnumerationSet hasClassModel(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        EnumerationSet answer = new EnumerationSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Enumeration obj = (Enumeration)iterator.next();
            if (!neighbors.contains(obj.getClassModel())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public EnumerationSet withClassModel(ClassModel value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Enumeration obj = (Enumeration)iterator.next();
            obj.withClassModel(value);
        }
        return this;
    }

    public MethodSet getMethods() {
        MethodSet result = new MethodSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Enumeration obj = (Enumeration)iterator.next();
            result.addAll((Collection)((Object)obj.getMethods()));
        }
        return result;
    }

    public EnumerationSet hasMethods(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        EnumerationSet answer = new EnumerationSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Enumeration obj = (Enumeration)iterator.next();
            if (Collections.disjoint(neighbors, obj.getMethods())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public EnumerationSet withMethods(Method value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Enumeration obj = (Enumeration)iterator.next();
            obj.withMethods(value);
        }
        return this;
    }

    public EnumerationSet withoutMethods(Method value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Enumeration obj = (Enumeration)iterator.next();
            obj.withoutMethods(value);
        }
        return this;
    }
}

