/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes.logic;

import java.util.Iterator;
import java.util.LinkedHashSet;
import org.sdmlib.CGUtil;
import org.sdmlib.codegen.Parser;
import org.sdmlib.codegen.SymTabEntry;
import org.sdmlib.models.classes.Annotation;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.Enumeration;
import org.sdmlib.models.classes.Method;
import org.sdmlib.models.classes.Visibility;
import org.sdmlib.models.classes.logic.GenClass;
import org.sdmlib.models.classes.logic.GenEnumeration;
import org.sdmlib.models.classes.logic.Generator;

public class GenMethod
extends Generator<Method> {
    public GenMethod generate(Clazz clazz, String rootDir, String helpersDir) {
        GenClass generator = clazz.getClassModel().getGenerator().getOrCreate(clazz);
        Parser parser = clazz.getClassModel().getGenerator().getOrCreate(clazz).getOrCreateParser(rootDir);
        this.insertMethodDecl(clazz, parser);
        Iterator iterator = ((Method)this.model).getAnnotations().iterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            this.getGenerator(annotation).generate(rootDir, helpersDir);
        }
        Parser modelSetParser = generator.getOrCreateParserForModelSetFile(helpersDir);
        this.insertMethodInModelSet(clazz, modelSetParser);
        generator.printFile(modelSetParser);
        Parser patternObjectParser = generator.getOrCreateParserForPatternObjectFile(helpersDir);
        this.insertMethodInPatternObject(clazz, patternObjectParser);
        generator.printFile(patternObjectParser);
        return this;
    }

    public GenMethod generate(Enumeration enumeration, String rootDir, String helpersDir) {
        GenEnumeration genEnumeration = enumeration.getClassModel().getGenerator().getOrCreate(enumeration);
        Parser parser = genEnumeration.getOrCreateParser(rootDir);
        this.insertMethodDecl(enumeration, parser);
        return this;
    }

    private void insertMethodDecl(Enumeration enumeration, Parser parser) {
        String signature = ((Method)this.model).getSignature(false);
        int pos = parser.indexOf("method:" + signature);
        String string = "method:" + signature;
        SymTabEntry symTabEntry = (SymTabEntry)parser.getSymTab().get((Object)string);
        enumeration.getClassModel().getGenerator().getOrCreate(enumeration);
        if (pos < 0) {
            signature = ((Method)this.model).getSignature(true);
            StringBuilder text = new StringBuilder("\n   \n   //==========================================================================\n   modifiers returnType mehodName( parameter )");
            text.append("\n   {\n      returnClause\n   }\n");
            String methodName = signature.substring(0, signature.indexOf("("));
            String parameter = signature.substring(signature.indexOf("(") + 1, signature.indexOf(")"));
            String returnClause = "";
            returnClause = "int float double".indexOf(((Method)this.model).getReturnType().getValue()) >= 0 ? "return 0;" : ("void".indexOf(((Method)this.model).getReturnType().getValue()) >= 0 ? "" : "return null;");
            String returnType = ((Method)this.model).getReturnType().getValue();
            if (returnType.contains(".")) {
                returnType = returnType.substring(returnType.lastIndexOf(".") + 1);
            }
            CGUtil.replaceAll(text, "modifiers", ((Method)this.model).getModifier().getValue(), "returnType", returnType, "mehodName", methodName, "parameter", parameter, "returnClause", returnClause);
            pos = parser.indexOf("classEnd");
            parser.insert(pos, text.toString());
        }
        String signatureSimple = ((Method)this.model).getSignature(false);
        pos = parser.indexOf("method:" + signatureSimple);
        symTabEntry = (SymTabEntry)parser.getSymTab().get((Object)string);
        if (pos >= 0 && ((Method)this.model).getBody() != null) {
            parser.parseMethodBody(symTabEntry);
            int startPos = symTabEntry.getEndPos();
            parser.replace(symTabEntry.getBodyStartPos() + 1, startPos, "\n" + ((Method)this.model).getBody() + "   ");
            pos = -1;
        }
    }

    private void insertMethodDecl(Clazz clazz, Parser parser) {
        String signature = ((Method)this.model).getSignature(false);
        int pos = parser.indexOf("method:" + signature);
        String string = "method:" + signature;
        SymTabEntry symTabEntry = (SymTabEntry)parser.getSymTab().get((Object)string);
        clazz.getClassModel().getGenerator().getOrCreate(clazz);
        if (pos < 0) {
            signature = ((Method)this.model).getSignature(true);
            StringBuilder text = new StringBuilder("\n   \n   //==========================================================================\n   modifiers returnType mehodName( parameter )");
            if (clazz.isInterface() || ((Method)this.model).getModifier().has(Visibility.ABSTRACT)) {
                text.append(";\n");
            } else {
                text.append("\n   {\n      returnClause\n   }\n");
            }
            String methodName = signature.substring(0, signature.indexOf("("));
            String parameter = signature.substring(signature.indexOf("(") + 1, signature.indexOf(")"));
            String returnClause = "";
            returnClause = "int float double".indexOf(((Method)this.model).getReturnType().getValue()) >= 0 ? "return 0;" : ("boolean".indexOf(((Method)this.model).getReturnType().getValue()) >= 0 ? "return false;" : ("void".indexOf(((Method)this.model).getReturnType().getValue()) >= 0 ? "" : "return null;"));
            String returnType = ((Method)this.model).getReturnType().getValue();
            if (returnType.contains(".")) {
                returnType = returnType.substring(returnType.lastIndexOf(".") + 1);
            }
            CGUtil.replaceAll(text, "modifiers", ((Method)this.model).getModifier().getValue(), "returnType", returnType, "mehodName", methodName, "parameter", parameter, "returnClause", returnClause);
            pos = parser.indexOf("classEnd");
            parser.insert(pos, text.toString());
        }
        String signatureSimple = ((Method)this.model).getSignature(false);
        pos = parser.indexOf("method:" + signatureSimple);
        symTabEntry = (SymTabEntry)parser.getSymTab().get((Object)string);
        if (pos >= 0 && ((Method)this.model).getBody() != null) {
            parser.parseMethodBody(symTabEntry);
            int startPos = symTabEntry.getEndPos();
            parser.replace(symTabEntry.getBodyStartPos() + 1, startPos, "\n" + ((Method)this.model).getBody() + "   ");
            pos = -1;
        }
    }

    public void generate(String rootDir, String helpersDir) {
        if (((Method)this.model).getClazz() != null) {
            this.generate(((Method)this.model).getClazz(), rootDir, helpersDir);
        }
        if (((Method)this.model).getEnumeration() != null) {
            this.generate(((Method)this.model).getEnumeration(), rootDir, helpersDir);
        }
    }

    private void insertMethodInModelSet(Clazz clazz2, Parser parser) {
        if (parser == null) {
            return;
        }
        String signature = ((Method)this.model).getSignature(false);
        int pos = parser.indexOf("method:" + signature);
        if (pos < 0 && ((Method)this.model).getModifier().has(Visibility.PUBLIC)) {
            signature = ((Method)this.model).getSignature(true);
            StringBuilder text = new StringBuilder("   \n   //==========================================================================\n   \n   modifiers returnType methodName(formalParameter)\n   {\n      returnSetCreate\n      for (memberType obj : this)\n      {\n         returnSetAdd obj.methodName(actualParameter) returnSetAddEnd;\n      }\n      returnStat\n   }\n\n");
            String methodName = signature.substring(0, signature.indexOf("("));
            String parameterSig = signature.substring(signature.indexOf("(") + 1, signature.indexOf(")"));
            String formalParameter = "";
            String actualParameter = "";
            String[] parameters = parameterSig.split("\\s*,\\s*");
            if (parameters.length != 1 || !parameters[0].isEmpty()) {
                for (int i = 0; i < parameters.length; ++i) {
                    String[] item = parameters[i].split(" ");
                    formalParameter = formalParameter + item[0] + " " + item[1];
                    actualParameter = actualParameter + item[1];
                    if (i + 1 >= parameters.length) continue;
                    formalParameter = formalParameter + ", ";
                    actualParameter = actualParameter + ", ";
                }
            }
            String returnSetCreate = "";
            String returnSetAdd = "";
            String returnSetAddEnd = "";
            String returnStat = "return this;";
            String type = ((Method)this.model).getReturnType().getValue();
            if (type == null) {
                type = "void";
            }
            if (type.endsWith("[]")) {
                type = type.substring(0, type.length() - 2);
            }
            String importType = type;
            GenClass generator = ((Method)this.model).getClazz().getClassModel().getGenerator().getOrCreate(((Method)this.model).getClazz());
            if ("void".equals(type)) {
                type = CGUtil.shortClassName(clazz2.getFullName()) + "Set";
            } else {
                if ("String int double long boolean".indexOf(type) >= 0) {
                    type = type + "List";
                    importType = "org.sdmlib.models.modelsets." + type;
                } else if ("Object".indexOf(type) >= 0) {
                    type = "LinkedHashSet<Object>";
                    importType = LinkedHashSet.class.getName();
                } else {
                    type = type + "Set";
                    importType = ((Method)this.model).getClazz().getFullName();
                    int dotpos = importType.lastIndexOf(46);
                    int typePos = type.lastIndexOf(46);
                    type = type.substring(typePos + 1);
                    importType = importType.substring(0, dotpos) + ".util" + "." + type;
                }
                generator.insertImport(parser, importType);
                returnSetCreate = type + " result = new " + type + "();\n      ";
                returnSetAdd = "result.add(";
                returnSetAddEnd = ")";
                returnStat = "return result;";
            }
            if (((Method)this.model).getModifier().has(Visibility.STATIC)) {
                returnStat = "";
            }
            CGUtil.replaceAll(text, "returnSetCreate\n      ", returnSetCreate, "returnSetAdd ", returnSetAdd, " returnSetAddEnd", returnSetAddEnd, "returnStat", returnStat, "modifiers", ((Method)this.model).getModifier().getValue(), "returnType", type, "methodName", methodName, "memberType", CGUtil.shortClassName(clazz2.getFullName()), "formalParameter", formalParameter, "actualParameter", actualParameter);
            pos = parser.indexOf("classEnd");
            parser.insert(pos, text.toString());
        }
    }

    private void insertMethodInPatternObject(Clazz clazz2, Parser parser) {
        if (parser == null) {
            return;
        }
        String signature = ((Method)this.model).getSignature(false);
        String key = "method:" + signature;
        int pos = parser.indexOf(key);
        if (pos < 0 && ((Method)this.model).getModifier().has(Visibility.PUBLIC)) {
            signature = ((Method)this.model).getSignature(true);
            StringBuilder text = new StringBuilder("   \n   //==========================================================================\n   \n   public returnType methodName(formalParameter)\n   {\n      if (this.getPattern().getHasMatch())\n      {\n         returnStart ((memberType) getCurrentMatch()).methodName(actualParameter);\n      }\n      returnStat\n   }\n\n");
            String methodName = signature.substring(0, signature.indexOf("("));
            String parameterSig = signature.substring(signature.indexOf("(") + 1, signature.indexOf(")"));
            String formalParameter = "";
            String actualParameter = "";
            String[] parameters = parameterSig.split("\\s*,\\s*");
            if (parameters.length != 1 || !parameters[0].isEmpty()) {
                for (int i = 0; i < parameters.length; ++i) {
                    String[] item = parameters[i].split(" ");
                    formalParameter = formalParameter + item[0] + " " + item[1];
                    actualParameter = actualParameter + item[1];
                    if (i + 1 >= parameters.length) continue;
                    formalParameter = formalParameter + ", ";
                    actualParameter = actualParameter + ", ";
                }
            }
            String returnStart = "";
            String returnStat = "";
            String type = ((Method)this.model).getReturnType().getValue();
            if (type == null) {
                type = "void";
            }
            if (type.endsWith("[]")) {
                type = type.substring(0, type.length() - 2);
            }
            String importType = type;
            GenClass generator = ((Method)this.model).getClazz().getClassModel().getGenerator().getOrCreate(((Method)this.model).getClazz());
            if ("Object".indexOf(type) < 0) {
                generator.insertImport(parser, importType);
            }
            if (!"void".equals(type)) {
                returnStart = "return";
                returnStat = "int double float".indexOf(type) >= 0 ? "      return 0;\n" : ("boolean".equals(type) ? "      return false;\n" : "      return null;\n");
            }
            CGUtil.replaceAll(text, "returnSetCreate\n      ", returnStart, "returnStart", returnStart, "      returnStat\n", returnStat, "returnType", type, "methodName", methodName, "memberType", CGUtil.shortClassName(clazz2.getFullName()), "formalParameter", formalParameter, "actualParameter", actualParameter);
            pos = parser.indexOf("classEnd");
            parser.insert(pos, text.toString());
        }
    }
}

