/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes.logic;

import de.uniks.networkparser.json.JsonIdMap;
import java.io.File;
import java.util.Iterator;
import org.sdmlib.CGUtil;
import org.sdmlib.codegen.Parser;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.Feature;
import org.sdmlib.models.classes.logic.GenClass;
import org.sdmlib.models.classes.logic.GenClassModel;

public class GenFactory {
    public Parser getOrCreateFactoryFactoryParser(GenClassModel genClassModel, String rootDir) {
        if (!genClassModel.getModel().getClasses().isEmpty() && genClassModel.creatorCreatorParser == null && genClassModel.model.getName() != null && genClassModel.getModel().hasFeature(Feature.Serialization)) {
            String creatorCreatorClassName;
            String packageName = genClassModel.getModel().getName();
            packageName = packageName + ".util";
            String fileName = creatorCreatorClassName = packageName + ".CreatorCreator";
            fileName = fileName.replaceAll("\\.", "/");
            fileName = rootDir + "/" + fileName + ".java";
            File javaFile = new File(fileName);
            genClassModel.creatorCreatorParser = new Parser().withFileName(fileName);
            if (javaFile.exists()) {
                genClassModel.creatorCreatorParser.withFileBody(CGUtil.readFile(javaFile));
            } else {
                StringBuilder text = new StringBuilder("package packageName;\n\nimport " + JsonIdMap.class.getName() + ";\n" + "import org.sdmlib.serialization.SDMLibJsonIdMap;\n" + "\n" + "class className{\n" + "\n" + "   public static JsonIdMap createIdMap(String sessionID)\n" + "   {\n" + "      JsonIdMap jsonIdMap = (JsonIdMap) new SDMLibJsonIdMap().withSessionId(sessionID);\n" + "      \n" + "JSONCREATORS\n" + "      return jsonIdMap;\n" + "   }\n" + "}\n");
                StringBuilder creators = new StringBuilder();
                Iterator iterator = genClassModel.model.getClasses().iterator();
                while (iterator.hasNext()) {
                    Clazz clazz = (Clazz)iterator.next();
                    if (clazz.isInterface() || clazz.isEnumeration() || !clazz.hasFeature(Feature.Serialization)) continue;
                    String creatorName = "";
                    if (clazz.isExternal()) {
                        GenClass genClass;
                        Parser creatorClassParser;
                        String string;
                        String alternativeFilePath;
                        creatorName = genClassModel.model.getName() + ".util" + "." + CGUtil.shortClassName(clazz.getFullName());
                        if (!creatorName.equals(alternativeFilePath = (string = (creatorClassParser = (genClass = genClassModel.getOrCreate(clazz)).getOrCreateParserForCreatorClass(rootDir)).getFileName()).substring(rootDir.length() + 1, string.length() - "Creator.java".length()).replaceAll("/", "."))) {
                            creatorName = alternativeFilePath;
                        }
                    } else {
                        creatorName = CGUtil.packageName(clazz.getFullName()) + ".util" + "." + CGUtil.shortClassName(clazz.getFullName());
                    }
                    creators.append("      jsonIdMap.withCreator(new " + creatorName + "Creator());\n");
                    if (clazz.hasFeature(Feature.PatternObject)) {
                        creators.append("      jsonIdMap.withCreator(new " + creatorName + "POCreator());\n");
                    }
                    if (genClassModel.model.getName().equals(CGUtil.packageName(clazz.getFullName()))) continue;
                }
                CGUtil.replaceAll(text, "class className", "public class className");
                CGUtil.replaceAll(text, "className", CGUtil.shortClassName(creatorCreatorClassName), "packageName", packageName, "JSONCREATORS", creators.toString());
                genClassModel.creatorCreatorParser.withFileBody(text).withFileChanged(true);
            }
            Iterator iterator = genClassModel.getModel().getClasses().iterator();
            while (iterator.hasNext()) {
                Clazz clazz = (Clazz)iterator.next();
                if (clazz.isInterface() || clazz.isExternal() || !clazz.hasFeature(Feature.Serialization) || clazz.isEnumeration()) continue;
                genClassModel.genFactory.insertCreatorClassInFactoryFactory(genClassModel.creatorCreatorParser, clazz);
            }
            if (genClassModel.getShowDiff() == GenClassModel.DIFF.NONE) {
                CGUtil.printFile(genClassModel.creatorCreatorParser);
            }
        }
        return genClassModel.creatorCreatorParser;
    }

    public void insertCreatorClassInFactoryFactory(Parser ccParser, Clazz clazz) {
        int pos = ccParser.indexOf("method:createIdMap(String)");
        if (pos < 0) {
            System.err.println("Warning: SDMLib codgen for creatorSet initialisation invocation " + clazz.getName() + "Creator for class " + ccParser.getFileName() + ": \nDid not find method getCreatorSet(). Should have been generated by my model. " + "\nCould not add required code fragment there. :( ");
            return;
        }
        int methodBodyStartPos = ccParser.getMethodBodyStartPos();
        String shortCreatorClassName = CGUtil.shortClassName(clazz.getName()) + "Creator";
        String shortCreatorPOClassName = CGUtil.shortClassName(clazz.getName()) + "POCreator";
        String creatorClassName = CGUtil.packageName(clazz.getFullName()) + ".util." + shortCreatorClassName;
        String creatorPOClassName = CGUtil.packageName(clazz.getFullName()) + ".util." + shortCreatorPOClassName;
        pos = ccParser.methodBodyIndexOf("nameToken:" + shortCreatorClassName, methodBodyStartPos);
        if (pos < 0) {
            ccParser.methodBodyIndexOf("methodEnd", methodBodyStartPos);
            int addCreatorPos = ccParser.search("return jsonIdMap;", methodBodyStartPos);
            StringBuilder text = new StringBuilder("jsonIdMap.withCreator(new ClassCreator());\n");
            if (clazz.hasFeature(Feature.PatternObject)) {
                text.append("      jsonIdMap.withCreator(new ClassPOCreator());\n");
            }
            text.append("      ");
            CGUtil.replaceAll(text, "ClassCreator", creatorClassName, "ClassPOCreator", creatorPOClassName);
            ccParser.insert(addCreatorPos, text.toString());
        }
    }
}

