/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes.logic;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.sdmlib.CGUtil;
import org.sdmlib.codegen.LocalVarTableEntry;
import org.sdmlib.codegen.Parser;
import org.sdmlib.codegen.SymTabEntry;
import org.sdmlib.models.classes.ClassModel;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.Enumeration;
import org.sdmlib.models.classes.Method;
import org.sdmlib.models.classes.logic.GenClassModel;
import org.sdmlib.models.classes.logic.Generator;
import org.sdmlib.models.classes.util.ClazzSet;

public class GenEnumeration
extends Generator<Enumeration> {
    private Parser parser = null;

    public void generate(String rootDir, String helpersDir) {
        if (!((Enumeration)this.model).isExternal()) {
            this.getOrCreateParser(rootDir);
            this.insertLicense(this.parser);
            this.insertValues();
            this.insertMethods(rootDir, helpersDir);
            this.printFile(this.parser);
        }
    }

    private void insertMethods(String rootDir, String helpersDir) {
        Iterator iterator = ((Enumeration)this.model).getMethods().iterator();
        while (iterator.hasNext()) {
            String[] array;
            Method method = (Method)iterator.next();
            this.getGenerator(method).generate(rootDir, helpersDir);
            String signature = method.getSignature(false);
            this.parser.parse();
            ArrayList<SymTabEntry> symTabEntries = this.parser.getSymTabEntriesFor(signature);
            if (symTabEntries.size() <= 0) continue;
            SymTabEntry symTabEntry = symTabEntries.get(0);
            this.parser.parseMethodBody(symTabEntry);
            LinkedHashMap<String, LocalVarTableEntry> localVarTable = this.parser.getLocalVarTable();
            for (String key : array = localVarTable.keySet().toArray(new String[0])) {
                LocalVarTableEntry localVarTableEntry = localVarTable.get(key);
                if (localVarTableEntry == null) continue;
                String type = localVarTableEntry.getType();
                ClazzSet classes = ((Enumeration)this.getModel()).getClassModel().getClasses();
                Iterator iterator2 = classes.iterator();
                while (iterator2.hasNext()) {
                    Clazz clazz = (Clazz)iterator2.next();
                    if (!clazz.getName().equals(type) && !clazz.getName().endsWith("." + type)) continue;
                    this.insertImport(clazz.getFullName());
                }
            }
        }
    }

    private void insertImport(String fullName) {
        SymTabEntry symTabEntry;
        if ("String int double float boolean void".indexOf(fullName) >= 0) {
            return;
        }
        int pos = this.parser.indexOf("import");
        String prefix = "";
        if (this.parser.search("import", pos) < 0) {
            prefix = "\n";
        }
        if ((symTabEntry = (SymTabEntry)this.parser.getSymTab().get((Object)("import:" + fullName))) == null) {
            this.parser.insert(this.parser.getEndOfImports() + 1, prefix + "\nimport " + fullName + ";");
        }
    }

    private void insertValues() {
        this.parser.parse();
        int enumCurrentPos = -1;
        String signature = "enumvalue:";
        ArrayList<SymTabEntry> enumEntriesInSymTab = this.parser.getSymTabEntriesFor(signature);
        for (SymTabEntry symTabEnumEntry : enumEntriesInSymTab) {
            int endPos = symTabEnumEntry.getEndPos();
            if (endPos <= -1 || endPos >= enumCurrentPos) continue;
            enumCurrentPos = endPos;
        }
        boolean isNew = false;
        if (enumCurrentPos < 0) {
            isNew = true;
        }
        Iterator iterator = ((Enumeration)this.model).getValueNames().iterator();
        while (iterator.hasNext()) {
            ArrayList valueNames = (ArrayList)iterator.next();
            for (int i = 0; i < valueNames.size(); ++i) {
                Object value = valueNames.get(i);
                if (this.symTabContains(enumEntriesInSymTab, value)) continue;
                enumCurrentPos = this.insertValue((String)value, enumCurrentPos, i == valueNames.size() - 1 && isNew);
            }
        }
    }

    private boolean symTabContains(ArrayList<SymTabEntry> enumEntriesInSymTab, Object value) {
        String valueString = String.valueOf(value);
        if (valueString.matches("-?\\d+(.\\d+)?")) {
            value = "_" + value;
        }
        for (SymTabEntry symTabEnumEntry : enumEntriesInSymTab) {
            if (!symTabEnumEntry.getMemberName().equals(value)) continue;
            return true;
        }
        return false;
    }

    private int insertValue(String value, int enumCurrentPos, boolean end) {
        if (value.matches("-?\\d+(.\\d+)?")) {
            value = "_" + value;
        }
        if (enumCurrentPos < 0) {
            enumCurrentPos = this.parser.indexOf("enum");
            if ((enumCurrentPos = this.parser.search("enum", enumCurrentPos)) > -1) {
                enumCurrentPos = this.parser.search("{", enumCurrentPos);
            }
        }
        String text = end ? "\n\t\t" + value + ";" : "\n\t\t" + value + ",";
        this.parser.insert(enumCurrentPos + 1, text);
        return enumCurrentPos + text.length();
    }

    private void insertLicense(Parser parser) {
        int pos = parser.search("/*");
        if (pos < 0 || pos > 20) {
            String year = new SimpleDateFormat("yyyy").format(new Date(System.currentTimeMillis()));
            parser.replaceAll(0, "/*\n   Copyright (c) <year> <developer> \n   \n   Permission is hereby granted, free of charge, to any person obtaining a copy of this software \n   and associated documentation files (the \"Software\"), to deal in the Software without restriction, \n   including without limitation the rights to use, copy, modify, merge, publish, distribute, \n   sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is \n   furnished to do so, subject to the following conditions: \n   \n   The above copyright notice and this permission notice shall be included in all copies or \n   substantial portions of the Software. \n   \n   The Software shall be used for Good, not Evil. \n   \n   THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING \n   BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND \n   NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, \n   DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, \n   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. \n */\n   \n", "<year>", year, "<developer>", System.getProperty("user.name"));
        }
    }

    public Parser getParser() {
        return this.parser;
    }

    public Parser getOrCreateParser(String rootDir) {
        if (this.parser == null) {
            String name = ((Enumeration)this.model).getFullName();
            int pos = name.lastIndexOf(46);
            String packageName = name.substring(0, pos);
            String fileName = name;
            String className = name.substring(pos + 1);
            fileName = fileName.replaceAll("\\.", "/");
            fileName = rootDir + "/" + fileName + ".java";
            File javaFile = new File(fileName);
            this.parser = new Parser().withFileName(fileName);
            if (javaFile.exists() && !this.isShowDiff()) {
                this.parser.withFileBody(CGUtil.readFile(javaFile));
            } else {
                this.parser.replaceAll("package packageName;\n\npublic enum enumName\n{\n}\n", "enumName", className, "packageName", packageName);
                this.parser.withFileChanged(true);
            }
        }
        return this.parser;
    }

    public boolean isShowDiff() {
        ClassModel model = ((Enumeration)this.getModel()).getClassModel();
        if (model != null) {
            return model.getGenerator().getShowDiff() != GenClassModel.DIFF.NONE;
        }
        return false;
    }

    public void printFile(Parser parser) {
        if (!this.isShowDiff()) {
            CGUtil.printFile(parser);
        }
    }
}

