/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes.logic;

import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.json.JsonIdMap;
import de.uniks.networkparser.list.SimpleKeyValueList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sdmlib.CGUtil;
import org.sdmlib.StrUtil;
import org.sdmlib.codegen.LocalVarTableEntry;
import org.sdmlib.codegen.Parser;
import org.sdmlib.codegen.StatementEntry;
import org.sdmlib.codegen.SymTabEntry;
import org.sdmlib.codegen.util.StatementEntrySet;
import org.sdmlib.models.classes.Annotation;
import org.sdmlib.models.classes.Association;
import org.sdmlib.models.classes.Attribute;
import org.sdmlib.models.classes.Card;
import org.sdmlib.models.classes.ClassModel;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.DataType;
import org.sdmlib.models.classes.Enumeration;
import org.sdmlib.models.classes.Method;
import org.sdmlib.models.classes.Parameter;
import org.sdmlib.models.classes.Role;
import org.sdmlib.models.classes.SDMLibClass;
import org.sdmlib.models.classes.Value;
import org.sdmlib.models.classes.logic.GenAnnotation;
import org.sdmlib.models.classes.logic.GenAssociation;
import org.sdmlib.models.classes.logic.GenAttribute;
import org.sdmlib.models.classes.logic.GenClass;
import org.sdmlib.models.classes.logic.GenEnumeration;
import org.sdmlib.models.classes.logic.GenFactory;
import org.sdmlib.models.classes.logic.GenMethod;
import org.sdmlib.models.classes.logic.GenRole;
import org.sdmlib.models.classes.logic.Generator;
import org.sdmlib.models.classes.util.AssociationSet;
import org.sdmlib.models.classes.util.AttributeSet;
import org.sdmlib.models.classes.util.ClazzSet;
import org.sdmlib.models.classes.util.MethodSet;
import org.sdmlib.models.classes.util.RoleSet;
import org.sdmlib.models.objects.GenericAttribute;
import org.sdmlib.models.objects.GenericLink;
import org.sdmlib.models.objects.GenericObject;
import org.sdmlib.storyboards.Storyboard;

public class GenClassModel {
    public static final String UTILPATH = ".util";
    ClassModel model;
    private LinkedHashMap<String, Clazz> handledClazzes = new LinkedHashMap();
    private AssociationSet associations = null;
    private HashMap<Object, Generator<?>> generators = new HashMap();
    Parser creatorCreatorParser;
    private DIFF showDiff = DIFF.NONE;
    private List<String> ignoreDiff;
    public GenFactory genFactory = new GenFactory();
    HashMap<String, GenClass> imports = new HashMap();

    public boolean addToAssociations(Association value) {
        boolean changed = false;
        if (value != null) {
            if (this.associations == null) {
                this.associations = new AssociationSet();
            }
            changed = this.associations.add(value);
        }
        return changed;
    }

    public boolean removeFromAssociations(Association value) {
        boolean changed = false;
        if (this.associations != null && value != null) {
            changed = this.associations.remove(value);
        }
        return changed;
    }

    public AssociationSet getAssociations() {
        if (this.associations == null) {
            return new AssociationSet();
        }
        return this.associations;
    }

    public GenEnumeration getOrCreate(Enumeration enumeration) {
        if (this.generators.containsKey(enumeration)) {
            return (GenEnumeration)this.generators.get(enumeration);
        }
        Generator<Enumeration> gen = new GenEnumeration().withModel(enumeration);
        this.generators.put(enumeration, gen);
        return (GenEnumeration)gen;
    }

    public GenClass getOrCreate(Clazz clazz) {
        if (this.generators.containsKey(clazz)) {
            return (GenClass)this.generators.get(clazz);
        }
        Generator<Clazz> gen = new GenClass().withModel(clazz);
        this.generators.put(clazz, gen);
        return (GenClass)gen;
    }

    public GenMethod getOrCreate(Method method) {
        if (this.generators.containsKey(method)) {
            return (GenMethod)this.generators.get(method);
        }
        Generator<Method> gen = new GenMethod().withModel(method);
        this.generators.put(method, gen);
        return (GenMethod)gen;
    }

    public GenAttribute getOrCreate(Attribute attribute) {
        if (this.generators.containsKey(attribute)) {
            return (GenAttribute)this.generators.get(attribute);
        }
        Generator<Attribute> gen = new GenAttribute().withModel(attribute);
        this.generators.put(attribute, gen);
        return (GenAttribute)gen;
    }

    public GenAnnotation getOrCreate(Annotation annotation) {
        if (this.generators.containsKey(annotation)) {
            return (GenAnnotation)this.generators.get(annotation);
        }
        Generator<Annotation> gen = new GenAnnotation().withModel(annotation);
        this.generators.put(annotation, gen);
        return (GenAnnotation)gen;
    }

    public GenAssociation getOrCreate(Association association) {
        if (this.generators.containsKey(association)) {
            return (GenAssociation)this.generators.get(association);
        }
        Generator<Association> gen = new GenAssociation().withModel(association);
        this.generators.put(association, gen);
        return (GenAssociation)gen;
    }

    public GenRole getOrCreate(Role role) {
        if (this.generators.containsKey(role)) {
            return (GenRole)this.generators.get(role);
        }
        Generator<Role> gen = new GenRole().withModel(role);
        this.generators.put(role, gen);
        return (GenRole)gen;
    }

    public boolean generate(String rootDir) {
        this.resetParsers();
        this.fixClassModel();
        this.addHelperClassesForUnknownAttributeTypes();
        this.genFactory.getOrCreateFactoryFactoryParser(this, rootDir);
        Iterator iterator = this.model.getEnumerations().iterator();
        while (iterator.hasNext()) {
            Enumeration enumeration = (Enumeration)iterator.next();
            this.getOrCreate(enumeration).generate(rootDir, rootDir);
        }
        iterator = this.model.getClasses().iterator();
        while (iterator.hasNext()) {
            Clazz clazz = (Clazz)iterator.next();
            this.getOrCreate(clazz).generate(rootDir, rootDir);
        }
        iterator = this.getAssociations().iterator();
        while (iterator.hasNext()) {
            Association assoc = (Association)iterator.next();
            this.getOrCreate(assoc).generate(rootDir, rootDir);
        }
        RuntimeException e = new RuntimeException();
        this.attributNameConsistenceCheck(e, rootDir);
        if (this.getShowDiff() != DIFF.NONE) {
            int count = 0;
            Iterator iterator2 = this.model.getClasses().iterator();
            while (iterator2.hasNext()) {
                Clazz clazz = (Clazz)iterator2.next();
                count += this.getOrCreate(clazz).printAll(this.getShowDiff(), this.ignoreDiff);
            }
            System.out.println("Totalchanges of all Files: " + count);
        }
        this.doCoverageOfModelCode();
        return true;
    }

    private void fixClassModel() {
        Clazz[] classes = (Clazz[])this.model.getClasses().toArray(new Clazz[this.model.getClasses().size()]);
        HashSet<Clazz> visited = new HashSet<Clazz>();
        for (Clazz item : classes) {
            this.fixClassModel(item, visited);
        }
    }

    private void fixClassModel(Clazz item, HashSet<Clazz> visited) {
        Clazz entity;
        Iterator iterator = item.getInterfaces().iterator();
        while (iterator.hasNext()) {
            entity = (Clazz)iterator.next();
            if (entity.getClassModel() != null) continue;
            if (visited.add(entity)) {
                this.fixClassModel(entity, visited);
            }
            entity.with(this.model);
        }
        iterator = item.getSuperClazzes().iterator();
        while (iterator.hasNext()) {
            entity = (Clazz)iterator.next();
            if (entity.getClassModel() != null) continue;
            if (visited.add(entity)) {
                this.fixClassModel(entity, visited);
            }
            entity.with(this.model);
        }
        iterator = item.getKidClazzes().iterator();
        while (iterator.hasNext()) {
            entity = (Clazz)iterator.next();
            if (entity.getClassModel() != null) continue;
            entity.with(this.model);
            if (!visited.add(entity)) continue;
            this.fixClassModel(entity, visited);
        }
        iterator = item.getRoles().iterator();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            Clazz clazz = role.getPartnerRole().getClazz();
            if (clazz.getClassModel() == null) {
                clazz.with(this.model);
                if (visited.add(clazz)) {
                    this.fixClassModel(clazz, visited);
                }
            }
            this.addToAssociations(role.getAssoc());
        }
    }

    public void addHelperClassesForUnknownAttributeTypes() {
        Iterator iterator = this.model.getClasses().getAttributes().getType().iterator();
        while (iterator.hasNext()) {
            Clazz clazz;
            DataType item = (DataType)iterator.next();
            String typeName = item.getValue();
            int pos = typeName.indexOf(60);
            if (pos >= 0) {
                typeName = typeName.substring(0, pos);
            }
            if ((pos = typeName.indexOf(91)) >= 0) {
                typeName = typeName.substring(0, pos);
            }
            if (CGUtil.isPrimitiveType(typeName) || (clazz = this.model.getClazz(typeName)) != null) continue;
            if (typeName.indexOf(".") >= 0) {
                this.model.createClazz(typeName).withExternal(true);
                continue;
            }
            this.model.createClazz(typeName);
        }
    }

    private void attributNameConsistenceCheck(Exception e, String rootDir) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        StackTraceElement secondStackTraceElement = stackTrace[1];
        String fileName = secondStackTraceElement.getFileName();
        String className = secondStackTraceElement.getClassName();
        String methodName = secondStackTraceElement.getMethodName();
        int callMethodLineNumber = secondStackTraceElement.getLineNumber();
        int i = 2;
        while (ClassModel.class.getName().equals(className)) {
            secondStackTraceElement = stackTrace[i];
            fileName = secondStackTraceElement.getFileName();
            className = secondStackTraceElement.getClassName();
            methodName = secondStackTraceElement.getMethodName();
            callMethodLineNumber = secondStackTraceElement.getLineNumber();
            ++i;
        }
        Clazz modelCreationClass = new ClassModel().withName(".").getGenerator().getOrCreateClazz(className);
        Parser parser = this.getOrCreate(modelCreationClass).getOrCreateParser(rootDir);
        parser.indexOf("classEnd");
        String signature = "method:" + methodName + "(";
        ArrayList<SymTabEntry> symTabEntries = parser.getSymTabEntriesFor(signature);
        SymTabEntry symTabEntry = null;
        for (SymTabEntry symTabEnt : symTabEntries) {
            long startPos = parser.getLineIndexOf(symTabEnt.getStartPos());
            long endPos = parser.getLineIndexOf(symTabEnt.getEndPos());
            if (startPos > (long)callMethodLineNumber || endPos < (long)callMethodLineNumber) continue;
            symTabEntry = symTabEnt;
        }
        LinkedHashMap<String, LocalVarTableEntry> localVarTable = null;
        if (symTabEntry != null) {
            parser.parseMethodBody(symTabEntry);
            localVarTable = parser.getLocalVarTable();
        }
        Iterator iterator = this.model.getClasses().iterator();
        while (iterator.hasNext()) {
            Clazz clazz = (Clazz)iterator.next();
            HashMap<String, SDMLibClass> attributs = new HashMap<String, SDMLibClass>();
            HashSet<SDMLibClass> duplicateEntries = new HashSet<SDMLibClass>();
            Iterator iterator2 = clazz.getAttributes().iterator();
            while (iterator2.hasNext()) {
                Attribute attr = (Attribute)iterator2.next();
                String string = attr.getName();
                if (attributs.containsKey(string)) {
                    duplicateEntries.add(attr);
                    duplicateEntries.add((SDMLibClass)attributs.get(string));
                }
                attributs.put(string, attr);
            }
            RoleSet roles = clazz.getRoles().getOtherRoles();
            Iterator<Object> iterator3 = roles.iterator();
            while (iterator3.hasNext()) {
                Role role = (Role)iterator3.next();
                String name = role.getName();
                if (name == null) {
                    name = "";
                }
                if (name.equals(role.getPartnerRole().getName()) || name.equals("")) continue;
                if (attributs.containsKey(name)) {
                    duplicateEntries.add(role);
                    duplicateEntries.add((SDMLibClass)attributs.get(name));
                }
                attributs.put(name, role);
            }
            for (Object object : duplicateEntries) {
                String position;
                if (object instanceof Attribute) {
                    Attribute attribute = (Attribute)object;
                    position = this.defPositionAsString(parser, localVarTable, attribute.getName(), attribute.getType(), attribute.getClazz().getFullName());
                    System.out.println("in " + fileName + ":  duplicate name found in definition for attribute" + attribute.getClazz() + "\n    " + position + "\n     Attribute " + attribute);
                    attribute.removeYou();
                    continue;
                }
                if (!(object instanceof Role)) continue;
                Role role = (Role)object;
                position = this.defPositionAsString(parser, localVarTable, role.getName(), DataType.ref("NONE"), role.getClazz().getFullName());
                System.out.println("in " + fileName + "  duplicate name found in definition for " + role.getClazz() + "\n    " + position + "\n      Role " + role);
                System.out.println(parser.getLineForPos((int)this.defPosition(parser, localVarTable, role.getName(), DataType.ref("NONE"), role.getClazz().getFullName())));
                Association assoc = role.getAssoc();
                if (assoc != null) {
                    assoc.removeYou();
                }
                role.removeYou();
            }
        }
    }

    private String defPositionAsString(Parser parser, LinkedHashMap<String, LocalVarTableEntry> localVarTable, String name, DataType attrType, String clazzType) {
        String position = "";
        if (localVarTable != null) {
            for (LocalVarTableEntry entry : localVarTable.values()) {
                String type;
                if (entry.getType() == null || !entry.getType().equals("Clazz") || !clazzType.endsWith(type = entry.getInitSequence().get(0).get(1).replace("\"", ""))) continue;
                CharSequence subSequence = parser.getText().subSequence(entry.getStartPos(), entry.getEndPos() + 1);
                String subSequenceString = subSequence.toString();
                Pattern fileName = Pattern.compile("\"" + name + "\"\\s*,\\s*\"" + attrType + "\"");
                Matcher matcher = fileName.matcher(subSequenceString);
                int indexOf = 0;
                while (matcher.find()) {
                    String group = matcher.group(0);
                    indexOf = subSequenceString.indexOf(group);
                }
                position = "at line " + parser.getLineIndexOf(entry.getStartPos() + indexOf) + "    ";
            }
        }
        return position;
    }

    private long defPosition(Parser parser, LinkedHashMap<String, LocalVarTableEntry> localVarTable, String name, DataType attrType, String clazzType) {
        long position = 0L;
        if (localVarTable != null) {
            for (LocalVarTableEntry entry : localVarTable.values()) {
                String type;
                if (entry.getType() == null || !entry.getType().equals("Clazz") || !clazzType.endsWith(type = entry.getInitSequence().get(0).get(1).replace("\"", ""))) continue;
                CharSequence subSequence = parser.getText().subSequence(entry.getStartPos(), entry.getEndPos() + 1);
                String subSequenceString = subSequence.toString();
                Pattern fileName = Pattern.compile("\"" + name + "\"\\s*,\\s*\"" + attrType + "\"");
                Matcher matcher = fileName.matcher(subSequenceString);
                int indexOf = 0;
                while (matcher.find()) {
                    String group = matcher.group(0);
                    indexOf = subSequenceString.indexOf(group);
                }
                position = entry.getStartPos() + indexOf;
            }
        }
        return position;
    }

    private void writeToFile(Clazz modelCreationClass) {
        this.getOrCreate(modelCreationClass).printFile();
    }

    private void resetParsers() {
        Iterator iterator = this.model.getClasses().iterator();
        while (iterator.hasNext()) {
            Clazz clazz = (Clazz)iterator.next();
            this.getOrCreate(clazz).setParser(null);
        }
    }

    public void setModel(ClassModel value) {
        if (this.model != value) {
            this.model = value;
        }
    }

    protected Clazz getOrCreateClazz(String className) {
        Iterator iterator = this.getModel().getClasses().iterator();
        while (iterator.hasNext()) {
            Clazz clazz = (Clazz)iterator.next();
            if (!StrUtil.stringEquals(clazz.getFullName(), className)) continue;
            return clazz;
        }
        Clazz clazz = this.getModel().createClazz(className);
        return clazz;
    }

    public ClassModel getModel() {
        return this.model;
    }

    public void insertModelCreationCodeHere(String rootDir, String newMethod) {
        StackTraceElement[] stackTrace = new RuntimeException().getStackTrace();
        StackTraceElement secondStackTraceElement = stackTrace[1];
        String className = secondStackTraceElement.getClassName();
        this.insertModelCreationCodeHere(rootDir, className, newMethod);
    }

    public void insertModelCreationCodeHere(String rootDir, String className, String newMethod) {
        Clazz modelCreationClass = this.getOrCreateClazz(className);
        modelCreationClass.getClassModel().without(modelCreationClass);
        GenClass modelCreationGenerator = this.getOrCreate(modelCreationClass);
        Parser modelCreationParser = modelCreationGenerator.getOrCreateParser(rootDir);
        modelCreationParser.indexOf("classEnd");
        String signature = "method:" + newMethod + "(";
        ArrayList<SymTabEntry> symTabEntriesFor = modelCreationParser.getSymTabEntriesFor(signature);
        int currentInsertPos = modelCreationParser.indexOf("classBody");
        if (symTabEntriesFor.size() < 1) {
            currentInsertPos = modelCreationParser.insert(currentInsertPos, "      @Test\n      public void " + newMethod + "() {\n" + "      \tClassModel clazzModel = new ClassModel(\"" + this.model.getName() + "\");\n");
            modelCreationParser.insert(currentInsertPos, "      }\n");
        } else {
            SymTabEntry symTabEntry = symTabEntriesFor.get(0);
            currentInsertPos = symTabEntry.getBodyStartPos() + 2;
        }
        modelCreationParser.indexOf("classEnd");
        TreeSet<Clazz> sortedClazz = new TreeSet<Clazz>(new Comparator<Clazz>(){

            @Override
            public int compare(Clazz o1, Clazz o2) {
                return o1.getFullName().compareTo(o2.getFullName());
            }
        });
        currentInsertPos = this.insertNewCreationClasses(modelCreationClass, signature, currentInsertPos, rootDir, sortedClazz);
        this.completeImports();
        this.writeToFile(modelCreationClass);
    }

    public void insertModelCreationCodeHere(String rootDir) {
        String className = null;
        String methodName = null;
        String callMethodName = null;
        RuntimeException e = new RuntimeException();
        StackTraceElement[] stackTrace = e.getStackTrace();
        StackTraceElement firstStackTraceElement = stackTrace[0];
        callMethodName = firstStackTraceElement.getMethodName();
        StackTraceElement secondStackTraceElement = stackTrace[1];
        className = secondStackTraceElement.getClassName();
        methodName = secondStackTraceElement.getMethodName();
        int callMethodLineNumber = secondStackTraceElement.getLineNumber();
        Clazz modelCreationClass = this.getOrCreateClazz(className);
        modelCreationClass.getClassModel().without(modelCreationClass);
        String signature = "method:" + methodName + "(";
        GenClass modelCreationGenerator = this.getOrCreate(modelCreationClass);
        Parser modelCreationParser = modelCreationGenerator.getOrCreateParser(rootDir);
        modelCreationParser.indexOf("classEnd");
        SymTabEntry symTabEntry = modelCreationParser.getMethodEntryWithLineNumber(signature, callMethodLineNumber);
        if (symTabEntry == null) {
            System.out.println("call method for model creation code not found");
            return;
        }
        int currentInsertPos = modelCreationParser.methodCallIndexOf("nameToken:model", symTabEntry.getBodyStartPos(), symTabEntry.getEndPos());
        if (currentInsertPos > 0) {
            currentInsertPos = modelCreationParser.indexOfInMethodBody("nameToken:;", currentInsertPos + 1, symTabEntry.getEndPos() - 1) + 1;
        } else {
            currentInsertPos = symTabEntry.getBodyStartPos() + 2;
            currentInsertPos = modelCreationParser.insert(currentInsertPos, "      ClassModel clazzModel = new ClassModel(\"" + this.model.getName() + "\");");
        }
        currentInsertPos = this.completeCreationClasses(callMethodName, modelCreationClass, signature, currentInsertPos, rootDir);
        currentInsertPos = this.insertNewCreationClasses(callMethodName, modelCreationClass, signature, currentInsertPos, rootDir);
        this.completeImports();
        this.writeToFile(modelCreationClass);
    }

    private void completeImports() {
        for (String className : this.imports.keySet()) {
            GenClass genClass = this.imports.get(className);
            genClass.insertImport(className);
        }
        this.imports.clear();
    }

    private int completeCreationClasses(String callMethodName, Clazz modelCreationClass, String signature, int currentInsertPos, String rootDir) {
        this.refreshMethodScan(signature, modelCreationClass, rootDir);
        Iterator iterator = this.model.getClasses().iterator();
        while (iterator.hasNext()) {
            Clazz clazz = (Clazz)iterator.next();
            String modelClassName = clazz.getFullName();
            Parser parser = this.getOrCreate(modelCreationClass).getParser();
            LocalVarTableEntry entry = this.findInLocalVarTable(parser.getLocalVarTable(), modelClassName);
            if (entry != null) {
                this.handledClazzes.put(modelClassName, clazz);
                this.getOrCreate(clazz).getOrCreateParser(rootDir);
                currentInsertPos = this.checkCodeForClazz(entry, signature, callMethodName, modelCreationClass, this.refreshMethodScan(signature, modelCreationClass, rootDir), clazz, this.handledClazzes, currentInsertPos, rootDir);
            }
            this.writeToFile(modelCreationClass);
        }
        return currentInsertPos;
    }

    private SymTabEntry refreshMethodScan(String signature, Clazz clazz, String rootDir) {
        SymTabEntry symTabEntry = null;
        this.rescanCode(clazz, rootDir);
        SimpleKeyValueList<String, SymTabEntry> symTab = this.getOrCreate(clazz).getOrCreateParser(rootDir).getSymTab();
        for (String key : symTab.keySet()) {
            if (!key.startsWith(signature)) continue;
            symTabEntry = (SymTabEntry)symTab.get(key);
            break;
        }
        this.getOrCreate(clazz).getParser().parseMethodBody(symTabEntry);
        return symTabEntry;
    }

    private void rescanCode(Clazz clazz, String rootDir) {
        this.getOrCreate(clazz).getOrCreateParser(rootDir).indexOf("classEnd");
    }

    private int checkCodeForClazz(LocalVarTableEntry entry, String signature, String callMethodName, Clazz modelCreationClass, SymTabEntry symTabEntry, Clazz clazz, LinkedHashMap<String, Clazz> handledClazzes, int currentInsertPos, String rootDir) {
        Object attribute;
        StringBuilder text;
        int methodCallStartPos;
        Object token;
        Parser modelCreationClassParser = this.getOrCreate(modelCreationClass).getParser();
        if (clazz.getSuperClass() != null && !this.checkSuper(clazz, entry, "withSuperClazz")) {
            token = "nameToken:" + entry.getName();
            methodCallStartPos = modelCreationClassParser.methodCallIndexOf((String)token, symTabEntry.getBodyStartPos(), symTabEntry.getEndPos());
            token = "nameToken:;";
            currentInsertPos = modelCreationClassParser.indexOfInMethodBody((String)token, methodCallStartPos, symTabEntry.getEndPos());
            currentInsertPos = this.insertCreationCode("\n       /*set superclass*/", currentInsertPos, modelCreationClass);
            currentInsertPos = this.insertCreationCode("\n", currentInsertPos, modelCreationClass);
            text = new StringBuilder("      .withSuperClazz(superClassName)");
            CGUtil.replaceAll(text, "superClassName", StrUtil.downFirstChar(CGUtil.shortClassName(clazz.getSuperClass().getFullName())) + "Class");
            currentInsertPos = this.insertCreationCode(text, currentInsertPos, modelCreationClass);
            ++currentInsertPos;
            symTabEntry = this.refreshMethodScan(signature, modelCreationClass, rootDir);
        } else if (clazz.isInterface() && !this.isInterface(entry)) {
            token = "nameToken:" + entry.getName();
            methodCallStartPos = modelCreationClassParser.methodCallIndexOf((String)token, symTabEntry.getBodyStartPos(), symTabEntry.getEndPos());
            token = "nameToken:;";
            currentInsertPos = modelCreationClassParser.indexOfInMethodBody((String)token, methodCallStartPos, symTabEntry.getEndPos());
            currentInsertPos = this.insertCreationCode("\n       /*set interface*/", currentInsertPos, modelCreationClass);
            currentInsertPos = this.insertCreationCode("\n", currentInsertPos, modelCreationClass);
            text = new StringBuilder("      .withInterface(true)");
            currentInsertPos = this.insertCreationCode(text, currentInsertPos, modelCreationClass);
            ++currentInsertPos;
            symTabEntry = this.refreshMethodScan(signature, modelCreationClass, rootDir);
        }
        token = clazz.getInterfaces().iterator();
        while (token.hasNext()) {
            Clazz interfaze = (Clazz)token.next();
            if (!this.checkSuper(interfaze, entry, "withInterfaces")) {
                String token2 = "nameToken:" + entry.getName();
                int methodCallStartPos2 = modelCreationClassParser.methodCallIndexOf(token2, symTabEntry.getBodyStartPos(), symTabEntry.getEndPos());
                token2 = "nameToken:;";
                currentInsertPos = modelCreationClassParser.indexOfInMethodBody(token2, methodCallStartPos2, symTabEntry.getEndPos());
                currentInsertPos = this.insertCreationCode("\n       /*add interface*/", currentInsertPos, modelCreationClass);
                currentInsertPos = this.insertCreationCode("\n", currentInsertPos, modelCreationClass);
                StringBuilder text2 = new StringBuilder("      .withSuperClazz(interfaceName)");
                CGUtil.replaceAll(text2, "interfaceName", StrUtil.downFirstChar(CGUtil.shortClassName(interfaze.getFullName())) + "Class");
                currentInsertPos = this.insertCreationCode(text2, currentInsertPos, modelCreationClass);
                ++currentInsertPos;
            }
            ++currentInsertPos;
            symTabEntry = this.refreshMethodScan(signature, modelCreationClass, rootDir);
        }
        AttributeSet clazzAttributes = clazz.getAttributes();
        Iterator interfaze = clazzAttributes.iterator();
        while (interfaze.hasNext()) {
            attribute = (Attribute)interfaze.next();
            if (!this.hasAttribute((Attribute)attribute, entry, rootDir) && !"PropertyChangeSupport".equals(((Value)attribute).getType())) {
                this.writeToFile(modelCreationClass);
                String tokenString = entry.getInitSequence().get(0).get(0);
                if (tokenString.endsWith(".withAssoc")) {
                    boolean found = false;
                    Iterator iterator = modelCreationClassParser.getCurrentStatement().getParent().getBodyStats().iterator();
                    while (iterator.hasNext()) {
                        StatementEntry stat = (StatementEntry)iterator.next();
                        String token3 = stat.getTokenList().get(0);
                        if (!token3.equals(entry.getName() + ".withAttribute") && !token3.equals(entry.getName() + ".with(new Attribute")) continue;
                        currentInsertPos = stat.getEndPos() - 1;
                        found = true;
                        break;
                    }
                    if (!found) {
                        StringBuilder text3 = new StringBuilder("\n\n      classVar.withAttributes(\n         \"name\", \"type\");");
                        CGUtil.replaceAll(text3, "classVar", entry.getName(), "name", ((SDMLibClass)attribute).getName(), "type", ((Value)attribute).getType());
                        currentInsertPos = this.insertCreationCode(text3.toString(), entry.getEndPos() + 2, modelCreationClass);
                        symTabEntry = this.refreshMethodScan(signature, clazz, rootDir);
                        continue;
                    }
                } else {
                    String token4 = "nameToken:" + entry.getName();
                    int methodCallStartPos3 = modelCreationClassParser.methodCallIndexOf(token4, symTabEntry.getBodyStartPos(), symTabEntry.getEndPos());
                    token4 = "nameToken:;";
                    currentInsertPos = modelCreationClassParser.indexOfInMethodBody(token4, methodCallStartPos3, symTabEntry.getEndPos());
                }
                StringBuilder text4 = new StringBuilder("\n         /*add attribut*/\n       .with(new Attribute(\"name\", DataType.ref(\"type\")) )");
                CGUtil.replaceAll(text4, "name", ((SDMLibClass)attribute).getName(), "type", ((Value)attribute).getType().getValue());
                currentInsertPos = this.insertCreationCode(text4.toString(), currentInsertPos, modelCreationClass);
                GenClass genCreationClass = this.getOrCreate(modelCreationClass);
                this.addImportForClazz("org.sdmlib.models.classes.Attribute", genCreationClass);
                ++currentInsertPos;
            }
            currentInsertPos += 2;
            symTabEntry = this.refreshMethodScan(signature, modelCreationClass, rootDir);
        }
        MethodSet methods = clazz.getMethods();
        attribute = methods.iterator();
        while (attribute.hasNext()) {
            Method method = (Method)attribute.next();
            currentInsertPos = this.tryToInsertMethod(symTabEntry, method, currentInsertPos, modelCreationClass);
            symTabEntry = this.refreshMethodScan(signature, modelCreationClass, rootDir);
        }
        LinkedHashSet roles = new LinkedHashSet();
        if (!clazz.getRoles().isEmpty()) {
            roles.addAll(clazz.getRoles());
        }
        for (Role role : roles) {
            Association association = role.getAssoc();
            if (association == null) continue;
            String sourceClassName = association.getSource().getClazz().getFullName();
            String targetClassName = association.getTarget().getClazz().getFullName();
            if (!handledClazzes.containsKey(sourceClassName) || !handledClazzes.containsKey(targetClassName)) continue;
            symTabEntry = this.refreshMethodScan(signature, modelCreationClass, rootDir);
            int indexOfSourceClassPos = this.positionOfClazzDecl(sourceClassName, modelCreationClass);
            int indexOfTargetClassPos = this.positionOfClazzDecl(targetClassName, modelCreationClass);
            int resultPos = Math.max(indexOfSourceClassPos, indexOfTargetClassPos) + 3;
            currentInsertPos = Math.max(resultPos, currentInsertPos);
            currentInsertPos = this.tryToInsertAssoc(symTabEntry, role, currentInsertPos, modelCreationClass);
        }
        return currentInsertPos;
    }

    private LocalVarTableEntry findInLocalVarTable(LinkedHashMap<String, LocalVarTableEntry> localVarTable, String name) {
        for (LocalVarTableEntry entry : localVarTable.values()) {
            String className;
            ArrayList<String> initSequence;
            if (!"Clazz".equals(entry.getType()) || entry.getInitSequence() == null || (initSequence = entry.getInitSequence().get(0)).size() < 2 || !initSequence.get(0).startsWith("new") && !initSequence.get(0).startsWith("model.createClazz") && !initSequence.get(0).endsWith(".createClassAndAssoc") || !StrUtil.stringEquals(name, className = initSequence.get(1).replaceAll("\"", "")) && !name.endsWith("." + className)) continue;
            return entry;
        }
        return null;
    }

    private int positionOfClazzDecl(String sourceClassName, Clazz clazz) {
        LinkedHashMap<String, LocalVarTableEntry> localVarTable = this.getOrCreate(clazz).getParser().getLocalVarTable();
        for (String localVarTableEntityName : localVarTable.keySet()) {
            LocalVarTableEntry localVarTableEntry = localVarTable.get(localVarTableEntityName);
            ArrayList<String> arrayList = localVarTableEntry.getInitSequence().get(0);
            String string = "";
            if (arrayList.size() <= 1 || !sourceClassName.equals(string = arrayList.get(1).replaceAll("\"", "")) && !sourceClassName.endsWith("." + string)) continue;
            return localVarTableEntry.getEndPos();
        }
        return -1;
    }

    private int tryToInsertAssoc(SymTabEntry symTabEntry, Role role, int currentInsertPos, Clazz modelCreationClass) {
        Parser parser = this.getOrCreate(modelCreationClass).getParser();
        parser.parseMethodBody(symTabEntry);
        boolean assocIsNew = true;
        LinkedHashMap<String, LocalVarTableEntry> localVarTable = parser.getLocalVarTable();
        Association assoc = role.getAssoc();
        block0: for (String string : localVarTable.keySet()) {
            LocalVarTableEntry localVarTableEntry = localVarTable.get(string);
            if ("Clazz".equals(localVarTableEntry.getType())) {
                ArrayList<ArrayList<String>> sequence = localVarTableEntry.getInitSequence();
                for (ArrayList<String> subSequence : sequence) {
                    String className;
                    if (!"withAssoc".equals(subSequence.get(0)) || !this.compareAssocDecl(assoc, subSequence, className = sequence.get(0).get(1), localVarTable)) continue;
                    assocIsNew = false;
                    continue block0;
                }
                continue;
            }
            if (!string.startsWith("Association_") || !this.compareAssocDecl(assoc, localVarTableEntry)) continue;
            assocIsNew = false;
            break;
        }
        Iterator<String> iterator = this.getOrCreate(modelCreationClass).getParser().getStatementList().getBodyStats().iterator();
        while (iterator.hasNext()) {
            String assocRoleName2;
            String tokenRoleName2;
            String assocRoleName1;
            String tokenRoleName1;
            String classNameFromAssoc;
            String classVar;
            LocalVarTableEntry localVarTableEntry;
            String classNameFromText;
            StatementEntry stat = (StatementEntry)((Object)iterator.next());
            if (!stat.getTokenList().get(0).endsWith(".withAssoc") && !stat.getTokenList().get(0).endsWith(".createClassAndAssoc") || !StrUtil.stringEquals(classNameFromText = (localVarTableEntry = localVarTable.get(classVar = CGUtil.packageName(stat.getTokenList().get(0)))).getInitSequence().get(0).get(1).replaceAll("\"", ""), classNameFromAssoc = assoc.getSource().getClazz().getFullName()) && !classNameFromAssoc.endsWith("." + classNameFromText)) continue;
            classVar = stat.getTokenList().get(2);
            localVarTableEntry = localVarTable.get(classVar);
            classNameFromText = stat.getTokenList().get(0).endsWith(".withAssoc") ? localVarTableEntry.getInitSequence().get(0).get(1).replaceAll("\"", "") : stat.getTokenList().get(2).replaceAll("\"", "");
            if (!StrUtil.stringEquals(classNameFromText, classNameFromAssoc = assoc.getTarget().getClazz().getFullName()) && !classNameFromAssoc.endsWith("." + classNameFromText) || !this.stringsPairwiseEquals(tokenRoleName1 = stat.getTokenList().get(4).replaceAll("\"", ""), assocRoleName1 = assoc.getTarget().getName(), tokenRoleName2 = stat.getTokenList().get(8).replaceAll("\"", ""), assocRoleName2 = assoc.getSource().getName())) continue;
            assocIsNew = false;
            break;
        }
        if (assocIsNew) {
            String name = CGUtil.shortClassName(role.getClazz().getFullName()) + "Class";
            name = StrUtil.downFirstChar(name);
            LocalVarTableEntry localVarTableEntry = localVarTable.get(name);
            int insertPos = localVarTableEntry.getEndPos() + 3;
            insertPos = currentInsertPos;
            currentInsertPos = this.insertCreationCode("      /* add assoc */", insertPos, modelCreationClass);
            currentInsertPos = this.insertCreationAssociationCode(assoc, currentInsertPos, modelCreationClass, symTabEntry);
        }
        return currentInsertPos;
    }

    private boolean stringsPairwiseEquals(String string1, String string2, String string3, String string4) {
        return StrUtil.stringEquals(string1, string2) && StrUtil.stringEquals(string3, string4) || StrUtil.stringEquals(string1, string3) && StrUtil.stringEquals(string2, string4) || StrUtil.stringEquals(string1, string4) && StrUtil.stringEquals(string2, string3);
    }

    private boolean compareAssocDecl(Association assoc, ArrayList<String> subSequence, String className, LinkedHashMap<String, LocalVarTableEntry> localVarTable) {
        String sourceInitSequence = subSequence.get(7).replaceAll("\"", "") + "|" + className.replaceAll("\"", "");
        String targetClassName = subSequence.get(1);
        for (String key : localVarTable.keySet()) {
            if (!key.equals(targetClassName)) continue;
            LocalVarTableEntry entry = localVarTable.get(key);
            ArrayList<ArrayList<String>> initSequence = entry.getInitSequence();
            targetClassName = initSequence.get(0).get(1);
        }
        String targetInitSequence = subSequence.get(2).replaceAll("\"", "") + "|" + targetClassName.replaceAll("\"", "");
        String sourceSequence = assoc.getSource().getName() + "|" + assoc.getSource().getClazz().getFullName();
        String targetSequence = assoc.getTarget().getName() + "|" + assoc.getTarget().getClazz().getFullName();
        return sourceInitSequence.equals(sourceSequence) && targetInitSequence.equals(targetSequence) || targetInitSequence.equals(sourceSequence) && sourceInitSequence.equals(targetSequence);
    }

    private boolean compareAssocDecl(Association assoc, LocalVarTableEntry localVarTableEntry) {
        return this.compareAssocs(assoc, localVarTableEntry.getInitSequence());
    }

    private boolean compareAssocs(Association assoc, ArrayList<ArrayList<String>> initSequence) {
        String sourceInitSequence = this.findInitSequenceAsString(".withSource", initSequence);
        sourceInitSequence = this.cutCardinality(sourceInitSequence);
        String targetInitSequence = this.findInitSequenceAsString(".withTarget", initSequence);
        targetInitSequence = this.cutCardinality(targetInitSequence);
        String sourceSequence = this.getInitSequenceAsString(".withSource", assoc);
        sourceSequence = this.cutCardinality(sourceSequence);
        String targetSequence = this.getInitSequenceAsString(".withTarget", assoc);
        targetSequence = this.cutCardinality(targetSequence);
        return sourceInitSequence.equals(sourceSequence) && targetInitSequence.equals(targetSequence) || targetInitSequence.equals(sourceSequence) && sourceInitSequence.equals(targetSequence);
    }

    private String cutCardinality(String sourceInitSequence) {
        sourceInitSequence = sourceInitSequence.substring(0, sourceInitSequence.lastIndexOf(44));
        return sourceInitSequence;
    }

    private String getInitSequenceAsString(String string, Association assoc) {
        String sequence = string + "(";
        Role role = null;
        if (".withSource".equals(string)) {
            role = assoc.getSource();
        } else if (".withTarget".equals(string)) {
            role = assoc.getTarget();
        } else {
            return null;
        }
        sequence = sequence + "\"" + role.getName() + "\"";
        String shortClassName = CGUtil.shortClassName(role.getClazz().getFullName());
        String clazzString = StrUtil.downFirstChar(shortClassName) + "Class";
        sequence = sequence + "," + clazzString + ",";
        sequence = sequence + "\"" + role.getCard() + "\"" + ")";
        return sequence;
    }

    private String findInitSequenceAsString(String searchString, ArrayList<ArrayList<String>> initSequence) {
        for (ArrayList<String> sequence : initSequence) {
            String sequenceString = "";
            for (String string : sequence) {
                sequenceString = sequenceString + string;
            }
            if (!sequenceString.startsWith(searchString)) continue;
            return sequenceString;
        }
        return null;
    }

    private int tryToInsertMethod(SymTabEntry symTabEntry, Method method, int currentInsertPos, Clazz modelCreationClass) {
        Parser parser = this.getOrCreate(modelCreationClass).getParser();
        parser.parseMethodBody(symTabEntry);
        boolean methodIsNew = true;
        LinkedHashMap<String, LocalVarTableEntry> localVarTable = parser.getLocalVarTable();
        for (LocalVarTableEntry localVarTableEntry : localVarTable.values()) {
            if (!this.compareMethodDecl(method, localVarTableEntry, modelCreationClass)) continue;
            currentInsertPos = localVarTableEntry.getEndPos() + 2;
            methodIsNew = false;
            break;
        }
        if (methodIsNew && !this.isSDMLibMethod(method)) {
            LocalVarTableEntry localVarTableEntry;
            String name = CGUtil.shortClassName(method.getClazz().getFullName()) + "Class";
            localVarTableEntry = localVarTable.get(name = StrUtil.downFirstChar(name));
            if (localVarTableEntry == null) {
                return currentInsertPos;
            }
            int insertPos = localVarTableEntry.getEndPos() + 1;
            currentInsertPos = this.insertCreationCode("\n      /* add method */", insertPos, modelCreationClass);
            currentInsertPos = this.insertCreationMethodCode(method, currentInsertPos, modelCreationClass, symTabEntry);
            this.writeToFile(modelCreationClass);
        }
        return currentInsertPos;
    }

    private boolean isSDMLibMethod(Method method) {
        return method.getName().startsWith("get") && method.getName().endsWith("Transitive");
    }

    private boolean compareMethodDecl(Method method, LocalVarTableEntry localVarTableEntry, Clazz modelCreationClass) {
        String shortClassName = CGUtil.shortClassName(method.getClazz().getFullName());
        ArrayList<ArrayList<String>> initSequence = localVarTableEntry.getInitSequence();
        ArrayList<String> init = initSequence.get(0);
        if (init.size() != 2) {
            return false;
        }
        if (!init.get(0).endsWith(".createClazz")) {
            return false;
        }
        String initClassName = init.get(1);
        if (!shortClassName.equals(CGUtil.shortClassName(initClassName = initClassName.substring(1, initClassName.length() - 1)))) {
            return false;
        }
        for (int i = 1; i < initSequence.size(); ++i) {
            String searchType;
            init = initSequence.get(i);
            if (!"withMethod".equals(init.get(0)) || !("\"" + method.getName() + "\"").equals(init.get(1))) continue;
            if (init.size() <= 7 && method.getParameter().size() == 0) {
                return true;
            }
            if (init.size() < 4) continue;
            String dataType = init.get(3);
            if (!dataType.equals(searchType = method.getReturnType().toString())) {
                return false;
            }
            try {
                int j = 6;
                Iterator paramIter = method.getParameter().iterator();
                while (j < init.size() && paramIter.hasNext()) {
                    Parameter searchParam = (Parameter)paramIter.next();
                    String token = init.get(j);
                    if (!token.equals("[")) {
                        return false;
                    }
                    if (!(token = init.get(++j)).equals("new")) {
                        return false;
                    }
                    if (!(token = init.get(++j)).equals("Parameter")) {
                        return false;
                    }
                    if (!(token = init.get(++j)).equals(searchParam.getType().toString())) {
                        if (!token.equals("DataType.ref") || !init.get(j + 1).equals("\"" + searchParam.getType().getValue() + "\"")) {
                            return false;
                        }
                        ++j;
                    }
                    if ((j += 3) != init.size() || paramIter.hasNext()) continue;
                    return true;
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    protected String parseDataType(String typeString, Clazz modelCreationClass) {
        String type = "";
        if (typeString.startsWith("DataType.ref")) {
            String typeSplit = typeString.substring("DataType.ref".length() + 1, typeString.length() - 1);
            if (typeSplit.startsWith("\"")) {
                typeSplit = typeSplit.replaceAll("\"", "");
                typeSplit = typeSplit.toUpperCase();
                return "DataType." + typeSplit;
            }
            LocalVarTableEntry tableEntry = this.getOrCreate(modelCreationClass).getParser().getLocalVarEntriesFor(typeSplit);
            if (tableEntry != null) {
                String className = tableEntry.getInitSequence().get(0).get(1).replaceAll("\"", "");
                className = className.toUpperCase();
                return "DataType." + className;
            }
        } else if (typeString.startsWith("DataType.")) {
            // empty if block
        }
        return type;
    }

    private int createAndInsertCodeForNewClazz(Clazz modelCreationClass, SymTabEntry symTabEntry, Clazz clazz, LinkedHashMap<String, Clazz> handledClazzes, int currentInsertPos) {
        Clazz superClass;
        String classModelName;
        String modelClassName = clazz.getFullName();
        if (modelClassName.startsWith(classModelName = clazz.getClassModel().getName())) {
            modelClassName = modelClassName.replaceFirst(classModelName + ".", "");
        }
        currentInsertPos = this.insertCreationClassCode(currentInsertPos, modelClassName, modelCreationClass, symTabEntry);
        if (clazz.isInterface()) {
            currentInsertPos = this.insertCreationIsInterfaceCode(currentInsertPos, modelCreationClass, symTabEntry);
            currentInsertPos = this.insertCreationCode("\n", currentInsertPos, modelCreationClass);
        }
        if ((superClass = clazz.getSuperClass()) != null) {
            currentInsertPos = this.insertCreationSuperClassCode(currentInsertPos, superClass.getFullName(), modelCreationClass, symTabEntry);
            currentInsertPos = this.insertCreationCode("\n", currentInsertPos, modelCreationClass);
        }
        Iterator iterator = clazz.getInterfaces().iterator();
        while (iterator.hasNext()) {
            Clazz interfaze = (Clazz)iterator.next();
            if (interfaze == null) continue;
            currentInsertPos = this.insertCreationInterfaceCode(currentInsertPos, interfaze.getFullName(), modelCreationClass, symTabEntry);
            currentInsertPos = this.insertCreationCode("\n", currentInsertPos, modelCreationClass);
        }
        AttributeSet clazzAttributes = clazz.getAttributes();
        TreeSet<Attribute> sortedAttributes = new TreeSet<Attribute>(new Comparator<Attribute>(){

            @Override
            public int compare(Attribute o1, Attribute o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Iterator<Object> iterator2 = clazzAttributes.iterator();
        while (iterator2.hasNext()) {
            Attribute attribute = (Attribute)iterator2.next();
            sortedAttributes.add(attribute);
        }
        for (Attribute attribute : sortedAttributes) {
            if ("PropertyChangeSupport".equals(attribute.getType())) continue;
            currentInsertPos = this.insertCreationAttributeCode(attribute, currentInsertPos, modelCreationClass, symTabEntry);
            currentInsertPos = this.insertCreationCode("\n", currentInsertPos, modelCreationClass);
        }
        currentInsertPos = 1 + this.insertCreationCode(";", currentInsertPos - 1, modelCreationClass);
        MethodSet methods = clazz.getMethods();
        TreeSet<Method> sortedMethods = new TreeSet<Method>(new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Iterator<Object> iterator3 = methods.iterator();
        while (iterator3.hasNext()) {
            Method method = (Method)iterator3.next();
            sortedMethods.add(method);
        }
        for (Method method : sortedMethods) {
            currentInsertPos = this.insertCreationMethodCode(method, currentInsertPos, modelCreationClass, symTabEntry);
        }
        TreeSet<Role> roles = new TreeSet<Role>(new Comparator<Role>(){

            @Override
            public int compare(Role o1, Role o2) {
                return o1.getPartnerRole().getName().compareTo(o2.getPartnerRole().getName());
            }
        });
        if (!clazz.getRoles().isEmpty()) {
            Iterator iterator4 = clazz.getRoles().iterator();
            while (iterator4.hasNext()) {
                Role role = (Role)iterator4.next();
                roles.add(role);
            }
        }
        currentInsertPos = this.handleAssocs(roles, currentInsertPos, modelCreationClass, symTabEntry, handledClazzes);
        return currentInsertPos;
    }

    private int handleAssocs(TreeSet<Role> roles, int currentInsertPos, Clazz modelCreationClass, SymTabEntry symTabEntry, LinkedHashMap<String, Clazz> handledClazzes) {
        ArrayList<Association> handledAssocs = new ArrayList<Association>();
        ArrayList<Role> handledRoles = new ArrayList<Role>();
        for (Role firstRole : roles) {
            Association assoc = firstRole.getAssoc();
            if (assoc == null || this.assocHasHandled(assoc, handledAssocs)) continue;
            Role secondRole = assoc.getTarget() != firstRole ? assoc.getTarget() : assoc.getSource();
            String secondClassName = secondRole.getClazz().getFullName();
            if (handledClazzes.containsKey(secondClassName) && !handledRoles.contains(secondRole)) {
                handledAssocs.add(assoc);
                handledRoles.add(firstRole);
                currentInsertPos = this.insertCreationAssociationCode(assoc, currentInsertPos, modelCreationClass, symTabEntry);
            }
            this.writeToFile(modelCreationClass);
        }
        return currentInsertPos;
    }

    private int insertNewCreationClasses(String callMethodName, Clazz modelCreationClass, String signature, int currentInsertPos, String rootDir) {
        return this.insertNewCreationClasses(modelCreationClass, signature, currentInsertPos, rootDir, new LinkedHashSet<Clazz>());
    }

    private int insertNewCreationClasses(Clazz modelCreationClass, String signature, int currentInsertPos, String rootDir, Set<Clazz> clazzQueue) {
        Clazz clazz;
        Iterator iterator = this.model.getClasses().iterator();
        while (iterator.hasNext()) {
            clazz = (Clazz)iterator.next();
            clazzQueue.add(clazz);
        }
        boolean format = false;
        while (!clazzQueue.isEmpty()) {
            clazz = clazzQueue.iterator().next();
            clazzQueue.remove(clazz);
            String modelClassName = clazz.getFullName();
            Parser parser = this.getOrCreate(modelCreationClass).getParser().parse();
            ArrayList<SymTabEntry> symTabEntry = parser.getSymTabEntriesFor(signature);
            parser.parseMethodBody(symTabEntry.get(0));
            LocalVarTableEntry entry = this.findInLocalVarTable(this.getOrCreate(modelCreationClass).getParser().getLocalVarTable(), modelClassName);
            if (entry != null) continue;
            if (!this.checkDependencies(clazz)) {
                clazzQueue.add(clazz);
            } else {
                if (!format) {
                    currentInsertPos = this.insertCreationCode("\n", currentInsertPos, modelCreationClass);
                    format = true;
                }
                this.handledClazzes.put(modelClassName, clazz);
                currentInsertPos = this.createAndInsertCodeForNewClazz(modelCreationClass, this.refreshMethodScan(signature, modelCreationClass, rootDir), clazz, this.handledClazzes, currentInsertPos);
            }
            this.writeToFile(modelCreationClass);
        }
        return currentInsertPos;
    }

    private boolean checkDependencies(Clazz clazz) {
        ArrayList<Clazz> dependencies = new ArrayList<Clazz>();
        if (clazz.getSuperClass() != null) {
            dependencies.add(clazz.getSuperClass());
        }
        if (clazz.getInterfaces() != null) {
            dependencies.addAll((Collection<Clazz>)((Object)clazz.getInterfaces()));
        }
        for (Clazz depClazz : dependencies) {
            if (this.handledClazzes.get(depClazz.getFullName()) != null) continue;
            return false;
        }
        return true;
    }

    private boolean assocHasHandled(Association assoc, ArrayList<Association> handledAssocs) {
        Role source = assoc.getSource();
        Role target = assoc.getTarget();
        for (Association association : handledAssocs) {
            Role source2 = association.getSource();
            Role target2 = association.getTarget();
            if (!this.compareRoles(source, target2) || !this.compareRoles(target, source2)) continue;
            return true;
        }
        return false;
    }

    private int insertCreationClassCode(int currentInsertPos, String modelClassName, Clazz modelCreationClass, SymTabEntry symTabEntry) {
        StringBuilder text = new StringBuilder("\n      Clazz localVar = clazzModel.createClazz(\"className\")\n");
        Parser parser = this.getOrCreate(modelCreationClass).getParser();
        LinkedHashMap<String, LocalVarTableEntry> localVarTable = parser.getLocalVarTable();
        for (String key : localVarTable.keySet()) {
            LocalVarTableEntry localVarTableEntry = localVarTable.get(key);
            if (!"ClassModel".equals(localVarTableEntry.getType())) continue;
            String classmodelName = localVarTableEntry.getName();
            CGUtil.replaceAll(text, "clazzModel", classmodelName);
            break;
        }
        CGUtil.replaceAll(text, "localVar", StrUtil.downFirstChar(CGUtil.shortClassName(modelClassName)) + "Class", "className", modelClassName);
        currentInsertPos = this.checkImport("Clazz", currentInsertPos, modelCreationClass, symTabEntry);
        return this.insertCreationCode(text, currentInsertPos, modelCreationClass);
    }

    private int insertCreationSuperClassCode(int currentInsertPos, String superClassName, Clazz modelCreationClass, SymTabEntry symTabEntry) {
        StringBuilder text = new StringBuilder("      .withSuperClazz(superClassName)");
        CGUtil.replaceAll(text, "superClassName", StrUtil.downFirstChar(CGUtil.shortClassName(superClassName)) + "Class");
        return this.insertCreationCode(text, currentInsertPos, modelCreationClass);
    }

    private int insertCreationInterfaceCode(int currentInsertPos, String interfaceName, Clazz modelCreationClass, SymTabEntry symTabEntry) {
        StringBuilder text = new StringBuilder("      .withSuperClazz(interfaceName)");
        CGUtil.replaceAll(text, "interfaceName", StrUtil.downFirstChar(CGUtil.shortClassName(interfaceName)) + "Class");
        return this.insertCreationCode(text, currentInsertPos, modelCreationClass);
    }

    private int insertCreationIsInterfaceCode(int currentInsertPos, Clazz modelCreationClass, SymTabEntry symTabEntry) {
        StringBuilder text = new StringBuilder("      .withInterface(true)");
        return this.insertCreationCode(text, currentInsertPos, modelCreationClass);
    }

    private int insertCreationAttributeCode(Attribute attribute, int currentInsertPos, Clazz modelCreationClass, SymTabEntry symTabEntry) {
        GenClass genCreationClass = this.getOrCreate(modelCreationClass);
        Parser parser = genCreationClass.getParser();
        String initialization = attribute.getInitialization();
        initialization = initialization != null ? ".withInitialization(\"" + initialization + "\")" : "";
        StringBuilder result = parser.replaceAll(currentInsertPos, "      .with(new Attribute(\"attributeName\", DataType.ref(\"attributeType\")) attributeInit)", "attributeType", attribute.getType().getValue(), "attributeName", attribute.getName(), "attributeInit", initialization);
        this.addImportForClazz("org.sdmlib.models.classes.Attribute", genCreationClass);
        return currentInsertPos + result.length();
    }

    private void addImportForClazz(String className, GenClass genCreationClass) {
        this.imports.put(className, genCreationClass);
    }

    private int insertCreationMethodCode(Method method, int currentInsertPos, Clazz modelCreationClass, SymTabEntry symTabEntry) {
        Object role;
        String methodName = method.getName();
        if (methodName.startsWith("get") && methodName.endsWith("Transitive")) {
            String part = methodName.substring("get".length(), methodName.length() - "Transitive".length());
            Clazz clazz = method.getClazz();
            Iterator iterator = clazz.getRoles().iterator();
            while (iterator.hasNext()) {
                role = (Role)iterator.next();
                if (!((SDMLibClass)role).getName().toLowerCase().equals(part.toLowerCase())) continue;
                return currentInsertPos;
            }
        }
        Parser parser = this.getOrCreate(modelCreationClass).getParser();
        String clazzName = method.getClazz().getFullName();
        clazzName = StrUtil.downFirstChar(CGUtil.shortClassName(clazzName)) + "Class";
        StringBuilder paString = new StringBuilder();
        role = method.getParameter().iterator();
        while (role.hasNext()) {
            Parameter parameter = (Parameter)role.next();
            paString.append(", new Parameter(" + parameter.getType().toString() + ")");
        }
        StringBuilder result = parser.replaceAll(currentInsertPos - 2, "\n      .withMethod(\"METHODNAME\", Return_TypePARAMETERS)", "Return_Type", method.getReturnType().toString(), "PARAMETERS", paString.toString(), "METHODNAME", methodName);
        currentInsertPos = this.checkImport("Method", currentInsertPos, modelCreationClass, symTabEntry);
        currentInsertPos += result.length();
        if (paString.length() > 0) {
            currentInsertPos = this.checkImport("Parameter", currentInsertPos, modelCreationClass, symTabEntry);
        }
        return currentInsertPos;
    }

    private int checkImport(String newImport, int currentInsertPos, Clazz modelCreationClass, SymTabEntry symTabEntry) {
        this.getOrCreate(modelCreationClass).getParser().indexOf("classEnd");
        SimpleKeyValueList<String, SymTabEntry> symTab = this.getOrCreate(modelCreationClass).getParser().getSymTab();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String key : symTab.keySet()) {
            if (!key.startsWith("import") || !key.endsWith("." + newImport) && !key.endsWith(".ClassModel")) continue;
            String path = key.replace("import:", "");
            int lastIndexOf = path.lastIndexOf(46) + 1;
            String name = path.substring(lastIndexOf);
            String pathString = path.substring(0, lastIndexOf - 1);
            result.put(name, pathString);
        }
        if (!result.containsKey(newImport) && result.containsKey("ClassModel")) {
            String symTabEntryName = (String)result.get("ClassModel");
            int endOfImports = this.getOrCreate(modelCreationClass).getParser().getEndOfImports() + 1;
            String importString = "\nimport " + symTabEntryName + "." + newImport + ";";
            this.insertCreationCode(importString, endOfImports, modelCreationClass);
            currentInsertPos += importString.length();
        }
        return currentInsertPos;
    }

    private int insertCreationAssociationCode(Association assoc, int currentInsertPos, Clazz modelCreationClass, SymTabEntry symTabEntry) {
        StringBuilder text = new StringBuilder("\n      sourceClazz.withAssoc(targetClazz, \"targetName\", targetCard, \"sourceName\", sourceCard);\n");
        Role source = assoc.getSource();
        Role target = assoc.getTarget();
        if (source.getName().compareTo(target.getName()) < 1) {
            Role tempRole = source;
            source = target;
            target = tempRole;
        }
        String sourceCard = "Card." + source.getCard().toUpperCase();
        String sourceName = source.getName();
        String sourceClazz = StrUtil.downFirstChar(CGUtil.shortClassName(source.getClazz().getFullName())) + "Class";
        String targetCard = "Card." + target.getCard().toUpperCase();
        String targetName = target.getName();
        String targetClazz = StrUtil.downFirstChar(CGUtil.shortClassName(target.getClazz().getFullName())) + "Class";
        CGUtil.replaceAll(text, "sourceName", sourceName, "sourceClazz", sourceClazz, "sourceCard", sourceCard, "targetName", targetName, "targetClazz", targetClazz, "targetCard", targetCard);
        currentInsertPos = this.checkImport("Association", currentInsertPos, modelCreationClass, symTabEntry);
        GenClass genCreationClass = this.getOrCreate(modelCreationClass);
        this.addImportForClazz("org.sdmlib.models.classes.Card", genCreationClass);
        return this.insertCreationCode(text, currentInsertPos, modelCreationClass);
    }

    private boolean checkSuper(Clazz clazz, LocalVarTableEntry entry, String classType) {
        ArrayList<ArrayList<String>> initSequence = entry.getInitSequence();
        for (ArrayList<String> sequencePart : initSequence) {
            if (!classType.equals(sequencePart.get(0))) continue;
            return true;
        }
        return false;
    }

    private boolean isInterface(LocalVarTableEntry entry) {
        ArrayList<ArrayList<String>> initSequence = entry.getInitSequence();
        for (ArrayList<String> sequencePart : initSequence) {
            if (!"withInterface".equals(sequencePart.get(0))) continue;
            return true;
        }
        return false;
    }

    private int insertCreationCode(StringBuilder text, int insertPos, Clazz modelCreationClass) {
        this.getOrCreate(modelCreationClass).getParser().insert(insertPos, text.toString());
        return insertPos + text.length();
    }

    private int insertCreationCode(String string, int insertPos, Clazz modelCreationClass) {
        StringBuilder text = new StringBuilder(string);
        return this.insertCreationCode(text, insertPos, modelCreationClass);
    }

    public String getMemberType(String currentType, String varName) {
        String result = null;
        Iterator iterator = this.model.getClasses().iterator();
        while (iterator.hasNext()) {
            Clazz clazz = (Clazz)iterator.next();
            String name = CGUtil.shortClassName(clazz.getFullName());
            if (!StrUtil.stringEquals(name, currentType)) continue;
            Iterator iterator2 = clazz.getAttributes().iterator();
            while (iterator2.hasNext()) {
                Attribute attr = (Attribute)iterator2.next();
                if (!StrUtil.stringEquals(attr.getName(), varName)) continue;
                return attr.getType().getValue();
            }
            iterator2 = clazz.getRoles().iterator();
            while (iterator2.hasNext()) {
                Role role = (Role)iterator2.next();
                if (!StrUtil.stringEquals((role = role.getPartnerRole()).getName(), varName)) continue;
                return CGUtil.shortClassName(role.getClazz().getFullName());
            }
        }
        return result;
    }

    public ClassModel learnFromGenericObjects(String packageName, GenericObject root) {
        LinkedHashSet<Object> allObjects = new LinkedHashSet<Object>();
        LinkedList<GenericObject> todoObjects = new LinkedList<GenericObject>();
        LinkedHashSet allLinks = new LinkedHashSet();
        todoObjects.add(root);
        while (!todoObjects.isEmpty()) {
            GenericObject currentObject = (GenericObject)todoObjects.pop();
            allObjects.add(currentObject);
            allLinks.addAll(currentObject.getOutgoingLinks());
            allLinks.addAll(currentObject.getIncommingLinks());
            todoObjects.addAll((Collection<GenericObject>)currentObject.getOutgoingLinks().getTgt().minus(allObjects));
            todoObjects.addAll((Collection<GenericObject>)currentObject.getIncommingLinks().getSrc().minus(allObjects));
        }
        for (GenericObject genericObject : allObjects) {
            if (genericObject.getType() == null) continue;
            Clazz currentClazz = this.getOrCreateClazz(packageName + "." + genericObject.getType());
            Iterator iterator = genericObject.getAttrs().iterator();
            while (iterator.hasNext()) {
                GenericAttribute attr = (GenericAttribute)iterator.next();
                Attribute attrDecl = currentClazz.getOrCreateAttribute(attr.getName(), DataType.OBJECT);
                this.learnAttrType(attr, attrDecl);
            }
        }
        LinkedHashSet<String> alreadyUsedLabels = new LinkedHashSet<String>();
        for (GenericLink currentLink : allLinks) {
            String targetLabel;
            String targetType;
            String sourceType = currentLink.getSrc().getType();
            if (sourceType == null || (targetType = currentLink.getTgt().getType()) == null) continue;
            String sourceLabel = currentLink.getSrcLabel();
            if (sourceLabel == null) {
                sourceLabel = StrUtil.downFirstChar(sourceType) + "s";
            }
            if ((targetLabel = currentLink.getTgtLabel()) == null) {
                targetLabel = StrUtil.downFirstChar(sourceType) + "s";
            }
            Association currentAssoc = null;
            Iterator iterator = this.getAssociations().iterator();
            while (iterator.hasNext()) {
                Association assoc = (Association)iterator.next();
                if (!sourceType.equals(CGUtil.shortClassName(assoc.getSource().getClazz().getName())) || !targetType.equals(CGUtil.shortClassName(assoc.getTarget().getClazz().getName())) || !sourceLabel.equals(assoc.getSource().getName()) || !targetLabel.equals(assoc.getTarget().getName())) continue;
                currentAssoc = assoc;
                break;
            }
            if (currentAssoc == null) {
                currentAssoc = new Association().withSource(this.getOrCreateClazz(packageName + "." + sourceType), sourceLabel, Card.ONE).withTarget(this.getOrCreateClazz(packageName + "." + targetType), targetLabel, Card.ONE);
                this.addToAssociations(currentAssoc);
            }
            if (alreadyUsedLabels.contains(currentLink.getSrc().hashCode() + ":" + targetLabel)) {
                currentAssoc.getTarget().setCard(Card.MANY.toString());
            }
            if (alreadyUsedLabels.contains(currentLink.getTgt().hashCode() + ":" + sourceLabel)) {
                currentAssoc.getSource().setCard(Card.MANY.toString());
            }
            alreadyUsedLabels.add(currentLink.getSrc().hashCode() + ":" + targetLabel);
            alreadyUsedLabels.add(currentLink.getTgt().hashCode() + ":" + sourceLabel);
        }
        return this.getModel();
    }

    private void learnAttrType(GenericAttribute attr, Attribute attrDecl) {
        String valueString = attr.getValue();
        DataType attrType = DataType.STRING;
        try {
            Integer.parseInt(valueString);
            attrType = DataType.INT;
        }
        catch (NumberFormatException e) {
            try {
                Double.parseDouble(valueString);
                attrType = DataType.DOUBLE;
            }
            catch (NumberFormatException e1) {
                try {
                    DateFormat.getDateInstance().parse(valueString);
                    attrType = DataType.ref("java.util.Date");
                }
                catch (ParseException e2) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-mm-dd'T'hh:mm:ss");
                        simpleDateFormat.parse(valueString);
                        attrType = DataType.ref("java.util.Date");
                    }
                    catch (ParseException e3) {
                        // empty catch block
                    }
                }
            }
        }
        String typeOrder = "Object int double java.util.Date String";
        if (typeOrder.indexOf(attrDecl.getType().getValue()) < typeOrder.indexOf(attrType.getValue())) {
            attrDecl.setType(attrType);
        }
    }

    private boolean compareRoles(Role first, Role second) {
        Clazz firstClass = first.getClazz();
        String firstName = first.getName();
        String firstCard = first.getCard();
        Clazz secondClass = second.getClazz();
        String secondName = second.getName();
        String secondCard = second.getCard();
        return firstClass == secondClass && firstName.equals(secondName) && firstCard.equals(secondCard);
    }

    public Clazz findClass(String partnerClassName) {
        Iterator iterator = this.model.getClasses().iterator();
        while (iterator.hasNext()) {
            Clazz partnerClass = (Clazz)iterator.next();
            String shortClassName = CGUtil.shortClassName(partnerClass.getFullName());
            if (!partnerClassName.equals(shortClassName)) continue;
            return partnerClass;
        }
        return null;
    }

    public String findPartnerClassName(String partnerTypeName) {
        int openAngleBracket = partnerTypeName.indexOf("<");
        int closeAngleBracket = partnerTypeName.indexOf(">");
        String partnerClassName = openAngleBracket > -1 && closeAngleBracket > openAngleBracket ? partnerTypeName.substring(openAngleBracket + 1, closeAngleBracket) : (partnerTypeName.endsWith("Set") ? partnerTypeName.substring(0, partnerTypeName.length() - 3) : partnerTypeName);
        return partnerClassName;
    }

    private ArrayList<File> searchForJavaFiles(String path) {
        ArrayList<File> javaFiles = new ArrayList<File>();
        File file = new File(path);
        if (file.exists() && file.isDirectory()) {
            File[] directory;
            File[] listFiles = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.toLowerCase().endsWith(".java");
                }
            });
            Collections.addAll(javaFiles, listFiles);
            for (File dir : directory = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return file.isDirectory();
                }
            })) {
                javaFiles.addAll(this.searchForJavaFiles(dir.getPath()));
            }
        }
        javaFiles.sort(new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                return file1.getAbsolutePath().compareTo(file2.getAbsolutePath());
            }
        });
        return javaFiles;
    }

    public void updateFromCode(String includePathes, String packages) {
        File projectRootFolder = new File(".");
        this.updateFromCode(includePathes, packages, projectRootFolder);
    }

    public void updateFromCode(String includePathes, String packages, File projectRoot) {
        if (projectRoot != null) {
            ArrayList<File> javaFiles = this.searchForJavaFiles(includePathes, packages, projectRoot);
            this.addJavaFilesToClasses(packages, projectRoot, javaFiles);
            if (this.model.getClasses().isEmpty()) {
                System.out.println("no class files found !!!! END");
                return;
            }
            Iterator i = this.model.getClasses().cloneIterator();
            while (i.hasNext()) {
                Clazz clazz = (Clazz)i.next();
                this.handleMember(clazz, includePathes, projectRoot);
            }
        }
    }

    private Clazz handleMember(Clazz clazz, String rootDir, File projectRoot) {
        System.out.println("parse " + clazz.getFullName());
        Parser parser = this.getOrCreate(clazz).getOrCreateParser(projectRoot.getAbsolutePath() + "//" + rootDir);
        parser.indexOf("classEnd");
        if (this.isHelperClass(parser)) {
            clazz.removeYou();
        }
        if ("interface".equals(parser.getClassType())) {
            clazz.setInterface(true);
        }
        LinkedHashMap<String, Object> symTab = new LinkedHashMap<String, Object>();
        for (String key : parser.getSymTab().keySet()) {
            symTab.put(key, parser.getSymTab().get((Object)key));
        }
        for (String memberName : symTab.keySet()) {
            this.addMemberToModel(clazz, parser, memberName, rootDir);
        }
        return clazz;
    }

    private boolean isSDMLibClass(Clazz clazz) {
        String sDMLibClasses = "org.sdmlib.serialization.EntityFactory org.sdmlib.models.pattern.PatternObject org.sdmlib.models.pattern.util.PatternObjectCreator org.sdmlib.models.modelsets.SDMSet org.sdmlib.serialization.PropertyChangeInterface";
        String className = clazz.getFullName();
        return sDMLibClasses.indexOf(className) >= 0;
    }

    private boolean isHelperClass(Parser parser) {
        String className = parser.getClassName();
        if ("CreatorCreator".equals(className)) {
            return true;
        }
        if (className.endsWith("Creator") && this.isClassExtends("EntityFactory PatternObjectCreator", parser)) {
            return true;
        }
        if (this.isClassExtends("PatternObject", parser)) {
            return true;
        }
        return this.isClassExtends("SDMSet", parser);
    }

    private boolean isClassExtends(String extendsString, Parser parser) {
        for (String extendClass : extendsString.split(" ")) {
            if (parser.getSymTabEntriesFor("extends:" + extendClass).size() <= 0) continue;
            return true;
        }
        return false;
    }

    private void addMemberToModel(Clazz clazz, Parser parser, String memberName, String rootDir) {
        if (memberName.startsWith("method")) {
            this.addMemberAsMethod(clazz, memberName, parser);
        } else if (memberName.startsWith("attribute")) {
            String[] split = memberName.split(":");
            String attrName = split[1];
            SymTabEntry symTabEntry = (SymTabEntry)parser.getSymTab().get((Object)memberName);
            if (symTabEntry != null) {
                this.addMemberAsAttribut(clazz, attrName, symTabEntry, rootDir);
            }
        }
        if (memberName.startsWith("extends")) {
            if (clazz.isInterface()) {
                this.addMemberAsInterface(clazz, memberName, parser);
            } else {
                this.addMemberAsSuperClass(clazz, memberName, parser);
            }
        } else if (memberName.startsWith("implements")) {
            this.addMemberAsInterface(clazz, memberName, parser);
        }
    }

    private void addMemberAsAttribut(Clazz clazz, String attrName, SymTabEntry symTabEntry, String rootDir) {
        String modifiers = symTabEntry.getModifiers();
        if ((modifiers.indexOf("public") >= 0 || modifiers.indexOf("private") >= 0) && modifiers.indexOf("static") >= 0 && modifiers.indexOf("final") >= 0) {
            return;
        }
        String type = symTabEntry.getType();
        if (CGUtil.isPrimitiveType(type = type.replace("[]", ""))) {
            if (!this.classContainsAttribut(clazz, attrName, symTabEntry.getType())) {
                new Attribute(attrName, DataType.ref(symTabEntry.getType())).with(clazz);
            }
        } else {
            this.handleComplexAttr(clazz, attrName, symTabEntry, rootDir);
        }
    }

    private void handleComplexAttr(Clazz clazz, String attrName, SymTabEntry symTabEntry, String rootDir) {
        String memberName = symTabEntry.getMemberName();
        String partnerTypeName = symTabEntry.getType();
        String partnerClassName = this.findPartnerClassName(partnerTypeName);
        Clazz partnerClass = this.model.getClazz(partnerTypeName);
        if (partnerClass == null) {
            return;
        }
        Card card = this.findRoleCard(partnerTypeName);
        String setterPrefix = "set";
        if (Card.MANY.equals((Object)card)) {
            setterPrefix = "addTo";
        }
        String name = StrUtil.upFirstChar(memberName);
        Parser parser = this.getOrCreate(clazz).getParser().parse();
        SymTabEntry addToSymTabEntry = (SymTabEntry)parser.getSymTab().get((Object)("method:" + setterPrefix + name + "(" + partnerClassName + ")"));
        if (addToSymTabEntry == null && "addTo".equals(setterPrefix)) {
            addToSymTabEntry = (SymTabEntry)parser.getSymTab().get((Object)("method:with" + name + "(" + partnerClassName + "...)"));
        }
        if (addToSymTabEntry == null) {
            new Attribute(memberName, DataType.ref(partnerTypeName)).with(clazz);
            return;
        }
        parser.parseMethodBody(addToSymTabEntry);
        LinkedHashSet<String> methodBodyQualifiedNames = new LinkedHashSet<String>();
        for (String key : parser.getMethodBodyQualifiedNames()) {
            methodBodyQualifiedNames.add(key);
        }
        boolean done = false;
        for (String qualifiedName : methodBodyQualifiedNames) {
            if (qualifiedName.startsWith("value.set")) {
                this.handleAssoc(clazz, rootDir, memberName, card, partnerClassName, partnerClass, qualifiedName.substring("value.set".length()));
                done = true;
                continue;
            }
            if (qualifiedName.startsWith("value.with") || qualifiedName.startsWith("item.with")) {
                this.handleAssoc(clazz, rootDir, memberName, card, partnerClassName, partnerClass, qualifiedName.substring("value.with".length()));
                done = true;
                continue;
            }
            if (!qualifiedName.startsWith("value.addTo")) continue;
            this.handleAssoc(clazz, rootDir, memberName, card, partnerClassName, partnerClass, qualifiedName.substring("value.addTo".length()));
            done = true;
        }
        if (!done) {
            new Attribute(memberName, DataType.ref(partnerTypeName)).with(clazz);
        }
    }

    private void handleAssoc(Clazz clazz, String rootDir, String memberName, Card card, String partnerClassName, Clazz partnerClass, String partnerAttrName) {
        String searchString;
        partnerAttrName = StrUtil.downFirstChar(partnerAttrName);
        GenClass partnerGenClass = this.getOrCreate(partnerClass);
        Parser partnerParser = partnerGenClass.getOrCreateParser(rootDir);
        int attributePosition = partnerParser.indexOf(searchString = "attribute:" + partnerAttrName);
        if (attributePosition > -1) {
            Card partnerCard = this.findRoleCard(partnerParser, searchString);
            this.tryToCreateAssoc(clazz, memberName, card, partnerClassName, partnerClass, partnerAttrName, partnerCard);
        }
    }

    private void tryToCreateAssoc(Clazz clazz, String memberName, Card card, String partnerClassName, Clazz partnerClass, String partnerAttrName, Card partnerCard) {
        Role sourceRole = new Role(clazz, partnerAttrName, partnerCard);
        Role targetRole = new Role(partnerClass, memberName, card);
        if (!this.assocWithRolesExists(sourceRole, targetRole)) {
            new Association().withSource(sourceRole).withTarget(targetRole);
            clazz.with(sourceRole);
        }
    }

    private boolean assocWithRolesExists(Role source, Role target) {
        Iterator iterator = this.getAssociations().iterator();
        while (iterator.hasNext()) {
            Association assoc = (Association)iterator.next();
            if (!this.compareRoles(source, target, assoc) && !this.compareRoles(target, source, assoc)) continue;
            return true;
        }
        return false;
    }

    private boolean compareRoles(Role source, Role target, Association assoc) {
        return this.compareRoles(assoc.getSource(), source) && this.compareRoles(assoc.getTarget(), target);
    }

    private Card findRoleCard(Parser partnerParser, String searchString) {
        SymTabEntry partnerSymTabEntry = (SymTabEntry)partnerParser.getSymTab().get((Object)searchString);
        String partnerTypeName = partnerSymTabEntry.getType();
        return this.findRoleCard(partnerTypeName);
    }

    private Card findRoleCard(String partnerTypeName) {
        Card partnerCard = Card.ONE;
        int _openAngleBracket = partnerTypeName.indexOf("<");
        int _closeAngleBracket = partnerTypeName.indexOf(">");
        if (_openAngleBracket > 1 && _closeAngleBracket > _openAngleBracket) {
            partnerCard = Card.MANY;
        } else if (partnerTypeName.endsWith("Set") && partnerTypeName.length() > 3) {
            String prefix = partnerTypeName.substring(0, partnerTypeName.length() - 3);
            Iterator iterator = this.model.getClasses().iterator();
            while (iterator.hasNext()) {
                Clazz clazz = (Clazz)iterator.next();
                if (!prefix.equals(CGUtil.shortClassName(clazz.getName()))) continue;
                partnerCard = Card.MANY;
                break;
            }
        }
        return partnerCard;
    }

    private void addMemberAsSuperClass(Clazz clazz, String memberName, Parser parser) {
        Clazz memberClass = this.findMemberClass(clazz, memberName, parser);
        if (this.isSDMLibClass(memberClass)) {
            memberClass.removeYou();
            return;
        }
        if (memberClass != null) {
            clazz.withSuperClazz(memberClass);
        }
    }

    private void addMemberAsInterface(Clazz clazz, String memberName, Parser parser) {
        Clazz memberClass = this.findMemberClass(clazz, memberName, parser);
        if (this.isSDMLibClass(memberClass)) {
            memberClass.removeYou();
            return;
        }
        if (memberClass != null) {
            memberClass.withInterface(true);
            clazz.withSuperClazz(memberClass);
        }
    }

    private Clazz findMemberClass(Clazz clazz, String memberName, Parser parser) {
        String[] split = memberName.split(":");
        String signature = split[1];
        SimpleKeyValueList<String, SymTabEntry> symTab = parser.getSymTab();
        for (String key : symTab.keySet()) {
            Clazz modelClass;
            String importName = ((SymTabEntry)symTab.get(key)).getMemberName();
            if (key.startsWith("import:") && importName.endsWith(signature)) {
                modelClass = this.findClassInModel(importName);
                if (modelClass != null) {
                    return modelClass;
                }
                Clazz externClass = this.model.createClazz(importName).withExternal(true);
                return externClass;
            }
            if (!key.startsWith("import:") || !importName.endsWith("*") || (modelClass = this.findClassInModel(importName = importName.substring(0, importName.length() - 1) + signature)) == null) continue;
            return modelClass;
        }
        String name = clazz.getFullName();
        int lastIndex = name.lastIndexOf(46);
        name = name.substring(0, lastIndex + 1) + signature;
        return this.findClassInModel(name);
    }

    private Clazz findClassInModel(String name) {
        ClazzSet classes = this.model.getClasses();
        Iterator iterator = classes.iterator();
        while (iterator.hasNext()) {
            Clazz eClazz = (Clazz)iterator.next();
            if (!eClazz.getFullName().equals(name)) continue;
            return eClazz;
        }
        return null;
    }

    private void addMemberAsMethod(Clazz clazz, String memberName, Parser parser) {
        String fullSignature;
        String[] split;
        String signature;
        String filterString;
        SymTabEntry symTabEntry = (SymTabEntry)parser.getSymTab().get((Object)memberName);
        if (symTabEntry == null) {
            parser.parse();
            symTabEntry = (SymTabEntry)parser.getSymTab().get((Object)memberName);
        }
        if ((filterString = "get(String) set(String,Object) getPropertyChangeSupport() removeYou() addPropertyChangeListener(PropertyChangeListener) removePropertyChangeListener(PropertyChangeListener) addPropertyChangeListener(String,PropertyChangeListener) removePropertyChangeListener(String,PropertyChangeListener)toString()").indexOf(signature = (split = (fullSignature = symTabEntry.getType()).split(":"))[1]) < 0 && !this.isGetterSetter(signature, parser, clazz) && this.isNewMethod(signature, clazz)) {
            int part = signature.indexOf("(");
            String[] params = signature.substring(part + 1, signature.length() - 1).split(",");
            Method method = new Method(signature.substring(0, part), new Parameter[0]).with(clazz).withReturnType(DataType.ref(split[2]));
            for (String param : params) {
                if (param == null || param.length() <= 0) continue;
                method.with(new Parameter(DataType.ref(param)));
            }
            if (!symTabEntry.getAnnotations().isEmpty()) {
                method.withAnnotations(new Annotation().withName(symTabEntry.getAnnotations()));
            }
        }
    }

    private boolean isGetterSetter(String signature, Parser parser, Clazz clazz) {
        SimpleKeyValueList<String, SymTabEntry> symTab = parser.getSymTab();
        ArrayList<String> attributeKeys = new ArrayList<String>();
        for (String key : symTab.keySet()) {
            if (!key.startsWith("attribute:")) continue;
            attributeKeys.add(key);
        }
        if (signature.startsWith("with") || signature.startsWith("set") || signature.startsWith("get") || signature.startsWith("add") || signature.startsWith("remove") || signature.startsWith("create")) {
            for (String attrKey : attributeKeys) {
                SymTabEntry symTabEntry = (SymTabEntry)symTab.get(attrKey);
                String attrName = symTabEntry.getMemberName();
                String signName = signature.substring(0, signature.indexOf("("));
                if (!signName.toLowerCase().endsWith(attrName.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNewMethod(String memberName, Clazz clazz) {
        Iterator iterator = clazz.getMethods().iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (!method.getSignature(true).equals(memberName)) continue;
            return false;
        }
        return true;
    }

    private ArrayList<File> searchForJavaFiles(String includePathes, String packageString, File projectRoot) {
        ArrayList<File> javaFiles = new ArrayList<File>();
        String[] packages = packageString.split("\\s+");
        String[] includes = includePathes.split("\\s+");
        for (String pAckage : packages) {
            String packagepath = pAckage.replace('.', '/');
            for (String include : includes) {
                String newPath = projectRoot.getPath() + "/" + include + "/" + packagepath;
                javaFiles.addAll(this.searchForJavaFiles(newPath));
            }
        }
        return javaFiles;
    }

    private void addJavaFilesToClasses(String packageString, File srcFolder, ArrayList<File> javaFiles) {
        String[] packages = packageString.split("\\s+");
        for (File file : javaFiles) {
            String filePath = file.getAbsolutePath();
            filePath = filePath.replace(srcFolder.getAbsolutePath(), "");
            filePath = filePath.replace(File.separatorChar, '.').substring(1);
            filePath = filePath.substring(0, filePath.length() - 5);
            this.addClassToClasses(filePath, packages);
        }
    }

    private void addClassToClasses(String filePath, String[] packages) {
        int pos = filePath.indexOf(46);
        int n = 0;
        String[] stringArray = packages;
        int n2 = stringArray.length;
        if (n < n2) {
            String packageName = stringArray[n];
            pos = filePath.indexOf(packageName) - 1;
        }
        String rootDir = filePath.substring(0, pos);
        if (this.commonPrefix(filePath = filePath.substring(pos + 1), packages)) {
            if (!this.classExists(filePath)) {
                Clazz clazz = this.model.createClazz(filePath);
                this.getOrCreate(clazz).withFilePath(rootDir);
            }
            return;
        }
    }

    private boolean commonPrefix(String filePath, String[] packages) {
        for (String p : packages) {
            if (!filePath.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    private boolean classContainsAttribut(Clazz clazz, String attrName, String type) {
        Iterator iterator = clazz.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute attr = (Attribute)iterator.next();
            if (!attrName.equals(attr.getName()) || !type.equals(attr.getType())) continue;
            return true;
        }
        return false;
    }

    private boolean classExists(String filePath) {
        Iterator iterator = this.model.getClasses().iterator();
        while (iterator.hasNext()) {
            Clazz clazz = (Clazz)iterator.next();
            if (!clazz.getFullName().equals(filePath)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAttribute(Attribute attribute, LocalVarTableEntry entry, String rootDir) {
        String name = attribute.getName();
        ArrayList<ArrayList<String>> initSequence = entry.getInitSequence();
        for (ArrayList<String> sequencePart : initSequence) {
            ArrayList<String> isAttribute = this.partIsAttribute(sequencePart);
            if (isAttribute != null) {
                String sequencePartName = isAttribute.get(0).replace("\"", "");
                if (!StrUtil.stringEquals(name, sequencePartName)) continue;
                return true;
            }
            if (!"model.createClazz".equals(sequencePart.get(0))) continue;
            int pos = 2;
            while (pos + 1 < sequencePart.size()) {
                String attrName = sequencePart.get(pos).replace("\"", "");
                if (StrUtil.stringEquals(name, attrName)) {
                    return true;
                }
                pos += 2;
            }
        }
        String withAttrCall = entry.getName() + ".with";
        String attrNameQuoted = "\"" + name + "\"";
        GenClass orCreate = this.getOrCreate(attribute.getClazz());
        Parser parser = orCreate.getOrCreateParser(rootDir);
        parser.parse();
        StatementEntry currentStatement = parser.getCurrentStatement();
        if (currentStatement == null) {
            return false;
        }
        StatementEntry parent = currentStatement.getParent();
        StatementEntrySet bodyStats = parent.getBodyStats();
        Iterator iterator = bodyStats.iterator();
        while (iterator.hasNext()) {
            StatementEntry stat = (StatementEntry)iterator.next();
            String firstToken = stat.getTokenList().get(0);
            if (!StrUtil.stringEquals(withAttrCall, firstToken)) continue;
            for (int i = 2; i < stat.getTokenList().size(); ++i) {
                if (!StrUtil.stringEquals(attrNameQuoted, stat.getTokenList().get(i))) continue;
                return true;
            }
        }
        return false;
    }

    private ArrayList<String> partIsAttribute(ArrayList<String> sequencePart) {
        ArrayList<String> attributeSequence = new ArrayList<String>();
        if ("with".equals(sequencePart.get(0)) && "[".equals(sequencePart.get(1)) && "new".equals(sequencePart.get(2)) && "Attribute".equals(sequencePart.get(3))) {
            attributeSequence.add(sequencePart.get(4));
            attributeSequence.add(sequencePart.get(6));
            return attributeSequence;
        }
        if ("withAttribute".equals(sequencePart.get(0))) {
            attributeSequence.add(sequencePart.get(1));
            attributeSequence.add(sequencePart.get(5));
            return attributeSequence;
        }
        return null;
    }

    public void removeAllGeneratedCode(String rootDir, String srcDir, String helpersDir) {
        this.turnRemoveCallToComment(rootDir);
        Iterator iterator = this.model.getClasses().iterator();
        while (iterator.hasNext()) {
            Clazz clazz = (Clazz)iterator.next();
            try {
                this.removeAllCodeForClass(srcDir, helpersDir, clazz);
            }
            catch (Exception e) {}
        }
    }

    public void turnRemoveCallToComment(String rootDir) {
        int codeLineNumber = -1;
        String className = null;
        try {
            throw new RuntimeException();
        }
        catch (Exception e) {
            StackTraceElement[] stackTrace = e.getStackTrace();
            StackTraceElement callEntry = stackTrace[2];
            codeLineNumber = callEntry.getLineNumber();
            className = callEntry.getClassName();
            String fileName = rootDir + "/" + className.replaceAll("\\.", "/") + ".java";
            File file = new File(fileName);
            if (file.exists()) {
                try {
                    BufferedReader in = new BufferedReader(new FileReader(file));
                    String line = "";
                    int lineNo = 0;
                    StringBuilder buf = new StringBuilder();
                    while ((line = in.readLine()) != null) {
                        if (++lineNo == codeLineNumber && line.indexOf("//") == -1) {
                            int pos;
                            for (pos = 0; pos < line.length() && Character.isWhitespace(line.charAt(pos)); ++pos) {
                            }
                            line = line.substring(0, pos) + "// " + line.substring(pos);
                        }
                        buf.append(line).append('\n');
                    }
                    in.close();
                    FileWriter fileWriter = new FileWriter(file);
                    fileWriter.write(buf.toString());
                    fileWriter.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            return;
        }
    }

    public void removeAllCodeForClass(String srcDir, String helpersDir, Clazz clazz) {
        String className = clazz.getFullName();
        int pos = className.lastIndexOf(46);
        String packageName = className.substring(0, pos);
        String fileName = srcDir + "/" + className.replaceAll("\\.", "/") + ".java";
        this.deleteFile(fileName);
        String path = helpersDir + "/" + (packageName + UTILPATH).replaceAll("\\.", "/") + "/";
        fileName = path + CGUtil.shortClassName(className) + "Creator.java";
        this.deleteFile(fileName);
        fileName = path + CGUtil.shortClassName(className) + "Set.java";
        this.deleteFile(fileName);
        fileName = path + CGUtil.shortClassName(className) + "PO.java";
        this.deleteFile(fileName);
        fileName = path + CGUtil.shortClassName(className) + "POCreator.java";
        this.deleteFile(fileName);
        fileName = path + "CreatorCreator.java";
        this.deleteFile(fileName);
    }

    private void deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    public DIFF getShowDiff() {
        return this.showDiff;
    }

    public GenClassModel withShowDiff(DIFF showDiff) {
        this.showDiff = showDiff;
        return this;
    }

    public GenClassModel withIgnoreClazz(String name) {
        if (this.ignoreDiff == null) {
            this.ignoreDiff = new ArrayList<String>();
        }
        this.ignoreDiff.add(name);
        return this;
    }

    public void doCoverageOfModelCode() {
        Clazz firstClazz = (Clazz)this.getModel().getClasses().first();
        try {
            String creatorClassName = CGUtil.helperClassName(firstClazz.getFullName(), "Creator");
            Class<?> creatorClass = Class.forName(creatorClassName);
            java.lang.reflect.Method method = creatorClass.getMethod("createIdMap", String.class);
            JsonIdMap map = (JsonIdMap)method.invoke(null, "t");
            Iterator iterator = this.model.getClasses().iterator();
            while (iterator.hasNext()) {
                Clazz clazz = (Clazz)iterator.next();
                try {
                    SendableEntityCreator creator = map.getCreator(clazz.getFullName(), true);
                    Object object1 = creator.getSendableInstance(false);
                    map.getId(object1);
                    Iterator iterator2 = clazz.getAttributes().iterator();
                    while (iterator2.hasNext()) {
                        Attribute attr = (Attribute)iterator2.next();
                        try {
                            creator.setValue(object1, attr.getName(), (Object)"42", "");
                        }
                        catch (Exception g) {}
                    }
                    iterator2 = clazz.getRoles().iterator();
                    while (iterator2.hasNext()) {
                        Role role = (Role)iterator2.next();
                        role = role.getPartnerRole();
                        Clazz partnerClazz = role.getClazz();
                        SendableEntityCreator partnerCreator = map.getCreator(partnerClazz.getFullName(), true);
                        Object partnerObject = partnerCreator.getSendableInstance(false);
                        map.getId(partnerObject);
                        creator.setValue(object1, role.getName(), partnerObject, "");
                        try {
                            java.lang.reflect.Method createMethod = object1.getClass().getMethod("create" + StrUtil.upFirstChar(role.getName()), new Class[0]);
                            createMethod.invoke(object1, new Object[0]);
                        }
                        catch (Exception g) {}
                    }
                }
                catch (Exception f) {
                }
            }
            Storyboard story = new Storyboard("coverage");
            story.coverSetAndPOClasses(map);
            story.coverSeldomModelMethods(map);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enum DIFF {
        NONE,
        DIFF,
        FULL;

    }
}

