/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes.logic;

import de.uniks.networkparser.json.JsonIdMap;
import de.uniks.networkparser.list.SimpleKeyValueList;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.sdmlib.CGUtil;
import org.sdmlib.StrUtil;
import org.sdmlib.codegen.LocalVarTableEntry;
import org.sdmlib.codegen.Parser;
import org.sdmlib.codegen.SymTabEntry;
import org.sdmlib.models.classes.Annotation;
import org.sdmlib.models.classes.Attribute;
import org.sdmlib.models.classes.ClassModel;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.Feature;
import org.sdmlib.models.classes.Method;
import org.sdmlib.models.classes.Role;
import org.sdmlib.models.classes.SDMLibClass;
import org.sdmlib.models.classes.logic.GenAttribute;
import org.sdmlib.models.classes.logic.GenClassModel;
import org.sdmlib.models.classes.logic.Generator;
import org.sdmlib.models.classes.util.ClazzSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class GenClass
extends Generator<Clazz> {
    public static final String PROPERTY_FILEPATH = "filePath";
    private String filePath;
    private LinkedHashMap<String, String> constantDecls = new LinkedHashMap();
    private Parser creatorParser = null;
    private Parser modelSetParser = null;
    private Parser patternObjectParser = null;
    private Parser patternObjectCreatorParser = null;
    private Parser parser = null;
    private boolean repairThis = false;

    public GenClass generate(String rootDir, String helpersDir) {
        if (!((Clazz)this.model).isExternal()) {
            this.getOrCreateParser(rootDir);
            this.insertLicense(this.parser);
            this.insertInterfaces();
            this.insertConstants();
            this.insertImports();
            this.insertMethods(rootDir, helpersDir);
            if (!((Clazz)this.model).isInterface()) {
                this.insertSuperClass();
                this.insertPropertyChangeSupport(rootDir);
                this.insertInterfaceMethods((Clazz)this.model, rootDir, helpersDir);
                if (((Clazz)this.model).hasFeature(Feature.REMOVEYOUMETHOD)) {
                    this.insertRemoveYouMethod(rootDir);
                }
                if (((Clazz)this.model).hasFeature(Feature.Serialization)) {
                    this.insertInterfaceAttributesInCreatorClass((Clazz)this.model, rootDir, helpersDir);
                }
            }
            this.generateAnnotations(rootDir, helpersDir);
            this.generateAttributes(rootDir, helpersDir, false);
            this.printFile();
        } else {
            this.generateAttributes(rootDir, helpersDir, false);
        }
        if (!((Clazz)this.model).isEnumeration() && !((Clazz)this.model).isInterface() && ((Clazz)this.model).hasFeature(Feature.Serialization) && this.getRepairClassModel().hasFeature(Feature.Serialization)) {
            this.getOrCreateParserForCreatorClass(helpersDir);
            if (((Clazz)this.model).hasFeature(Feature.REMOVEYOUMETHOD)) {
                this.insertRemoveObjectInCreatorClass();
            }
            this.printFile(this.creatorParser);
        }
        if (((Clazz)this.model).hasFeature(Feature.Serialization)) {
            this.getOrCreateParserForModelSetFile(helpersDir);
            this.printFile(this.modelSetParser);
            if (this.getRepairClassModel().hasFeature(Feature.PatternObject)) {
                this.getOrCreateParserForPatternObjectFile(helpersDir);
                this.printFile(this.patternObjectParser);
                this.getOrCreateParserForPatternObjectCreatorFile(helpersDir);
                this.printFile(this.patternObjectCreatorParser);
            }
        }
        return this;
    }

    private void insertMethods(String rootDir, String helpersDir) {
        Iterator iterator = ((Clazz)this.model).getMethods().iterator();
        while (iterator.hasNext()) {
            String[] array;
            Method method = (Method)iterator.next();
            this.getGenerator(method).generate(rootDir, helpersDir);
            String signature = method.getSignature(false);
            this.parser.parse();
            ArrayList<SymTabEntry> symTabEntries = this.parser.getSymTabEntriesFor(signature);
            if (symTabEntries.size() <= 0) continue;
            SymTabEntry symTabEntry = symTabEntries.get(0);
            this.parser.parseMethodBody(symTabEntry);
            LinkedHashMap<String, LocalVarTableEntry> localVarTable = this.parser.getLocalVarTable();
            for (String key : array = localVarTable.keySet().toArray(new String[0])) {
                LocalVarTableEntry localVarTableEntry = localVarTable.get(key);
                if (localVarTableEntry == null) continue;
                String type = localVarTableEntry.getType();
                ClazzSet classes = ((Clazz)this.getModel()).getClassModel().getClasses();
                Iterator iterator2 = classes.iterator();
                while (iterator2.hasNext()) {
                    Clazz clazz = (Clazz)iterator2.next();
                    if (!clazz.getName().equals(type) && !clazz.getName().endsWith("." + type)) continue;
                    this.insertImport(clazz.getFullName());
                }
            }
        }
    }

    private void generateAnnotations(String rootDir, String helpersDir) {
        Iterator iterator = ((Clazz)this.model).getAnnotations().iterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            this.getGenerator(annotation).generate(rootDir, helpersDir);
        }
    }

    private void insertImports() {
        for (String importClazz : ((Clazz)this.model).getImports()) {
            this.insertImport(importClazz);
        }
    }

    private void insertConstants() {
        if (this.constantDecls.size() == 0) {
            return;
        }
        for (String constName : this.constantDecls.keySet()) {
            int endOfClass = this.parser.indexOf("classEnd");
            String string = "attribute:" + constName;
            SymTabEntry symTabEntry = (SymTabEntry)this.parser.getSymTab().get((Object)string);
            if (symTabEntry != null) continue;
            this.parser.insert(endOfClass, this.constantDecls.get(constName));
        }
    }

    public ClassModel getRepairClassModel() {
        SDMLibClass item;
        if (((Clazz)this.model).getClassModel() != null) {
            return ((Clazz)this.model).getClassModel();
        }
        if (this.repairThis) {
            return null;
        }
        this.repairThis = true;
        Iterator i = ((Clazz)this.model).getSuperClazzes().iterator();
        while (i.hasNext()) {
            item = (Clazz)i.next();
            if (((Clazz)item).getClassModel() == null) continue;
            ((Clazz)this.model).with(((Clazz)item).getClassModel());
            System.err.println("Classmodel try to repair automaticly from Superclass (" + this.getRepairClassModel().getName() + "). Please add Classmodel to Clazz: " + ((Clazz)this.model).getName());
            this.repairThis = false;
            return this.getRepairClassModel();
        }
        i = ((Clazz)this.model).getKidClazzes().iterator();
        while (i.hasNext()) {
            item = (Clazz)i.next();
            if (((Clazz)item).getClassModel() == null) continue;
            ((Clazz)this.model).with(((Clazz)item).getClassModel());
            System.err.println("Classmodel try to repair automaticly from Kindclass (" + this.getRepairClassModel() + "). Please add Classmodel to Clazz: " + ((Clazz)this.model).getName());
            this.repairThis = false;
            return this.getRepairClassModel();
        }
        i = ((Clazz)this.model).getRoles().iterator();
        while (i.hasNext()) {
            item = (Role)i.next();
            Clazz otherClazz = ((Role)item).getPartnerRole().getClazz();
            if (otherClazz == this.model || otherClazz.getClassModel() == null) continue;
            ((Clazz)this.model).with(otherClazz.getClassModel());
            System.err.println("Classmodel try to repair automaticly from Assoc (" + this.getRepairClassModel().getName() + "). Please add Classmodel to Clazz: " + ((Clazz)this.model).getName());
            this.repairThis = false;
            return this.getRepairClassModel();
        }
        System.err.println("Classmodel try to repair automaticly. Please add Classmodel to Clazz: " + ((Clazz)this.model).getName());
        this.repairThis = false;
        return this.getRepairClassModel();
    }

    private void generateAttributes(String rootDir, String helpersDir, boolean fromSuperClass) {
        Iterator iterator = ((Clazz)this.model).getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute attr = (Attribute)iterator.next();
            if ("PropertyChangeSupport".equals(attr.getType())) continue;
            this.getGenerator(attr).generate(rootDir, helpersDir, fromSuperClass);
        }
        if (((Clazz)this.model).getSuperClass() != null) {
            this.gernerateSuperAttributes(((Clazz)this.model).getSuperClass(), rootDir, helpersDir);
        }
        iterator = ((Clazz)this.model).getInterfaces().iterator();
        while (iterator.hasNext()) {
            Clazz interfaze = (Clazz)iterator.next();
            this.gernerateSuperAttributes(interfaze, rootDir, helpersDir);
        }
    }

    private void gernerateSuperAttributes(Clazz superClazz, String rootDir, String helpersDir) {
        Iterator iterator = superClazz.getAttributes().iterator();
        while (iterator.hasNext()) {
            GenAttribute generator;
            Attribute attr = (Attribute)iterator.next();
            if ("PropertyChangeSupport".equals(attr.getType()) || (generator = this.getGenerator(attr)) == null) continue;
            generator.generate((Clazz)this.model, rootDir, helpersDir, true);
        }
        if (superClazz.getSuperClass() != null) {
            this.gernerateSuperAttributes(superClazz.getSuperClass(), rootDir, helpersDir);
        }
        iterator = superClazz.getInterfaces().iterator();
        while (iterator.hasNext()) {
            Clazz interfaze = (Clazz)iterator.next();
            this.gernerateSuperAttributes(interfaze, rootDir, helpersDir);
        }
    }

    private void insertInterfaceAttributesInCreatorClass(Clazz clazz, String rootDir, String helpersDir) {
        Iterator iterator = clazz.getInterfaces().iterator();
        while (iterator.hasNext()) {
            Clazz interfaze = (Clazz)iterator.next();
            if (interfaze.isInterface()) {
                Iterator iterator2 = interfaze.getAttributes().iterator();
                while (iterator2.hasNext()) {
                    Attribute attr = (Attribute)iterator2.next();
                    Parser creatorParser = this.getOrCreateParserForCreatorClass(helpersDir);
                    this.getGenerator(attr).insertPropertyInCreatorClass(interfaze.getFullName(), creatorParser, helpersDir, false);
                }
            }
            this.insertInterfaceAttributesInCreatorClass(interfaze, rootDir, helpersDir);
        }
    }

    private void insertInterfaceMethods(Clazz clazz, String rootDir, String helpersDir) {
        Iterator iterator = clazz.getInterfaces().iterator();
        while (iterator.hasNext()) {
            Clazz interfaze = (Clazz)iterator.next();
            if (interfaze.isInterface()) {
                Iterator iterator2 = interfaze.getAttributes().iterator();
                while (iterator2.hasNext()) {
                    Attribute attr = (Attribute)iterator2.next();
                    this.getGenerator(attr).generate((Clazz)this.model, rootDir, helpersDir);
                }
                iterator2 = interfaze.getMethods().iterator();
                while (iterator2.hasNext()) {
                    Method method = (Method)iterator2.next();
                    method.withAnnotations(new Annotation().withName("Override"));
                    this.getGenerator(method).generate((Clazz)this.model, rootDir, helpersDir);
                }
            }
            this.insertInterfaceMethods(interfaze, rootDir, helpersDir);
        }
    }

    private void insertInterfaces() {
        String string = "implements";
        if (((Clazz)this.model).isInterface()) {
            string = "extends";
        }
        Iterator iterator = ((Clazz)this.model).getInterfaces().iterator();
        while (iterator.hasNext()) {
            Clazz interfaze = (Clazz)iterator.next();
            int extendsPos = this.parser.indexOf(string);
            if (extendsPos < 0) {
                extendsPos = this.parser.getEndOfClassName();
                this.parser.insert(extendsPos + 1, " " + string + " " + CGUtil.shortClassName(interfaze.getFullName()));
                this.insertImport(interfaze.getFullName());
                continue;
            }
            String shortClassName = CGUtil.shortClassName(interfaze.getFullName());
            String key = string + ":" + shortClassName;
            SymTabEntry symTabEntry = (SymTabEntry)this.parser.getSymTab().get((Object)key);
            if (symTabEntry != null) continue;
            this.parser.insert(this.parser.getEndOfImplementsClause() + 1, ", " + shortClassName);
            this.insertImport(interfaze.getFullName());
        }
    }

    private void insertSuperClass() {
        if (((Clazz)this.model).getSuperClass() == null) {
            return;
        }
        String searchString = "extends";
        int extendsPos = this.parser.indexOf(searchString);
        if (extendsPos < 0) {
            extendsPos = this.parser.getEndOfClassName();
            this.parser.insert(extendsPos + 1, " extends " + CGUtil.shortClassName(((Clazz)this.model).getSuperClass().getFullName()));
            this.insertImport(((Clazz)this.model).getSuperClass().getFullName());
        }
    }

    private void insertRemoveObjectInCreatorClass() {
        if (!this.getRepairClassModel().hasFeature(Feature.PropertyChangeSupport)) {
            return;
        }
        if (this.creatorParser.indexOf("method:removeObject(Object)") < 0) {
            StringBuilder template = this.creatorParser.replace("\n   \n   //==========================================================================\n   \n   @Override\n   public void removeObject(Object entity)\n   {\n      BODY\n   }\n", "BODY", ((Clazz)this.model).isExternal() ? "// wrapped object has no removeYou method" : "((ModelClass) entity).removeYou();");
            this.creatorParser.replaceAll(template, "ModelClass", CGUtil.shortClassName(((Clazz)this.model).getFullName()));
        }
    }

    private void insertRemoveYouMethod(String rootDir) {
        String searchString;
        String propChSupport = "getPropertyChangeSupport().firePropertyChange(\"REMOVE_YOU\", this, null);";
        if (!this.getRepairClassModel().hasFeature(Feature.PropertyChangeSupport)) {
            propChSupport = "";
        }
        if (this.parser.indexOf(searchString = "method:removeYou()") < 0) {
            String overrideText = "";
            for (Clazz clazz : ((Clazz)this.model).getSuperClazzesTransitive().minus(this.model)) {
                if (clazz.isInterface()) continue;
                if (!clazz.isExternal()) {
                    overrideText = "@Override";
                }
                if (this.getGenerator(clazz).getOrCreateParser(rootDir).indexOf(searchString) < 0) continue;
                overrideText = "@Override";
                break;
            }
            String superReplacement = "";
            if (((Clazz)this.model).getSuperClass() != null && !((Clazz)this.model).getSuperClass().isExternal()) {
                superReplacement = "\n      super.removeYou();\n";
            }
            this.parser.replaceAll("\n   \n   //==========================================================================\n   \n   OVERRIDE\n   public void removeYou()\n   {SUPER\n      " + propChSupport + "\n   }" + "\n", "OVERRIDE", overrideText, "SUPER", superReplacement);
        }
    }

    private void insertPropertyChangeSupport(String rootDir) {
        if (!this.getRepairClassModel().hasFeature(Feature.PropertyChangeSupport)) {
            return;
        }
        String searchString = "method:getPropertyChangeSupport()";
        for (Clazz clazz : ((Clazz)this.model).getSuperClazzesTransitive().minus(this.model)) {
            if (clazz.isInterface()) continue;
            if (!clazz.isExternal()) {
                return;
            }
            if (this.getGenerator(clazz).getOrCreateParser(rootDir).indexOf(searchString) < 0) continue;
            return;
        }
        this.insertImplementsClauseForPropertyChangeInterface();
        int pos = this.parser.indexOf(searchString);
        if (pos < 0) {
            this.parser.replaceAll("\n   \n   //==========================================================================\n   \n   protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);\n   \n   public PropertyChangeSupport getPropertyChangeSupport()\n   {\n      return listeners;\n   }\n   \n   public void addPropertyChangeListener(PropertyChangeListener listener) \n   {\n      getPropertyChangeSupport().addPropertyChangeListener(listener);\n   }\n", new Object[0]);
        }
        this.insertImport(PropertyChangeSupport.class.getName());
        this.insertImport(PropertyChangeListener.class.getName());
    }

    private void insertImplementsClauseForPropertyChangeInterface() {
        String searchString = "implements";
        int implementsPos = this.parser.indexOf(searchString);
        String propertyChangeInterface = PropertyChangeInterface.class.getSimpleName();
        if (implementsPos < 0) {
            implementsPos = this.parser.getEndOfExtendsClause();
            if (implementsPos == 0) {
                implementsPos = this.parser.getEndOfClassName();
            }
            String string = " implements ";
            if (((Clazz)this.model).isInterface()) {
                string = " extends ";
            }
            this.parser.insert(implementsPos + 1, string + propertyChangeInterface);
            this.insertImport(PropertyChangeInterface.class.getName());
        } else {
            SymTabEntry symTabEntry = (SymTabEntry)this.parser.getSymTab().get((Object)("implements:" + propertyChangeInterface));
            if (symTabEntry == null) {
                this.parser.insert(this.parser.getEndOfImplementsClause() + 1, ", " + propertyChangeInterface);
            }
            this.insertImport(PropertyChangeInterface.class.getName());
        }
    }

    public void insertImport(String className) {
        this.insertImport(this.parser, className);
    }

    public void insertImport(Parser myParser, String className) {
        SymTabEntry symTabEntry;
        if (className.indexOf("<") > 0) {
            className = className.substring(0, className.indexOf("<"));
        }
        if ("String int double float boolean void".indexOf(className) >= 0) {
            return;
        }
        int pos = myParser.indexOf("import");
        String prefix = "";
        if (myParser.search("import", pos) < 0) {
            prefix = "\n";
        }
        if ((symTabEntry = (SymTabEntry)myParser.getSymTab().get((Object)("import:" + className))) == null) {
            myParser.insert(myParser.getEndOfImports() + 1, prefix + "\nimport " + className + ";");
        }
    }

    public void printFile() {
        if (((Clazz)this.model).getClassModel() == null || ((Clazz)this.model).getClassModel().getGenerator().getShowDiff() == GenClassModel.DIFF.NONE) {
            CGUtil.printFile(this.parser);
        }
    }

    public void printFile(Parser parser) {
        if (parser == null) {
            return;
        }
        if (!this.isShowDiff()) {
            CGUtil.printFile(parser);
        }
    }

    private void insertLicense(Parser parser) {
        int pos = parser.search("/*");
        if (pos < 0 || pos > 20) {
            int existingIndex;
            String lineForPos;
            String[] items;
            String year = new SimpleDateFormat("yyyy").format(new Date(System.currentTimeMillis()));
            String developer = ((Clazz)this.model).getClassModel().getAuthorName();
            if (pos > 0 && !(items = (lineForPos = parser.getLineForPos(existingIndex = parser.indexOf("Copyright (c) "))).split(" "))[items.length - 1].trim().isEmpty()) {
                developer = items[items.length - 1].trim();
            }
            parser.replaceAll(0, "/*\n   Copyright (c) <year> <developer>\r\n   \r\n   Permission is hereby granted, free of charge, to any person obtaining a copy of this software \n   and associated documentation files (the \"Software\"), to deal in the Software without restriction, \n   including without limitation the rights to use, copy, modify, merge, publish, distribute, \n   sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is \n   furnished to do so, subject to the following conditions: \n   \n   The above copyright notice and this permission notice shall be included in all copies or \n   substantial portions of the Software. \n   \n   The Software shall be used for Good, not Evil. \n   \n   THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING \n   BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND \n   NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, \n   DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, \n   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. \n */\n   \n", "<year>", year, "<developer>", developer);
        }
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public Parser getParser() {
        return this.parser;
    }

    public Parser getOrCreateParser(String rootDir) {
        if (this.parser == null) {
            String name = ((Clazz)this.model).getFullName();
            int pos = name.lastIndexOf(46);
            String packageName = "";
            if (pos >= 0) {
                packageName = name.substring(0, pos);
            }
            String fileName = name;
            String className = name.substring(pos + 1);
            String abztract = "";
            if (((Clazz)this.model).isAbztract()) {
                abztract = "abstract";
            }
            fileName = fileName.replaceAll("\\.", "/");
            fileName = rootDir + "/" + fileName + ".java";
            File javaFile = new File(fileName);
            this.parser = new Parser().withFileName(fileName);
            if (javaFile.exists() && !this.isShowDiff()) {
                this.parser.withFileBody(CGUtil.readFile(javaFile));
            } else {
                this.parser.replaceAll("package packageName;\n\npublic abztract clazz className\n{\n}\n", "abztract", abztract, "className", className, "packageName", packageName, "clazz", ((Clazz)this.model).isInterface() ? "interface" : "class");
                this.parser.withFileChanged(true);
            }
        }
        return this.parser;
    }

    public boolean isShowDiff() {
        ClassModel model = ((Clazz)this.getModel()).getClassModel();
        if (model != null) {
            return model.getGenerator().getShowDiff() != GenClassModel.DIFF.NONE;
        }
        return false;
    }

    public Parser getOrCreateParserForCreatorClass(String rootDir) {
        if (this.creatorParser == null) {
            String name = ((Clazz)this.model).getFullName();
            int pos = name.lastIndexOf(46);
            String packageName = name.substring(0, pos) + ".util";
            if (((Clazz)this.model).isExternal()) {
                packageName = this.getRepairClassModel().getName() + ".util";
            }
            String fullEntityClassName = name;
            String entitiyClassName = name.substring(pos + 1);
            String creatorClassName = entitiyClassName + "Creator";
            String fileName = packageName + "." + creatorClassName;
            fileName = fileName.replaceAll("\\.", "/");
            fileName = rootDir + "/" + fileName + ".java";
            File creatorJavaFile = new File(fileName);
            if (!creatorJavaFile.exists() && ((Clazz)this.model).hasFeature(Feature.Serialization)) {
                HashSet<String> featureSet = Feature.Serialization.getPath();
                Iterator<String> iterator = featureSet.iterator();
                while (iterator.hasNext()) {
                    String featureValue;
                    String alternativePackageName = featureValue = iterator.next();
                    String alternativeFileName = alternativePackageName + "." + creatorClassName;
                    alternativeFileName = alternativeFileName.replaceAll("\\.", "/");
                    alternativeFileName = rootDir + "/" + alternativeFileName + ".java";
                    File alternativeJavaFile = new File(alternativeFileName);
                    if (!alternativeJavaFile.exists()) continue;
                    fileName = alternativeFileName;
                    creatorJavaFile = alternativeJavaFile;
                    break;
                }
            }
            this.creatorParser = new Parser().withFileName(fileName);
            if (creatorJavaFile.exists() && !this.isShowDiff()) {
                this.creatorParser.withFileBody(CGUtil.readFile(creatorJavaFile));
            } else {
                StringBuilder text = new StringBuilder("package packageName;\n\nimport org.sdmlib.serialization.EntityFactory;\nimport " + JsonIdMap.class.getName() + ";\n" + "fullEntityClassName" + "\n" + "public class creatorClassName extends EntityFactory\n" + "{\n" + "   private final String[] properties = new String[]\n" + "   {\n" + "   };\n" + "   \n" + "   @Override\n" + "   public String[] getProperties()\n" + "   {\n" + "      return properties;\n" + "   }\n" + "   \n" + "   @Override\n" + "   public Object getSendableInstance(boolean reference)\n" + "   {\n" + "      return instanceCreationClause;\n" + "   }\n" + "   \n" + "   @Override\n" + "   public Object getValue(Object target, String attrName)\n" + "   {\n" + "      int pos = attrName.indexOf('.');\n" + "      String attribute = attrName;\n" + "      \n" + "      if (pos > 0)\n" + "      {\n" + "         attribute = attrName.substring(0, pos);\n" + "      }\n" + "      \n" + "      return null;\n" + "   }\n" + "   \n" + "   @Override\n" + "   public boolean setValue(Object target, String attrName, Object value, String type)\n" + "   {\n" + "      if (JsonIdMap.REMOVE.equals(type) && value != null)\n" + "      {\n" + "         attrName = attrName + type;\n" + "      }\n" + "      \n" + "      return false;\n" + "   }\n" + "   public static JsonIdMap createIdMap(String sessionID)\n" + "   {\n" + "      return ClassModelPackageCreatorCreator.createIdMap(sessionID);\n" + "   }" + "}\n");
                if (((Clazz)this.model).isExternal()) {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    boolean hasConstructor = false;
                    try {
                        Class<?> loadClass = classLoader.loadClass(((Clazz)this.model).getFullName());
                        if (loadClass != null) {
                            Constructor<?> constructor = loadClass.getConstructor(loadClass);
                            hasConstructor = constructor != null;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!hasConstructor) {
                        CGUtil.replaceAll(text, "instanceCreationClause", "null", "fullEntityClassName", "");
                    }
                }
                String instanceCreationClause = "new " + entitiyClassName + "()";
                String modelPackage = CGUtil.packageName(((Clazz)this.model).getFullName());
                if (((Clazz)this.model).getFullName().endsWith("Impl") && modelPackage.endsWith(".impl")) {
                    modelPackage = CGUtil.packageName(modelPackage);
                    String modelName = CGUtil.shortClassName(modelPackage);
                    String basicClassName = entitiyClassName.substring(0, entitiyClassName.length() - 4);
                    instanceCreationClause = modelPackage + "." + modelName + "Factory.eINSTANCE.create" + basicClassName + "()";
                }
                if (((Clazz)this.model).isAbztract()) {
                    instanceCreationClause = "null";
                }
                String classModelPackage = ((Clazz)this.model).getClassModel().getName() + ".util.";
                CGUtil.replaceAll(text, "creatorClassName", creatorClassName, "entitiyClassName", entitiyClassName, "fullEntityClassName", "import " + fullEntityClassName + ";\n", "packageName", packageName, "instanceCreationClause", instanceCreationClause, "ClassModelPackage", classModelPackage);
                this.creatorParser.withFileBody(text).withFileChanged(true);
                this.insertLicense(this.creatorParser);
            }
        }
        return this.creatorParser;
    }

    public String getModelSetClassName() {
        String name = ((Clazz)this.model).getFullName();
        int pos = name.lastIndexOf(46);
        String entitiyClassName = ((Clazz)this.model).getFullName().substring(pos + 1);
        if (!((Clazz)this.getModel()).hasFeature(Feature.ALBERTsSets)) {
            return "java.util.LinkedHashSet<" + entitiyClassName + ">";
        }
        String packageName = name.substring(0, pos) + ".util";
        if (((Clazz)this.model).isExternal()) {
            packageName = this.getRepairClassModel().getName() + ".util";
        }
        String modelSetClassName = entitiyClassName + "Set";
        String fullModelSetClassName = packageName + "." + modelSetClassName;
        return fullModelSetClassName;
    }

    public String getModelSetClassNameShort() {
        String result = this.getModelSetClassName();
        int pos = result.lastIndexOf(".");
        if (pos > 0) {
            result = result.substring(pos + 1);
        }
        return result;
    }

    public Parser getOrCreateParserForModelSetFile(String rootDir) {
        if (!this.getRepairClassModel().hasFeature(Feature.ALBERTsSets) && !this.getRepairClassModel().hasFeature(Feature.Serialization)) {
            return null;
        }
        if (this.modelSetParser == null) {
            if (((Clazz)this.model).getFullName().equals("java.util.Date")) {
                System.out.println("ups");
            }
            String name = ((Clazz)this.model).getFullName();
            int pos = name.lastIndexOf(46);
            String packageName = name.substring(0, pos) + ".util";
            if (((Clazz)this.model).isExternal()) {
                packageName = this.getRepairClassModel().getName() + ".util";
            }
            String fullEntityClassName = name;
            String entitiyClassName = name.substring(pos + 1);
            String modelSetClassName = entitiyClassName + "Set";
            String fileName = packageName + "." + modelSetClassName;
            fileName = fileName.replaceAll("\\.", "/");
            fileName = rootDir + "/" + fileName + ".java";
            File modelSetJavaFile = new File(fileName);
            if (!modelSetJavaFile.exists() && ((Clazz)this.model).hasFeature(Feature.Serialization)) {
                HashSet<String> featureSet = Feature.Serialization.getPath();
                Iterator<String> iterator = featureSet.iterator();
                while (iterator.hasNext()) {
                    String featureValue;
                    String alternativePackageName = featureValue = iterator.next();
                    String alternativeFileName = alternativePackageName + "." + modelSetClassName;
                    alternativeFileName = alternativeFileName.replaceAll("\\.", "/");
                    alternativeFileName = rootDir + "/" + alternativeFileName + ".java";
                    File alternativeJavaFile = new File(alternativeFileName);
                    if (!alternativeJavaFile.exists()) continue;
                    fileName = alternativeFileName;
                    modelSetJavaFile = alternativeJavaFile;
                    break;
                }
            }
            this.modelSetParser = new Parser().withFileName(fileName);
            if (modelSetJavaFile.exists() && !this.isShowDiff()) {
                this.modelSetParser.withFileBody(CGUtil.readFile(modelSetJavaFile));
            } else {
                StringBuilder text = new StringBuilder("package packageName;\n\nimport org.sdmlib.models.modelsets.SDMSet;\nimport fullEntityClassName;\n\npublic class modelSetClassName extends SDMSet<entitiyClassName>\n{\n}\n");
                CGUtil.replaceAll(text, "modelSetClassName", modelSetClassName, "entitiyClassName", entitiyClassName, "fullEntityClassName", fullEntityClassName, "packageName", packageName, "Item", entitiyClassName);
                this.modelSetParser.withFileBody(text).withFileChanged(true);
            }
            this.insertLicense(this.modelSetParser);
            this.insertEmptySetDecl(this.modelSetParser, modelSetClassName);
            this.insertSetStartModelPattern(this.modelSetParser);
            this.insertSetEntryType(this.modelSetParser);
            this.insertSetWithWithout(this.modelSetParser);
        }
        return this.modelSetParser;
    }

    private void insertEmptySetDecl(Parser parser, String modelSetClassName) {
        int partnerPos = parser.indexOf("attribute:EMPTY_SET");
        if (partnerPos < 0) {
            partnerPos = parser.indexOf("classEnd");
            StringBuilder partnerText = new StringBuilder("\n   public static final type EMPTY_SET = new type()READONLY;\n");
            String replaceReadOnly = ".withReadOnly(true)";
            CGUtil.replaceAll(partnerText, "type", modelSetClassName, "READONLY", replaceReadOnly);
            parser.insert(partnerPos, partnerText.toString());
        }
    }

    private void insertSetWithWithout(Parser parser) {
        String searchString = "method:with(Object)";
        int pos = parser.indexOf(searchString);
        if (pos < 0) {
            StringBuilder text = new StringBuilder("\n\n   @SuppressWarnings(\"unchecked\")\n   public ModelTypeSet with(Object value)\n   {\n      if (value instanceof java.util.Collection)\n      {\n         this.addAll((Collection<ModelType>)value);\n      }\n      else if (value != null)\n      {\n         this.add((ModelType) value);\n      }\n      \n      return this;\n   }\n   \n   public ModelTypeSet without(ModelType value)\n   {\n      this.remove(value);\n      return this;\n   }\n\n");
            CGUtil.replaceAll(text, "ModelType", CGUtil.shortClassName(((Clazz)this.model).getFullName()));
            pos = parser.indexOf("classEnd");
            parser.insert(pos, text.toString());
            this.insertImport(parser, "java.util.Collection");
        }
    }

    private void insertSetEntryType(Parser parser) {
        String searchString = "method:getEntryType()";
        int pos = parser.indexOf(searchString);
        if (pos < 0) {
            StringBuilder text = new StringBuilder("\n\n   public String getEntryType()\n   {\n      return \"ModelType\";\n   }\n");
            CGUtil.replaceAll(text, "ModelType", ((Clazz)this.model).getFullName());
            pos = parser.indexOf("classEnd");
            parser.insert(pos, text.toString());
        }
    }

    public Parser getOrCreateParserForPatternObjectFile(String rootDir) {
        if (!this.getRepairClassModel().hasFeature(Feature.ALBERTsSets)) {
            return null;
        }
        if (this.patternObjectParser == null) {
            String name = ((Clazz)this.model).getFullName();
            int pos = name.lastIndexOf(46);
            String packageName = name.substring(0, pos) + ".util";
            if (((Clazz)this.model).isExternal()) {
                packageName = this.getRepairClassModel().getName() + ".util";
            }
            String fullEntityClassName = name;
            String entitiyClassName = name.substring(pos + 1);
            String patternObjectClassName = entitiyClassName + "PO";
            String fileName = packageName + "." + patternObjectClassName;
            fileName = fileName.replaceAll("\\.", "/");
            fileName = rootDir + "/" + fileName + ".java";
            File patternObjectJavaFile = new File(fileName);
            if (!patternObjectJavaFile.exists() && ((Clazz)this.model).hasFeature(Feature.Serialization)) {
                HashSet<String> featureSet = Feature.Serialization.getPath();
                Iterator<String> iterator = featureSet.iterator();
                while (iterator.hasNext()) {
                    String featureValue;
                    String alternativePackageName = featureValue = iterator.next();
                    String alternativeFileName = alternativePackageName + "." + patternObjectClassName;
                    alternativeFileName = alternativeFileName.replaceAll("\\.", "/");
                    alternativeFileName = rootDir + "/" + alternativeFileName + ".java";
                    File alternativeJavaFile = new File(alternativeFileName);
                    if (!alternativeJavaFile.exists()) continue;
                    fileName = alternativeFileName;
                    patternObjectJavaFile = alternativeJavaFile;
                    break;
                }
            }
            this.patternObjectParser = new Parser().withFileName(fileName);
            if (patternObjectJavaFile.exists() && !this.isShowDiff()) {
                this.patternObjectParser.withFileBody(CGUtil.readFile(patternObjectJavaFile));
            } else {
                StringBuilder text = new StringBuilder("package packageName;\n\nimport org.sdmlib.models.pattern.PatternObject;\nimport fullEntityClassName;\n\npublic class patternObjectClassName extends PatternObject<patternObjectClassName, entitiyClassName>\n{\nALLMATCHES\n\n   public patternObjectClassName(){\n      newInstance(ClassModelPackageCreatorCreator.createIdMap(\"PatternObjectType\"));\n   }\n\n   public patternObjectClassName(ModelClass... hostGraphObject) {\n      if(hostGraphObject==null || hostGraphObject.length<1){\n         return ;\n      }\n      newInstance(ClassModelPackageCreatorCreator.createIdMap(\"PatternObjectType\"), hostGraphObject);\n   }\n}\n");
                if (this.getRepairClassModel().hasFeature(Feature.ALBERTsSets)) {
                    CGUtil.replaceAll(text, "ALLMATCHES", "\n    public entitiyClassNameSet allMatches()\n   {\n      this.setDoAllMatches(true);\n      \n      entitiyClassNameSet matches = new entitiyClassNameSet();\n\n      while (this.getPattern().getHasMatch())\n      {\n         matches.add((entitiyClassName) this.getCurrentMatch());\n         \n         this.getPattern().findMatch();\n      }\n      \n      return matches;\n   }\n");
                } else {
                    CGUtil.replaceAll(text, "ALLMATCHES", "");
                }
                CGUtil.replaceAll(text, "patternObjectClassName", patternObjectClassName, "entitiyClassName", entitiyClassName, "fullEntityClassName", fullEntityClassName, "ModelClass", entitiyClassName, "packageName", packageName, "ClassModelPackage", ((Clazz)this.model).getClassModel().getName() + ".util.");
                this.patternObjectParser.withFileBody(text).withFileChanged(true);
            }
        }
        return this.patternObjectParser;
    }

    private void insertSetStartModelPattern(Parser parser) {
        String searchString = "method:has" + CGUtil.shortClassName(((Clazz)this.model).getName()) + "PO()";
        int pos = parser.indexOf(searchString);
        if (pos < 0) {
            StringBuilder text = new StringBuilder("\n\n   public ModelPO hasModelPO()\n   {\n      return new ModelPO(this.toArray(new ModelItem[this.size()]));\n   }\n");
            String packageName = CGUtil.packageName(((Clazz)this.model).getName());
            if (((Clazz)this.model).getName().endsWith("Impl") && packageName.endsWith(".impl")) {
                packageName = packageName.substring(0, packageName.length() - 5);
            }
            CGUtil.replaceAll(text, "ModelPO", CGUtil.shortClassName(((Clazz)this.model).getName()) + "PO", "ModelPatternClass", packageName + ".creators.ModelPattern", "ModelItem", CGUtil.shortClassName(((Clazz)this.model).getName()));
            pos = parser.indexOf("classEnd");
            parser.insert(pos, text.toString());
        }
    }

    public Parser getOrCreateParserForPatternObjectCreatorFile(String rootDir) {
        if (!this.getRepairClassModel().hasFeature(Feature.Serialization)) {
            return null;
        }
        if (this.patternObjectCreatorParser == null) {
            String name = ((Clazz)this.model).getFullName();
            int pos = name.lastIndexOf(46);
            String packageName = name.substring(0, pos) + ".util";
            if (((Clazz)this.model).isExternal()) {
                packageName = this.getRepairClassModel().getName() + ".util";
            }
            String entitiyClassName = name.substring(pos + 1);
            String patternObjectCreatorClassName = entitiyClassName + "POCreator";
            String fileName = packageName + "." + patternObjectCreatorClassName;
            fileName = fileName.replaceAll("\\.", "/");
            fileName = rootDir + "/" + fileName + ".java";
            File patternObjectCreatorJavaFile = new File(fileName);
            if (!patternObjectCreatorJavaFile.exists() && ((Clazz)this.model).hasFeature(Feature.Serialization)) {
                HashSet<String> featureSet = Feature.Serialization.getPath();
                Iterator<String> iterator = featureSet.iterator();
                while (iterator.hasNext()) {
                    String featureValue;
                    String alternativePackageName = featureValue = iterator.next();
                    String alternativeFileName = alternativePackageName + "." + patternObjectCreatorClassName;
                    alternativeFileName = alternativeFileName.replaceAll("\\.", "/");
                    alternativeFileName = rootDir + "/" + alternativeFileName + ".java";
                    File alternativeJavaFile = new File(alternativeFileName);
                    if (!alternativeJavaFile.exists()) continue;
                    fileName = alternativeFileName;
                    patternObjectCreatorJavaFile = alternativeJavaFile;
                    break;
                }
            }
            this.patternObjectCreatorParser = new Parser().withFileName(fileName);
            boolean addImport = false;
            if (patternObjectCreatorJavaFile.exists() && !this.isShowDiff()) {
                this.patternObjectCreatorParser.withFileBody(CGUtil.readFile(patternObjectCreatorJavaFile));
            } else {
                StringBuilder text = new StringBuilder("package packageName;\n\nimport org.sdmlib.models.pattern.util.PatternObjectCreator;\nimport " + JsonIdMap.class.getName() + ";\n" + "\n" + "public class patternObjectCreatorClassName extends PatternObjectCreator\n" + "{\n" + "   @Override\n" + "   public Object getSendableInstance(boolean reference)\n" + "   {\n" + "      if(reference) {\n" + "          return new entitiyPOClassName(new entitiyClassName[]{});\n" + "      } else {\n" + "          return new entitiyPOClassName();\n" + "      }\n" + "   }\n" + "   \n" + "   public static JsonIdMap createIdMap(String sessionID) {\n" + "      return ClassModelPackageCreatorCreator.createIdMap(sessionID);\n" + "   }\n" + "}\n");
                CGUtil.replaceAll(text, "patternObjectCreatorClassName", patternObjectCreatorClassName, "entitiyPOClassName", entitiyClassName + "PO", "entitiyClassName", entitiyClassName, "packageName", packageName, "ClassModelPackage", ((Clazz)this.model).getClassModel().getName() + ".util.");
                this.patternObjectCreatorParser.withFileBody(text).withFileChanged(true);
                addImport = true;
            }
            if (addImport) {
                this.insertImport(this.patternObjectCreatorParser, name);
            }
        }
        return this.modelSetParser;
    }

    public void insertCreatorClassInCreatorCreator(Parser ccParser) {
        int pos = ccParser.indexOf("method:getCreatorSet()");
        String name = ((Clazz)this.model).getFullName();
        if (pos < 0) {
            System.err.println("Warning: SDMLib codgen for creatorSet initialisation invocation " + name + "Creator for class " + ccParser.getFileName() + ": \nDid not find method getCreatorSet(). Should have been generated by my model. " + "\nCould not add required code fragment there. :( ");
            return;
        }
        int methodBodyStartPos = ccParser.getMethodBodyStartPos();
        String shortCreatorClassName = CGUtil.shortClassName(name) + "Creator";
        String shortCreatorPOClassName = CGUtil.shortClassName(name) + "POCreator";
        String creatorClassName = CGUtil.packageName(name) + ".util" + "." + shortCreatorClassName;
        String creatorPOClassName = CGUtil.packageName(name) + ".util" + "." + shortCreatorPOClassName;
        if (((Clazz)this.model).isExternal()) {
            creatorClassName = this.getRepairClassModel().getName() + ".util" + "." + shortCreatorClassName;
            creatorPOClassName = this.getRepairClassModel().getName() + ".util" + "." + shortCreatorPOClassName;
        }
        if ((pos = ccParser.methodBodyIndexOf("nameToken:" + shortCreatorClassName, methodBodyStartPos)) < 0) {
            ccParser.methodBodyIndexOf("methodEnd", methodBodyStartPos);
            int addCreatorPos = ccParser.search("creatorSet.addAll", methodBodyStartPos);
            StringBuilder text = new StringBuilder("creatorSet.add(new ClassCreator());\n         creatorSet.add(new ClassPOCreator());\n         ");
            CGUtil.replaceAll(text, "ClassCreator", creatorClassName, "ClassPOCreator", creatorPOClassName);
            ccParser.insert(addCreatorPos, text.toString());
        }
    }

    public String shortNameAndImport(String typeName, Parser parser) {
        if (typeName.indexOf(46) < 0) {
            return typeName;
        }
        String baseName = CGUtil.shortClassName(typeName);
        int pos = typeName.indexOf(60);
        if (pos >= 0) {
            typeName = typeName.substring(0, pos);
        }
        this.insertImport(parser, typeName);
        return baseName;
    }

    public void removeAllGeneratedCode(String testDir, String srcDir, String helpersDir) {
        this.getRepairClassModel().getGenerator().turnRemoveCallToComment(testDir);
        this.getRepairClassModel().getGenerator().removeAllCodeForClass(srcDir, helpersDir, (Clazz)this.model);
    }

    public GenClass withConstant(String name, int i) {
        StringBuilder decl = new StringBuilder("   public static int string = number;\n");
        CGUtil.replaceAll(decl, "string", name, "number", "" + i);
        this.constantDecls.put(name, decl.toString());
        return this;
    }

    public GenClass withConstant(String name, String value) {
        StringBuilder decl = new StringBuilder("   public static String name = \"value\";\n");
        CGUtil.replaceAll(decl, "name", name, "value", value);
        this.constantDecls.put(name, decl.toString());
        return this;
    }

    public GenClass withRunningConstants(String ... names) {
        int i = 0;
        for (String string : names) {
            this.withConstant(string, i);
            ++i;
        }
        return this;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String value) {
        if (!StrUtil.stringEquals(this.filePath, value)) {
            this.filePath = value;
        }
    }

    public GenClass withFilePath(String value) {
        this.setFilePath(value);
        return this;
    }

    public int printAll(GenClassModel.DIFF diff, List<String> ignoreDiff) {
        int count = 0;
        count += this.showDiffForParser(this.parser, diff, ignoreDiff);
        count += this.showDiffForParser(this.creatorParser, diff, ignoreDiff);
        count += this.showDiffForParser(this.modelSetParser, diff, ignoreDiff);
        count += this.showDiffForParser(this.patternObjectParser, diff, ignoreDiff);
        return count += this.showDiffForParser(this.patternObjectCreatorParser, diff, ignoreDiff);
    }

    private int showDiffForParser(Parser newFileParser, GenClassModel.DIFF diff, List<String> ignoreDiff) {
        int count = 0;
        if (newFileParser == null) {
            return 0;
        }
        File file = new File(newFileParser.getFileName());
        if (file.exists()) {
            Parser oldFileParser = new Parser().withFileName(newFileParser.getFileName());
            oldFileParser.withFileBody(CGUtil.readFile(file));
            oldFileParser.parse();
            newFileParser.parse();
            SimpleKeyValueList<String, SymTabEntry> oldSymTab = oldFileParser.getSymTab();
            String packageName = CGUtil.packageName(((Clazz)this.model).getFullName());
            String shortName = newFileParser.getFileName().replace("\\", ".").replace("/", ".");
            shortName = shortName.substring(shortName.indexOf(packageName));
            if (ignoreDiff != null && ignoreDiff.contains(shortName.substring(0, shortName.length() - 5))) {
                return 0;
            }
            for (Map.Entry item : newFileParser.getSymTab().entrySet()) {
                String[] newSplit;
                if (((SymTabEntry)item.getValue()).getMemberName().startsWith("import") || ((String)item.getKey()).startsWith("extends") || ((String)item.getKey()).startsWith("implements")) continue;
                if (!oldSymTab.containsKey(item.getKey())) {
                    if (diff != GenClassModel.DIFF.FULL) continue;
                    System.err.println(file.getAbsolutePath() + ";" + (String)item.getKey() + ";Method not found");
                    continue;
                }
                SymTabEntry oldValue = (SymTabEntry)oldSymTab.get(item.getKey());
                int oldValueLen = oldValue.getEndPos() - oldValue.getStartPos();
                SymTabEntry newValue = (SymTabEntry)item.getValue();
                int newValueLen = newValue.getEndPos() - newValue.getStartPos();
                String oldStrValue = oldFileParser.getText().substring(oldValue.getStartPos(), oldValue.getEndPos() + 1).trim();
                String newStrValue = newFileParser.getText().substring(newValue.getStartPos(), newValue.getEndPos() + 1).trim();
                String[] oldSplit = oldStrValue.split("\\s+");
                boolean foundDiff = oldSplit.length != (newSplit = newStrValue.split("\\s+")).length;
                String diffToken = "";
                for (int j = 0; j < oldSplit.length && !foundDiff; ++j) {
                    if (oldSplit[j].equals(newSplit[j])) continue;
                    foundDiff = true;
                    diffToken = oldSplit[j] + " != " + newSplit[j];
                    break;
                }
                if (!foundDiff) continue;
                System.err.println(file.getPath() + ";" + (String)item.getKey() + ";Body different:" + oldValueLen + "!=" + newValueLen + ";");
                System.err.println("in line:" + oldFileParser.getLineIndexOf(oldValue.getStartPos()) + "-" + oldFileParser.getLineIndexOf(oldValue.getEndPos()) + ";");
                System.err.println("(" + shortName + ":" + oldFileParser.getLineIndexOf(oldValue.getStartPos()) + ")");
                System.err.println(newStrValue);
                System.err.println("diff token: " + diffToken);
                ++count;
            }
        } else if (diff == GenClassModel.DIFF.FULL) {
            System.err.println(file.getAbsolutePath() + ";;File not Found!!!");
        }
        return count;
    }

    public String toString() {
        return "gen " + this.model;
    }
}

