/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes.logic;

import java.util.ArrayList;
import java.util.Set;
import org.sdmlib.codegen.Parser;
import org.sdmlib.codegen.SymTabEntry;
import org.sdmlib.models.classes.Annotation;
import org.sdmlib.models.classes.Attribute;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.Method;
import org.sdmlib.models.classes.logic.Generator;

public class GenAnnotation
extends Generator<Annotation> {
    public GenAnnotation generate(String rootDir, String helperDir) {
        if (((Annotation)this.model).getClazz() != null) {
            return this.generate(((Annotation)this.model).getClazz(), rootDir, helperDir);
        }
        if (((Annotation)this.model).getMethod() != null) {
            return this.generate(((Annotation)this.model).getMethod(), rootDir, helperDir);
        }
        if (((Annotation)this.model).getAttribute() != null) {
            return this.generate(((Annotation)this.model).getAttribute(), rootDir, helperDir);
        }
        return this;
    }

    private GenAnnotation generate(Attribute attribute, String rootDir, String helperDir) {
        Parser parser = this.getGenerator(attribute.getClazz()).getOrCreateParser(rootDir);
        parser.parse();
        return this.generate(parser, this.getStartPos(parser));
    }

    private int getStartPos(Parser parser) {
        return parser.indexOf("attribute:" + ((Annotation)this.model).getAttribute().getName());
    }

    private GenAnnotation generate(Method method, String rootDir, String helperDir) {
        Parser parser = this.getGenerator(method.getClazz()).getOrCreateParser(rootDir);
        parser.parse();
        ArrayList<SymTabEntry> tabEntries = parser.getSymTabEntriesFor(method.getSignature(false));
        return this.generate(parser, this.getStartPos(tabEntries));
    }

    private GenAnnotation generate(Clazz clazz, String rootDir, String helperDir) {
        Parser parser = this.getGenerator(clazz).getOrCreateParser(rootDir);
        parser.parse();
        ArrayList<SymTabEntry> tabEntries = parser.getSymTabEntriesFor(clazz.getFullName());
        return this.generate(parser, this.getStartPos(tabEntries));
    }

    private int getStartPos(ArrayList<SymTabEntry> tabEntries) {
        SymTabEntry symTabEntry = null;
        if (tabEntries.size() > 0) {
            symTabEntry = tabEntries.get(0);
        }
        if (symTabEntry == null || this.annotationAlreadyInserted(symTabEntry)) {
            return -1;
        }
        return symTabEntry.getStartPos();
    }

    private boolean annotationAlreadyInserted(SymTabEntry symTabEntry) {
        boolean inserted = false;
        if (symTabEntry.getAnnotations() != null && symTabEntry.getAnnotations().contains(((Annotation)this.model).getName())) {
            inserted = true;
            for (String value : ((Annotation)this.model).getValues()) {
                if (symTabEntry.getAnnotations().contains(value)) continue;
                inserted = false;
                break;
            }
        }
        return inserted;
    }

    private GenAnnotation generate(Parser parser, int startPos) {
        if (startPos == -1) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("@");
        sb.append(((Annotation)this.model).getName());
        Set<String> values = ((Annotation)this.model).getValues();
        if (values.size() == 1) {
            sb.append("(");
            sb.append(values.toArray(new String[values.size()])[0]);
            sb.append(")");
        } else if (values.size() > 1) {
            sb.append("({");
            for (String value : values) {
                sb.append("\"");
                sb.append(value);
                sb.append("\", ");
            }
            sb.replace(sb.length() - 2, sb.length(), "");
            sb.append("})");
        }
        sb.append("\n");
        parser.insert(startPos, sb.toString());
        parser.parse();
        return this;
    }
}

