/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes;

import de.uniks.networkparser.gui.javafx.window.DiagramEditor;
import de.uniks.networkparser.gui.javafx.window.FXStageController;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonObject;
import javafx.application.Application;
import javafx.scene.Parent;
import org.sdmlib.StrUtil;
import org.sdmlib.models.classes.Card;
import org.sdmlib.models.classes.ClassModel;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.DataType;

public class SDMDiagramEditor
extends DiagramEditor {
    public static void main(String[] args) {
        SDMDiagramEditor.launch((String[])args);
    }

    public void generate(JsonObject model) {
        if (!model.has("nodes")) {
            System.err.println("no Nodes");
            System.out.println("no Nodes");
            return;
        }
        JsonObject nodes = model.getJsonObject("nodes");
        ClassModel classModel = new ClassModel(model.getString((Object)"package"));
        for (int i = 0; i < nodes.size(); ++i) {
            Object item = nodes.getValueByIndex(i);
            if (!(item instanceof JsonObject)) continue;
            JsonObject node = (JsonObject)item;
            Clazz clazz = classModel.createClazz(node.getString((Object)"id"));
            if (!node.has("attributes")) continue;
            JsonArray attributes = node.getJsonArray("attributes");
            for (Object entity : attributes) {
                String attribute;
                int pos;
                if (!(entity instanceof String) || (pos = (attribute = (String)entity).indexOf(":")) <= 0) continue;
                clazz.withAttribute(attribute.substring(0, pos), DataType.ref(attribute.substring(pos + 1)));
            }
        }
        if (model.has("edges")) {
            JsonArray edges = model.getJsonArray("edges");
            for (Object entity : edges) {
                if (!(entity instanceof JsonObject)) continue;
                JsonObject edge = (JsonObject)entity;
                JsonObject source = edge.getJsonObject("source");
                JsonObject target = edge.getJsonObject("target");
                if (!edge.getString((Object)"typ").equalsIgnoreCase("edge")) continue;
                Clazz fromClazz = classModel.getClazz(source.getString((Object)"id"));
                Clazz toClazz = classModel.getClazz(target.getString((Object)"id"));
                fromClazz.withAssoc(toClazz, target.getString((Object)"property"), Card.ONE, source.getString((Object)"property"), Card.ONE);
            }
        }
        String genModel = classModel.getName() + ".genModel";
        classModel.getGenerator().insertModelCreationCodeHere("gen", genModel, "testGenModel");
        classModel.generate("gen");
    }

    protected Parent createContents(FXStageController controller, Application.Parameters args) {
        Parent parent = super.createContents(controller, args);
        controller.withIcon(StrUtil.class.getResource("sdmlib.png"));
        return parent;
    }
}

