/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes;

import org.sdmlib.StrUtil;
import org.sdmlib.models.classes.Association;
import org.sdmlib.models.classes.Card;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.SDMLibClass;
import org.sdmlib.models.classes.util.RoleSet;

public class Role
extends SDMLibClass {
    public static final String VANILLA = "vanilla";
    public static final String AGGREGATION = "aggregation";
    public static final String PROPERTY_CARD = "card";
    public static final String PROPERTY_CLAZZ = "clazz";
    public static final String PROPERTY_KIND = "kind";
    private String kind = "vanilla";
    private Clazz clazz = null;
    private String card = Card.MANY.toString();
    public static final RoleSet EMPTY_SET = (RoleSet)new RoleSet().withReadOnly(true);
    public static final String PROPERTY_ASSOC = "assoc";
    private Association assoc = null;

    protected Role() {
    }

    public Role(Clazz clazz, String roleName, Card card) {
        this.setName(roleName);
        this.setClazz(clazz);
        this.setCard(card.toString());
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(" ").append(this.getCard());
        result.append(" ").append(this.getKind());
        result.append(" ").append(this.getName());
        return result.substring(1);
    }

    public String labelForRole() {
        String result = this.getName();
        if (this.getCard().equals(Card.MANY.toString())) {
            result = result + " *";
        }
        return result;
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public boolean setClazz(Clazz value) {
        boolean changed = false;
        if (this.clazz != value) {
            Clazz oldValue = this.clazz;
            if (this.clazz != null) {
                this.clazz = null;
                oldValue.without(this);
            }
            this.clazz = value;
            if (value != null) {
                value.with(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CLAZZ, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public Role with(Clazz value) {
        this.setClazz(value);
        return this;
    }

    public String getCard() {
        return this.card;
    }

    public boolean setCard(String value) {
        if (!StrUtil.stringEquals(this.card, value)) {
            String oldValue = this.card;
            this.card = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CARD, oldValue, value);
            return true;
        }
        return false;
    }

    public Role withCard(String value) {
        this.setCard(value);
        return this;
    }

    @Override
    public Role withName(String value) {
        this.setName(value);
        return this;
    }

    public String getKind() {
        return this.kind;
    }

    public boolean setKind(String value) {
        if (!StrUtil.stringEquals(this.kind, value)) {
            String oldValue = this.kind;
            this.kind = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KIND, oldValue, value);
            return true;
        }
        return false;
    }

    public Role withKind(String value) {
        this.setKind(value);
        return this;
    }

    public Association getAssoc() {
        return this.assoc;
    }

    public boolean setAssoc(Association value) {
        boolean changed = false;
        if (this.assoc != value) {
            Association oldValue = this.assoc;
            this.assoc = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ASSOC, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public Role with(Association value) {
        this.setAssoc(value);
        return this;
    }

    @Override
    public void removeYou() {
        super.removeYou();
        this.setAssoc(null);
        this.setClazz(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public Role getPartnerRole() {
        if (this.getAssoc() == null) {
            return null;
        }
        if (this == this.getAssoc().getSource()) {
            return this.getAssoc().getTarget();
        }
        return this.getAssoc().getSource();
    }

    protected Clazz createClazz() {
        Clazz value = new Clazz(null);
        this.with(value);
        return value;
    }

    protected Association createAssoc() {
        Association value = new Association();
        this.with(value);
        return value;
    }

    Role withClazz(Clazz value) {
        this.setClazz(value);
        return this;
    }

    Role withAssoc(Association value) {
        this.setAssoc(value);
        return this;
    }
}

