/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes;

import org.sdmlib.models.classes.DataType;
import org.sdmlib.models.classes.Method;
import org.sdmlib.models.classes.Value;
import org.sdmlib.models.classes.util.ParameterSet;

public class Parameter
extends Value {
    public static final String PROPERTY_METHOD = "method";
    private Method method = null;
    public static final ParameterSet EMPTY_SET = (ParameterSet)new ParameterSet().withReadOnly(true);

    protected Parameter() {
    }

    public Parameter(DataType type) {
        this.type = type;
    }

    public Parameter(String name, DataType type) {
        this.withName(name);
        this.type = type;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean setMethod(Method value) {
        boolean changed = false;
        if (this.method != value) {
            Method oldValue = this.method;
            if (this.method != null) {
                this.method = null;
                oldValue.without(this);
            }
            this.method = value;
            if (value != null) {
                value.with(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_METHOD, oldValue, value);
            changed = true;
        }
        return changed;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(" ").append(this.getType());
        if (this.name != null) {
            result.append(" ").append(this.getName());
        }
        if (this.initialization != null) {
            result.append(":").append(this.getInitialization());
        }
        return result.substring(1);
    }

    @Override
    public void removeYou() {
        super.removeYou();
        this.setMethod(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    @Override
    public Parameter withName(String string) {
        this.setName(string);
        return this;
    }

    @Override
    public Parameter with(DataType value) {
        this.setType(value);
        return this;
    }

    @Override
    public Parameter withInitialization(String value) {
        this.setInitialization(value);
        return this;
    }

    public Parameter with(Method value) {
        this.setMethod(value);
        return this;
    }

    protected Method createMethod() {
        Method value = new Method();
        this.with(value);
        return value;
    }

    Parameter withMethod(Method value) {
        this.setMethod(value);
        return this;
    }
}

