/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes;

import java.util.Iterator;
import org.sdmlib.StrUtil;
import org.sdmlib.models.classes.Annotation;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.DataType;
import org.sdmlib.models.classes.Enumeration;
import org.sdmlib.models.classes.Parameter;
import org.sdmlib.models.classes.SDMLibClass;
import org.sdmlib.models.classes.Visibility;
import org.sdmlib.models.classes.util.AnnotationSet;
import org.sdmlib.models.classes.util.MethodSet;
import org.sdmlib.models.classes.util.ParameterSet;

public class Method
extends SDMLibClass {
    public static final String PROPERTY_RETURNTYPE = "returnType";
    public static final String PROPERTY_PARAMETER = "parameter";
    public static final String PROPERTY_BODY = "body";
    public static final String PROPERTY_CLAZZ = "clazz";
    public static final String PROPERTY_MODIFIER = "modifier";
    public static final MethodSet EMPTY_SET = (MethodSet)new MethodSet().withReadOnly(true);
    private Visibility modifier = Visibility.PUBLIC;
    private Clazz clazz = null;
    private String body;
    private ParameterSet parameter = null;
    private DataType returnType = DataType.VOID;
    public static final String PROPERTY_ENUMERATION = "enumeration";
    private Enumeration enumeration = null;
    public static final String PROPERTY_ANNOTATIONS = "annotations";
    private AnnotationSet annotations = null;

    public String getSignature(boolean includeName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName() + "(");
        boolean first = true;
        int i = 0;
        Iterator iterator = this.getParameter().iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (first) {
                sb.append(this.getParameterSignature(includeName, parameter, i));
                first = false;
            } else {
                sb.append(this.getParameterSignature(includeName, parameter, i));
            }
            if (i < this.getParameter().size() - 1) {
                if (includeName) {
                    sb.append(", ");
                } else {
                    sb.append(",");
                }
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    private String getParameterSignature(boolean includeName, Parameter parameter, int i) {
        String param = parameter.getType().getValue();
        if (!includeName) {
            return param;
        }
        String name = "";
        if (parameter.getName() != null) {
            name = parameter.getName().trim();
        }
        if (name != "") {
            return param + " " + name;
        }
        return param + " p" + i;
    }

    protected Method() {
    }

    public Method(String name, DataType returnType, Parameter ... parameters) {
        this.setName(name);
        this.with(parameters);
        this.setReturnType(returnType);
    }

    public Method(String name, Parameter ... parameters) {
        this.with(parameters);
        this.setName(name);
    }

    @Override
    public Method withName(String name) {
        this.setName(name);
        return this;
    }

    public Method with(Parameter ... value) {
        if (value == null) {
            return this;
        }
        if (this.parameter == null) {
            this.parameter = new ParameterSet();
        }
        for (Parameter item : value) {
            if (item == null || !this.parameter.add(item)) continue;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PARAMETER, null, item);
        }
        return this;
    }

    public Method withParameter(String paramName, DataType dataType) {
        this.createParameter().withName(paramName).with(dataType);
        return this;
    }

    public Method withParameter(String paramName, Clazz clazz) {
        this.createParameter().withName(paramName).with(DataType.ref(clazz));
        return this;
    }

    public Method withParameter(String paramName, Class<?> clazz) {
        this.createParameter().withName(paramName).with(DataType.ref(clazz));
        return this;
    }

    public Method without(Parameter ... value) {
        if (this.parameter == null || value == null) {
            return this;
        }
        for (Parameter item : value) {
            if (item == null || !this.parameter.remove(item)) continue;
            item.setMethod(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PARAMETER, item, null);
        }
        return this;
    }

    public Visibility getModifier() {
        return this.modifier;
    }

    public void setModifier(Visibility value) {
        this.modifier = value;
    }

    public Method with(Visibility ... visibility) {
        if (visibility == null) {
            return this;
        }
        if (visibility.length == 1) {
            this.modifier = visibility[0];
        }
        this.modifier = Visibility.ref(visibility);
        return this;
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public boolean setClazz(Clazz value) {
        boolean changed = false;
        if (this.clazz != value) {
            Clazz oldValue = this.clazz;
            if (this.clazz != null) {
                this.clazz = null;
                oldValue.without(this);
            }
            this.clazz = value;
            if (value != null) {
                value.with(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CLAZZ, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public Method with(Clazz value) {
        this.setClazz(value);
        return this;
    }

    @Override
    public void removeYou() {
        super.removeYou();
        this.setClazz(null);
        this.without((Parameter[])this.getParameter().toArray(new Parameter[this.getParameter().size()]));
        this.withoutParameter((Parameter[])this.getParameter().toArray(new Parameter[this.getParameter().size()]));
        this.setEnumeration(null);
        this.withoutAnnotations((Annotation[])this.getAnnotations().toArray(new Annotation[this.getAnnotations().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public DataType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(DataType value) {
        if (this.returnType == null && value != null || this.returnType != null && this.returnType != value) {
            DataType oldValue = this.returnType;
            this.returnType = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_RETURNTYPE, oldValue, value);
        }
    }

    public Method withReturnType(DataType value) {
        this.setReturnType(value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(" ").append(this.getModifier());
        result.append(" ").append(this.getReturnType());
        result.append(" ").append(this.getName());
        result.append(" ").append(this.getParameter());
        if (this.body != null) {
            result.append(" ").append(this.getBody());
        }
        return result.substring(1);
    }

    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName() + "(");
        boolean first = true;
        int i = 0;
        Iterator iterator = this.getParameter().iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (first) {
                sb.append(this.getParameterSignature(true, parameter, i));
                first = false;
            } else {
                sb.append(this.getParameterSignature(true, parameter, i));
            }
            if (i < this.getParameter().size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(")");
        if (this.returnType != null && this.returnType != DataType.VOID) {
            sb.append(" " + this.returnType.getValue());
        }
        return sb.toString();
    }

    public String getBody() {
        return this.body;
    }

    public boolean setBody(String value) {
        if (!StrUtil.stringEquals(this.body, value)) {
            String oldValue = this.body;
            this.body = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_BODY, oldValue, value);
            return true;
        }
        return false;
    }

    public Method withBody(String value) {
        this.setBody(value);
        return this;
    }

    public ParameterSet getParameter() {
        if (this.parameter == null) {
            return Parameter.EMPTY_SET;
        }
        return this.parameter;
    }

    public Parameter createParameter(DataType type) {
        Parameter value = new Parameter(type);
        this.with(value);
        return value;
    }

    Method withParameter(Parameter ... value) {
        return this.with(value);
    }

    Method withoutParameter(Parameter ... value) {
        return this.without(value);
    }

    Parameter createParameter() {
        Parameter value = new Parameter();
        this.withParameter(value);
        return value;
    }

    Method withClazz(Clazz value) {
        this.setClazz(value);
        return this;
    }

    Clazz createClazz() {
        Clazz value = new Clazz(null);
        this.withClazz(value);
        return value;
    }

    public Enumeration getEnumeration() {
        return this.enumeration;
    }

    public boolean setEnumeration(Enumeration value) {
        boolean changed = false;
        if (this.enumeration != value) {
            Enumeration oldValue = this.enumeration;
            if (this.enumeration != null) {
                this.enumeration = null;
                oldValue.withoutMethods(this);
            }
            this.enumeration = value;
            if (value != null) {
                value.withMethods(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ENUMERATION, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public Method withEnumeration(Enumeration value) {
        this.setEnumeration(value);
        return this;
    }

    public Enumeration createEnumeration() {
        Enumeration value = new Enumeration();
        this.withEnumeration(value);
        return value;
    }

    public AnnotationSet getAnnotations() {
        if (this.annotations == null) {
            return AnnotationSet.EMPTY_SET;
        }
        return this.annotations;
    }

    public Method withAnnotations(Annotation ... value) {
        if (value == null) {
            return this;
        }
        for (Annotation item : value) {
            boolean changed;
            if (item == null) continue;
            if (this.annotations == null) {
                this.annotations = new AnnotationSet();
            }
            if (!(changed = this.annotations.add(item))) continue;
            item.withMethod(this);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ANNOTATIONS, null, item);
        }
        return this;
    }

    public Method withoutAnnotations(Annotation ... value) {
        for (Annotation item : value) {
            if (this.annotations == null || item == null || !this.annotations.remove(item)) continue;
            item.setMethod(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ANNOTATIONS, item, null);
        }
        return this;
    }

    public Annotation createAnnotations() {
        Annotation value = new Annotation();
        this.withAnnotations(value);
        return value;
    }
}

