/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes;

import java.util.HashSet;
import org.sdmlib.models.classes.Clazz;

public class FeatureProperty {
    public static final Clazz ALL = new Clazz("*");
    private HashSet<Clazz> includeClazz = new HashSet();
    private HashSet<Clazz> excludeClazz = new HashSet();
    private HashSet<String> path = new HashSet();

    public FeatureProperty() {
        this.includeClazz.add(ALL);
    }

    public boolean match(String clazzName) {
        boolean result = false;
        for (Clazz item : this.includeClazz) {
            if (item == null) continue;
            if (ALL.getFullName().equals(item.getFullName())) {
                result = true;
                break;
            }
            if (!item.getFullName().equals(clazzName)) continue;
            result = true;
            break;
        }
        for (Clazz item : this.excludeClazz) {
            if (item == null) continue;
            if (ALL.getFullName().equals(item.getFullName())) {
                result = false;
                break;
            }
            if (!item.getFullName().equals(clazzName)) continue;
            result = false;
            break;
        }
        return result;
    }

    public FeatureProperty withPath(String ... value) {
        if (value == null) {
            return this;
        }
        for (String item : value) {
            if (item == null) continue;
            this.path.add(item);
        }
        return this;
    }

    public FeatureProperty withInclude(String ... value) {
        if (value == null) {
            return this;
        }
        for (String item : value) {
            if (item == null) continue;
            this.excludeClazz.add(new Clazz(item));
        }
        return this;
    }

    public FeatureProperty withExclude(String ... value) {
        if (value == null) {
            return this;
        }
        if (value.length > 0) {
            this.includeClazz.remove(ALL);
        }
        for (String item : value) {
            if (item == null) continue;
            this.includeClazz.add(new Clazz(item));
        }
        return this;
    }

    public FeatureProperty withExclude(Clazz ... value) {
        if (value == null) {
            return this;
        }
        if (value.length > 0) {
            this.includeClazz.remove(ALL);
        }
        for (Clazz item : value) {
            if (item == null) continue;
            this.includeClazz.add(item);
        }
        return this;
    }

    public HashSet<String> getPath() {
        return this.path;
    }
}

