/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes;

import java.util.ArrayList;
import java.util.Arrays;
import org.sdmlib.models.classes.ClassModel;
import org.sdmlib.models.classes.DataType;
import org.sdmlib.models.classes.Method;
import org.sdmlib.models.classes.Parameter;
import org.sdmlib.models.classes.SDMLibClass;
import org.sdmlib.models.classes.util.ArrayListSet;
import org.sdmlib.models.classes.util.EnumerationSet;
import org.sdmlib.models.classes.util.MethodSet;

public class Enumeration
extends SDMLibClass {
    public static final String PROPERTY_VALUENAMES = "valueNames";
    private ArrayListSet valueNames = new ArrayListSet();
    public static final EnumerationSet EMPTY_SET = (EnumerationSet)new EnumerationSet().withReadOnly(true);
    public static final String PROPERTY_CLASSMODEL = "classModel";
    private ClassModel classModel = null;
    public static final String PROPERTY_METHODS = "methods";
    private MethodSet methods = null;
    public static final String PROPERTY_EXTERNAL = "external";
    private boolean external;

    @Override
    public void removeYou() {
        super.removeYou();
        this.setClassModel(null);
        this.withoutMethods((Method[])this.getMethods().toArray(new Method[this.getMethods().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public ArrayListSet getValueNames() {
        return this.valueNames;
    }

    public void setValueNames(ArrayListSet value) {
        if (this.valueNames != value) {
            ArrayListSet oldValue = this.valueNames;
            this.valueNames = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_VALUENAMES, oldValue, value);
        }
    }

    public Enumeration withValueNames(String ... values) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(values));
        ArrayListSet listSet = new ArrayListSet();
        listSet.add(list);
        this.setValueNames(listSet);
        return this;
    }

    public Enumeration withValueNames(ArrayListSet value) {
        this.setValueNames(value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(" ").append(this.getName());
        return result.substring(1);
    }

    public ClassModel getClassModel() {
        return this.classModel;
    }

    public boolean setClassModel(ClassModel value) {
        boolean changed = false;
        if (this.classModel != value) {
            ClassModel oldValue = this.classModel;
            if (this.classModel != null) {
                this.classModel = null;
                oldValue.withoutEnumerations(this);
            }
            this.classModel = value;
            if (value != null) {
                value.withEnumerations(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CLASSMODEL, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public Enumeration withClassModel(ClassModel value) {
        this.setClassModel(value);
        return this;
    }

    public ClassModel createClassModel() {
        ClassModel value = new ClassModel();
        this.withClassModel(value);
        return value;
    }

    public MethodSet getMethods() {
        if (this.methods == null) {
            return Method.EMPTY_SET;
        }
        return this.methods;
    }

    public Enumeration withMethod(String name) {
        return this.with(new Method(name, new Parameter[0]));
    }

    public Enumeration withMethod(String name, DataType returnType) {
        return this.with(new Method(name, returnType, new Parameter[0]));
    }

    public Enumeration withMethod(String name, DataType returnType, Parameter ... parameters) {
        return this.with(new Method(name, returnType, parameters));
    }

    private Enumeration with(Method ... value) {
        if (value == null) {
            return this;
        }
        for (Method item : value) {
            boolean changed;
            if (item == null) continue;
            if (this.methods == null) {
                this.methods = new MethodSet();
            }
            if (!(changed = this.methods.add(item))) continue;
            item.withEnumeration(this);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_METHODS, null, item);
        }
        return this;
    }

    public Enumeration withMethods(Method ... value) {
        return this.with(value);
    }

    public Enumeration withoutMethods(Method ... value) {
        for (Method item : value) {
            if (this.methods == null || item == null || !this.methods.remove(item)) continue;
            item.setEnumeration(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_METHODS, item, null);
        }
        return this;
    }

    public Method createMethods() {
        Method value = new Method();
        this.withMethods(value);
        return value;
    }

    @Override
    public SDMLibClass withName(String value) {
        this.setName(value);
        return this;
    }

    public boolean isExternal() {
        return this.external;
    }

    public boolean setExternal(boolean value) {
        if (this.external != value) {
            boolean oldValue = this.external;
            this.external = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_EXTERNAL, oldValue, value);
            return true;
        }
        return false;
    }

    public Enumeration withExternal(boolean value) {
        this.setExternal(value);
        return this;
    }

    public String getFullName() {
        if (this.name.indexOf(46) < 0 && this.getClassModel() != null && this.getClassModel().getName() != null) {
            return this.getClassModel().getName() + "." + this.name.replace("$", ".");
        }
        return this.name.replace("$", ".");
    }
}

