/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes;

import java.util.concurrent.ConcurrentHashMap;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.Enumeration;

public class DataType {
    private static ConcurrentHashMap<Clazz, DataType> instances = new ConcurrentHashMap();
    public static final DataType VOID = DataType.getInstance("void");
    public static final DataType INT = DataType.getInstance("int");
    public static final DataType LONG = DataType.getInstance("long");
    public static final DataType DOUBLE = DataType.getInstance("double");
    public static final DataType STRING = DataType.getInstance("String");
    public static final DataType BOOLEAN = DataType.getInstance("boolean");
    public static final DataType OBJECT = DataType.getInstance("Object");
    public static final DataType CHAR = DataType.getInstance("char");
    private String value;
    private Clazz clazzValue;

    public static synchronized DataType getInstance(String key) {
        DataType result = instances.get(key);
        if (result == null) {
            result = new DataType(key);
            instances.put(new Clazz(key), result);
        }
        return result;
    }

    public static synchronized DataType getInstance(Clazz key) {
        return DataType.getInstance(key.getFullName());
    }

    private DataType(String value) {
        this.value = value;
    }

    private DataType(Clazz value) {
        this.clazzValue = value;
    }

    public String getValue() {
        return this.value;
    }

    public static DataType ref(String value) {
        return DataType.getInstance(value);
    }

    public static DataType ref(Class<?> value) {
        return DataType.getInstance(value.getName().replace("$", "."));
    }

    public static DataType ref(Clazz value) {
        return DataType.getInstance(value);
    }

    public static DataType ref(Enumeration value) {
        return DataType.getInstance(value.getFullName());
    }

    public String toString() {
        if ("void int long double String boolean Object".indexOf(this.value) >= 0) {
            return "DataType." + this.value.toUpperCase();
        }
        return "DataType.ref(\"" + this.value + "\")";
    }
}

