/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes;

import java.util.ArrayList;
import java.util.Iterator;
import org.sdmlib.models.classes.Annotation;
import org.sdmlib.models.classes.Association;
import org.sdmlib.models.classes.Attribute;
import org.sdmlib.models.classes.Card;
import org.sdmlib.models.classes.ClassModel;
import org.sdmlib.models.classes.DataType;
import org.sdmlib.models.classes.Enumeration;
import org.sdmlib.models.classes.Feature;
import org.sdmlib.models.classes.Method;
import org.sdmlib.models.classes.Parameter;
import org.sdmlib.models.classes.Role;
import org.sdmlib.models.classes.SDMLibClass;
import org.sdmlib.models.classes.util.AnnotationSet;
import org.sdmlib.models.classes.util.AttributeSet;
import org.sdmlib.models.classes.util.ClazzSet;
import org.sdmlib.models.classes.util.MethodSet;
import org.sdmlib.models.classes.util.RoleSet;

public class Clazz
extends SDMLibClass {
    public static final String PROPERTY_ATTRIBUTES = "attributes";
    public static final String PROPERTY_CLASSMODEL = "classModel";
    public static final String PROPERTY_SUPERCLAZZES = "superClazzes";
    public static final String PROPERTY_KIDCLAZZES = "kidClazzes";
    public static final String PROPERTY_METHODS = "methods";
    public static final String PROPERTY_ROLES = "roles";
    public static final String PROPERTY_INTERFAZE = "interface";
    public static final String PROPERTY_EXTERNAL = "external";
    public static final ClazzSet EMPTY_SET = (ClazzSet)new ClazzSet().withReadOnly(true);
    private AttributeSet attributes = null;
    private ClassModel classModel = null;
    private ClazzSet superClazzes = null;
    private ClazzSet kidClazzes = null;
    private ArrayList<String> imports = new ArrayList();
    private MethodSet methods = null;
    private RoleSet roles = null;
    private boolean interfaze = false;
    private boolean external;
    public static final String PROPERTY_ANNOTATIONS = "annotations";
    private AnnotationSet annotations = null;
    private boolean abztract;
    public static final String PROPERTY_ABZTRACT = "abztract";

    Clazz(String name) {
        this.setName(name);
    }

    public Clazz withAssoc(Clazz tgtClass, String tgtRoleName, Card tgtCard, String srcRoleName, Card srcCard) {
        Association assoc = new Association().withTarget(tgtClass, tgtRoleName, tgtCard).withSource(this, srcRoleName, srcCard);
        if (this.getClassModel() != null && this.getClassModel().getGenerator() != null) {
            this.getClassModel().getGenerator().addToAssociations(assoc);
        }
        return this;
    }

    public void withUniDirectionalAssoc(Clazz tgtClass, String tgtRoleName, Card tgtCard) {
        this.withAssoc(tgtClass, tgtRoleName, tgtCard, "", Card.ONE);
    }

    public String getFullName() {
        if (this.name.indexOf(46) < 0 && this.getClassModel() != null && this.getClassModel().getName() != null) {
            return this.getClassModel().getName() + "." + this.name.replace("$", ".");
        }
        return this.name.replace("$", ".");
    }

    @Override
    public Clazz withName(String name) {
        this.setName(name);
        return this;
    }

    public Clazz getSuperClass() {
        if (this.superClazzes == null) {
            return null;
        }
        Iterator iterator = this.superClazzes.iterator();
        while (iterator.hasNext()) {
            Clazz clazz = (Clazz)iterator.next();
            if (clazz.isInterface()) continue;
            return clazz;
        }
        return null;
    }

    public ClazzSet getInterfaces() {
        ClazzSet interfaces = new ClazzSet();
        if (this.superClazzes == null) {
            return interfaces;
        }
        Iterator iterator = this.superClazzes.iterator();
        while (iterator.hasNext()) {
            Clazz clazz = (Clazz)iterator.next();
            if (!clazz.isInterface()) continue;
            interfaces.add(clazz);
        }
        return interfaces;
    }

    public ClazzSet getSuperClazzes() {
        if (this.superClazzes == null) {
            return EMPTY_SET;
        }
        return this.superClazzes;
    }

    public Clazz withSuperClazz(Clazz ... value) {
        if (value == null) {
            return this;
        }
        if (this.superClazzes == null) {
            this.superClazzes = new ClazzSet();
        }
        for (Clazz item : value) {
            if (item == null || !this.superClazzes.add(item)) continue;
            item.withKidClazzes(this);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SUPERCLAZZES, null, item);
        }
        return this;
    }

    public ClazzSet getKidClazzes() {
        if (this.kidClazzes == null) {
            return EMPTY_SET;
        }
        return this.kidClazzes;
    }

    public ClazzSet getKidClazzesTransitive() {
        ClazzSet result = new ClazzSet().with(this);
        return result.getKidClazzesTransitive();
    }

    public Clazz withKidClazzes(Clazz ... value) {
        if (value == null) {
            return this;
        }
        if (this.kidClazzes == null) {
            this.kidClazzes = new ClazzSet();
        }
        for (Clazz item : value) {
            if (item == null || !this.kidClazzes.add(item)) continue;
            item.withSuperClazz(this);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KIDCLAZZES, null, item);
        }
        return this;
    }

    public ClassModel getClassModel() {
        return this.classModel;
    }

    public boolean setClassModel(ClassModel value) {
        boolean changed = false;
        if (this.classModel != value) {
            ClassModel oldValue = this.classModel;
            if (this.classModel != null) {
                this.classModel = null;
                oldValue.without(this);
            }
            this.classModel = value;
            if (value != null) {
                value.with(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CLASSMODEL, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public Clazz with(ClassModel value) {
        this.setClassModel(value);
        return this;
    }

    public AttributeSet getAttributes() {
        if (this.attributes == null) {
            return Attribute.EMPTY_SET;
        }
        return this.attributes;
    }

    public RoleSet getRoles() {
        if (this.roles == null) {
            return Role.EMPTY_SET;
        }
        return this.roles;
    }

    public Clazz with(Attribute ... value) {
        if (value == null) {
            return this;
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet();
        }
        for (Attribute item : value) {
            if (item == null || !this.attributes.add(item)) continue;
            item.with(this);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ATTRIBUTES, null, item);
        }
        return this;
    }

    public MethodSet getMethods() {
        if (this.methods == null) {
            return Method.EMPTY_SET;
        }
        return this.methods;
    }

    public Clazz withMethod(String name) {
        return this.with(new Method(name, new Parameter[0]));
    }

    public Clazz withMethod(String name, DataType returnType, Parameter ... parameters) {
        return this.with(new Method(name, returnType, parameters));
    }

    public Clazz withAttribute(String name, DataType type) {
        return this.with(new Attribute(name, type));
    }

    public Clazz withAttribute(String name, DataType type, String initialization) {
        this.with(new Attribute(name, type).withInitialization(initialization));
        return this;
    }

    @Override
    public void removeYou() {
        super.removeYou();
        this.setClassModel(null);
        this.without((Attribute[])this.getAttributes().toArray(new Attribute[this.getAttributes().size()]));
        this.without((Method[])this.getMethods().toArray(new Method[this.getMethods().size()]));
        this.without((Role[])this.getRoles().toArray(new Role[this.getRoles().size()]));
        this.withoutKidClazz((Clazz[])this.getKidClazzes().toArray(new Clazz[this.getKidClazzes().size()]));
        this.withoutSuperClazz((Clazz[])this.getSuperClazzes().toArray(new Clazz[this.getSuperClazzes().size()]));
        this.withoutKidClazzes((Clazz[])this.getKidClazzes().toArray(new Clazz[this.getKidClazzes().size()]));
        this.withoutSuperClazzes((Clazz[])this.getSuperClazzes().toArray(new Clazz[this.getSuperClazzes().size()]));
        this.withoutAttributes((Attribute[])this.getAttributes().toArray(new Attribute[this.getAttributes().size()]));
        this.withoutMethods((Method[])this.getMethods().toArray(new Method[this.getMethods().size()]));
        this.withoutRoles((Role[])this.getRoles().toArray(new Role[this.getRoles().size()]));
        this.withoutAnnotations((Annotation[])this.getAnnotations().toArray(new Annotation[this.getAnnotations().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public boolean isWithNoObjects() {
        return this.isAbztract() || this.isInterfaze();
    }

    public boolean isInterface() {
        return this.interfaze;
    }

    public boolean setInterface(boolean value) {
        if (this.interfaze != value) {
            boolean oldValue = this.interfaze;
            this.interfaze = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_INTERFAZE, oldValue, value);
            return true;
        }
        return false;
    }

    public Attribute getOrCreateAttribute(String attrName, DataType attrType) {
        Iterator iterator = this.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute attrDecl = (Attribute)iterator.next();
            if (!attrDecl.getName().equals(attrName)) continue;
            return attrDecl;
        }
        return new Attribute(attrName, attrType).with(this);
    }

    public boolean isExternal() {
        return this.external;
    }

    public boolean setExternal(boolean value) {
        if (this.external != value) {
            boolean oldValue = this.external;
            this.external = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_EXTERNAL, oldValue, value);
            return true;
        }
        return false;
    }

    public Clazz withExternal(boolean value) {
        this.setExternal(value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(" ").append(this.getName());
        return result.substring(1);
    }

    public Clazz withInterface(boolean value) {
        this.setInterface(value);
        return this;
    }

    public Clazz without(Attribute ... value) {
        if (this.attributes == null || value == null) {
            return this;
        }
        for (Attribute item : value) {
            if (item == null || !this.attributes.remove(item)) continue;
            item.setClazz(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ATTRIBUTES, item, null);
        }
        return this;
    }

    public Clazz with(Method ... value) {
        if (value == null) {
            return this;
        }
        if (this.methods == null) {
            this.methods = new MethodSet();
        }
        for (Method item : value) {
            if (item == null || !this.methods.add(item)) continue;
            item.with(this);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_METHODS, null, item);
        }
        return this;
    }

    public Clazz without(Method ... value) {
        if (this.methods == null || value == null) {
            return this;
        }
        for (Method item : value) {
            if (item == null || !this.methods.remove(item)) continue;
            item.setClazz(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_METHODS, item, null);
        }
        return this;
    }

    public Clazz with(Role ... value) {
        if (value == null) {
            return this;
        }
        for (Role item : value) {
            if (item == null) continue;
            if (this.roles == null) {
                this.roles = new RoleSet();
            }
            if (!this.roles.add(item)) continue;
            item.with(this);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ROLES, null, value);
        }
        return this;
    }

    public Clazz without(Role ... value) {
        if (this.roles == null || value == null) {
            return this;
        }
        for (Role item : value) {
            if (item == null || !this.roles.remove(item)) continue;
            item.setClazz(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ROLES, item, null);
        }
        return this;
    }

    public ClazzSet getSuperClassTransitive() {
        ClazzSet result = new ClazzSet().with(this);
        return result.getSuperClassTransitive();
    }

    public ClazzSet getInterfacesTransitive() {
        ClazzSet result = new ClazzSet().with(this);
        return result.getInterfacesTransitive();
    }

    public Method createMethod(String name, Parameter ... parameters) {
        return new Method().withName(name).with(parameters).with(this);
    }

    public Method createMethod(String name, DataType returnValue, Parameter ... parameters) {
        return new Method().withName(name).with(parameters).withReturnType(returnValue).with(this);
    }

    public Attribute createAttribute(String name, DataType type) {
        Attribute attribute = new Attribute(name, type);
        this.with(attribute);
        return attribute;
    }

    Method createMethod() {
        Method value = new Method();
        this.with(value);
        return value;
    }

    public Clazz withoutKidClazz(Clazz ... value) {
        if (this.kidClazzes == null || value == null) {
            return this;
        }
        for (Clazz item : value) {
            if (item == null || !this.kidClazzes.remove(item)) continue;
            item.withoutSuperClazz(this);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KIDCLAZZES, item, null);
        }
        return this;
    }

    public Clazz createKidClazz(String name) {
        Clazz value = new Clazz(name);
        this.withKidClazzes(value);
        return value;
    }

    Clazz createKidClazz() {
        Clazz value = new Clazz(null);
        this.withKidClazzes(value);
        return value;
    }

    public ClazzSet getSuperClazzesTransitive() {
        ClazzSet result = new ClazzSet().with(this);
        return result.getSuperClazzesTransitive();
    }

    public Clazz withoutSuperClazz(Clazz ... value) {
        if (this.superClazzes == null || value == null) {
            return this;
        }
        for (Clazz item : value) {
            if (item == null || !this.superClazzes.remove(item)) continue;
            item.withoutKidClazz(this);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SUPERCLAZZES, item, null);
        }
        return this;
    }

    Clazz createSuperClazz() {
        Clazz value = new Clazz(null);
        this.withSuperClazz(value);
        return value;
    }

    public Clazz withClassModel(ClassModel value) {
        this.setClassModel(value);
        return this;
    }

    ClassModel createClassModel() {
        ClassModel value = new ClassModel();
        this.withClassModel(value);
        return value;
    }

    boolean addToKidClazzes(Clazz value) {
        boolean changed = false;
        if (value != null) {
            if (this.kidClazzes == null) {
                this.kidClazzes = new ClazzSet();
            }
            if (changed = this.kidClazzes.add(value)) {
                value.withSuperClazzes(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KIDCLAZZES, null, value);
            }
        }
        return changed;
    }

    Clazz withoutKidClazzes(Clazz ... value) {
        for (Clazz item : value) {
            if (this.kidClazzes == null || item == null || !this.kidClazzes.remove(item)) continue;
            item.withoutSuperClazzes(this);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KIDCLAZZES, item, null);
        }
        return this;
    }

    Clazz createKidClazzes() {
        Clazz value = new Clazz(null);
        this.withKidClazzes(value);
        return value;
    }

    Clazz withSuperClazzes(Clazz ... value) {
        return this.withSuperClazz(value);
    }

    Clazz withoutSuperClazzes(Clazz ... value) {
        return this.withoutSuperClazz(value);
    }

    Clazz createSuperClazzes() {
        Clazz value = new Clazz(null);
        this.withSuperClazzes(value);
        return value;
    }

    Clazz withAttributes(Attribute ... value) {
        return this.with(value);
    }

    Clazz withoutAttributes(Attribute ... value) {
        return this.without(value);
    }

    Attribute createAttributes() {
        Attribute value = new Attribute(null, null);
        this.withAttributes(value);
        return value;
    }

    Clazz withMethods(Method ... value) {
        return this.with(value);
    }

    Clazz withoutMethods(Method ... value) {
        return this.without(value);
    }

    Method createMethods() {
        Method value = new Method();
        this.withMethods(value);
        return value;
    }

    Clazz withRoles(Role ... value) {
        return this.with(value);
    }

    Clazz withoutRoles(Role ... value) {
        return this.without(value);
    }

    Role createRoles() {
        Role value = new Role();
        this.withRoles(value);
        return value;
    }

    boolean isInterfaze() {
        return this.interfaze;
    }

    void setInterfaze(boolean value) {
        if (this.interfaze != value) {
            boolean oldValue = this.interfaze;
            this.interfaze = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_INTERFAZE, oldValue, value);
        }
    }

    Clazz withInterfaze(boolean value) {
        this.setInterfaze(value);
        return this;
    }

    public Clazz withImport(String value) {
        this.imports.add(value);
        return this;
    }

    public ArrayList<String> getImports() {
        return this.imports;
    }

    public boolean isEnumeration() {
        Iterator iterator = this.getClassModel().getEnumerations().iterator();
        while (iterator.hasNext()) {
            String clazzName;
            Enumeration enumeration = (Enumeration)iterator.next();
            String enumName = enumeration.getFullName();
            if (!enumName.equals(clazzName = this.getFullName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasFeature(Feature feature) {
        return this.getClassModel().hasFeature(feature, this);
    }

    public AnnotationSet getAnnotations() {
        if (this.annotations == null) {
            return AnnotationSet.EMPTY_SET;
        }
        return this.annotations;
    }

    public Clazz withAnnotations(Annotation ... value) {
        if (value == null) {
            return this;
        }
        for (Annotation item : value) {
            boolean changed;
            if (item == null) continue;
            if (this.annotations == null) {
                this.annotations = new AnnotationSet();
            }
            if (!(changed = this.annotations.add(item))) continue;
            item.withClazz(this);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ANNOTATIONS, null, item);
        }
        return this;
    }

    public Clazz withoutAnnotations(Annotation ... value) {
        for (Annotation item : value) {
            if (this.annotations == null || item == null || !this.annotations.remove(item)) continue;
            item.setClazz(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ANNOTATIONS, item, null);
        }
        return this;
    }

    public Annotation createAnnotations() {
        Annotation value = new Annotation();
        this.withAnnotations(value);
        return value;
    }

    public boolean isAbztract() {
        return this.abztract;
    }

    public void setAbztract(boolean value) {
        if (this.abztract != value) {
            boolean oldValue = this.abztract;
            this.abztract = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ABZTRACT, oldValue, value);
        }
    }

    public Clazz withAbztract(boolean value) {
        this.setAbztract(value);
        return this;
    }
}

