/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.sdmlib.CGUtil;
import org.sdmlib.doc.DocEnvironment;
import org.sdmlib.doc.GraphFactory;
import org.sdmlib.doc.interfaze.Adapter.GuiAdapter;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.Enumeration;
import org.sdmlib.models.classes.Feature;
import org.sdmlib.models.classes.SDMLibClass;
import org.sdmlib.models.classes.logic.GenClassModel;
import org.sdmlib.models.classes.util.ClazzSet;
import org.sdmlib.models.classes.util.EnumerationSet;

public class ClassModel
extends SDMLibClass {
    public static final String PROPERTY_CLASSES = "classes";
    private static final String PROPERTY_FEATURE = "feature";
    private Set<Feature> features = Feature.getAll();
    private String defaultAuthorName = System.getProperty("user.name");
    private ClazzSet classes;
    private GenClassModel generator;
    public static final String PROPERTY_ENUMERATIONS = "enumerations";
    private EnumerationSet enumerations = null;

    public ClassModel() {
        this.name = "i.love.sdmlib";
        Feature.reset();
    }

    public ClassModel(String packageName) {
        this();
        this.withName(packageName);
    }

    public ClassModel generate() {
        File srcDir = new File("src/main/java");
        if (srcDir.exists()) {
            return this.generate("src/main/java");
        }
        return this.generate("src");
    }

    public ClassModel generate(String rootDir) {
        this.getGenerator().generate(rootDir);
        return this;
    }

    public GenClassModel getGenerator() {
        if (this.generator == null) {
            this.setGenerator(new GenClassModel());
        }
        return this.generator;
    }

    protected void setGenerator(GenClassModel value) {
        if (this.generator != value) {
            GenClassModel oldValue = this.generator;
            if (this.generator != null) {
                this.generator = null;
                oldValue.setModel(null);
            }
            this.generator = value;
            if (value != null) {
                value.setModel(this);
            }
        }
    }

    public ClazzSet getClasses() {
        if (this.classes == null) {
            return Clazz.EMPTY_SET;
        }
        return this.classes;
    }

    public Clazz getClazz(String name) {
        Iterator iterator = this.getClasses().iterator();
        while (iterator.hasNext()) {
            Clazz c = (Clazz)iterator.next();
            if (!c.getName().equals(name) && !c.getName().endsWith("." + name)) continue;
            return c;
        }
        return null;
    }

    public Clazz createClazz(String name) {
        if (this.name == null) {
            this.name = CGUtil.packageName(name);
        }
        Clazz clazz = new Clazz(name);
        clazz.with(this);
        return clazz;
    }

    public Enumeration createEnumeration(String name) {
        if (this.name == null) {
            this.name = CGUtil.packageName(name);
        }
        Enumeration enumeration = (Enumeration)new Enumeration().withName(name);
        this.withEnumerations(enumeration);
        enumeration.withClassModel(this);
        return enumeration;
    }

    public String dumpClassDiagram(String diagName) {
        GuiAdapter graphViz = GraphFactory.getAdapter();
        return graphViz.dumpClassDiagram(diagName, this);
    }

    private String dumpClassDiagram(String diagName, String outputType) {
        GuiAdapter graphViz = GraphFactory.getAdapter(outputType);
        return graphViz.dumpClassDiagram(diagName, this);
    }

    @Override
    public void removeYou() {
        super.removeYou();
        this.without((Clazz[])this.getClasses().toArray(new Clazz[this.getClasses().size()]));
        this.withoutClasses((Clazz[])this.getClasses().toArray(new Clazz[this.getClasses().size()]));
        this.withoutEnumerations((Enumeration[])this.getEnumerations().toArray(new Enumeration[this.getEnumerations().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public void removeAllGeneratedCode() {
        this.getGenerator().removeAllGeneratedCode("src", "src", "src");
    }

    public void removeAllGeneratedCode(String rootDir) {
        this.getGenerator().removeAllGeneratedCode(rootDir, rootDir, rootDir);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(" ").append(this.getName());
        return result.substring(1);
    }

    public ClassModel with(Clazz ... value) {
        if (value == null) {
            return this;
        }
        if (this.classes == null) {
            this.classes = new ClazzSet();
        }
        for (Clazz item : value) {
            if (item == null || !this.classes.add(item)) continue;
            item.with(this);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CLASSES, null, item);
        }
        return this;
    }

    public ClassModel without(Clazz ... value) {
        if (this.classes == null) {
            return this;
        }
        for (Clazz item : value) {
            if (item == null || !this.classes.remove(item)) continue;
            item.setClassModel(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CLASSES, item, null);
        }
        return this;
    }

    public ClassModel withFeature(Feature ... value) {
        if (value == null) {
            return this;
        }
        for (Feature item : value) {
            if (item == null || !this.features.add(item)) continue;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_FEATURE, null, (Object)item);
        }
        return this;
    }

    public ClassModel withoutFeature(Feature ... value) {
        if (value == null) {
            return this;
        }
        for (Feature item : value) {
            if (item == null || !this.features.remove((Object)item)) continue;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_FEATURE, (Object)item, null);
        }
        return this;
    }

    public ClassModel withFeatures(HashSet<Feature> value) {
        if (value == null) {
            this.features.clear();
            return this;
        }
        for (Feature item : value) {
            if (item == null || !this.features.add(item)) continue;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_FEATURE, null, (Object)item);
        }
        return this;
    }

    public boolean hasFeature(Feature value) {
        return this.features.contains((Object)value);
    }

    public boolean hasFeature(Feature feature, Clazz value) {
        if (this.hasFeature(feature)) {
            return feature.match(value);
        }
        return false;
    }

    @Override
    public ClassModel withName(String value) {
        this.setName(value);
        return this;
    }

    ClassModel withClasses(Clazz ... value) {
        return this.with(value);
    }

    ClassModel withoutClasses(Clazz ... value) {
        return this.without(value);
    }

    Clazz createClasses() {
        Clazz value = new Clazz(null);
        this.withClasses(value);
        return value;
    }

    public void dumpHTML(String diagramName) {
        this.dumpHTML(diagramName, "doc", "Javascript");
    }

    public void dumpHTML(String diagramName, String folder, String outputType) {
        new File(folder).mkdirs();
        String dumpClassDiagram = this.dumpClassDiagram(diagramName, outputType);
        String htmlTemplate = "<html>\n<head>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"includes/diagramstyle.css\">\n<script src=\"includes/dagre.min.js\"></script>\n<script src=\"includes/graph.js\"></script>\n<script src=\"includes/drawer.js\"></script>\n</head>\n<body>\nbodytext\n</body>\n</html>\n";
        htmlTemplate = htmlTemplate.replaceFirst("bodytext", dumpClassDiagram);
        File file = new File(folder + "/" + diagramName + ".html");
        try {
            PrintStream out = new PrintStream(file);
            out.println(htmlTemplate);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        new DocEnvironment().copyJS(folder);
    }

    public EnumerationSet getEnumerations() {
        if (this.enumerations == null) {
            return Enumeration.EMPTY_SET;
        }
        return this.enumerations;
    }

    public ClassModel withEnumerations(Enumeration ... value) {
        if (value == null) {
            return this;
        }
        for (Enumeration item : value) {
            boolean changed;
            if (item == null) continue;
            if (this.enumerations == null) {
                this.enumerations = new EnumerationSet();
            }
            if (!(changed = this.enumerations.add(item))) continue;
            item.withClassModel(this);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ENUMERATIONS, null, item);
        }
        return this;
    }

    public ClassModel withoutEnumerations(Enumeration ... value) {
        for (Enumeration item : value) {
            if (this.enumerations == null || item == null || !this.enumerations.remove(item)) continue;
            item.setClassModel(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ENUMERATIONS, item, null);
        }
        return this;
    }

    public Enumeration createEnumerations() {
        Enumeration value = new Enumeration();
        this.withEnumerations(value);
        return value;
    }

    public String getAuthorName() {
        return this.defaultAuthorName;
    }

    public void withAuthorName(String defaultAuthorName) {
        this.defaultAuthorName = defaultAuthorName;
    }
}

