/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes;

import org.sdmlib.models.classes.Annotation;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.DataType;
import org.sdmlib.models.classes.Value;
import org.sdmlib.models.classes.Visibility;
import org.sdmlib.models.classes.util.AnnotationSet;
import org.sdmlib.models.classes.util.AttributeSet;

public class Attribute
extends Value {
    public static final String PROPERTY_CLAZZ = "clazz";
    public static final AttributeSet EMPTY_SET = (AttributeSet)new AttributeSet().withReadOnly(true);
    private Clazz clazz = null;
    private Visibility visibility = Visibility.PRIVATE;
    public static final String PROPERTY_ANNOTATIONS = "annotations";
    private AnnotationSet annotations = null;

    public Attribute(String name, DataType type) {
        this.name = name;
        this.type = type;
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public boolean setClazz(Clazz value) {
        if (this.clazz != value) {
            Clazz oldValue = this.clazz;
            if (this.clazz != null) {
                this.clazz = null;
                oldValue.without(this);
            }
            this.clazz = value;
            if (value != null) {
                value.with(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CLAZZ, oldValue, value);
            return true;
        }
        return false;
    }

    public Attribute with(Clazz value) {
        this.setClazz(value);
        return this;
    }

    @Override
    public String toString() {
        return "" + this.name + " : " + this.type;
    }

    @Override
    public void removeYou() {
        super.removeYou();
        this.setClazz(null);
        this.withoutAnnotations((Annotation[])this.getAnnotations().toArray(new Annotation[this.getAnnotations().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    @Override
    public Attribute withName(String string) {
        this.setName(string);
        return this;
    }

    @Override
    public Attribute with(DataType value) {
        this.setType(value);
        return this;
    }

    @Override
    public Attribute withInitialization(String value) {
        this.setInitialization(value);
        return this;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public Attribute with(Visibility ... visibility) {
        if (visibility == null) {
            return this;
        }
        if (visibility.length == 1) {
            this.visibility = visibility[0];
        }
        this.visibility = Visibility.ref(visibility);
        return this;
    }

    Attribute withClazz(Clazz value) {
        this.setClazz(value);
        return this;
    }

    Clazz createClazz() {
        Clazz value = new Clazz(null);
        this.withClazz(value);
        return value;
    }

    public AnnotationSet getAnnotations() {
        if (this.annotations == null) {
            return AnnotationSet.EMPTY_SET;
        }
        return this.annotations;
    }

    public Attribute withAnnotations(Annotation ... value) {
        if (value == null) {
            return this;
        }
        for (Annotation item : value) {
            boolean changed;
            if (item == null) continue;
            if (this.annotations == null) {
                this.annotations = new AnnotationSet();
            }
            if (!(changed = this.annotations.add(item))) continue;
            item.withAttribute(this);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ANNOTATIONS, null, item);
        }
        return this;
    }

    public Attribute withoutAnnotations(Annotation ... value) {
        for (Annotation item : value) {
            if (this.annotations == null || item == null || !this.annotations.remove(item)) continue;
            item.setAttribute(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ANNOTATIONS, item, null);
        }
        return this;
    }

    public Annotation createAnnotations() {
        Annotation value = new Annotation();
        this.withAnnotations(value);
        return value;
    }
}

