/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes;

import org.sdmlib.CGUtil;
import org.sdmlib.models.classes.Card;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.Role;
import org.sdmlib.models.classes.SDMLibClass;

public class Association
extends SDMLibClass {
    public static final String PROPERTY_SOURCE = "source";
    public static final String PROPERTY_TARGET = "target";
    private Role source = null;
    private Role target;

    @Override
    public String toString() {
        String text = "role is missing";
        try {
            text = CGUtil.shortClassName(this.source.getClazz().getName()) + "|" + this.source.getName() + " -- " + this.target.getName() + "|" + CGUtil.shortClassName(this.target.getClazz().getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }

    public Association withSource(Clazz sourceClass, String roleName, Card card) {
        this.setSource(new Role().withName(roleName).with(sourceClass).withCard(card.toString()));
        if (sourceClass.getClassModel() != null && sourceClass.getClassModel().getGenerator() != null) {
            sourceClass.getClassModel().getGenerator().addToAssociations(this);
        }
        return this;
    }

    public Association withTarget(Clazz targetClass, String roleName, Card card) {
        this.setTarget(new Role().withName(roleName).with(targetClass).withCard(card.toString()));
        if (targetClass.getClassModel() != null && targetClass.getClassModel().getGenerator() != null) {
            targetClass.getClassModel().getGenerator().addToAssociations(this);
        }
        return this;
    }

    public Role getTarget() {
        return this.target;
    }

    public boolean setTarget(Role value) {
        boolean changed = false;
        if (this.target != value) {
            Role oldValue = this.target;
            if (this.target != null) {
                this.target = null;
                oldValue.setAssoc(null);
            }
            this.target = value;
            if (value != null) {
                value.with(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TARGET, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public Association withTarget(Role value) {
        this.setTarget(value);
        return this;
    }

    public Role getSource() {
        return this.source;
    }

    public boolean setSource(Role value) {
        boolean changed = false;
        if (this.source != value) {
            Role oldValue = this.source;
            if (this.source != null) {
                this.source = null;
                oldValue.setAssoc(null);
            }
            this.source = value;
            if (value != null) {
                value.with(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SOURCE, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public Association withSource(Role value) {
        this.setSource(value);
        return this;
    }

    @Override
    public void removeYou() {
        Clazz targetClazz = null;
        if (this.getSource() != null) {
            targetClazz = this.getSource().getClazz();
        } else if (this.getTarget() != null) {
            targetClazz = this.getTarget().getClazz();
        }
        if (targetClazz != null) {
            targetClazz.getClassModel().getGenerator().removeFromAssociations(this);
        }
        this.setSource(null);
        this.setTarget(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    @Override
    public Association withName(String value) {
        this.setName(value);
        return this;
    }

    Role createSource() {
        Role value = new Role();
        this.withSource(value);
        return value;
    }

    Role createTarget() {
        Role value = new Role();
        this.withTarget(value);
        return value;
    }
}

