/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.classes;

import java.util.HashSet;
import java.util.Set;
import org.sdmlib.models.classes.Attribute;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.Method;
import org.sdmlib.models.classes.SDMLibClass;

public class Annotation
extends SDMLibClass {
    public static final String PROPERTY_CLAZZ = "clazz";
    private Clazz clazz = null;
    public static final String PROPERTY_METHOD = "method";
    private Method method = null;
    public static final String PROPERTY_VALUES = "values";
    private Set<String> values;
    public static final String DEPRECATED = "Deprecated";
    public static final String OVERRIDE = "Override";
    public static final String SAFE_VARGARGS = "SafeVarargs";
    public static final String SUPPRESS_WARNINGS = "SuppressWarnings";
    public static final String PROPERTY_ATTRIBUTE = "attribute";
    private Attribute attribute = null;

    @Override
    public void removeYou() {
        super.removeYou();
        this.setClazz(null);
        this.setMethod(null);
        this.setAttribute(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public boolean setClazz(Clazz value) {
        boolean changed = false;
        if (this.clazz != value) {
            Clazz oldValue = this.clazz;
            if (this.clazz != null) {
                this.clazz = null;
                oldValue.withoutAnnotations(this);
            }
            this.clazz = value;
            if (value != null) {
                value.withAnnotations(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CLAZZ, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public Annotation withClazz(Clazz value) {
        this.setClazz(value);
        return this;
    }

    public Clazz createClazz() {
        Clazz value = new Clazz(null);
        this.withClazz(value);
        return value;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean setMethod(Method value) {
        boolean changed = false;
        if (this.method != value) {
            Method oldValue = this.method;
            if (this.method != null) {
                this.method = null;
                oldValue.withoutAnnotations(this);
            }
            this.method = value;
            if (value != null) {
                value.withAnnotations(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_METHOD, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public Annotation withMethod(Method value) {
        this.setMethod(value);
        return this;
    }

    public Method createMethod() {
        Method value = new Method();
        this.withMethod(value);
        return value;
    }

    @Override
    public Annotation withName(String value) {
        this.setName(value);
        return this;
    }

    public static Annotation createOverrideAnnotation() {
        return new Annotation().withName(OVERRIDE);
    }

    public static Annotation createDeprecatedAnnotation() {
        return new Annotation().withName(DEPRECATED);
    }

    public static Annotation createSuppressWarningsAnnotation(String ... values) {
        return new Annotation().withName(SUPPRESS_WARNINGS).withValues(values);
    }

    public static Annotation createSafeVarargsAnnotation() {
        return new Annotation().withName(SAFE_VARGARGS);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(" ").append(this.getName()).append(", ").append(this.values);
        return result.substring(1);
    }

    public Set<String> createValues() {
        if (this.values == null) {
            this.values = new HashSet<String>();
        }
        return this.values;
    }

    public Set<String> getValues() {
        if (this.values == null) {
            this.values = new HashSet<String>();
        }
        return this.values;
    }

    public void setValues(Set<String> values) {
        Set<String> oldValues = this.values;
        this.values = values;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_VALUES, oldValues, values);
    }

    public Annotation withValues(String ... values) {
        if (this.values == null) {
            this.values = new HashSet<String>();
        }
        for (String value : values) {
            if (!this.values.add(value)) continue;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_VALUES, null, value);
        }
        return this;
    }

    public Annotation withoutValues(String ... values) {
        if (this.values == null) {
            this.values = new HashSet<String>();
        }
        for (String value : values) {
            if (!this.values.remove(value)) continue;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_VALUES, value, null);
        }
        return this;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public boolean setAttribute(Attribute value) {
        boolean changed = false;
        if (this.attribute != value) {
            Attribute oldValue = this.attribute;
            if (this.attribute != null) {
                this.attribute = null;
                oldValue.withoutAnnotations(this);
            }
            this.attribute = value;
            if (value != null) {
                value.withAnnotations(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ATTRIBUTE, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public Annotation withAttribute(Attribute value) {
        this.setAttribute(value);
        return this;
    }

    public Attribute createAttribute() {
        Attribute value = new Attribute(null, null);
        this.withAttribute(value);
        return value;
    }
}

