/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.doc.JavascriptAdapter;

import de.uniks.networkparser.graph.GraphAttribute;
import de.uniks.networkparser.graph.GraphCardinality;
import de.uniks.networkparser.graph.GraphClazz;
import de.uniks.networkparser.graph.GraphConverter;
import de.uniks.networkparser.graph.GraphDataType;
import de.uniks.networkparser.graph.GraphEdge;
import de.uniks.networkparser.graph.GraphEdgeTypes;
import de.uniks.networkparser.graph.GraphLabel;
import de.uniks.networkparser.graph.GraphList;
import de.uniks.networkparser.graph.GraphMethod;
import de.uniks.networkparser.graph.GraphNode;
import de.uniks.networkparser.graph.GraphParameter;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonIdMap;
import de.uniks.networkparser.json.JsonObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.sdmlib.CGUtil;
import org.sdmlib.doc.interfaze.Adapter.GuiAdapter;
import org.sdmlib.doc.interfaze.Drawer.GuiFileDrawer;
import org.sdmlib.models.classes.Association;
import org.sdmlib.models.classes.Attribute;
import org.sdmlib.models.classes.ClassModel;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.Method;
import org.sdmlib.models.classes.Parameter;
import org.sdmlib.models.classes.Role;
import org.sdmlib.models.classes.SDMLibClass;
import org.sdmlib.models.classes.Value;
import org.sdmlib.models.objects.GenericGraph;
import org.sdmlib.models.objects.util.GenericObjectSet;
import org.sdmlib.models.taskflows.util.LogEntrySet;

public class Javascript
implements GuiAdapter {
    public static final String NAME = "Javascript";
    private String rootDir = "src";
    private JsonIdMap lastIdMap = null;
    private LinkedHashMap<String, String> iconMap;

    @Override
    public Javascript withRootDir(String rootDir) {
        this.rootDir = rootDir;
        return this;
    }

    @Override
    public Javascript withIconMap(LinkedHashMap<String, String> iconMap) {
        this.iconMap = iconMap;
        return this;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String toImg(String imgName, JsonArray jsonArray) {
        for (Map.Entry<String, String> entry : this.iconMap.entrySet()) {
            JsonObject jsonObject = jsonArray.get(entry.getKey());
            if (jsonObject == null) continue;
            jsonObject.put((Object)"headimage", (Object)entry.getValue());
        }
        GraphConverter graphConverter = new GraphConverter();
        JsonObject objectModel = graphConverter.convertToJson("objectdiagram", jsonArray, true);
        String text = "<script>\n   var json = " + objectModel.toString(3) + "   ;\n" + "   json[\"options\"]={\"canvasid\":\"canvas" + imgName + "\", " + "\"display\":\"html\", " + "\"fontsize\":10," + "\"bar\":true};" + "   var g = new Graph(json);\n" + "   g.layout(100,100);\n" + "</script>\n";
        return text;
    }

    @Override
    public String addGenericObjectDiag(String diagramName, GenericGraph graph, GenericObjectSet hiddenObjects) {
        return "";
    }

    @Override
    public String dumpSwimlanes(String name, LogEntrySet entries) {
        return "";
    }

    @Override
    public void fillNodeAndEdgeBuilders(String imgName, JsonArray objects, StringBuilder nodeBuilder, StringBuilder edgeBuilder, boolean omitRoot, String ... aggregationRoles) {
    }

    @Override
    public String dumpDiagram(String diagramName, String fileText) {
        return "";
    }

    public GraphList convertModelToGraphList(ClassModel model) {
        GraphList list = new GraphList().withTyp("classdiagram");
        HashMap<String, GraphClazz> nodes = new HashMap<String, GraphClazz>();
        Iterator iterator = model.getClasses().iterator();
        while (iterator.hasNext()) {
            Clazz clazz = (Clazz)iterator.next();
            GraphClazz node = new GraphClazz().withClassName(CGUtil.shortClassName(clazz.getName()));
            Iterator iterator2 = clazz.getAttributes().iterator();
            while (iterator2.hasNext()) {
                Attribute attr = (Attribute)iterator2.next();
                node.add((Object)new GraphAttribute(attr.getName(), GraphDataType.ref((String)attr.getType().getValue())));
            }
            iterator2 = clazz.getMethods().iterator();
            while (iterator2.hasNext()) {
                Method method = (Method)iterator2.next();
                GraphMethod newMethod = new GraphMethod(method.getName(), new GraphParameter[0]);
                Iterator iterator3 = method.getParameter().iterator();
                while (iterator3.hasNext()) {
                    Parameter param = (Parameter)iterator3.next();
                    newMethod.withParameter(param.getName(), GraphDataType.ref((String)param.getType().getValue()));
                }
                node.add((Object)newMethod);
            }
            list.with(node);
            nodes.put(node.getId(), node);
        }
        iterator = model.getClasses().getRoles().getAssoc().iterator();
        while (iterator.hasNext()) {
            Association assoc = (Association)iterator.next();
            Role source = assoc.getSource();
            Role target = assoc.getTarget();
            GraphEdge sourceEdge = new GraphEdge().with(GraphCardinality.create((String)source.getCard()));
            GraphEdge targetEdge = new GraphEdge().with(GraphCardinality.create((String)target.getCard()));
            sourceEdge.with(targetEdge);
            sourceEdge.withInfo(new GraphLabel().withValue(source.getName()));
            sourceEdge.with((Object[])new GraphNode[]{(GraphNode)nodes.get(CGUtil.shortClassName(source.getClazz().getName()))});
            targetEdge.withInfo(new GraphLabel().withValue(target.getName()));
            targetEdge.with((Object[])new GraphNode[]{(GraphNode)nodes.get(CGUtil.shortClassName(target.getClazz().getName()))});
            list.with(sourceEdge);
        }
        iterator = model.getClasses().iterator();
        while (iterator.hasNext()) {
            Clazz kidClazz = (Clazz)iterator.next();
            Iterator iterator4 = kidClazz.getSuperClazzes().iterator();
            while (iterator4.hasNext()) {
                Clazz superClazz = (Clazz)iterator4.next();
                GraphEdge generationEdge = new GraphEdge().withTyp(GraphEdgeTypes.GENERALISATION);
                generationEdge.with((Object[])new GraphNode[]{(GraphNode)nodes.get(CGUtil.shortClassName(kidClazz.getName()))});
                GraphEdge kidEdge = new GraphEdge().withTyp(GraphEdgeTypes.GENERALISATION);
                generationEdge.with(kidEdge);
                kidEdge.with((Object[])new GraphNode[]{(GraphNode)nodes.get(CGUtil.shortClassName(superClazz.getName()))});
                list.with(generationEdge);
            }
        }
        return list;
    }

    public JsonObject convertModel(ClassModel model) {
        JsonObject json = new JsonObject();
        json.put((Object)"typ", (Object)"class");
        JsonArray jsonNodes = new JsonArray();
        JsonArray jsonEdges = new JsonArray();
        Iterator iterator = model.getClasses().iterator();
        while (iterator.hasNext()) {
            Object attr;
            Clazz clazz = (Clazz)iterator.next();
            JsonObject jsonClazz = new JsonObject();
            jsonClazz.put((Object)"typ", (Object)"node");
            jsonClazz.put((Object)"id", (Object)CGUtil.shortClassName(clazz.getName()));
            JsonArray jsonAttrs = new JsonArray();
            Iterator iterator2 = clazz.getAttributes().iterator();
            while (iterator2.hasNext()) {
                attr = (Attribute)iterator2.next();
                jsonAttrs.add((Object)("" + ((SDMLibClass)attr).getName() + " : " + ((Value)attr).getType().getValue()));
            }
            if (jsonAttrs.size() > 0) {
                jsonClazz.put((Object)"attributes", (Object)jsonAttrs);
            }
            JsonArray jsonMethods = new JsonArray();
            attr = clazz.getMethods().iterator();
            while (attr.hasNext()) {
                Method method = (Method)attr.next();
                jsonMethods.add((Object)("" + method.getSignature()));
            }
            if (jsonMethods.size() > 0) {
                jsonClazz.put((Object)"methods", (Object)jsonMethods);
            }
            jsonNodes.add((Object)jsonClazz);
        }
        json.put((Object)"nodes", (Object)jsonNodes);
        iterator = model.getClasses().getRoles().getAssoc().iterator();
        while (iterator.hasNext()) {
            Association assoc = (Association)iterator.next();
            JsonObject jsonAssoc = new JsonObject();
            jsonAssoc.put((Object)"typ", (Object)"edge");
            JsonObject jsonRole = new JsonObject();
            jsonAssoc.put((Object)"source", (Object)jsonRole);
            Role source = assoc.getSource();
            Role target = assoc.getTarget();
            jsonRole.put((Object)"cardinality", (Object)source.getCard());
            jsonRole.put((Object)"property", (Object)source.getName());
            jsonRole.put((Object)"id", (Object)CGUtil.shortClassName(source.getClazz().getName()));
            jsonRole = new JsonObject();
            jsonAssoc.put((Object)"target", (Object)jsonRole);
            jsonRole.put((Object)"id", (Object)CGUtil.shortClassName(target.getClazz().getName()));
            jsonRole.put((Object)"cardinality", (Object)target.getCard());
            jsonRole.put((Object)"property", (Object)target.getName());
            jsonEdges.add((Object)jsonAssoc);
        }
        iterator = model.getClasses().iterator();
        while (iterator.hasNext()) {
            Clazz kidClazz = (Clazz)iterator.next();
            Iterator iterator3 = kidClazz.getSuperClazzes().iterator();
            while (iterator3.hasNext()) {
                Clazz superClazz = (Clazz)iterator3.next();
                JsonObject jsonAssoc = new JsonObject();
                jsonAssoc.put((Object)"typ", (Object)"generalisation");
                JsonObject jsonRole = new JsonObject();
                jsonRole.put((Object)"id", (Object)CGUtil.shortClassName(kidClazz.getName()));
                jsonAssoc.put((Object)"source", (Object)jsonRole);
                jsonRole = new JsonObject();
                jsonRole.put((Object)"id", (Object)CGUtil.shortClassName(superClazz.getName()));
                jsonAssoc.put((Object)"target", (Object)jsonRole);
                jsonEdges.add((Object)jsonAssoc);
            }
        }
        json.put((Object)"edges", (Object)jsonEdges);
        return json;
    }

    @Override
    public String dumpClassDiagram(String diagName, ClassModel model) {
        JsonObject json = this.convertModel(model);
        String text = "<script>\n   var json = " + json.toString(3) + "   ;\n" + "   new Graph(json, {\"canvasid\":\"canvas" + diagName + "\", " + "\"display\":\"html\", " + "\"fontsize\":10," + "\"bar\":true}).layout(100,100);\n" + "</script>\n";
        return text;
    }

    @Override
    public Javascript withDrawer(GuiFileDrawer drawer) {
        return null;
    }
}

