/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.doc.GraphVizAdapter;

import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonIdMap;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.xml.HTMLEntities;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import org.sdmlib.CGUtil;
import org.sdmlib.StrUtil;
import org.sdmlib.doc.GraphVizAdapter.ClassModelTemplate;
import org.sdmlib.doc.interfaze.Adapter.GuiAdapter;
import org.sdmlib.doc.interfaze.Drawer.GuiFileDrawer;
import org.sdmlib.models.classes.ClassModel;
import org.sdmlib.models.modelsets.StringList;
import org.sdmlib.models.objects.GenericAttribute;
import org.sdmlib.models.objects.GenericGraph;
import org.sdmlib.models.objects.GenericLink;
import org.sdmlib.models.objects.GenericObject;
import org.sdmlib.models.objects.util.GenericObjectSet;
import org.sdmlib.models.taskflows.LogEntry;
import org.sdmlib.models.taskflows.util.LogEntrySet;

public class GraphViz
implements GuiAdapter {
    public static final String NAME = "GraphViz";
    private String rootDir = "src";
    private JsonIdMap lastIdMap = null;
    private static LinkedHashMap<String, String> iconMap;
    private int objNo;
    private GuiFileDrawer drawer;

    @Override
    public GraphViz withRootDir(String rootDir) {
        this.rootDir = rootDir;
        return this;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setLastIdMap(JsonIdMap lastIdMap) {
        this.lastIdMap = lastIdMap;
    }

    public void dumpImage(String imgName, Object root) {
        JsonArray jsonArray = this.lastIdMap.toJsonArray(root);
        String imgLink = this.toImg(imgName, jsonArray);
    }

    public void dumpImage(String imgName, JsonIdMap newIdMap, Object root) {
        this.lastIdMap = newIdMap;
        JsonArray jsonArray = newIdMap.toJsonArray(root);
        String imgLink = this.toImg(imgName, jsonArray);
    }

    @Override
    public String toImg(String imgName, JsonArray objects) {
        return this.toImg(imgName, objects, false, null);
    }

    public String toImg(String imgName, JsonArray objects, boolean omitRoot, String[] aggregationRoles) {
        String link = "<embed type=\"image/svg+xml\" src='<imagename>'>\n";
        link = link.replaceFirst("<imagename>", imgName + ".svg");
        String fileText = "graph ObjectDiagram {\n   node [shape = none, fontsize = 10, fontname = \"Arial\"];\n   edge [fontsize = 10, fontname = \"Arial\"];\n   compound=true;\n\n<nodes>\n<edges>}\n";
        StringBuilder nodeBuilder = new StringBuilder();
        StringBuilder edgeBuilder = new StringBuilder();
        this.fillNodeAndEdgeBuilders(imgName, objects, nodeBuilder, edgeBuilder, omitRoot, aggregationRoles);
        fileText = fileText.replaceFirst("<nodes>", Matcher.quoteReplacement(nodeBuilder.toString()));
        fileText = fileText.replaceFirst("<edges>", Matcher.quoteReplacement(edgeBuilder.toString()));
        this.draw(imgName, fileText);
        return link;
    }

    @Override
    public void fillNodeAndEdgeBuilders(String imgName, JsonArray objects, StringBuilder nodeBuilder, StringBuilder edgeBuilder, boolean omitRoot, String ... aggregationRoles) {
        String omittedId = "";
        LinkedHashMap<String, EdgeLabels> edgeMap = new LinkedHashMap<String, EdgeLabels>();
        LinkedHashSet<String> knownIds = new LinkedHashSet<String>();
        LinkedHashMap<String, LinkedHashSet<String>> aggregationMap = new LinkedHashMap<String, LinkedHashSet<String>>();
        LinkedHashMap<String, JsonObject> jsonObjectMap = new LinkedHashMap<String, JsonObject>();
        for (int i = 0; i < objects.size(); ++i) {
            JsonObject jsonObject = objects.getJSONObject(i);
            String jsonId = jsonObject.getString((Object)"id");
            if (omitRoot && i == 0) {
                omittedId = jsonId;
                continue;
            }
            knownIds.add(jsonId);
            aggregationMap.put(jsonId, new LinkedHashSet());
            jsonObjectMap.put(jsonId, jsonObject);
        }
        LinkedHashSet<String> aggregationRolesSet = new LinkedHashSet<String>();
        if (aggregationRoles != null && aggregationRoles.length > 0) {
            aggregationRolesSet.addAll(Arrays.asList(aggregationRoles));
            for (String id : (LinkedHashSet)knownIds.clone()) {
                JsonObject properties = jsonObjectMap.get(id);
                JsonObject props = (JsonObject)properties.get((Object)"prop");
                if (props == null) continue;
                Iterator iter = props.keyIterator();
                while (iter.hasNext()) {
                    String nextProp = (String)iter.next();
                    if (!aggregationRolesSet.contains(nextProp)) continue;
                    Object propValue = props.get((Object)nextProp);
                    if (propValue instanceof JsonArray) {
                        JsonArray propArray = (JsonArray)propValue;
                        for (int i = 0; i < propArray.size(); ++i) {
                            JsonObject containedId = propArray.getJSONObject(i);
                            String subId = containedId.getString((Object)"id");
                            aggregationMap.get(id).add(subId);
                            knownIds.remove(subId);
                        }
                        continue;
                    }
                    String subId = ((JsonObject)propValue).getString((Object)"id");
                    aggregationMap.get(id).add(subId);
                    knownIds.remove(subId);
                }
            }
        }
        this.listOfNodes(nodeBuilder, omittedId, edgeMap, knownIds, aggregationMap, jsonObjectMap, imgName);
        for (String keyPair : edgeMap.keySet()) {
            String[] split = keyPair.split(":");
            EdgeLabels edgeLabels = edgeMap.get(keyPair);
            if (aggregationRolesSet.contains(edgeLabels.headlabel) || aggregationRolesSet.contains(edgeLabels.taillabel)) continue;
            String edgeLine = "<srcId> -- <tgtId> [headlabel = \"<headlabel>\" taillabel = \"<taillabel>\"];\n";
            edgeLine = edgeLine.replaceFirst("<srcId>", Matcher.quoteReplacement(split[0]));
            edgeLine = edgeLine.replaceFirst("<tgtId>", Matcher.quoteReplacement(split[1]));
            edgeLine = edgeLine.replaceFirst("<headlabel>", Matcher.quoteReplacement(edgeLabels.headlabel));
            String taillabel = edgeLabels.taillabel;
            if (taillabel.startsWith("_")) {
                taillabel = taillabel.substring(1);
            }
            edgeLine = edgeLine.replaceFirst("<taillabel>", Matcher.quoteReplacement(taillabel));
            edgeBuilder.append(edgeLine);
        }
    }

    private void listOfNodes(StringBuilder nodeBuilder, String omittedId, LinkedHashMap<String, EdgeLabels> edgeMap, Set<String> knownIds, LinkedHashMap<String, LinkedHashSet<String>> aggregationMap, LinkedHashMap<String, JsonObject> jsonObjectMap, String imgName) {
        for (String topId : knownIds) {
            JsonObject jsonObject = jsonObjectMap.get(topId);
            String nodeLine = "<id> [label=<<table border='0' cellborder='1' cellspacing='0'> <optionalImage><tr> <td href=\"<classRef>\"> <u><id> :<classname></u></td></tr></table>>];\n";
            boolean isCluster = false;
            if (aggregationMap.get(topId).size() > 0) {
                isCluster = true;
                nodeLine = "subgraph cluster_<id> { \n   <id> [label=<<table border='0' cellborder='0' cellspacing='0'> <optionalImage><tr> <td> <u><id> :<classname></u></td></tr></table>>];\n   \n";
            }
            String imageName = jsonObject.getString((Object)"class") + ".svg";
            File imageFile = new File("doc/" + imageName);
            nodeLine = imageFile.exists() ? nodeLine.replaceFirst("<optionalImage>", "<tr><td border='0'><IMG src=\"" + imageName + "\" /></td></tr>") : (iconMap != null && iconMap.get(topId) != null ? nodeLine.replaceFirst("<optionalImage>", "<tr><td border='0'><IMG src=\"" + iconMap.get(topId) + "\" /></td></tr>") : nodeLine.replaceFirst("<optionalImage>", ""));
            String jsonId = GraphViz.lastPartStartLow(jsonObject.getString((Object)"id"));
            nodeLine = nodeLine.replaceAll("<id>", Matcher.quoteReplacement(jsonId));
            String className = jsonObject.getString((Object)"class");
            String classFileName = className;
            if (classFileName.indexOf(36) >= 0) {
                classFileName = classFileName.substring(0, classFileName.indexOf(36));
            }
            classFileName = classFileName.replaceAll("\\.", "/") + ".java";
            String localFileName = "./" + this.rootDir + "/" + classFileName;
            classFileName = new File(localFileName).exists() ? "../" + this.rootDir + "/" + classFileName : "../../SDMLib/src/" + classFileName;
            nodeLine = nodeLine.replaceAll("<classRef>", Matcher.quoteReplacement(classFileName));
            className = GraphViz.lastPart(className);
            nodeLine = nodeLine.replaceAll("<classname>", Matcher.quoteReplacement(className));
            jsonObject = jsonObject.has("prop") ? jsonObject.getJsonObject("prop") : new JsonObject();
            String attrText = "<tr><td><table border='0' cellborder='0' cellspacing='0'></table></td></tr>";
            boolean addAttrText = false;
            Iterator iter = jsonObject.keyIterator();
            while (iter.hasNext()) {
                String attrLine;
                String key = (String)iter.next();
                if ("id".equals(key) || "class".equals(key)) continue;
                Object value = jsonObject.get((Object)key);
                if (value instanceof Number || value instanceof Enum) {
                    addAttrText = true;
                    attrLine = "<tr><td align='left'><key> = <value></td></tr>";
                    attrLine = attrLine.replaceFirst("<key>", Matcher.quoteReplacement(key));
                    attrLine = attrLine.replaceFirst("<value>", Matcher.quoteReplacement(value.toString()));
                    attrText = attrText.replaceFirst("</table>", Matcher.quoteReplacement(attrLine + "</table>"));
                    continue;
                }
                if (value instanceof JsonObject) {
                    JsonObject tgtJsonObject = (JsonObject)value;
                    String tgtId = tgtJsonObject.getString((Object)"id");
                    if (tgtJsonObject.get((Object)"hyperref") != null) {
                        addAttrText = true;
                        String attrLine2 = "<tr><td align='left' href=\"<key>\">\"<value>\"</td></tr>";
                        attrLine2 = attrLine2.replaceFirst("<key>", Matcher.quoteReplacement(imgName + "/" + tgtId + ".svg"));
                        attrLine2 = attrLine2.replaceFirst("<value>", Matcher.quoteReplacement(imgName + "/" + tgtId + ".svg"));
                        attrText = attrText.replaceFirst("</table>", Matcher.quoteReplacement(attrLine2 + "</table>"));
                        continue;
                    }
                    if (omittedId.equals(tgtId)) continue;
                    tgtId = GraphViz.lastPartStartLow(tgtId);
                    GraphViz.addToEdges(edgeMap, jsonId, tgtId, key);
                    continue;
                }
                if (value instanceof JsonArray) {
                    JsonArray jsonArray = (JsonArray)value;
                    for (int j = 0; j < jsonArray.size(); ++j) {
                        JsonObject tgtJsonObject = jsonArray.getJSONObject(j);
                        String tgtId = tgtJsonObject.getString((Object)"id");
                        if (omittedId.equals(tgtId)) continue;
                        tgtId = GraphViz.lastPartStartLow(tgtId);
                        GraphViz.addToEdges(edgeMap, jsonId, tgtId, key);
                    }
                    continue;
                }
                addAttrText = true;
                attrLine = "<tr><td align='left'><key> = \"<value>\"</td></tr>";
                attrLine = attrLine.replaceFirst("<key>", Matcher.quoteReplacement(key));
                String encode = new HTMLEntities().encode(value.toString());
                int pos = attrLine.indexOf("<value>");
                attrLine = attrLine.substring(0, pos) + encode + attrLine.substring(pos + "<value>".length());
                attrText = attrText.replaceFirst("</table>", Matcher.quoteReplacement(attrLine + "</table>"));
            }
            if (addAttrText) {
                nodeLine = nodeLine.replaceFirst("</table>", Matcher.quoteReplacement(attrText + "</table>"));
            }
            nodeBuilder.append(nodeLine);
            if (!isCluster) continue;
            this.listOfNodes(nodeBuilder, omittedId, edgeMap, (Set<String>)aggregationMap.get(topId), aggregationMap, jsonObjectMap, imgName);
            nodeBuilder.append("}\n");
        }
    }

    private static void addToEdges(LinkedHashMap<String, EdgeLabels> edgeMap, String srcId, String tgtId, String label) {
        EdgeLabels fwdEdgeLabels = edgeMap.get(srcId + ":" + tgtId);
        if (fwdEdgeLabels != null) {
            fwdEdgeLabels.headlabel = fwdEdgeLabels.headlabel + "_" + label;
        } else {
            EdgeLabels bwdEdgeLabels = edgeMap.get(tgtId + ":" + srcId);
            if (bwdEdgeLabels != null) {
                bwdEdgeLabels.taillabel = bwdEdgeLabels.taillabel + "_" + label;
            } else {
                fwdEdgeLabels = new EdgeLabels();
                fwdEdgeLabels.headlabel = label;
                edgeMap.put(srcId + ":" + tgtId, fwdEdgeLabels);
            }
        }
    }

    private static String lastPartStartLow(String dottedName) {
        return StrUtil.downFirstChar(GraphViz.lastPart(dottedName));
    }

    private static String lastPart(String dottedName) {
        int dotPos = dottedName.lastIndexOf(46);
        dottedName = dottedName.substring(dotPos + 1);
        return dottedName;
    }

    @Override
    public GraphViz withIconMap(LinkedHashMap<String, String> iconMap) {
        GraphViz.iconMap = iconMap;
        return this;
    }

    public LinkedHashMap<String, String> getIconMap() {
        return iconMap;
    }

    @Override
    public String addGenericObjectDiag(String diagramName, GenericGraph graph, GenericObjectSet hiddenObjects) {
        this.objNo = 0;
        LinkedHashMap<GenericObject, String> allObjects = new LinkedHashMap<GenericObject, String>();
        String link = "<embed type=\"image/svg+xml\" src='<imagename>'>\n";
        link = link.replaceFirst("<imagename>", diagramName + ".svg");
        String fileText = "graph ObjectDiagram {\n   node [shape = none, fontsize = 10];\n   edge [fontsize = 10];\n\n<nodes>\n<edges>}\n";
        StringBuilder nodeBuilder = new StringBuilder();
        Iterator iterator = graph.getObjects().iterator();
        while (iterator.hasNext()) {
            GenericObject currentObject = (GenericObject)iterator.next();
            if (hiddenObjects.contains(currentObject)) continue;
            StringBuilder nodeLine = new StringBuilder("<id> [label=<<table border='0' cellborder='borderSize' cellspacing='0'> iconrow<tr> <td> <u><id> :<classname></u></td></tr>attrText</table>>];\n");
            String borderSize = "1";
            allObjects.put(currentObject, this.findNameFor(currentObject));
            String iconRow = "";
            if (currentObject.getIcon() != null) {
                iconRow = "<tr><td border='0'><img src=\"" + currentObject.getIcon() + "\"/></td></tr>";
                borderSize = "0";
            }
            String type = "_";
            if (currentObject.getType() != null) {
                type = currentObject.getType();
            }
            String attrText = "<tr><td border='borderSize'><table border='0' cellborder='0' cellspacing='0'></table></td></tr>";
            attrText = attrText.replaceFirst("borderSize", borderSize);
            Iterator iterator2 = currentObject.getAttrs().iterator();
            while (iterator2.hasNext()) {
                GenericAttribute attr = (GenericAttribute)iterator2.next();
                String attrLine = "<tr><td><key> = \"<value>\"</td></tr>";
                attrLine = attrLine.replaceFirst("<key>", attr.getName());
                attrLine = attrLine.replaceFirst("<value>", attr.getValue());
                attrLine = attrLine.replaceFirst("borderSize", borderSize);
                attrText = attrText.replaceFirst("</table>", attrLine + "</table>");
            }
            if (currentObject.getAttrs().isEmpty()) {
                attrText = "";
            }
            CGUtil.replaceAll(nodeLine, "iconrow", iconRow, "<id>", allObjects.get(currentObject), "<classname>", type, "attrText", attrText, "borderSize", borderSize);
            nodeBuilder.append(nodeLine.toString());
        }
        fileText = fileText.replaceFirst("<nodes>", nodeBuilder.toString());
        StringBuilder edgeBuilder = new StringBuilder();
        Iterator iterator3 = graph.getLinks().iterator();
        while (iterator3.hasNext()) {
            GenericLink currentLink = (GenericLink)iterator3.next();
            if (hiddenObjects.contains(currentLink.getSrc()) || hiddenObjects.contains(currentLink.getTgt())) continue;
            String edgeLine = "<srcId> -- <tgtId> [headlabel = \"<headlabel>\" taillabel = \"<taillabel>\"];\n";
            edgeLine = edgeLine.replaceFirst("<srcId>", (String)allObjects.get(currentLink.getSrc()));
            edgeLine = edgeLine.replaceFirst("<tgtId>", (String)allObjects.get(currentLink.getTgt()));
            String headLabel = currentLink.getTgtLabel();
            if (headLabel == null) {
                headLabel = " ";
            }
            edgeLine = edgeLine.replaceFirst("<headlabel>", currentLink.getTgtLabel());
            String taillabel = currentLink.getSrcLabel();
            if (taillabel == null) {
                taillabel = " ";
            }
            edgeLine = edgeLine.replaceFirst("<taillabel>", taillabel);
            edgeBuilder.append(edgeLine);
        }
        fileText = fileText.replaceFirst("<edges>", edgeBuilder.toString());
        this.draw(diagramName, fileText);
        return link;
    }

    private String findNameFor(GenericObject currentObject) {
        if (currentObject.getName() != null) {
            return currentObject.getName();
        }
        ++this.objNo;
        return "_" + this.objNo;
    }

    @Override
    public String dumpSwimlanes(String name, LogEntrySet entries) {
        StringBuilder text = new StringBuilder(" digraph TaskFlowDiagram {\n    \nswimlanes\n    \nlinks\n}");
        StringBuilder swimlanesText = this.dumpSwimlanes(entries);
        StringBuilder linksText = this.dumpLinks(entries);
        CGUtil.replaceAll(text, "swimlanes", swimlanesText.toString(), "links", linksText.toString());
        this.draw(name, text.toString());
        return name;
    }

    private StringBuilder dumpSwimlanes(LogEntrySet entries) {
        StringBuilder swimlanesText = new StringBuilder();
        StringList nodeNames = entries.getNodeName();
        for (String nodeName : nodeNames) {
            StringBuilder laneText = new StringBuilder("    subgraph clusterLaneName {\n    \trankdir=\"LR\";\n    \tstyle=filled;\n\t\tcolor=lightgrey;\ninnerTasks\n    \tlabel = \"LaneName\";\n    }\n    \n");
            StringBuilder innerTasksText = this.dumpInnerTasks(nodeName, entries);
            CGUtil.replaceAll(laneText, "LaneName", nodeName, "innerTasks", innerTasksText.toString());
            swimlanesText.append(laneText.toString());
        }
        return swimlanesText;
    }

    private StringBuilder dumpInnerTasks(String nodeName, LogEntrySet entries) {
        StringBuilder innerTasksText = new StringBuilder();
        LinkedHashSet<String> taskNames = new LinkedHashSet<String>();
        Iterator<Object> iterator = entries.iterator();
        while (iterator.hasNext()) {
            LogEntry entry = (LogEntry)iterator.next();
            if (!nodeName.equals(entry.getNodeName())) continue;
            taskNames.add(entry.getTaskName());
        }
        for (String taskName : taskNames) {
            innerTasksText.append("        " + nodeName + "_" + taskName + "[label=\"" + taskName + "\"];\n");
        }
        return innerTasksText;
    }

    private StringBuilder dumpLinks(LogEntrySet entries) {
        StringBuilder linksText = new StringBuilder();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            LogEntry entry = (LogEntry)iterator.next();
            LogEntry previousEntry = entry.getParent();
            if (previousEntry == null) continue;
            linksText.append("    " + previousEntry.getNodeName() + "_" + previousEntry.getTaskName() + " -> " + entry.getNodeName() + "_" + entry.getTaskName() + "; \n");
        }
        return linksText;
    }

    @Override
    public String dumpClassDiagram(String diagName, ClassModel model) {
        StringBuilder dotFileText = new ClassModelTemplate().dump(this.rootDir, diagName, model);
        this.draw(diagName, dotFileText.toString());
        String text = "<embed type=\"image/svg+xml\" src='" + diagName + ".svg'>";
        return text;
    }

    @Override
    public String dumpDiagram(String diagramName, String fileText) {
        this.draw(diagramName, fileText);
        return diagramName;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private boolean draw(String name, String text) {
        if (this.drawer == null) {
            System.err.println("No GraphViz-Drawer");
            return false;
        }
        return this.drawer.drawImg(name, text);
    }

    @Override
    public GraphViz withDrawer(GuiFileDrawer drawer) {
        this.drawer = drawer;
        return this;
    }

    static class EdgeLabels {
        String headlabel = "";
        String taillabel = "";

        EdgeLabels() {
        }
    }
}

