/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.doc.GraphVizAdapter;

import java.util.Iterator;
import org.sdmlib.CGUtil;
import org.sdmlib.models.classes.Association;
import org.sdmlib.models.classes.Attribute;
import org.sdmlib.models.classes.ClassModel;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.Method;

public class ClassModelTemplate {
    public StringBuilder dump(String rootdir, String diagName, ClassModel model) {
        Object oneSuperClassText;
        Clazz clazz;
        StringBuilder dotFileText = new StringBuilder("\n digraph ClassDiagram {\n    node [shape = none, fontsize = 10]; \n    edge [fontsize = 10];\n    \n    modelClasses\n    \n    \n    modelAssocs\n}\n");
        StringBuilder modelClassesText = new StringBuilder();
        model.getGenerator().addHelperClassesForUnknownAttributeTypes();
        Iterator iterator = model.getClasses().iterator();
        while (iterator.hasNext()) {
            Clazz clazz2 = (Clazz)iterator.next();
            StringBuilder modelClassText = new StringBuilder("\n    _className [label=<<table border='0' cellborder='1' cellspacing='0'> <tr> <td HREF=\"classfilename\">className</td> </tr> attrCompartment methodCompartment </table>>];");
            if (clazz2.isInterface()) {
                CGUtil.replaceAll(modelClassText, "table border", "table color='lightgrey' border");
            }
            CGUtil.replaceAll(modelClassText, "className", CGUtil.shortClassNameHTMLEncoded(clazz2.getName()), "classfilename", "../" + rootdir + "/" + clazz2.getName().replaceAll("\\.", "/") + ".java", "attrCompartment", this.dumpAttributes(clazz2), "methodCompartment", this.dumpMethods(clazz2));
            modelClassesText.append(modelClassText.toString());
        }
        StringBuilder allAssocsText = new StringBuilder();
        Iterator iterator2 = model.getClasses().iterator();
        while (iterator2.hasNext()) {
            clazz = (Clazz)iterator2.next();
            if (clazz.getSuperClass() == null) continue;
            oneSuperClassText = new StringBuilder("\n    _superClass ->  _mClass [dir = \"back\" arrowtail = \"empty\"];");
            CGUtil.replaceAll((StringBuilder)oneSuperClassText, "superClass", CGUtil.shortClassName(clazz.getSuperClass().getName()), "mClass", CGUtil.shortClassName(clazz.getName()));
            allAssocsText.append(((StringBuilder)oneSuperClassText).toString());
        }
        iterator2 = model.getClasses().iterator();
        while (iterator2.hasNext()) {
            clazz = (Clazz)iterator2.next();
            oneSuperClassText = clazz.getInterfaces().iterator();
            while (oneSuperClassText.hasNext()) {
                Clazz interfaceClass = (Clazz)oneSuperClassText.next();
                if (!interfaceClass.isInterface()) continue;
                StringBuilder oneSuperClassText2 = new StringBuilder("\n    _interfaceClass ->  _mClass [dir = \"back\" arrowtail = \"empty\"];");
                CGUtil.replaceAll(oneSuperClassText2, "interfaceClass", CGUtil.shortClassName(interfaceClass.getName()), "mClass", CGUtil.shortClassName(clazz.getName()));
                allAssocsText.append(oneSuperClassText2.toString());
            }
        }
        iterator2 = model.getGenerator().getAssociations().iterator();
        while (iterator2.hasNext()) {
            Association assoc = (Association)iterator2.next();
            StringBuilder oneAssocText = new StringBuilder("\n    _sourceClass -> _targetClass [headlabel = \"targetRole\" taillabel = \"sourceRole\" arrowhead = \"none\" ];");
            CGUtil.replaceAll(oneAssocText, "sourceClass", CGUtil.shortClassName(assoc.getSource().getClazz().getName()), "targetClass", CGUtil.shortClassName(assoc.getTarget().getClazz().getName()), "sourceRole", assoc.getSource().labelForRole(), "targetRole", assoc.getTarget().labelForRole());
            allAssocsText.append(oneAssocText.toString());
        }
        iterator2 = model.getClasses().getAttributes().iterator();
        while (iterator2.hasNext()) {
            Attribute attr = (Attribute)iterator2.next();
            if (CGUtil.isPrimitiveType(attr.getType().getValue())) continue;
            String tgtClassName = model.getGenerator().findPartnerClassName(attr.getType().getValue());
            tgtClassName = CGUtil.shortClassName(tgtClassName);
            StringBuilder oneAssocText = new StringBuilder("\n    _sourceClass -> _targetClass [headlabel = \"targetRole\" taillabel = \"sourceRole\" arrowhead = \"vee\" ];");
            CGUtil.replaceAll(oneAssocText, "sourceClass", CGUtil.shortClassName(attr.getClazz().getName()), "targetClass", tgtClassName, "sourceRole", "", "targetRole", attr.getName());
            allAssocsText.append(oneAssocText.toString());
        }
        CGUtil.replaceAll(dotFileText, "modelClasses", modelClassesText.toString(), "modelAssocs", allAssocsText.toString());
        return dotFileText;
    }

    public String dumpAttributes(Clazz clazz) {
        StringBuilder allAttrsText = new StringBuilder("<tr><td><table border='0' cellborder='0' cellspacing='0'> attrRow </table></td></tr>");
        if (clazz.getAttributes().size() > 0) {
            Iterator iterator = clazz.getAttributes().iterator();
            while (iterator.hasNext()) {
                Attribute attr = (Attribute)iterator.next();
                StringBuilder oneAttrText = new StringBuilder("<tr><td align='left'>attrDecl</td></tr>");
                CGUtil.replaceAll(oneAttrText, "attrDecl", attr.getName() + " :" + CGUtil.shortClassNameHTMLEncoded(attr.getType().getValue()));
                CGUtil.replaceAll(allAttrsText, "attrRow", oneAttrText.append(" attrRow").toString());
            }
            CGUtil.replaceAll(allAttrsText, "attrRow", "");
        } else {
            CGUtil.replaceAll(allAttrsText, "attrRow", "<tr><td> </td></tr>");
        }
        return allAttrsText.toString();
    }

    public String dumpMethods(Clazz clazz) {
        StringBuilder allMethodsText = new StringBuilder("<tr><td><table border='0' cellborder='0' cellspacing='0'> methodRow </table></td></tr>");
        if (clazz.getMethods().size() > 0) {
            Iterator iterator = clazz.getMethods().iterator();
            while (iterator.hasNext()) {
                Method method = (Method)iterator.next();
                StringBuilder oneMethodText = new StringBuilder("<tr><td align='left'>methodDecl</td></tr>");
                CGUtil.replaceAll(oneMethodText, "methodDecl", CGUtil.shortClassNameHTMLEncoded(method.getSignature(true)));
                CGUtil.replaceAll(allMethodsText, "methodRow", oneMethodText.append(" methodRow").toString());
            }
            CGUtil.replaceAll(allMethodsText, "methodRow", "");
        } else {
            CGUtil.replaceAll(allMethodsText, "methodRow", "<tr><td> </td></tr>");
        }
        return allMethodsText.toString();
    }
}

