/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.codegen;

import de.uniks.networkparser.list.SimpleKeyValueList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import org.sdmlib.StrUtil;
import org.sdmlib.codegen.LocalVarTableEntry;
import org.sdmlib.codegen.StatementEntry;
import org.sdmlib.codegen.SymTabEntry;
import org.sdmlib.codegen.Token;

public class Parser {
    public static final char EOF = '\u0000';
    public static final String VOID = "void";
    public static final String CLASS = "class";
    public static final String INTERFACE = "interface";
    public static final String ENUM = "enum";
    public static final char COMMENT_START = 'c';
    public static final String PACKAGE = "package";
    public static final char LONG_COMMENT_END = 'd';
    public static final String CONSTRUCTOR = "constructor";
    public static final String ATTRIBUTE = "attribute";
    public static final String ENUMVALUE = "enumvalue";
    public static final String METHOD = "method";
    public static final String IMPORT = "import";
    public static final String CLASS_BODY = "classBody";
    public static final String CLASS_END = "classEnd";
    public static final String NAME_TOKEN = "nameToken";
    public static final String METHOD_END = "methodEnd";
    public static final String LAST_RETURN_POS = "lastReturnPos";
    public static final String IMPLEMENTS = "implements";
    public static final String QUALIFIED_NAME = "qualifiedName";
    public static final String EXTENDS = "extends";
    public static char NEW_LINE = (char)10;
    private StringBuilder fileBody = null;
    private boolean fileBodyHasChanged = false;
    private Token lookAheadToken = null;
    private Token currentToken;
    private char currentChar;
    private int index;
    private SimpleKeyValueList<String, SymTabEntry> symTab;
    private LinkedHashMap<String, LocalVarTableEntry> localVarTable;
    private StatementEntry currentParentStatement;
    private StatementEntry currentStatement = null;
    private boolean verbose = false;
    private int endPos;
    private char lookAheadChar;
    private int lookAheadIndex;
    private String searchString;
    private int methodBodyStartPos;
    private int endOfAttributeInitialization;
    private int endOfImplementsClause;
    private int endOfClassName;
    private int endOfExtendsClause;
    private int endOfImports;
    public Token currentRealToken;
    public Token lookAheadRealToken;
    public Token previousRealToken;
    public int indexOfResult;
    private Token previousToken;
    private String className;
    private String classType;
    public int lastIfStart;
    public int lastIfEnd;
    private int lastReturnStart;
    private LinkedHashMap<String, Integer> methodBodyQualifiedNames = new LinkedHashMap();
    private HashMap<StatementEntry, Integer> returnStatements = new HashMap();
    private String fileName;

    public boolean isFileBodyChanged() {
        return this.fileBodyHasChanged;
    }

    public SimpleKeyValueList<String, SymTabEntry> getSymTab() {
        return this.symTab;
    }

    public StatementEntry getCurrentStatement() {
        return this.currentStatement;
    }

    public StatementEntry getStatementList() {
        return this.currentParentStatement;
    }

    public LinkedHashMap<String, LocalVarTableEntry> getLocalVarTable() {
        return this.localVarTable;
    }

    public HashMap<StatementEntry, Integer> getReturnStatements() {
        return this.returnStatements;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public int getEndOfImports() {
        return this.endOfImports;
    }

    public int getEndOfExtendsClause() {
        return this.endOfExtendsClause;
    }

    public int getEndOfClassName() {
        return this.endOfClassName;
    }

    public int getEndOfImplementsClause() {
        return this.endOfImplementsClause;
    }

    public int getEndOfAttributeInitialization() {
        return this.endOfAttributeInitialization;
    }

    public int getMethodBodyStartPos() {
        return this.methodBodyStartPos;
    }

    public int insert(int offset, String text) {
        this.fileBody.insert(offset, text);
        this.fileBodyHasChanged = true;
        return offset + text.length();
    }

    public int search(String searchText, int pos) {
        return this.fileBody.indexOf(searchText, pos);
    }

    public int search(String searchText) {
        return this.fileBody.indexOf(searchText);
    }

    public String getClassName() {
        return this.className;
    }

    public Parser withFileBody(StringBuilder fileBody) {
        this.fileBody = fileBody;
        return this;
    }

    private Parser withInit(int startPos, int endPos) {
        if (this.symTab == null) {
            this.symTab = new SimpleKeyValueList();
        } else {
            this.symTab.clear();
        }
        if (this.localVarTable == null) {
            this.localVarTable = new LinkedHashMap();
        } else {
            this.localVarTable.clear();
        }
        if (this.returnStatements == null) {
            this.returnStatements = new HashMap();
        } else {
            this.returnStatements.clear();
        }
        this.currentParentStatement = new StatementEntry();
        this.methodBodyQualifiedNames.clear();
        this.currentChar = '\u0000';
        this.index = startPos - 1;
        this.lookAheadIndex = startPos - 1;
        this.endPos = endPos;
        this.nextChar();
        this.nextChar();
        this.currentToken = new Token();
        this.lookAheadToken = new Token();
        this.previousToken = new Token();
        this.nextToken();
        this.nextToken();
        this.currentRealToken = new Token();
        this.lookAheadRealToken = new Token();
        this.previousRealToken = new Token();
        this.nextRealToken();
        this.nextRealToken();
        return this;
    }

    public int indexOf(String searchString) {
        this.indexOfResult = -1;
        this.withInit(0, this.fileBody.length());
        this.searchString = searchString;
        try {
            this.parseFile();
        }
        catch (SearchStringFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.indexOfResult;
    }

    public Parser parse() {
        this.indexOf(CLASS_END);
        return this;
    }

    private void parseFile() {
        if (this.currentRealTokenEquals(PACKAGE)) {
            this.parsePackageDecl();
        }
        int startPos = this.currentRealToken.startPos;
        while (this.currentRealTokenEquals(IMPORT)) {
            this.parseImport();
        }
        this.endOfImports = this.previousRealToken.endPos;
        this.checkSearchStringFound(IMPORT, startPos);
        this.parseClassDecl();
    }

    private void parseClassDecl() {
        int startPos;
        this.parseModifiers();
        this.parseClassType();
        this.className = this.currentRealWord();
        this.endOfClassName = this.currentRealToken.endPos;
        this.nextRealToken();
        this.parseGenericTypeSpec();
        if (EXTENDS.equals(this.currentRealWord())) {
            startPos = this.currentRealToken.startPos;
            this.skip(EXTENDS);
            this.symTab.put((Object)("extends:" + this.currentRealWord()), (Object)new SymTabEntry().withBodyStartPos(this.currentRealToken.startPos).withKind(EXTENDS).withMemberName(this.currentRealWord()).withEndPos(this.currentRealToken.endPos));
            this.parseTypeRef();
            this.endOfExtendsClause = this.previousRealToken.endPos;
            this.checkSearchStringFound(EXTENDS, startPos);
        }
        if (IMPLEMENTS.equals(this.currentRealWord())) {
            startPos = this.currentRealToken.startPos;
            this.skip(IMPLEMENTS);
            while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals('{')) {
                this.symTab.put((Object)("implements:" + this.currentRealWord()), (Object)new SymTabEntry().withBodyStartPos(this.currentRealToken.startPos).withKind(IMPLEMENTS).withMemberName(this.currentRealWord()).withEndPos(this.currentRealToken.endPos));
                this.nextRealToken();
                if (!this.currentRealKindEquals(',')) continue;
                this.nextRealToken();
            }
            this.endOfImplementsClause = this.previousRealToken.endPos;
            this.checkSearchStringFound(IMPLEMENTS, startPos);
        }
        this.parseClassBody();
    }

    private void parseGenericTypeSpec() {
        if (this.currentRealKindEquals('<')) {
            this.skipTo('>');
            this.nextRealToken();
        }
    }

    private String parseClassType() {
        if (CLASS.equals(this.currentRealWord())) {
            this.skip(CLASS);
            this.classType = CLASS;
        } else if (INTERFACE.equals(this.currentRealWord())) {
            this.skip(INTERFACE);
            this.classType = INTERFACE;
        } else if (ENUM.equals(this.currentRealWord())) {
            this.skip(ENUM);
            this.classType = ENUM;
        }
        return this.classType;
    }

    private void parseClassBody() {
        this.skip("{");
        this.checkSearchStringFound(CLASS_BODY, this.currentRealToken.startPos);
        while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals('}')) {
            this.parseMemberDecl();
        }
        if (this.currentRealKindEquals('}')) {
            this.checkSearchStringFound(CLASS_END, this.currentRealToken.startPos);
        }
        if (!this.currentRealKindEquals('\u0000')) {
            this.skip("}");
        } else {
            this.checkSearchStringFound(CLASS_END, this.currentRealToken.startPos);
        }
    }

    private void parseMemberDecl() {
        String annotations = this.parseAnnotations();
        int startPos = this.currentRealToken.startPos;
        String modifiers = this.parseModifiers();
        if (this.currentRealTokenEquals("<")) {
            this.skip("<");
            while (!this.currentRealTokenEquals(">")) {
                this.nextRealToken();
            }
            this.skip(">");
        }
        if (this.currentRealTokenEquals(CLASS)) {
            while (!this.currentRealTokenEquals("{")) {
                this.nextRealToken();
            }
            this.skipBody();
            if (this.currentRealTokenEquals("}")) {
                return;
            }
            modifiers = this.parseModifiers();
        } else if (this.currentRealTokenEquals(ENUM)) {
            this.skip(ENUM);
            this.nextRealToken();
            this.skipBody();
            if (this.currentRealTokenEquals("}")) {
                return;
            }
            modifiers = this.parseModifiers();
        }
        if (this.currentRealTokenEquals(this.className) && this.lookAheadRealToken.kind == '(') {
            this.skip(this.className);
            String params = this.parseFormalParamList();
            this.parseBlock();
            String constructorSignature = "constructor:" + this.className + params;
            this.symTab.put((Object)constructorSignature, (Object)new SymTabEntry().withMemberName(constructorSignature).withKind(CONSTRUCTOR).withType(constructorSignature + ":" + CONSTRUCTOR).withStartPos(startPos).withEndPos(this.previousRealToken.startPos).withBodyStartPos(this.methodBodyStartPos).withModifiers(modifiers));
            this.checkSearchStringFound(constructorSignature, startPos);
        } else {
            String type = this.parseTypeRef();
            String memberName = this.currentRealWord();
            this.verbose("parsing member: " + memberName);
            this.nextRealToken();
            if (this.currentRealKindEquals('=')) {
                this.skip("=");
                this.parseExpression();
                this.endOfAttributeInitialization = this.previousRealToken.startPos;
                this.skip(";");
                this.symTab.put((Object)("attribute:" + memberName), (Object)new SymTabEntry().withMemberName(memberName).withKind(ATTRIBUTE).withType(type).withStartPos(startPos).withEndPos(this.previousRealToken.startPos).withModifiers(modifiers));
                this.checkSearchStringFound("attribute:" + memberName, startPos);
            } else if (this.currentRealKindEquals(';') && !",".equals(memberName)) {
                this.checkSearchStringFound("nameToken:" + this.searchString, startPos);
                this.skip(";");
                this.symTab.put((Object)("attribute:" + memberName), (Object)new SymTabEntry().withMemberName(memberName).withKind(ATTRIBUTE).withType(type).withStartPos(startPos).withEndPos(this.previousRealToken.startPos).withModifiers(modifiers));
                this.checkSearchStringFound("attribute:" + memberName, startPos);
            } else if (this.currentRealKindEquals('(')) {
                String params = this.parseFormalParamList();
                if (type.startsWith("@")) {
                    return;
                }
                if (this.currentRealTokenEquals("throws")) {
                    this.skipTo('{');
                }
                this.methodBodyStartPos = this.currentRealToken.startPos;
                if (this.currentRealKindEquals('{')) {
                    this.parseBlock();
                } else if (this.currentRealKindEquals(';')) {
                    this.skip(';');
                }
                String methodSignature = "method:" + memberName + params;
                this.symTab.put((Object)methodSignature, (Object)new SymTabEntry().withMemberName(methodSignature).withKind(METHOD).withType(methodSignature + ":" + type).withStartPos(startPos).withEndPos(this.previousRealToken.startPos).withBodyStartPos(this.methodBodyStartPos).withAnnotations(annotations).withModifiers(modifiers));
                this.checkSearchStringFound(methodSignature, startPos);
            } else if (ENUM.equals(this.classType) && (",".equalsIgnoreCase(memberName) || ";".equalsIgnoreCase(memberName) || !";".equals(type) && this.currentRealKindEquals('\u0000'))) {
                String enumSignature = "enumvalue:" + type;
                this.symTab.put((Object)enumSignature, (Object)new SymTabEntry().withMemberName(type).withKind(ENUMVALUE).withType(enumSignature + ":" + this.className).withStartPos(startPos).withEndPos(this.previousRealToken.startPos).withBodyStartPos(this.methodBodyStartPos).withModifiers(modifiers));
            }
        }
    }

    private String parseAnnotations() {
        String result = "";
        while ("@".equals(this.currentRealWord())) {
            result = result + this.currentRealWord();
            this.nextRealToken();
            result = result + this.currentRealWord();
            this.nextRealToken();
            if (!"(".equals(this.currentRealWord())) continue;
            result = result + this.currentRealWord();
            this.nextRealToken();
            while (!")".equals(this.currentRealWord())) {
                result = result + this.currentRealWord();
                this.nextRealToken();
            }
            result = result + this.currentRealWord();
            this.nextRealToken();
        }
        return result;
    }

    private void skipTo(char c) {
        while (!this.currentRealKindEquals(c) && !this.currentRealKindEquals('\u0000')) {
            this.nextRealToken();
        }
    }

    private void skipBody() {
        int index = 1;
        this.nextRealToken();
        while (index > 0 && !this.currentRealKindEquals('\u0000')) {
            this.nextRealToken();
            if (this.currentRealTokenEquals("{")) {
                ++index;
                continue;
            }
            if (!this.currentRealTokenEquals("}")) continue;
            --index;
        }
        this.nextRealToken();
    }

    private void verbose(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }

    private void parseExpression() {
        while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals(';')) {
            if (this.currentRealKindEquals('{')) {
                this.parseBlock();
                continue;
            }
            this.nextRealToken();
        }
    }

    private void parseBlock() {
        this.skip("{");
        while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals('}')) {
            if (this.currentRealKindEquals('{')) {
                this.parseBlock();
                continue;
            }
            this.nextRealToken();
        }
        this.skip("}");
    }

    private String parseTypeRef() {
        StringBuilder typeString = new StringBuilder();
        String typeName = VOID;
        if (this.currentRealTokenEquals(VOID)) {
            this.nextRealToken();
        } else {
            typeName = this.parseQualifiedName();
        }
        typeString.append(typeName);
        if (this.currentRealKindEquals('<')) {
            this.parseGenericTypeDefPart(typeString);
        }
        if (this.currentRealKindEquals('[')) {
            typeString.append("[]");
            this.skip("[");
            while (!"]".equals(this.currentRealWord()) && !this.currentRealKindEquals('\u0000')) {
                this.nextRealToken();
            }
            this.skip("]");
        }
        if (this.currentRealKindEquals('.')) {
            typeString.append("...");
            this.skip(".");
            this.skip(".");
            this.skip(".");
        }
        if (EXTENDS.equals(this.lookAheadRealToken.text.toString())) {
            typeString.append((CharSequence)this.currentRealToken.text);
            this.nextRealToken();
            typeString.append((CharSequence)this.currentRealToken.text);
            this.nextRealToken();
            typeString.append((CharSequence)this.currentRealToken.text);
            this.nextRealToken();
            typeString.append((CharSequence)this.currentRealToken.text);
        }
        if ("@".equals(typeString.toString())) {
            typeString.append((CharSequence)this.currentRealToken.text);
        }
        return typeString.toString();
    }

    private void parseGenericTypeDefPart(StringBuilder typeString) {
        this.skip("<");
        typeString.append('<');
        while (!this.currentRealKindEquals('>') && !this.currentRealKindEquals('\u0000')) {
            if (this.currentRealKindEquals('<')) {
                this.parseGenericTypeDefPart(typeString);
                continue;
            }
            typeString.append(this.currentRealWord());
            this.nextRealToken();
        }
        typeString.append(">");
        this.skip(">");
    }

    private String parseFormalParamList() {
        StringBuilder paramList = new StringBuilder().append('(');
        this.skip("(");
        while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals(')')) {
            int typeStartPos = this.currentRealToken.startPos;
            this.parseTypeRef();
            int typeEndPos = this.currentRealToken.startPos - 1;
            paramList.append(this.fileBody.substring(typeStartPos, typeEndPos));
            if (this.currentRealKindEquals(')')) break;
            this.nextRealToken();
            if (!this.currentRealKindEquals(',')) continue;
            this.skip(",");
            paramList.append(',');
        }
        this.skip(")");
        paramList.append(')');
        return paramList.toString();
    }

    private boolean currentRealKindEquals(char c) {
        return this.currentRealToken.kind == c;
    }

    private String currentRealWord() {
        return this.currentRealToken.text.toString();
    }

    private boolean currentRealTokenEquals(String word) {
        return StrUtil.stringEquals(this.currentRealWord(), word);
    }

    private String parseModifiers() {
        String result = "";
        String modifiers = " public protected private static abstract final native synchronized transient volatile strictfp ";
        while (modifiers.indexOf(" " + this.currentRealWord() + " ") >= 0) {
            result = result + this.currentRealWord() + " ";
            this.nextRealToken();
        }
        return result;
    }

    private void parseImport() {
        int startPos = this.currentRealToken.startPos;
        this.nextRealToken();
        String modifier = this.parseModifiers();
        String importName = this.parseQualifiedName();
        if (this.currentRealToken.kind == '*') {
            this.skip("*");
        }
        this.symTab.put((Object)("import:" + importName), (Object)new SymTabEntry().withMemberName(importName).withModifiers(modifier).withStartPos(startPos).withEndPos(this.previousRealToken.endPos));
        this.skip(";");
    }

    private void parsePackageDecl() {
        int startPos = this.currentRealToken.startPos;
        this.nextRealToken();
        this.parseQualifiedName();
        this.skip(";");
        this.checkSearchStringFound(PACKAGE, startPos);
    }

    private void checkSearchStringFound(String foundElem, int startPos) {
        if (StrUtil.stringEquals(this.searchString, foundElem)) {
            this.indexOfResult = startPos;
            throw new SearchStringFoundException();
        }
    }

    private String parseQualifiedName() {
        int startPos = this.currentRealToken.startPos;
        int endPos = this.currentRealToken.endPos;
        this.checkSearchStringFound("nameToken:" + this.currentRealWord(), this.currentToken.startPos);
        this.nextRealToken();
        while (this.currentRealKindEquals('.') && this.lookAheadRealToken.kind != '.' && !this.currentRealKindEquals('\u0000')) {
            this.skip(".");
            endPos = this.currentRealToken.endPos;
            this.checkSearchStringFound("nameToken:" + this.currentRealWord(), this.currentToken.startPos);
            this.nextRealToken();
        }
        return this.fileBody.substring(startPos, endPos + 1);
    }

    private void skip(char c) {
        if (this.currentRealKindEquals(c)) {
            this.nextRealToken();
        } else {
            System.out.println("Parser Problem: '" + this.currentRealToken.kind + "' :" + " but '" + c + "' expected in " + this.className + ".java  at line " + this.getLineIndexOf(this.currentRealToken.startPos) + "\n" + this.getLineForPos(this.currentRealToken.startPos));
        }
    }

    private void skip(String string) {
        if (!this.currentRealTokenEquals(string)) {
            System.err.println("Parser Error: expected token " + string + " found " + this.currentRealWord() + " at pos " + this.currentRealToken.startPos + " at line " + this.getLineIndexOf(this.currentRealToken.startPos, this.fileBody) + " in file \n" + this.fileName);
            throw new RuntimeException("parse error");
        }
        this.nextRealToken();
    }

    private long getLineIndexOf(int startPos, StringBuilder fileBody) {
        long count = 1L;
        String substring = fileBody.substring(0, startPos);
        for (int index = 0; index < substring.length() - 1; ++index) {
            char firstChar = substring.charAt(index);
            if (firstChar != NEW_LINE) continue;
            ++count;
        }
        return count;
    }

    public long getLineIndexOf(int startPos) {
        if (startPos < 0) {
            return -1L;
        }
        long count = 1L;
        String substring = this.fileBody.substring(0, startPos);
        for (int index = 0; index < substring.length() - 1; ++index) {
            char firstChar = substring.charAt(index);
            if (firstChar != NEW_LINE) continue;
            ++count;
        }
        return count;
    }

    public String getClassType() {
        return this.classType;
    }

    public LinkedHashMap<String, Integer> getMethodBodyQualifiedNamesMap() {
        return this.methodBodyQualifiedNames;
    }

    public Set<String> getMethodBodyQualifiedNames() {
        return this.methodBodyQualifiedNames.keySet();
    }

    public int getLastReturnStart() {
        return this.lastReturnStart;
    }

    private void nextRealToken() {
        Token tmp = this.previousRealToken;
        this.previousRealToken = this.currentRealToken;
        this.currentRealToken = this.lookAheadRealToken;
        this.lookAheadRealToken = tmp;
        this.lookAheadRealToken.kind = '\u0000';
        this.lookAheadRealToken.text.delete(0, this.lookAheadRealToken.text.length());
        while (this.currentToken.kind == 'c' || this.currentToken.kind == NEW_LINE) {
            if (this.currentToken.text.indexOf("/*") == 0) {
                this.parseLongComment();
                continue;
            }
            if (this.currentToken.text.indexOf("//") == 0) {
                this.parseLineComment();
                continue;
            }
            this.nextToken();
        }
        if (this.currentToken.kind == '\"') {
            int constStartPos = this.currentToken.startPos;
            this.parseStringConstant();
            this.lookAheadRealToken.kind = (char)34;
            this.lookAheadRealToken.text.append(this.fileBody.substring(constStartPos, this.previousToken.startPos + 1));
            this.lookAheadRealToken.startPos = constStartPos;
            this.lookAheadRealToken.endPos = this.previousToken.startPos;
        } else if (this.currentToken.kind == '\'') {
            int constStartPos = this.currentToken.startPos;
            this.parseCharConstant();
            this.lookAheadRealToken.kind = (char)39;
            this.lookAheadRealToken.text.append(this.fileBody.substring(constStartPos, this.previousToken.startPos + 1));
            this.lookAheadRealToken.startPos = constStartPos;
            this.lookAheadRealToken.endPos = this.previousToken.startPos;
        } else {
            this.lookAheadRealToken.kind = this.currentToken.kind;
            this.lookAheadRealToken.text.append(this.currentToken.text.toString());
            this.lookAheadRealToken.startPos = this.currentToken.startPos;
            this.lookAheadRealToken.endPos = this.currentToken.endPos;
            this.nextToken();
        }
    }

    private void parseCharConstant() {
        this.skipBasicToken('\'');
        if (this.currentToken.kind == '\\') {
            this.nextToken();
        }
        this.nextToken();
        this.skipBasicToken('\'');
    }

    private void parseLineComment() {
        this.nextToken();
        while (this.currentToken.kind != '\u0000' && this.currentToken.kind != '\n') {
            this.nextToken();
        }
        this.nextToken();
    }

    private void parseStringConstant() {
        this.skipBasicToken('\"');
        while (this.currentToken.kind != '\u0000' && this.currentToken.kind != '\"') {
            if (this.currentToken.kind == '\\') {
                this.nextToken();
            }
            this.nextToken();
        }
        this.skipBasicToken('\"');
    }

    private void skipBasicToken(char s) {
        if (this.currentToken.kind == s) {
            this.nextToken();
        }
    }

    private void parseLongComment() {
        this.nextToken();
        while (this.currentToken.kind != '\u0000' && this.currentToken.kind != 'd') {
            this.nextToken();
        }
        this.nextToken();
    }

    private void nextToken() {
        Token tmp = this.previousToken;
        this.previousToken = this.currentToken;
        this.currentToken = this.lookAheadToken;
        this.lookAheadToken = tmp;
        this.lookAheadToken.kind = '\u0000';
        this.lookAheadToken.text.delete(0, this.lookAheadToken.text.length());
        int state = 105;
        while (true) {
            switch (state) {
                case 105: {
                    if (Character.isLetter(this.currentChar) || this.currentChar == '_') {
                        state = 118;
                        this.lookAheadToken.kind = (char)118;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.startPos = this.index;
                        break;
                    }
                    if (this.currentChar == '\u0000') {
                        this.lookAheadToken.kind = '\u0000';
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.endPos = this.index;
                        return;
                    }
                    if (Character.isDigit(this.currentChar)) {
                        state = 57;
                        this.lookAheadToken.kind = (char)57;
                        this.lookAheadToken.value = this.currentChar - 48;
                        this.lookAheadToken.startPos = this.index;
                        break;
                    }
                    if (this.currentChar == '/' && (this.lookAheadChar == '*' || this.lookAheadChar == '/')) {
                        this.lookAheadToken.kind = (char)99;
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.nextChar();
                        this.lookAheadToken.text.append(this.currentChar);
                        this.nextChar();
                        return;
                    }
                    if (this.currentChar == '*' && this.lookAheadChar == '/') {
                        this.lookAheadToken.kind = (char)100;
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.nextChar();
                        this.lookAheadToken.text.append(this.currentChar);
                        this.nextChar();
                        return;
                    }
                    if ("+-*/\\\"'~=()><{}!.,@[]&|?;:#".indexOf(this.currentChar) >= 0) {
                        this.lookAheadToken.kind = this.currentChar;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.endPos = this.index;
                        this.nextChar();
                        return;
                    }
                    if (this.currentChar == NEW_LINE) {
                        this.lookAheadToken.kind = NEW_LINE;
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.endPos = this.index;
                        this.nextChar();
                        return;
                    }
                    if (!Character.isWhitespace(this.currentChar)) break;
                    break;
                }
                case 57: {
                    if (Character.isDigit(this.currentChar)) {
                        this.lookAheadToken.value = this.lookAheadToken.value * 10.0 + (double)(this.currentChar - 48);
                        break;
                    }
                    if (this.currentChar == '.') {
                        state = 56;
                        break;
                    }
                    this.lookAheadToken.endPos = this.index - 1;
                    return;
                }
                case 56: {
                    if (Character.isDigit(this.currentChar)) break;
                    this.lookAheadToken.endPos = this.index - 1;
                    return;
                }
                case 118: {
                    if (Character.isLetter(this.currentChar) || Character.isDigit(this.currentChar) || this.currentChar == '_') {
                        this.lookAheadToken.text.append(this.currentChar);
                        break;
                    }
                    this.lookAheadToken.endPos = this.index - 1;
                    return;
                }
            }
            this.nextChar();
        }
    }

    private void nextChar() {
        this.currentChar = this.lookAheadChar;
        this.index = this.lookAheadIndex;
        this.lookAheadChar = '\u0000';
        while (this.lookAheadChar == '\u0000' && this.lookAheadIndex < this.endPos - 1) {
            ++this.lookAheadIndex;
            this.lookAheadChar = this.fileBody.charAt(this.lookAheadIndex);
        }
    }

    public int methodBodyIndexOf(String searchString, int searchStartPos) {
        this.indexOfResult = -1;
        this.lastIfStart = -1;
        this.lastIfEnd = -1;
        this.withInit(searchStartPos, this.fileBody.length());
        this.searchString = searchString;
        try {
            this.parseBlockDetails();
            this.checkSearchStringFound(METHOD_END, this.previousRealToken.startPos);
        }
        catch (SearchStringFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.indexOfResult;
    }

    public int methodCallIndexOf(String searchString, int searchStartPos, int searchEndPos) {
        this.indexOfResult = -1;
        this.lastIfStart = -1;
        this.lastIfEnd = -1;
        this.withInit(searchStartPos, searchEndPos);
        this.searchString = searchString;
        try {
            this.parseBlockDetails();
            this.checkSearchStringFound(METHOD_END, this.previousRealToken.startPos);
        }
        catch (SearchStringFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.indexOfResult;
    }

    public int indexOfInMethodBody(String searchString, int searchStartPos, int searchEndPos) {
        this.indexOfResult = -1;
        this.lastIfStart = -1;
        this.lastIfEnd = -1;
        this.withInit(searchStartPos, searchEndPos);
        this.searchString = searchString;
        try {
            this.parseInnerBlockDetails();
            this.checkSearchStringFound(METHOD_END, this.previousRealToken.startPos);
        }
        catch (SearchStringFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.indexOfResult;
    }

    private void parseBlockDetails() {
        this.skip('{');
        this.parseInnerBlockDetails();
        this.skip('}');
    }

    private void parseSimpleStatementDetails() {
        this.currentStatement = new StatementEntry().withKind("simple").withStartPos(this.currentRealToken.startPos).withParent(this.currentParentStatement);
        this.parseExpressionDetails();
        this.skip(';');
    }

    private void parseForLoopDetails() {
        this.readToken("for");
        this.readToken('(');
        String type = this.parseTypeRef();
        String varname = this.currentRealWord();
        this.localVarTable.put(varname, new LocalVarTableEntry().withName(varname).withType(type));
        this.currentStatement.setAssignTargetVarName(varname);
        this.readToken();
        if (this.currentRealKindEquals(':')) {
            this.readToken(':');
            this.parseExpressionDetails();
        } else {
            this.readToken('=');
            this.parseExpressionDetails();
            this.readToken(';');
            this.parseExpressionDetails();
            this.readToken(';');
            this.parseExpressionDetails();
        }
        this.readToken(')');
        this.currentParentStatement = this.currentStatement;
        this.parseBlockDetails();
        this.currentParentStatement = this.currentParentStatement.getParent();
    }

    private void readToken(String string) {
        this.skip(string);
        if (this.currentStatement != null) {
            this.currentStatement.withToken(string, this.currentRealToken.endPos);
        }
    }

    private void parseInnerBlockDetails() {
        while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals('}')) {
            int startPos = this.currentRealToken.startPos;
            if (" if while catch ".indexOf(" " + this.currentRealWord() + " ") >= 0) {
                this.lastIfStart = startPos;
                this.currentStatement = new StatementEntry().withKind(this.currentRealWord()).withParent(this.currentParentStatement).withStartPos(this.currentRealToken.startPos);
                this.readToken();
                this.parseBracketExpressionDetails();
                this.currentParentStatement = this.currentStatement;
                if (this.currentRealKindEquals('{')) {
                    this.parseBlockDetails();
                } else {
                    this.checkSearchStringFound("nameToken:" + this.currentRealWord(), startPos);
                    this.parseSimpleStatementDetails();
                }
                this.currentParentStatement = this.currentParentStatement.getParent();
                this.lastIfEnd = this.previousRealToken.startPos;
                continue;
            }
            if (this.currentRealTokenEquals("for")) {
                this.currentStatement = new StatementEntry().withKind("for").withParent(this.currentParentStatement).withStartPos(this.currentRealToken.startPos);
                this.parseForLoopDetails();
                continue;
            }
            if (this.currentRealTokenEquals("return")) {
                this.currentStatement = new StatementEntry().withKind("return").withParent(this.currentParentStatement).withStartPos(this.currentRealToken.startPos);
                this.lastReturnStart = startPos;
                this.readToken("return");
                this.parseExpressionDetails();
                this.returnStatements.put(this.currentStatement, this.lastReturnStart);
                this.skip(';');
                continue;
            }
            if (this.currentRealTokenEquals("new")) {
                this.parseSimpleStatementDetails();
                continue;
            }
            if (this.currentRealKindEquals('v') && (this.lookAheadRealToken.kind == 'v' || this.lookAheadRealToken.kind == '=' || this.lookAheadRealToken.kind == '<')) {
                this.parseLocalVarDeclDetails();
                continue;
            }
            if (this.currentRealKindEquals('v') && this.lookAheadRealToken.kind == '{') {
                this.readToken();
                this.parseBlockDetails();
                continue;
            }
            if (this.currentRealKindEquals('v') && this.lookAheadRealToken.kind == ':') {
                this.readToken();
                this.readToken();
                continue;
            }
            if (this.currentRealKindEquals('v')) {
                this.checkSearchStringFound("nameToken:" + this.currentRealWord(), startPos);
                this.parseSimpleStatementDetails();
                continue;
            }
            if (this.currentRealKindEquals('{')) {
                this.parseBlockDetails();
                continue;
            }
            if (this.currentRealKindEquals(';')) {
                this.checkSearchStringFound("nameToken:" + this.currentRealWord(), startPos);
                this.skip(';');
                continue;
            }
            if (this.currentRealKindEquals('(')) {
                this.parseBracketExpressionDetails();
                continue;
            }
            this.nextRealToken();
        }
    }

    private void parseLocalVarDeclDetails() {
        while ("static final".indexOf(this.currentRealWord()) >= 0 && !this.currentRealKindEquals('\u0000')) {
            this.nextRealToken();
        }
        String type = null;
        if (this.lookAheadRealToken.kind == 'v' || this.lookAheadRealToken.kind == '<') {
            type = this.parseTypeRef();
        }
        String varName = this.currentRealWord();
        this.checkSearchStringFound("nameToken:" + varName, this.previousRealToken.startPos);
        this.nextRealToken();
        int startPos = this.currentRealToken.startPos;
        if (this.currentRealKindEquals('=')) {
            this.currentStatement = new StatementEntry().withKind("assign").withAssignTargetVarName(varName).withStartPos(this.currentRealToken.startPos).withParent(this.currentParentStatement);
            this.skip('=');
            ArrayList<ArrayList<String>> initCallSequence = new ArrayList<ArrayList<String>>();
            while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals(';')) {
                if (this.currentRealKindEquals('v')) {
                    ArrayList<String> methodClassDetails = this.parseMethodCallDetails();
                    if (methodClassDetails.isEmpty()) continue;
                    initCallSequence.add(methodClassDetails);
                    this.methodBodyQualifiedNames.clear();
                    continue;
                }
                if (this.currentRealKindEquals(';')) continue;
                this.readToken();
            }
            if (!initCallSequence.isEmpty()) {
                LocalVarTableEntry initSequence = new LocalVarTableEntry().withName(varName).withType(type).withInitSequence(initCallSequence).withStartPos(startPos).withEndPos(this.previousRealToken.endPos);
                this.localVarTable.put(varName, initSequence);
            }
            this.checkSearchStringFound("nameToken:;", this.currentRealToken.startPos);
            this.skip(';');
        } else if (this.currentRealKindEquals('(')) {
            ArrayList<ArrayList<String>> initElements = new ArrayList<ArrayList<String>>();
            this.skip('(');
            while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals(')')) {
                int paramStartPos = this.currentRealToken.startPos;
                this.parseExpressionDetails();
                int paramEndPos = this.previousRealToken.endPos;
                String name = this.fileBody.substring(paramStartPos, paramEndPos + 1);
                ArrayList<String> nameList = new ArrayList<String>();
                nameList.add(name);
                initElements.add(nameList);
                if (!this.currentRealKindEquals(',')) continue;
                this.skip(',');
            }
            this.skip(')');
            while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals(';')) {
                ArrayList<String> methodInitDetails;
                if (this.currentRealKindEquals('.')) {
                    this.skip('.');
                }
                if ((methodInitDetails = this.parseInitCallDetails()).isEmpty()) continue;
                initElements.add(methodInitDetails);
            }
            LocalVarTableEntry initSequence = new LocalVarTableEntry().withName((String)((ArrayList)initElements.get(0)).get(0)).withType(varName).withInitSequence(initElements).withStartPos(startPos).withEndPos(this.previousRealToken.endPos);
            String nameString = varName + "_" + initSequence.hashCode();
            this.localVarTable.put(nameString, initSequence);
        }
    }

    private ArrayList<String> parseInitCallDetails() {
        ArrayList<String> methodInitDetails = new ArrayList<String>();
        methodInitDetails.add(".");
        while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals(')')) {
            String text = this.currentRealToken.text.toString();
            methodInitDetails.add(text);
            this.nextRealToken();
        }
        methodInitDetails.add(")");
        this.skip(')');
        return methodInitDetails;
    }

    private ArrayList<String> parseMethodCallDetails() {
        ArrayList<String> methodCallElements = new ArrayList<String>();
        if ("new".equals(this.currentRealWord())) {
            this.readToken("new");
            String type = this.parseTypeRef();
            methodCallElements.add("new " + type);
            this.currentStatement.withToken(type, this.currentRealToken.endPos);
            if (this.currentRealKindEquals('(')) {
                this.readToken('(');
                while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals(')')) {
                    int paramStartPos = this.currentRealToken.startPos;
                    this.parseExpressionDetails();
                    int paramEndPos = this.previousRealToken.endPos;
                    methodCallElements.add(this.fileBody.substring(paramStartPos, paramEndPos + 1));
                    if (!this.currentRealKindEquals(',')) continue;
                    this.readToken(',');
                }
                this.readToken(')');
            }
        } else if (this.currentRealKindEquals('v')) {
            String qualifiedName = this.parseQualifiedName();
            this.currentStatement.withToken(qualifiedName, this.currentRealToken.endPos);
            if (this.currentRealKindEquals('(')) {
                methodCallElements.add(qualifiedName);
                this.readToken('(');
                while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals(')')) {
                    this.methodBodyQualifiedNames.clear();
                    this.parseExpressionDetails();
                    if (!(this.methodBodyQualifiedNames.keySet().isEmpty() || this.methodBodyQualifiedNames.keySet().size() == 1 && this.methodBodyQualifiedNames.keySet().toArray()[0].equals(this.previousRealToken.text.toString()))) {
                        methodCallElements.add("[");
                        methodCallElements.addAll(this.methodBodyQualifiedNames.keySet());
                        methodCallElements.add("]");
                    }
                    methodCallElements.add(this.previousRealToken.text.toString());
                    if (this.currentRealKindEquals(',')) {
                        this.readToken(',');
                        continue;
                    }
                    return methodCallElements;
                }
                this.readToken(')');
            }
        } else {
            this.parseExpressionDetails();
        }
        return methodCallElements;
    }

    private void parseExpressionDetails() {
        while (!(this.currentRealKindEquals('\u0000') || this.currentRealKindEquals(';') || this.currentRealKindEquals(',') || this.currentRealKindEquals(')'))) {
            if (this.currentRealKindEquals('{')) {
                this.parseBlockDetails();
                continue;
            }
            if (this.currentRealKindEquals('(')) {
                this.parseBracketExpressionDetails();
                continue;
            }
            if (this.currentRealKindEquals('v')) {
                this.checkSearchStringFound("nameToken:" + this.currentRealWord(), this.currentRealToken.startPos);
                String qualifiedName = this.parseQualifiedName();
                this.methodBodyQualifiedNames.put(qualifiedName, this.currentRealToken.startPos);
                this.currentStatement.withToken(qualifiedName, this.currentRealToken.endPos);
                continue;
            }
            this.readToken();
        }
    }

    private void parseBracketExpressionDetails() {
        this.readToken('(');
        while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals(')')) {
            String qualifiedName;
            if (this.currentRealKindEquals('(')) {
                this.parseBracketExpressionDetails();
                continue;
            }
            if (this.currentRealKindEquals('v')) {
                this.checkSearchStringFound("nameToken:" + this.currentRealWord(), this.currentRealToken.startPos);
                qualifiedName = this.parseQualifiedName();
                this.methodBodyQualifiedNames.put(qualifiedName, this.currentRealToken.startPos);
                this.currentStatement.withToken(qualifiedName, this.currentRealToken.endPos);
                continue;
            }
            if (this.currentRealKindEquals('\"')) {
                this.checkSearchStringFound("nameToken:" + this.currentRealWord(), this.currentRealToken.startPos);
                qualifiedName = this.parseQualifiedName();
                this.methodBodyQualifiedNames.put(qualifiedName, this.currentRealToken.startPos);
                this.currentStatement.withToken(qualifiedName, this.currentRealToken.endPos);
                continue;
            }
            this.readToken();
        }
        this.readToken(')');
    }

    private void readToken() {
        if (this.currentStatement != null) {
            this.currentStatement.withToken(this.currentRealToken);
        }
        this.nextRealToken();
    }

    private void readToken(char c) {
        this.skip(c);
        if (this.currentStatement != null) {
            this.currentStatement.withToken("" + c, this.currentRealToken.endPos);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Parser withFileName(String fileName) {
        this.setFileName(fileName);
        return this;
    }

    public void parseMethodBody(SymTabEntry symTabEntry) {
        if (symTabEntry.getMemberName().startsWith("method:")) {
            this.indexOfInMethodBody(METHOD_END, symTabEntry.getBodyStartPos() + 1, symTabEntry.getEndPos() - 1);
        }
    }

    public ArrayList<SymTabEntry> getSymTabEntriesFor(String signature) {
        ArrayList<SymTabEntry> entries = new ArrayList<SymTabEntry>();
        Set keySet = this.symTab.keySet();
        for (String key : keySet) {
            if (!key.contains(signature)) continue;
            entries.add((SymTabEntry)this.symTab.get((Object)key));
        }
        return entries;
    }

    public SymTabEntry getSymTabEntry(String signature) {
        return (SymTabEntry)this.symTab.get((Object)signature);
    }

    public SymTabEntry getMethodEntryWithLineNumber(String signature, long callMethodLineNumber) {
        ArrayList<SymTabEntry> symTabEntries = this.getSymTabEntriesFor(signature);
        for (SymTabEntry symTabEntry : symTabEntries) {
            long lineIndexOfStart = this.getLineIndexOf(symTabEntry.getStartPos());
            long lineIndexOfEnd = this.getLineIndexOf(symTabEntry.getEndPos());
            if (lineIndexOfStart > callMethodLineNumber || lineIndexOfEnd < callMethodLineNumber) continue;
            return symTabEntry;
        }
        return null;
    }

    public String getSignatureFor(SymTabEntry symTabEntry) {
        Set keySet = this.symTab.keySet();
        for (String key : keySet) {
            if (this.symTab.get((Object)key) != symTabEntry) continue;
            return key;
        }
        return "";
    }

    public void replace(int start, int end, String text) {
        this.fileBody.replace(start, end, text);
        this.fileBodyHasChanged = true;
    }

    public Parser withFileChanged(boolean value) {
        this.fileBodyHasChanged = value;
        return this;
    }

    public StringBuilder getText() {
        return this.fileBody;
    }

    public StringBuilder replaceAll(String text, Object ... args) {
        return this.replaceAll(-1, text, args);
    }

    public StringBuilder replaceAll(StringBuilder text, Object ... args) {
        return this.replaceAll(-1, text, args);
    }

    public StringBuilder replaceAll(int insertPos, String text, Object ... args) {
        return this.replaceAll(insertPos, new StringBuilder(text), args);
    }

    public StringBuilder replaceAll(int insertPos, StringBuilder text, Object ... args) {
        this.replace(text, args);
        if (this.fileBody == null) {
            this.fileBody = text;
        } else {
            if (insertPos == -1) {
                insertPos = this.indexOf(CLASS_END);
            }
            if (insertPos >= 0) {
                this.fileBody.insert(insertPos, text.toString());
            } else {
                System.out.println("ERROR WHILE PARSING");
            }
        }
        this.fileBodyHasChanged = true;
        return text;
    }

    public StringBuilder replace(String text, Object ... args) {
        return this.replace(new StringBuilder(text), args);
    }

    public StringBuilder replace(StringBuilder text, Object ... args) {
        String placeholder;
        int i;
        if (args == null || args.length < 1) {
            return text;
        }
        int pos = -1 - args[0].toString().length();
        for (i = 0; i < args.length; i += 2) {
            placeholder = args[i].toString();
            pos = -1 - placeholder.length();
            pos = text.indexOf(placeholder, pos + placeholder.length());
            while (pos >= 0) {
                text.replace(pos, pos + placeholder.length(), "<$<" + placeholder + ">$>");
                pos = text.indexOf(placeholder, pos + placeholder.length() + 6);
            }
        }
        for (i = 0; i < args.length; i += 2) {
            placeholder = "<$<" + args[i] + ">$>";
            pos = -1 - placeholder.length();
            pos = text.indexOf(placeholder, pos + placeholder.length());
            while (pos >= 0) {
                text.replace(pos, pos + placeholder.length(), args[i + 1].toString());
                pos = text.indexOf(placeholder, pos + args[i + 1].toString().length());
            }
        }
        return text;
    }

    public LocalVarTableEntry getLocalVarEntriesFor(String name) {
        for (String key : this.localVarTable.keySet()) {
            LocalVarTableEntry tableEntry;
            if (!name.equals(key) || !"Clazz".equals((tableEntry = this.localVarTable.get(key)).getType())) continue;
            return tableEntry;
        }
        return null;
    }

    public StringBuilder getFileBody() {
        return this.fileBody;
    }

    public String getLineForPos(int currentInsertPos) {
        String part1 = this.fileBody.substring(0, currentInsertPos);
        String part2 = this.fileBody.substring(currentInsertPos);
        int startPos = 1 + part1.lastIndexOf("\n");
        int endPos = currentInsertPos + part2.indexOf("\n");
        String lineString = "\"" + this.fileBody.substring(startPos, endPos).toString() + "\"";
        int index = currentInsertPos - startPos;
        char[] chars1 = new char[index];
        Arrays.fill(chars1, ' ');
        String string1 = new String(chars1);
        String posString = "\n" + string1 + "^";
        return lineString + posString;
    }

    class SearchStringFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        SearchStringFoundException() {
        }
    }
}

