/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib;

import de.uniks.networkparser.interfaces.SendableEntityCreator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import org.sdmlib.codegen.Parser;
import org.sdmlib.models.modelsets.ObjectSet;
import org.sdmlib.models.modelsets.StringList;
import org.sdmlib.storyboards.GenericIdMap;

public class CGUtil {
    public static final String SEARCH_POS = "__searchPos__";
    public static final String javaKeyWords = " abstract assert boolean break byte case catch char class const continue default do double else enum extends final finally float for if goto implements import instanceof int interface long native new package private protected public return short static strictfp super switch synchronized this throw throws transient try void volatile while ";
    public static final String emfTypes = " EOBJECT EBIG_DECIMAL EBOOLEAN EBYTE EBYTE_ARRAY ECHAR EDATE EDOUBLE EFLOAT EINT EINTEGER ELONG EMAP ERESOURCE ESHORT ESTRING ";

    public static boolean isPrimitiveType(String type) {
        String primitiveTypes = " String long int char short boolean byte float double Object java.util.Date ";
        if (type == null) {
            return false;
        }
        return primitiveTypes.indexOf(" " + type + " ") >= 0;
    }

    public static void printFile(Parser parser) {
        File file = new File(parser.getFileName());
        if (parser.isFileBodyChanged() || !file.exists()) {
            CGUtil.printFile(file, parser.getText().toString());
        }
    }

    public static void printFile(File file, String text) {
        try {
            File parentFile = file.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            PrintStream out = new PrintStream(file);
            out.print(text);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static StringBuilder readFile(String fileName) {
        File file = new File(fileName);
        StringBuilder stringBuilder = CGUtil.readFile(file);
        return stringBuilder;
    }

    public static StringBuilder readFile(File file) {
        StringBuilder result = new StringBuilder();
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = in.readLine();
            while (line != null) {
                result.append(line).append('\n');
                line = in.readLine();
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void replace(StringBuilder fileBody, String placeholder, String text) {
        int pos = fileBody.indexOf(placeholder);
        if (pos > 0) {
            fileBody.replace(pos, pos + placeholder.length(), text);
        }
    }

    public static String fill(String text, String ... args) {
        StringBuilder builder = new StringBuilder(text);
        Object[] params = Arrays.asList(args).toArray(new Object[args.length]);
        CGUtil.replaceAll(builder, params);
        return builder.toString();
    }

    public static String replaceAll(String text, Object ... args) {
        StringBuilder buf = new StringBuilder(text);
        CGUtil.replaceAll(buf, args);
        return buf.toString();
    }

    public static void replaceAll(StringBuilder text, Object ... args) {
        String placeholder;
        int i;
        int pos = -1 - args[0].toString().length();
        for (i = 0; i < args.length; i += 2) {
            placeholder = args[i].toString();
            pos = -1 - placeholder.length();
            pos = text.indexOf(placeholder, pos + placeholder.length());
            while (pos >= 0) {
                text.replace(pos, pos + placeholder.length(), "<$<" + placeholder + ">$>");
                pos = text.indexOf(placeholder, pos + placeholder.length() + 6);
            }
        }
        for (i = 0; i < args.length; i += 2) {
            placeholder = "<$<" + args[i] + ">$>";
            pos = -1 - placeholder.length();
            pos = text.indexOf(placeholder, pos + placeholder.length());
            while (pos >= 0) {
                String newString = "" + args[i + 1];
                text.replace(pos, pos + placeholder.length(), newString);
                pos = text.indexOf(placeholder, pos + newString.length());
            }
        }
    }

    public static String encodeHTML(String s) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f' || c == '\"' || c == '<' || c == '>') {
                out.append("&#" + c + ";");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String shortClassNameHTMLEncoded(String name) {
        return CGUtil.encodeHTML(CGUtil.shortClassName(name));
    }

    public static String shortClassName(String name) {
        int pos = name.lastIndexOf(46);
        if ((pos = (name = name.substring(pos + 1)).lastIndexOf(36)) >= 0) {
            name = name.substring(pos + 1);
        }
        return name;
    }

    public static String packageName(String name) {
        if (name == null) {
            return "";
        }
        int pos = name.lastIndexOf(46);
        if (pos >= 0) {
            return name.substring(0, pos);
        }
        return "";
    }

    public static String helperClassName(String modelClassName, String suffix) {
        return CGUtil.packageName(modelClassName) + ".util" + "." + CGUtil.shortClassName(modelClassName) + suffix;
    }

    public static String encodeJavaName(String text) {
        StringBuilder result = new StringBuilder();
        if (text.length() == 0 || !Character.isLetter(text.charAt(0))) {
            result.append('_');
        }
        for (int i = 0; i < text.length(); ++i) {
            if (!Character.isLetter(text.charAt(i)) && !Character.isDigit(text.charAt(i))) continue;
            result.append(text.charAt(i));
        }
        return result.toString();
    }

    public static String baseClassName(String typeName, String suffix) {
        if (typeName.endsWith(suffix)) {
            String className = CGUtil.shortClassName(typeName);
            String baseClassName = className.substring(0, className.length() - suffix.length());
            String packageName = CGUtil.packageName(typeName);
            if (packageName.endsWith(".util")) {
                packageName = CGUtil.packageName(packageName);
                return packageName + "." + baseClassName;
            }
        }
        return typeName;
    }

    public static LinkedHashMap<String, String> find(String newText, int searchPos, String pattern, Object ... objects) {
        LinkedHashMap<String, ObjectSet> placeholderTargets = new LinkedHashMap<String, ObjectSet>();
        ObjectSet dummyTarget = new ObjectSet();
        int i = 0;
        while (i < objects.length) {
            if (!(objects[i] instanceof String)) {
                ++i;
                continue;
            }
            String placeholder = (String)objects[i];
            if (++i + 1 < objects.length && !(objects[i] instanceof String)) {
                Object target = objects[i];
                String attrName = (String)objects[i + 1];
                placeholderTargets.put(placeholder, new ObjectSet().with(target, attrName));
                i += 2;
                continue;
            }
            placeholderTargets.put(placeholder, dummyTarget);
        }
        TreeMap<Integer, String> placeholderPositions = new TreeMap<Integer, String>();
        for (String placeholder : placeholderTargets.keySet()) {
            int pos = pattern.indexOf(placeholder);
            if (pos < 0) continue;
            placeholderPositions.put(pos, placeholder);
        }
        StringList fragments = new StringList();
        int fragmentPos = 0;
        for (Integer placeholderPos : placeholderPositions.keySet()) {
            String fragment = pattern.substring(fragmentPos, placeholderPos);
            fragments.add(fragment);
            fragmentPos = placeholderPos + ((String)placeholderPositions.get(placeholderPos)).length();
        }
        fragments.add(pattern.substring(fragmentPos, pattern.length()));
        Iterator fragmentsIterator = fragments.iterator();
        String fragment = (String)fragmentsIterator.next();
        LinkedHashMap<String, String> placeholderValues = new LinkedHashMap<String, String>();
        placeholderValues.put(SEARCH_POS, "" + searchPos);
        if (!newText.startsWith(fragment, searchPos)) {
            return placeholderValues;
        }
        searchPos += fragment.length();
        int previousFragmentPos = 0;
        for (Integer placeholderPos : placeholderPositions.keySet()) {
            String placeholder = (String)placeholderPositions.get(placeholderPos);
            fragment = (String)fragmentsIterator.next();
            fragmentPos = newText.indexOf(fragment, searchPos);
            if (fragmentPos >= searchPos) {
                if (previousFragmentPos >= 0) {
                    String value = newText.substring(searchPos, fragmentPos);
                    placeholderValues.put(placeholder, value);
                }
                searchPos = fragmentPos + fragment.length();
            }
            previousFragmentPos = fragmentPos;
        }
        placeholderValues.put(SEARCH_POS, "" + searchPos);
        GenericIdMap map = new GenericIdMap();
        for (String placeholder : placeholderTargets.keySet()) {
            ObjectSet targetDescription = (ObjectSet)placeholderTargets.get(placeholder);
            if (targetDescription == dummyTarget) continue;
            Iterator targetDescriptionIterator = targetDescription.iterator();
            Object target = targetDescriptionIterator.next();
            String attrName = (String)targetDescriptionIterator.next();
            String value = placeholderValues.get(placeholder);
            SendableEntityCreator creatorClass = map.getCreatorClass(target);
            creatorClass.setValue(target, attrName, (Object)value, null);
        }
        return placeholderValues;
    }

    public static String[] split(String list) {
        return CGUtil.split(list, "[", ", ", "]");
    }

    public static String[] split(String list, String prefix, String separator, String suffix) {
        list = list.substring(prefix.length(), list.length() - suffix.length());
        String[] entries = list.split(separator);
        return entries;
    }

    public static String toValidJavaId(String tag) {
        if (javaKeyWords.indexOf(" " + tag + " ") >= 0) {
            tag = "_" + tag;
        }
        return tag;
    }

    public static boolean isEMFType(String tag) {
        return emfTypes.indexOf(" " + tag.toUpperCase() + " ") >= 0;
    }
}

