/*
   Copyright (c) 2015 christian 
   
   Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
   and associated documentation files (the "Software"), to deal in the Software without restriction, 
   including without limitation the rights to use, copy, modify, merge, publish, distribute, 
   sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
   furnished to do so, subject to the following conditions: 
   
   The above copyright notice and this permission notice shall be included in all copies or 
   substantial portions of the Software. 
   
   The Software shall be used for Good, not Evil. 
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
   BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
   NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
   DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
 */
   
package org.sdmlib.models.classes.util;

import java.util.Set;

import org.sdmlib.models.classes.Annotation;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.Method;
import org.sdmlib.models.classes.SDMLibClass;
import org.sdmlib.serialization.EntityFactory;

import de.uniks.networkparser.json.JsonIdMap;
import org.sdmlib.models.classes.Attribute;

public class AnnotationCreator extends EntityFactory
{
   private final String[] properties = new String[]
   {
      Annotation.PROPERTY_VALUES,
      SDMLibClass.PROPERTY_NAME,
      Annotation.PROPERTY_CLAZZ,
      Annotation.PROPERTY_METHOD,
      Annotation.PROPERTY_VALUES,
      Annotation.PROPERTY_ATTRIBUTE,
   };
   
   @Override
   public String[] getProperties()
   {
      return properties;
   }
   
   @Override
   public Object getSendableInstance(boolean reference)
   {
      return new Annotation();
   }
   
   @Override
   public Object getValue(Object target, String attrName)
   {
      int pos = attrName.indexOf('.');
      String attribute = attrName;
      
      if (pos > 0)
      {
         attribute = attrName.substring(0, pos);
      }

      if (Annotation.PROPERTY_VALUES.equalsIgnoreCase(attribute))
      {
         return ((Annotation) target).getValues();
      }

      if (SDMLibClass.PROPERTY_NAME.equalsIgnoreCase(attribute))
      {
         return ((SDMLibClass) target).getName();
      }

      if (Annotation.PROPERTY_CLAZZ.equalsIgnoreCase(attribute))
      {
         return ((Annotation) target).getClazz();
      }

      if (Annotation.PROPERTY_METHOD.equalsIgnoreCase(attribute))
      {
         return ((Annotation) target).getMethod();
      }

      if (Annotation.PROPERTY_ATTRIBUTE.equalsIgnoreCase(attribute))
      {
         return ((Annotation) target).getAttribute();
      }
      
      return null;
   }
   
   @Override
   public boolean setValue(Object target, String attrName, Object value, String type)
   {
      if (JsonIdMap.REMOVE.equals(type) && value != null)
      {
         attrName = attrName + type;
      }

      if (Annotation.PROPERTY_VALUES.equalsIgnoreCase(attrName))
      {
         ((Annotation) target).setValues((Set<String>) value);
         return true;
      }

      if (SDMLibClass.PROPERTY_NAME.equalsIgnoreCase(attrName))
      {
         ((SDMLibClass) target).withName((String) value);
         return true;
      }

      if (Annotation.PROPERTY_CLAZZ.equalsIgnoreCase(attrName))
      {
         ((Annotation) target).setClazz((Clazz) value);
         return true;
      }

      if (Annotation.PROPERTY_METHOD.equalsIgnoreCase(attrName))
      {
         ((Annotation) target).setMethod((Method) value);
         return true;
      }

      if (Annotation.PROPERTY_ATTRIBUTE.equalsIgnoreCase(attrName))
      {
         ((Annotation) target).setAttribute((Attribute) value);
         return true;
      }
      
      return false;
   }
   public static JsonIdMap createIdMap(String sessionID)
   {
      return org.sdmlib.models.classes.util.CreatorCreator.createIdMap(sessionID);
   }
   
   //==========================================================================
   
   @Override
   public void removeObject(Object entity)
   {
      ((Annotation) entity).removeYou();
   }
}
