package org.sdmlib.models.classes.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.sdmlib.CGUtil;
import org.sdmlib.StrUtil;
import org.sdmlib.codegen.Parser;
import org.sdmlib.codegen.SymTabEntry;
import org.sdmlib.models.classes.Card;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.Feature;
import org.sdmlib.models.classes.Role;
import org.sdmlib.models.classes.util.ClazzSet;
import org.sdmlib.models.modelsets.ObjectSet;

import de.uniks.networkparser.json.JsonIdMap;

public class GenRole extends Generator<Role>
{
   private int elistPos;

   private void insertCaseInGenericGet(Clazz clazz, Parser parser, Role partnerRole, String rootDir)
   {
      if (clazz.isInterface())
      {
         return;
      }
      
      int pos = parser.indexOf(Parser.METHOD + ":getValue(Object,String)");

      if (pos < 0)
      {
         // ups, did not find generic get method. 
         System.err.println("Warning: SDMLib codgen for role" + partnerRole.getName() + " in class " + clazz.getFullName() 
            + ": \nDid not find method get(String). Should have been generated by the clazz. " 
            + "\nCould not add required code fragment there. :( ");

         return;
      }

      // OK, found method, parse its body to find if that handles me. 
      int methodBodyStartPos = parser.getMethodBodyStartPos();
      
      pos = parser.methodBodyIndexOf(Parser.NAME_TOKEN + ":PROPERTY_" + partnerRole.getName().toUpperCase() , methodBodyStartPos);

      if (pos < 0)
      {         
         // need to add if block to generic get method
         parser.methodBodyIndexOf(Parser.METHOD_END, methodBodyStartPos);
         
         int lastIfEndPos = parser.lastIfEnd + 2; // add 1 to be after } and 1 to be after \n
         if (lastIfEndPos - 2  < 0)
         {
            lastIfEndPos = methodBodyStartPos + 1;
         }
         
         StringBuilder text = new StringBuilder
            (  "\n      if (ClassName.PROPERTY_NAME.equalsIgnoreCase(attribute))" +
               "\n      {" +
               "\n         return ((ClassName) target).getPropertyName();" +
               "\n      }" +
               "\n" 
               );

         String partnerRoleNameUpFirst = StrUtil.upFirstChar(partnerRole.getName());
         
         CGUtil.replaceAll(text, 
            "ClassName", CGUtil.shortClassName(clazz.getName()),
            "PropertyName", partnerRoleNameUpFirst,
            "PROPERTY_NAME", "PROPERTY_" + partnerRole.getName().toUpperCase()
            );

         parser.insert(lastIfEndPos, text.toString());
      }
   }

   
   //   private void generateEmptySetInPartnerClass(String rootDir, Role partnerRole)
   //   {
   //      // generate EMPTY_SET in partner class
   //      Clazz partnerClass = partnerRole.getClazz();
   //      
   //      GenClass partnerClazz = getGenerator(partnerClass);
   //      Parser partnerParser = partnerClazz.getOrCreateParser(rootDir);
   //      
   //      int partnerPos = partnerParser.indexOf(Parser.ATTRIBUTE + ":EMPTY_SET");
   //      
   //      if (partnerPos < 0)
   //      {
   //         // add attribute declaration in class file
   //         partnerPos = partnerParser.indexOf(Parser.CLASS_END);
   //
   //         StringBuilder partnerText = new StringBuilder
   //            (  "\n   " +
   //               "\n   public static final type EMPTY_SET = new type()READONLY;" +
   //               "\n"
   //               );
   //
   //         String replaceReadOnly = ".withReadOnly(true)";
   //         if(!(partnerClass.hasFeature(Feature.ALBERTsSets))){
   //        	 replaceReadOnly = "";
   //         }
   //         
   //         CGUtil.replaceAll(partnerText, 
   //            "type", partnerClazz.getModelSetClassNameShort(),
   //            "READONLY", replaceReadOnly
   //            );
   //         
   //         partnerParser.insert(partnerPos, partnerText.toString());
   //         
   //         // insert import 
   ////         String ownerClassName = partnerClass.getFullName();
   ////         String packageName = CGUtil.packageName(ownerClassName);
   ////         String shortClassName = CGUtil.shortClassName(ownerClassName);
   //         getGenerator(partnerClass).insertImport(partnerClazz.getModelSetClassName());
   //         
   //         getGenerator(partnerRole.getClazz()).printFile();
   //
   //      }
   //      if (model.getPartnerRole().getCard().equals(Card.MANY.toString())){
   //         getGenerator(partnerRole.getClazz()).insertImport(getGenerator(partnerRole.getClazz()).getModelSetClassName());
   //      }
   //   }

   private void generateToManyRole(Parser myParser, Clazz clazz, Role partnerRole, StringBuilder text)
   {
      String myClassName = CGUtil.shortClassName(model.getClazz().getFullName());
      
      GenClass partnerClazz = getGenerator(partnerRole.getClazz());
      String partnerClassName = CGUtil.shortClassName(partnerRole.getClazz().getFullName());
      
      
      String partnerRoleName = partnerRole.getName();
      String partnerClassNameSet = partnerClazz.getModelSetClassNameShort();
      
      String partnerRoleUpFirstChar = StrUtil.upFirstChar(partnerRoleName);
      
      int pos = myParser.indexOf(Parser.ATTRIBUTE + ":PROPERTY_" + partnerRole.getName().toUpperCase());

      if (pos < 0)
      {
         text.append
         (  "\n   " +
               "\n   /********************************************************************" +
               "\n    * <pre>" +
               "\n    *              myCard                       partnerCard" +
               "\n    * myClassName ----------------------------------- partnerClassName" +
               "\n    *              myRoleName                   partnerRoleName" +
               "\n    * </pre>" +
               "\n    */" + 
               "\n   " +
               "\n   public static final String PROPERTY_PARTNER_ROLE_NAME = \"partnerRoleName\";" +
               "\n" );
      }
      
      if (! clazz.isInterface())
      {
         pos = myParser.indexOf(Parser.ATTRIBUTE + ":" + partnerRoleName);

         if (pos < 0)
         {
            text.append ("\n   private type partnerRoleName = null;" +
                         "\n   ");
         }
      }
      
      pos = myParser.indexOf(Parser.METHOD + ":get" + partnerRoleUpFirstChar + "()");

      if (pos < 0)
      {
         if (! clazz.isInterface())
         {
            text.append 
            (     "\n   public type getPartnerRoleName()" +
                  "\n   {" +
                  "\n      if (this.partnerRoleName == null)" +
                  "\n      {" +
                  "\n         return partnerClassNameSet.EMPTY_SET;" +
                  "\n      }" +
                  "\n   " +
                  "\n      return this.partnerRoleName;" +
                  "\n   }" +
                  "\n");
            
            if (!clazz.hasFeature(Feature.ALBERTsSets) 
            		&& !clazz.hasFeature(Feature.PatternObject)
            		&& !clazz.hasFeature(Feature.Serialization) ) {
            	CGUtil.replaceAll(text, "partnerClassNameSet.EMPTY_SET", "new type()");
            }
         }
         else
         {
            text.append
            (     "\n   public type getPartnerRoleName();" +
                  "\n");
         }
      }
      
      ArrayList<SymTabEntry> symTabEntries = myParser.getSymTabEntriesFor(Parser.METHOD + ":get" + partnerRoleUpFirstChar + "()");
      
      elistPos = -1;
      
      if (symTabEntries.size() > 0)
      {
         String type = symTabEntries.get(0).getType();
         elistPos = type.indexOf(":EList<");
      }
      
      if (elistPos >= 0)
      {
         pos = myParser.indexOf(Parser.METHOD + ":get" + partnerRoleUpFirstChar + "Set()");

         if (pos < 0)
         {
            if (! clazz.isInterface())
            {
               text.append 
               (     "  public type getPartnerRoleNameSet()\n" + 
                     "  {\n" + 
                     "     return new type().with(getPartnerRoleName());\n" + 
                     "  }\n" + 
                     "\n");
            }
            else
            {
               text.append
               (     "\n   public type getPartnerRoleNameSet();" +
                     "\n");
            }
         }
      }
      
      
      if (model.getClazz() == model.getPartnerRole().getClazz())
      {
         // recursive assoc, add getTransitive methods
         
         pos = myParser.indexOf(Parser.METHOD + ":get" + partnerRoleUpFirstChar + "Transitive()");
         
         if (pos < 0)
         {
            if (! clazz.isInterface())
            {
               text.append(
                  "   public partnerClassNameSet getPartnerRoleNameTransitive()\n" + 
                  "   {\n" + 
                  "      partnerClassNameSet result = new partnerClassNameSet().with(this);\n" + 
                  "      return result.getPartnerRoleNameTransitive();\n" + 
                  "   }\n" + 
                  "\n" 
                  );
            }
            else
            {
               text.append
               (     "\n   public partnerClassNameSet getPartnerRoleNameTransitive();" +
                     "\n");
            }
            getGenerator(clazz).insertImport(partnerClazz.getModelSetClassName());
         }
      }
      
      pos = myParser.indexOf(Parser.METHOD + ":with" + partnerRoleUpFirstChar + "(" + partnerClassName  +  "...)");
      
      if (pos < 0)
      {
         if (! clazz.isInterface())
         {
            String withMeth = 
                  "\n   public myClassName withPartnerRoleName(partnerClassName... value)" +
                  "\n   {" +
                  "\n      if(value==null){" + 
                  "\n         return this;" +
                  "\n      }" +
                  "\n      for (partnerClassName item : value)" +
                  "\n      {" +
                  "\n         if (item != null)" +
                  "\n         {" +
                  "\n            if (this.partnerRoleName == null)" +
                  "\n            {" +
                  "\n               this.partnerRoleName = initRoleVar;" +
                  "\n            }" +
                  "\n            " +
                  "\n            boolean changed = this.partnerRoleName.add (item);" +
                  "\n" +
                  "\n            if (changed)" +
                  "\n            {" +
                  "\n               item.withMyRoleName(this);" +
                  "\n               PROPERTYCHANGEADD" +
                  "\n            }" +
                  "\n         }" +
                  "\n      }" +
                  "\n      return this;" +
                  "\n   } " +
                  "\n";
            
            if (this.model.getName().equals(""))
            {
               // uni directional no reverse call
               withMeth = CGUtil.replaceAll(withMeth, "\n               item.withMyRoleName(this);", "");
            }
            
            text.append(withMeth);
           
         }
         else
         {
            text.append
            (     "\n   public myClassName withPartnerRoleName(partnerClassName... value);" +
                  "\n");
         }
         
         if (elistPos >= 0)
         {
            CGUtil.replaceAll(text, "initRoleVar", "this.getPartnerRoleName()");
         }
      }
      
      
      pos = myParser.indexOf(Parser.METHOD + ":without" + partnerRoleUpFirstChar + "(" + partnerClassName  +  "...)");
      
      if (pos < 0)
      {
         if (! clazz.isInterface())
         {
            String withOutMeth = 
                  "\n   public myClassName withoutPartnerRoleName(partnerClassName... value)" +
                  "\n   {" +
                  "\n      for (partnerClassName item : value)" +
                  "\n      {" +
                  "\n         if ((this.partnerRoleName != null) && (item != null))" +
                  "\n         {" +
                  "\n            if (this.partnerRoleName.remove(item))" +
                  "\n            {" +
                  "\n               item.reverseWithoutCall(this);" +
                  "\n               PROPERTYCHANGEREMOVE" +
                  "\n            }" +
                  "\n         }" +
                  "\n      }" +
                  "\n      return this;" +
                  "\n   }" +
                  "\n";
            
            if (this.model.getName().equals(""))
            {
               // uni directional no reverse call
               withOutMeth = CGUtil.replaceAll(withOutMeth, "\n               item.reverseWithoutCall(this);", "");
            }
            
            text.append (withOutMeth);
         }
         else
         {
            text.append
            (     "\n   public myClassName withoutPartnerRoleName(partnerClassName... value);" +
                  "\n");
         }
      }
      
      pos = myParser.indexOf(Parser.METHOD + ":create" + partnerRoleUpFirstChar + "()");
      
      //TODO UEBERPRUEFEN
      // System.out.println(partnerClassName +" ->" +genClazz.getName());
      String realPartnerClassName = partnerClassName;
      ClazzSet kidClasses = partnerRole.getClazz().getKidClazzes();
      ClazzSet kidClassesInterfaces =new ClazzSet();
      for(Clazz item : kidClasses){
         if(item.isInterface()){
            kidClassesInterfaces.add(item);
         }
      }
      if (partnerRole.getClazz().isInterface() && kidClassesInterfaces.size() == 1)
      {
         realPartnerClassName = CGUtil.shortClassName(kidClassesInterfaces.first().getFullName());
      }
      
      if (pos < 0 && ! partnerRole.getClazz().isInterface() && kidClassesInterfaces.size() != 1)
      {
         if (! clazz.isInterface())
         {
            text.append 
            (     "\n   public partnerClassName createPartnerRoleName()" +
                  "\n   {" +
                  "\n      partnerClassName value = new realPartnerClassName();" +
                  "\n      withPartnerRoleName(value);" +
                  "\n      return value;" +
                  "\n   } " +
                  "\n");
         }
         else
         {
            text.append
            (     "\n   public partnerClassName createPartnerRoleName();" +
                  "\n");
         }
      }
      
      GenClass generator = getGenerator(model.getClazz());
      
      // if my partnerclass has subclasses generate createPartnerRoleNameSubClassName() methods
      kidClasses = partnerRole.getClazz().getKidClazzesTransitive().without(partnerRole.getClazz());
      
      for (Clazz kid : kidClasses)
      {
         String kidClassName = CGUtil.shortClassName(kid.getName());
         pos = myParser.indexOf(Parser.METHOD + ":create" + partnerRoleUpFirstChar + kidClassName + "()");
         
         
         if (pos < 0 && ! kid.isInterface())
         {
            if (! clazz.isInterface())
            {
               text.append 
               (     "\n   public KidClassName createPartnerRoleNameSubClassName()" +
                     "\n   {" +
                     "\n      KidClassName value = new KidClassName();" +
                     "\n      withPartnerRoleName(value);" +
                     "\n      return value;" +
                     "\n   } " +
                     "\n");
            }
            else
            {
               text.append
               (     "\n   public KidClassName createPartnerRoleNameSubClassName();" +
                     "\n");
            }
         }
         
         CGUtil.replaceAll(text, 
            "KidClassName", kidClassName, 
            "PartnerRoleNameSubClassName", partnerRoleUpFirstChar + kidClassName
        	);
         
         if(generator!=null)
         {
            generator.insertImport(myParser, kid.getFullName());
         }
      }
      
      String reverseWithoutCall = "set" + StrUtil.upFirstChar(model.getName()) + "(null)";
      
      if (model.getCard().equals(Card.MANY.toString()))
      {
         reverseWithoutCall = "without" + StrUtil.upFirstChar(model.getName()) + "(this)";
      }
      
      String propertyChangeAdd = "";
      String propertyChangeRemove = "";
      if(model.getClazz().hasFeature(Feature.PropertyChangeSupport)){
     	 propertyChangeAdd = "getPropertyChangeSupport().firePropertyChange(PROPERTY_PARTNER_ROLE_NAME, null, item);";
     	 propertyChangeRemove = "getPropertyChangeSupport().firePropertyChange(PROPERTY_PARTNER_ROLE_NAME, item, null);"; 
      }
      
      CGUtil.replaceAll(text, "PROPERTYCHANGEADD", propertyChangeAdd, "PROPERTYCHANGEREMOVE", propertyChangeRemove);

      CGUtil.replaceAll(text, 
         "myCard", model.getCard(),
         "partnerCard", partnerRole.getCard(),
         "type", partnerClassNameSet, 
         "initRoleVar", "new " + partnerClassNameSet + "()", 
         "myClassName", myClassName,
         "partnerClassName", partnerClassName,
         "realPartnerClassName", realPartnerClassName,
         "myRoleName", model.getName(),
         "MyRoleName", StrUtil.upFirstChar(model.getName()),
         "partnerRoleName", partnerRoleName,
         "PARTNER_ROLE_NAME", partnerRoleName.toUpperCase(),
         "PartnerRoleName", partnerRoleUpFirstChar,
         "reverseWithoutCall(this)", reverseWithoutCall
         );
      if(generator!=null){
         generator.insertImport(myParser, getGenerator(partnerRole.getClazz()).getModelSetClassName());
      }
   } 
   
   private void generateToOneRole(Parser myParser, Clazz clazz, Role partnerRole, StringBuilder text)
   {
      String myClassName = CGUtil.shortClassName(model.getClazz().getFullName());
      
      String partnerClassName = CGUtil.shortClassName(partnerRole.getClazz().getFullName());
      
      String partnerRoleName = partnerRole.getName();
      
      String partnerRoleUpFirstChar = StrUtil.upFirstChar(partnerRoleName);
      
      int pos = myParser.indexOf(Parser.ATTRIBUTE + ":PROPERTY_" + partnerRole.getName().toUpperCase());

      if (pos < 0)
      {
         text.append
         (  "\n   " +
               "\n   /********************************************************************" +
               "\n    * <pre>" +
               "\n    *              myCard                       partnerCard" +
               "\n    * myClassName ----------------------------------- partnerClassName" +
               "\n    *              myRoleName                   partnerRoleName" +
               "\n    * </pre>" +
               "\n    */" + 
               "\n   " +
               "\n   public static final String PROPERTY_PARTNER_ROLE_NAME = \"partnerRoleName\";" +
               "\n" );
      }
      
      if (! clazz.isInterface())
      {
         pos = myParser.indexOf(Parser.ATTRIBUTE + ":" + partnerRoleName);

         if (pos < 0)
         {
            text.append ("\n   private partnerClassName partnerRoleName = null;" +
                         "\n");
         }
      }
      
      pos = myParser.indexOf(Parser.METHOD + ":get" + partnerRoleUpFirstChar + "()");

      if (pos < 0)
      {
         if (! clazz.isInterface())
         {
            text.append 
            (     "\n   public partnerClassName getPartnerRoleName()" +
                  "\n   {" +
                  "\n      return this.partnerRoleName;" +
                  "\n   }" +
                  "\n");
         }
         else
         {
            text.append
            (     "\n   public partnerClassName getPartnerRoleName();" +
                  "\n");
         }
      }
      
      
      if (model.getClazz() == model.getPartnerRole().getClazz())
      {
         // recursive assoc, add getTransitive methods
         
         pos = myParser.indexOf(Parser.METHOD + ":get" + partnerRoleUpFirstChar + "Transitive()");
         
         if (pos < 0)
         {
            if (! clazz.isInterface())
            {
               text.append(
                  "   public partnerClassNameSet getPartnerRoleNameTransitive()\n" + 
                  "   {\n" + 
                  "      partnerClassNameSet result = new partnerClassNameSet().with(this);\n" + 
                  "      return result.getPartnerRoleNameTransitive();\n" + 
                  "   }\n" + 
                  "\n");
            }
            else
            {
               text.append
               (     "\n   public partnerClassName getPartnerRoleNameTransitive();" +
                     "\n");
            }
            getGenerator(clazz).insertImport(CGUtil.helperClassName(partnerRole.getClazz().getFullName(),"Set"));
         
         }
      }
      
      pos = myParser.indexOf(Parser.METHOD + ":set" + partnerRoleUpFirstChar + "(" + partnerClassName  +  ")");
      
      if (pos < 0)
      {
         if (! clazz.isInterface())
         {
            String setMeth = "\n   public boolean setPartnerRoleName(partnerClassName value)" +
                  "\n   {" +
                  "\n      boolean changed = false;" +
                  "\n      " +
                  "\n      if (this.partnerRoleName != value)" +
                  "\n      {" +
                  "\n         partnerClassName oldValue = this.partnerRoleName;" +
                  "\n         " +
                  "\n         if (this.partnerRoleName != null)" +
                  "\n         {" +
                  "\n            this.partnerRoleName = null;" +
                  "\n            oldValue.withoutMethodCall(this);" +
                  "\n         }" +
                  "\n         " +
                  "\n         this.partnerRoleName = value;" +
                  "\n         " +
                  "\n         if (value != null)" +
                  "\n         {" +
                  "\n            value.withMyRoleName(this);" +
                  "\n         }" +
                  "\n         " +
                  "\n         PROPERTYCHANGEADD" +
                  "\n         changed = true;" +
                  "\n      }" +
                  "\n      " +
                  "\n      return changed;" +
                  "\n   }" +
                  "\n";

            if (this.model.getName().equals(""))
            {
               // uni directional assoc, do not call reverse
               setMeth = CGUtil.replaceAll(setMeth, 
                  "\n         if (this.partnerRoleName != null)" +
                        "\n         {" +
                        "\n            this.partnerRoleName = null;" +
                        "\n            oldValue.withoutMethodCall(this);" +
                        "\n         }", "",
                        "\n         if (value != null)" +
                              "\n         {" +
                              "\n            value.withMyRoleName(this);" +
                              "\n         }", ""
                     );
            }
            text.append(setMeth);
         }
         else
         {
            text.append
            (     "\n   public boolean setPartnerRoleName(partnerClassName value);" +
                  "\n");
         }
      }
      
      
      pos = myParser.indexOf(Parser.METHOD + ":with" + partnerRoleUpFirstChar + "(" + partnerClassName  +  ")");
      
      if (pos < 0)
      {
         if (! clazz.isInterface())
         {
            text.append 
            (     "\n   public myClassName withPartnerRoleName(partnerClassName value)" +
                  "\n   {" +
                  "\n      setPartnerRoleName(value);" +
                  "\n      return this;" +
                  "\n   } " +
                  "\n");
         }
         else
         {
            text.append
            (     "\n   public myClassName withPartnerRoleName(partnerClassName value);" +
                  "\n");
         }
      }
      

      pos = myParser.indexOf(Parser.METHOD + ":create" + partnerRoleUpFirstChar + "()");
      
      String realPartnerClassName = partnerClassName;
      
      ClazzSet kidClasses = partnerRole.getClazz().getKidClazzesTransitive().without(partnerRole.getClazz());
      ClazzSet kidClassesInterfaces =new ClazzSet();
      for(Clazz item : kidClasses){
         if(item.isWithNoObjects()){
            kidClassesInterfaces.add(item);
         }
      }
      
      if (partnerRole.getClazz().isWithNoObjects() && kidClassesInterfaces.size() == 1)
      {
         realPartnerClassName = CGUtil.shortClassName(kidClassesInterfaces.first().getFullName());
      }
      
      if (pos < 0 && ! (partnerRole.getClazz().isWithNoObjects() && kidClassesInterfaces.size() != 1))
      {
         if (! clazz.isWithNoObjects())
         {
            text.append 
            (     "\n   public partnerClassName createPartnerRoleName()" +
                  "\n   {" +
                  "\n      partnerClassName value = new realPartnerClassName();" +
                  "\n      withPartnerRoleName(value);" +
                  "\n      return value;" +
                  "\n   } " +
                  "\n");
         }
         else
         {
            text.append
            (     "\n   public partnerClassName createPartnerRoleName();" +
                  "\n");
         }
      }
      
      

      String reverseWithoutCall = "set" + StrUtil.upFirstChar(model.getName()) + "(null)";
      
      if (model.getCard().equals(Card.MANY.toString()))
      {
         reverseWithoutCall = "without" + StrUtil.upFirstChar(model.getName()) + "(this)";
      }
      
      String propertyChangeAdd = "";
      if(model.getClazz().hasFeature(Feature.PropertyChangeSupport)){
     	 propertyChangeAdd = "getPropertyChangeSupport().firePropertyChange(PROPERTY_PARTNER_ROLE_NAME, oldValue, value);";
      }
      CGUtil.replaceAll(text, "PROPERTYCHANGEADD", propertyChangeAdd);
      CGUtil.replaceAll(text, 
         "myCard", model.getCard(),
         "partnerCard", partnerRole.getCard(),
         "myClassName", myClassName,
         "partnerClassName", partnerClassName,
         "realPartnerClassName", realPartnerClassName,
         "myRoleName", model.getName(),
         "MyRoleName", StrUtil.upFirstChar(model.getName()),
         "partnerRoleName", partnerRoleName,
         
         "PARTNER_ROLE_NAME", partnerRoleName.toUpperCase(),
         "PartnerRoleName", partnerRoleUpFirstChar,
         "withoutMethodCall(this)", reverseWithoutCall
         );
      
      GenClass generator = getGenerator(model.getClazz());
      if (model.getPartnerRole().getCard().equals(Card.MANY.toString())){
         if(generator!=null ){
            generator.insertImport(myParser, getGenerator(partnerRole.getClazz()).getModelSetClassName());
         }
      }
   } 
   public void generate(String rootDir, String helperDir, Role partnerRole)
   {
      generate(model.getClazz(), rootDir, helperDir, partnerRole, false);
   }
   
   
   public void generate(Clazz clazz, String rootDir, String helperDir, Role partnerRole, boolean fromSuperClass)
   {
      if (clazz.isExternal())
      {
         return;
      }
      
      Parser myParser = getGenerator(clazz).getOrCreateParser(rootDir);
      
      if ( ! fromSuperClass)
      {
            // add attribute declaration in class file
            StringBuilder text = new StringBuilder();

            if (StrUtil.stringEquals(partnerRole.getCard(), Card.MANY.toString()))
            {
               generateToManyRole(myParser, clazz, partnerRole, text);
//               getGenerator(clazz).insertImport(LinkedHashSet.class.getName());
            }
            else
            {
               generateToOneRole(myParser, clazz, partnerRole, text);
            }

            int pos = myParser.indexOf(Parser.CLASS_END);
            try{
            	myParser.insert(pos, text.toString());
            }catch(Exception e){
            	System.out.println("FILE: "+myParser.getFileName());
            	System.out.println("FILEBODY: " +myParser.getFileBody());
            	throw e;
            }

//         if (StrUtil.stringEquals(partnerRole.getCard(), Card.MANY.toString()))
//         {
//            generateEmptySetInPartnerClass(rootDir, partnerRole);
//         }
      }
      
      //import partner role class if package name has changed
      if(!StrUtil.stringEquals(clazz.getFullName().substring(0, clazz.getFullName().lastIndexOf(".")), partnerRole.getClazz().getFullName().substring(0, partnerRole.getClazz().getFullName().lastIndexOf(".")))){
         getGenerator(clazz).insertImport(partnerRole.getClazz().getFullName());
      }
      
      if(!clazz.hasFeature(Feature.Serialization)) {
    	  insertRemovalInRemoveYou(clazz, myParser, partnerRole);
    	  getGenerator(clazz).printFile();
    	  return;
      }
      
      Parser creatorParser = getGenerator(clazz).getOrCreateParserForCreatorClass(helperDir);
      
      insertCaseInGenericGet(clazz, creatorParser, partnerRole, rootDir);

      if (StrUtil.stringEquals(partnerRole.getCard(), Card.MANY.toString()))
      {
         insertCaseInGenericSetToMany(clazz, creatorParser, partnerRole, rootDir);
      }
      else
      {
         insertCaseInGenericSetToOne(clazz, creatorParser, partnerRole, rootDir);
      }
      
      insertRemovalInRemoveYou(clazz, myParser, partnerRole);
      
      getGenerator(clazz).printFile();
      
      
      // generate property in creator class
      if (!clazz.isInterface() && partnerRole.getClazz().hasFeature(Feature.Serialization))
      {
         insertPropertyInCreatorClass(clazz, creatorParser, partnerRole);

         getGenerator(clazz).printFile(creatorParser);
      }
      
      if (partnerRole.getClazz().hasFeature(Feature.Serialization)) {
	      // generate property in model set class
	      Parser modelSetParser = getGenerator(clazz).getOrCreateParserForModelSetFile(helperDir);
	      
		  insertGetterInModelSetFile(clazz, modelSetParser, myParser, partnerRole);
		  insertSetterInModelSetFile(clazz, modelSetParser, partnerRole);
	      
	      getGenerator(clazz).printFile(modelSetParser);
	
	      if(getModel().getClazz().getClassModel().hasFeature(Feature.PatternObject)){
	      // generate property in pattern object class
	      Parser patternObjectParser = getGenerator(clazz).getOrCreateParserForPatternObjectFile(helperDir);
	      
	      insertGetterInPatternObjectFile(clazz, patternObjectParser, partnerRole);
	      
	      getGenerator(clazz).printFile(patternObjectParser);
	      }
      }
   }
   
   private void insertRemovalInRemoveYou(Clazz clazz, Parser parser, Role partnerRole)
   {
      if (clazz.isInterface())
      {
         return;
      }
      
      int pos = parser.indexOf(Parser.METHOD + ":removeYou()");

      if (pos < 0)
      {
         // ups, did not find generic set method. 
         System.err.println("Warning: SDMLib codgen for role " + partnerRole.getName() + " for class " + clazz.getFullName() 
            + ": \nDid not find method removeYou(). Should have been generated by my clazz. " 
            + "\nCould not add required code fragment there. :( ");

         return;
      }

      // OK, found method, parse its body to find if that handles me. 
      String removeCall = "set" + StrUtil.upFirstChar(partnerRole.getName());
      String fullRemoveCall = removeCall + "(null);\n      ";
      if (partnerRole.getCard().equals(Card.MANY.toString()))
      {
         String name = StrUtil.upFirstChar(partnerRole.getName());
         String clazzName = StrUtil.upFirstChar(partnerRole.getClazz().getName());
         clazzName = CGUtil.shortClassName(clazzName);
         removeCall = "without"+name;
         fullRemoveCall = removeCall + "(this.get"+name+"().toArray(new "+clazzName+"[this.get"+name+"().size()]));\n      ";
      }            
      
      int methodBodyStartPos = parser.getMethodBodyStartPos();
      
      pos = parser.methodBodyIndexOf(Parser.NAME_TOKEN + ":" + removeCall, methodBodyStartPos);

      if (pos < 0)
      {         
         // need to add remove call
         pos = parser.methodBodyIndexOf(Parser.NAME_TOKEN + ":getPropertyChangeSupport", methodBodyStartPos);
         
         if (pos < 0)
         {
            System.err.println("Warning: SDMLib codgen for role " + partnerRole.getName() + " for class " + clazz.getFullName() 
               + ": \nDid not find getPropertyChangeSupport call in method removeYou(). Should have been generated by my clazz. " 
               + "\nCould not add required code fragment there. :( ");

            return;
         }
         
         parser.insert(pos, fullRemoveCall);
      }
   }

   private void insertGetterInModelSetFile(Clazz tgtClass, Parser parser, Parser modelClassParser, Role partnerRole)
   {
      String key = Parser.METHOD + ":get" + StrUtil.upFirstChar(partnerRole.getName()) + "()";
      int pos = parser.indexOf(key);

      StringBuilder text = new StringBuilder();
      
      if (pos < 0)
      {
            text.append(
            "   public ModelSetType getName()\n" + 
            "   {\n" + 
            "      ModelSetType result = new ModelSetType();\n" + 
            "      \n" + 
            "      for (ContentType obj : this)\n" + 
            "      {\n" + 
            "         result.addOneOrMore(obj.getName());\n" + 
            "      }\n" + 
            "      \n" + 
            "      return result;\n" + 
            "   }\n" + 
            "\n" + 
            "   public ContentTypeSet hasName(Object value)\n" + 
            "   {\n" + 
            "      ObjectSet neighbors = new ObjectSet();\n" + 
            "\n" + 
            "      if (value instanceof Collection)\n" + 
            "      {\n" + 
            "         neighbors.addAll((Collection<?>) value);\n" + 
            "      }\n" + 
            "      else\n" + 
            "      {\n" + 
            "         neighbors.add(value);\n" + 
            "      }\n" + 
            "      \n" + 
            "      ContentTypeSet answer = new ContentTypeSet();\n" + 
            "      \n" + 
            "      for (ContentType obj : this)\n" + 
            "      {\n" + 
            "         if (containsClause)\n" + 
            "         {\n" + 
            "            answer.add(obj);\n" + 
            "         }\n" + 
            "      }\n" + 
            "      \n" + 
            "      return answer;\n" + 
            "   }\n" + 
            "\n");
            getGenerator(tgtClass).insertImport(parser, Collection.class.getName());
            getGenerator(tgtClass).insertImport(parser, ObjectSet.class.getName());
            
            String containsClause = "neighbors.contains(obj.get"
                  + StrUtil.upFirstChar(partnerRole.getName()) + "())";
            
            if (partnerRole.getCard().equals(Card.MANY.toString()))
            {
               containsClause = " ! Collections.disjoint(neighbors, obj.get" 
                     + StrUtil.upFirstChar(partnerRole.getName()) + "())";
               getGenerator(tgtClass).insertImport(parser, Collections.class.getName());
            }
            CGUtil.replaceAll(text, "containsClause", containsClause);
            
      }
       
      
      String key2 = Parser.METHOD + ":get" + StrUtil.upFirstChar(partnerRole.getName()) + "Transitive()";
      int pos2 = parser.indexOf(key2);
      
      if (pos2 < 0)
      {
         if (model.getClazz() == model.getPartnerRole().getClazz())
         {
            text
               .append("\n   public ModelSetType getNameTransitive()\n"
                  + "   {\n"
                  + "      ModelSetType todo = new ModelSetType().with(this);\n"
                  + "      \n"
                  + "      ModelSetType result = new ModelSetType();\n"
                  + "      \n" + "      while ( ! todo.isEmpty())\n"
                  + "      {\n"
                  + "         ModelType current = todo.first();\n"
                  + "         \n" + "         todo.remove(current);\n"
                  + "         \n"
                  + "         if ( ! result.contains(current))\n"
                  + "         {\n" + "            result.add(current);\n"
                  + "            \n"
                  + "            todo.with(current.getPartnerrolenameupfirst().minus(result));\n"
                  + "         }\n" + "      }\n" + "      \n"
                  + "      return result;\n" + "   }\n" + "\n" + "");
            
            if (partnerRole.getCard().equals(Card.ONE.toString()))
            {
               CGUtil.replaceAll(text, 
                  "todo.with(current.getPartnerrolenameupfirst().minus(result));", 
                  "if ( ! result.contains(current.getName()))\n"
                  + "            {\n"
                  + "               todo.with(current.getName());\n"
                  + "            }");
            }
            getGenerator(model.getClazz()).insertImport(CGUtil.helperClassName(partnerRole.getClazz().getFullName() ,"Set"));
         }
      }
      
      if (pos < 0 || pos2 < 0)
      {      
         String add = "add";
         if (partnerRole.getCard().equalsIgnoreCase(Card.MANY.name()))
         {
            add = "addAll";
         }
         
         String partnerRoleNameUpFirst = StrUtil.upFirstChar(partnerRole.getName());
         String partnerGetterName = partnerRoleNameUpFirst;
         
         modelClassParser.indexOf(key);
         ArrayList<SymTabEntry> symTabEntries = modelClassParser.getSymTabEntriesFor(Parser.METHOD + ":get" + partnerRoleNameUpFirst + "()");
         
         elistPos = -1;
         
         if (symTabEntries.size() > 0)
         {
            String type = symTabEntries.get(0).getType();
            elistPos = type.indexOf(":EList<");
         }
         
         if (elistPos >= 0)
         {
            partnerGetterName += "Set";
         }
         
         CGUtil.replaceAll(text, 
            "ContentType", CGUtil.shortClassName(tgtClass.getFullName()),
            "ModelType", CGUtil.shortClassName(partnerRole.getClazz().getFullName()),
            "ModelSetType", CGUtil.shortClassName(partnerRole.getClazz().getFullName()) + "Set",
            "Name", partnerRoleNameUpFirst,
            "addOneOrMore", add,
            "Partnerrolenameupfirst", partnerGetterName
            );

         int classEnd = parser.indexOf(Parser.CLASS_END);
         
         parser.insert(classEnd, text.toString());
         
         if (! partnerRole.getClazz().isExternal())
         {
            // external classes get a set in this util package, no need for an import
            // thus just for real classes that may be in other packages
            String helperClassName = CGUtil.helperClassName(partnerRole.getClazz().getFullName(),"Set");
            
            getGenerator(tgtClass).insertImport(parser, helperClassName);
         }
      }
   }


   private void insertGetterInPatternObjectFile(Clazz clazz, Parser parser, Role partnerRole)
   {
      insertHasNoParamInPatternObjectFile(clazz, parser, partnerRole);
      insertCreateNoParamInPatternObjectFile(clazz, parser, partnerRole);
      insertHasWithParamInPatternObjectFile(clazz, parser, partnerRole);
      insertCreateWithParamInPatternObjectFile(clazz, parser, partnerRole);
      insertGetInPatternObjectFile(clazz, parser, partnerRole);
   }

   private void insertGetInPatternObjectFile(Clazz clazz, Parser parser, Role partnerRole)
   {
      String key = Parser.METHOD + ":get" + StrUtil.upFirstChar(partnerRole.getName()) + "()";
      int pos = parser.indexOf(key);

      if (pos < 0)
      {
         StringBuilder text = new StringBuilder();
         
         if (elistPos < 0 || partnerRole.getCard().equals(Card.ONE.toString()))
         {
            text.append
            (       "   public TargetType getRoleName()\n"
                  + "   {\n"
                  + "      if (this.getPattern().getHasMatch())\n"
                  + "      {\n"
                  + "         return ((ModelClass) this.getCurrentMatch()).getRoleName();\n"
                  + "      }\n" + "      return null;\n" + "   }\n\n");
         }
         else
         {
            text.append
            (       "   public TargetType getRoleName()\n"
                  + "   {\n"
                  + "      if (this.getPattern().getHasMatch())\n"
                  + "      {\n"
                  + "         return ((ModelClass) this.getCurrentMatch()).getRoleNameSet();\n"
                  + "      }\n" + "      return null;\n" + "   }\n\n");
         }
         
         
//         getGenerator(clazz).insertImport(parser, PatternLink.class.getName());
         String targetType;
         
         if (partnerRole.getCard().equals(Card.MANY.toString()))
         {
            String fullTargetType = CGUtil.helperClassName(partnerRole.getClazz().getFullName(), "Set");
            if (partnerRole.getClazz().isExternal())
            {
               targetType = CGUtil.shortClassName(partnerRole.getClazz().getName()) + "Set";
            }
            else
            {
               targetType = getGenerator(partnerRole.getClazz()).shortNameAndImport(fullTargetType, parser);
            }
         }else{
            targetType = getGenerator(partnerRole.getClazz()).shortNameAndImport(partnerRole.getClazz().getFullName(), parser);
         }
         
         CGUtil.replaceAll(text, 
            "TargetType", targetType,
            "ModelClass", getGenerator(model.getClazz()).shortNameAndImport(model.getClazz().getFullName(), parser),
            "RoleName", StrUtil.upFirstChar(partnerRole.getName()), 
            "PROPERTY_NAME", "PROPERTY_" + partnerRole.getName().toUpperCase());

         int classEnd = parser.indexOf(Parser.CLASS_END);
         
         parser.insert(classEnd, text.toString());
      }
   }


   private void insertHasNoParamInPatternObjectFile(Clazz clazz, Parser parser,
         Role partnerRole)
   {
      String key = Parser.METHOD + ":has" + StrUtil.upFirstChar(partnerRole.getName()) + "()";
      int pos = parser.indexOf(key);

      if (pos < 0)
      {
         StringBuilder text = new StringBuilder(
            "   public PatternObjectType hasName()\n" + 
            "   {\n" + 
            "      PatternObjectType result = new PatternObjectType(new ClassObjectType[]{});\n" + 
            "      \n" + 
            "      result.setModifier(this.getPattern().getModifier());\n" + 
            "      super.hasLink(ModelClass.PROPERTY_NAME, result);\n" + 
            "      \n" + 
            "      return result;\n" + 
            "   }\n\n");

         //         getGenerator(clazz).insertImport(parser, PatternLink.class.getName());
         String fullPatternObjectType = CGUtil.helperClassName(partnerRole.getClazz().getFullName(), "PO");
         String patternObjectType = CGUtil.shortClassName(partnerRole.getClazz()+"PO");
         if ( ! partnerRole.getClazz().isExternal())
         {
            patternObjectType = getGenerator(partnerRole.getClazz()).shortNameAndImport(fullPatternObjectType, parser);
         }
         String partnerClass = partnerRole.getClazz().getName();
         CGUtil.replaceAll(text, 
            "PatternObjectType", patternObjectType,
            "hasName", "has" + StrUtil.upFirstChar(partnerRole.getName()), 
            "ClassObjectType", partnerClass,
            "ModelClass", getGenerator(model.getClazz()).shortNameAndImport(model.getClazz().getFullName(), parser),
            "PROPERTY_NAME", "PROPERTY_" + partnerRole.getName().toUpperCase());

         int classEnd = parser.indexOf(Parser.CLASS_END);
         
         parser.insert(classEnd, text.toString());
         if(partnerClass.indexOf(".")<0){
            getGenerator(partnerRole.getClazz()).insertImport(parser, partnerRole.getClazz().getFullName());
         }
      }
   }


   private void insertCreateNoParamInPatternObjectFile(Clazz clazz, Parser parser,
         Role partnerRole)
   {
      String key = Parser.METHOD + ":create" + StrUtil.upFirstChar(partnerRole.getName()) + "()";
      int pos = parser.indexOf(key);

      if (pos < 0)
      {
         StringBuilder text = new StringBuilder(
            "   public PatternObjectType createName()\n" + 
            "   {\n" + 
            "      return this.startCreate().hasName().endCreate();\n" + 
            "   }\n\n");

//         getGenerator(clazz).insertImport(parser, PatternLink.class.getName());
         
         String fullPatternObjectType = CGUtil.helperClassName(partnerRole.getClazz().getFullName(), "PO");
         String patternObjectType = CGUtil.shortClassName(partnerRole.getClazz()+"PO");
         if ( ! partnerRole.getClazz().isExternal())
         {
            patternObjectType = getGenerator(partnerRole.getClazz()).shortNameAndImport(fullPatternObjectType, parser);
         }
         
         CGUtil.replaceAll(text, 
            "PatternObjectType", patternObjectType,
            "Name", StrUtil.upFirstChar(partnerRole.getName()), 
            "ModelClass", getGenerator(model.getClazz()).shortNameAndImport(model.getClazz().getFullName(), parser));

         int classEnd = parser.indexOf(Parser.CLASS_END);
         
         parser.insert(classEnd, text.toString());
      }
   }


   private void insertHasWithParamInPatternObjectFile(Clazz clazz, Parser parser,
         Role partnerRole)
   {
      String fullPatternObjectType = CGUtil.helperClassName(partnerRole.getClazz().getFullName(), "PO");
//      String patternObjectType = getGenerator(partnerRole.getClazz()).shortNameAndImport(fullPatternObjectType, parser);
      String patternObjectType = CGUtil.shortClassName(fullPatternObjectType);
      
      String key = Parser.METHOD + ":has" + StrUtil.upFirstChar(partnerRole.getName()) + "(" + patternObjectType + ")";
      int pos = parser.indexOf(key);

      if (pos < 0)
      {
         StringBuilder text = new StringBuilder(
            "   public ModelPOType hasName(PatternObjectType tgt)\n" + 
            "   {\n" + 
            "      return hasLinkConstraint(tgt, ModelClass.PROPERTY_NAME);\n" + 
            "   }\n\n");

//         getGenerator(clazz).insertImport(parser, LinkConstraint.class.getName());
         
         String fullModelPOType = CGUtil.helperClassName(clazz.getFullName(), "PO");
         String modelPOType = getGenerator(clazz).shortNameAndImport(fullModelPOType, parser);
         
         CGUtil.replaceAll(text, 
            "PatternObjectType", patternObjectType,
            "hasName", "has" + StrUtil.upFirstChar(partnerRole.getName()), 
            "ModelClass", getGenerator(model.getClazz()).shortNameAndImport(model.getClazz().getFullName(), parser),
            "ModelPOType", modelPOType, 
            "PROPERTY_NAME", "PROPERTY_" + partnerRole.getName().toUpperCase());

         int classEnd = parser.indexOf(Parser.CLASS_END);
         
         parser.insert(classEnd, text.toString());
      }
   }


   private void insertCreateWithParamInPatternObjectFile(Clazz clazz, Parser parser,
         Role partnerRole)
   {
      String fullPatternObjectType = CGUtil.helperClassName(partnerRole.getClazz().getFullName(), "PO");
//      String patternObjectType = getGenerator(partnerRole.getClazz()).shortNameAndImport(fullPatternObjectType, parser);
      String patternObjectType = CGUtil.shortClassName(fullPatternObjectType);
      
      String key = Parser.METHOD + ":create" + StrUtil.upFirstChar(partnerRole.getName()) + "(" + patternObjectType + ")";
      int pos = parser.indexOf(key);

      if (pos < 0)
      {
         StringBuilder text = new StringBuilder(
            "   public ModelPOType createName(PatternObjectType tgt)\n" + 
            "   {\n" + 
            "      return this.startCreate().hasName(tgt).endCreate();\n" + 
            "   }\n\n");

//         getGenerator(clazz).insertImport(parser, LinkConstraint.class.getName());
         
         String fullModelPOType = CGUtil.helperClassName(clazz.getFullName(), "PO");
         String modelPOType = getGenerator(clazz).shortNameAndImport(fullModelPOType, parser);
         
         CGUtil.replaceAll(text, 
            "PatternObjectType", patternObjectType,
            "Name", StrUtil.upFirstChar(partnerRole.getName()), 
            "ModelPOType", modelPOType);

         int classEnd = parser.indexOf(Parser.CLASS_END);
         
         parser.insert(classEnd, text.toString());
      }
   }


   private void insertSetterInModelSetFile(Clazz tgtClass, Parser parser, Role partnerRole)
   {
      String targetType = CGUtil.shortClassName(partnerRole.getClazz().getFullName());
      
      String key = Parser.METHOD + ":with" + StrUtil.upFirstChar(partnerRole.getName()) + "(" + targetType + ")";
      int pos = parser.indexOf(key);

      if (pos < 0)
      {
         StringBuilder text = new StringBuilder(
            "   public ModelSetType withName(TargetType value)\n" + 
            "   {\n" + 
            "      for (ContentType obj : this)\n" + 
            "      {\n" + 
            "         obj.withName(value);\n" + 
            "      }\n" + 
            "      \n" + 
            "      return this;\n" + 
            "   }\n\n"
            );

         CGUtil.replaceAll(text, 
            "TargetType", targetType,
            "ContentType", CGUtil.shortClassName(tgtClass.getFullName()),
            "ModelSetType", CGUtil.shortClassName(tgtClass.getFullName()) + "Set",
            "Name", StrUtil.upFirstChar(partnerRole.getName())
            );

         int classEnd = parser.indexOf(Parser.CLASS_END);
         
         parser.insert(classEnd, text.toString());
         
         getGenerator(tgtClass).insertImport(parser, partnerRole.getClazz().getFullName());
      }
      
      if (partnerRole.getCard().equals(Card.MANY.toString()))
      {
         key = Parser.METHOD + ":without" + StrUtil.upFirstChar(partnerRole.getName()) + "(" + targetType + ")";
         pos = parser.indexOf(key);

         if (pos < 0)
         {
            StringBuilder text = new StringBuilder(
               "   public ModelSetType withoutName(TargetType value)\n" + 
               "   {\n" + 
               "      for (ContentType obj : this)\n" + 
               "      {\n" + 
               "         obj.withoutName(value);\n" + 
               "      }\n" + 
               "      \n" + 
               "      return this;\n" + 
               "   }\n\n"
               );

            CGUtil.replaceAll(text, 
               "TargetType", targetType,
               "ContentType", CGUtil.shortClassName(tgtClass.getFullName()),
               "ModelSetType", CGUtil.shortClassName(tgtClass.getFullName()) + "Set",
               "Name", StrUtil.upFirstChar(partnerRole.getName())
               );

            int classEnd = parser.indexOf(Parser.CLASS_END);
            
            parser.insert(classEnd, text.toString());
            
            getGenerator(tgtClass).insertImport(parser, partnerRole.getClazz().getFullName());
         }
      }
   }


   private void insertPropertyInCreatorClass(Clazz clazz, Parser parser, Role partnerRole)
   {
      String key = Parser.ATTRIBUTE + ":properties";
      int pos = parser.indexOf(key);

      if (pos < 0)
      {
         // ups, did not find generic get method. 
         System.err.println("Warning: SDMLib codgen for role " + partnerRole.getName() + " for creator class for " + clazz.getFullName() 
            + ": \nDid not find properties field. Should have been generated by my clazz. " 
            + "\nCould not add required code fragment there. :( ");

         return;
      }

      // OK, found method, parse its body to find if that handles me. 
      int endOfStringArrayInit = parser.getEndOfAttributeInitialization();
      
      String propertyName = "PROPERTY_" + partnerRole.getName().toUpperCase() +",";
      
      int propertyNameIndex = parser.search(propertyName, pos);

      if (propertyNameIndex < 0 || propertyNameIndex > endOfStringArrayInit)
      {         
         // need to add property to string array
         
         StringBuilder text = new StringBuilder(  "   className.PROPERTY_NAME,\n   ");

         String shortClassName = CGUtil.shortClassName(model.getClazz().getFullName());
         CGUtil.replaceAll(text, 
            "className", shortClassName,
            "PROPERTY_NAME", "PROPERTY_" + partnerRole.getName().toUpperCase()
            );

         parser.insert(endOfStringArrayInit, text.toString());
         getGenerator(clazz).insertImport(parser, model.getClazz().getFullName());
      }
   }
   
   private void insertCaseInGenericSetToMany(Clazz clazz, Parser parser, Role partnerRole, String rootDir)
   {   
      if (clazz.isInterface())
      {
         return;
      }
      
      int pos = parser.indexOf(Parser.METHOD + ":setValue(Object,String,Object,String)");

      if (pos < 0)
      {
         // ups, did not find generic set method. 
         System.err.println("Warning: SDMLib codgen for role " + partnerRole.getName() + " for class " + clazz.getFullName() 
            + ": \nDid not find method set(String,Object). Should have been generated by my clazz. " 
            + "\nCould not add required code fragment there. :( ");

         return;
      }

      // OK, found method, parse its body to find if that handles me. 
      int methodBodyStartPos = parser.getMethodBodyStartPos();
      
      pos = parser.methodBodyIndexOf(Parser.NAME_TOKEN + ":PROPERTY_" + partnerRole.getName().toUpperCase() , methodBodyStartPos);

      if (pos < 0)
      {         
         // need to add if block to generic set method
         parser.methodBodyIndexOf(Parser.METHOD_END, methodBodyStartPos);
         
         int lastIfEndPos = parser.lastIfEnd + 2; // add 1 to be after } and 1 to be after \n
         if (lastIfEndPos - 2  < 0)
         {
            lastIfEndPos = methodBodyStartPos + 1;
         }
         
         StringBuilder text = new StringBuilder
            (  "\n      if (ClassName.PROPERTY_NAME.equalsIgnoreCase(attrName))" +
               "\n      {" +
               "\n         ((ClassName) target).withPropertyName((type) value);" +
               "\n         return true;" +
               "\n      }" +
               "\n      " + 
               "\n      if ((ClassName.PROPERTY_NAME + JsonIdMap.REMOVE).equalsIgnoreCase(attrName))" +
               "\n      {" +
               "\n         ((ClassName) target).withoutPropertyName((type) value);" +
               "\n         return true;" +
               "\n      }" +
               "\n" 
               );

         String typePlaceholder = "type";
         String type = CGUtil.shortClassName(partnerRole.getClazz().getFullName());

         CGUtil.replaceAll(text, 
            typePlaceholder, type, 
            "ClassName", CGUtil.shortClassName(clazz.getName()),
            "PropertyName", StrUtil.upFirstChar(partnerRole.getName()),
            "PROPERTY_NAME", "PROPERTY_" + partnerRole.getName().toUpperCase()
            );

         parser.insert(lastIfEndPos, text.toString());
         
         getGenerator(clazz).insertImport(parser, JsonIdMap.class.getName());

         getGenerator(clazz).insertImport(parser, partnerRole.getClazz().getFullName());
         
      }
   }

   private void insertCaseInGenericSetToOne(Clazz clazz, Parser parser, Role partnerRole, String rootDir)
   {
      if (clazz.isInterface())
      {
         return;
      }
      
      int pos = parser.indexOf(Parser.METHOD + ":setValue(Object,String,Object,String)");

      if (pos < 0)
      {
         // ups, did not find generic set method. 
         System.err.println("Warning: SDMLib codgen for role " + partnerRole.getName() + " for class " + clazz.getFullName() 
            + ": \nDid not find method set(String,Object). Should have been generated by my clazz. " 
            + "\nCould not add required code fragment there. :( ");

         return;
      }

      // OK, found method, parse its body to find if that handles me. 
      int methodBodyStartPos = parser.getMethodBodyStartPos();
      
      pos = parser.methodBodyIndexOf(Parser.NAME_TOKEN + ":PROPERTY_" + partnerRole.getName().toUpperCase() , methodBodyStartPos);

      if (pos < 0)
      {         
         // need to add if block to generic set method
         parser.methodBodyIndexOf(Parser.METHOD_END, methodBodyStartPos);
         
         int lastIfEndPos = parser.lastIfEnd + 2; // add 1 to be after } and 1 to be after \n
         if (lastIfEndPos - 2  < 0)
         {
            lastIfEndPos = methodBodyStartPos + 1;
         }
         
         StringBuilder text = new StringBuilder
            (  "\n      if (ClassName.PROPERTY_NAME.equalsIgnoreCase(attrName))" +
               "\n      {" +
               "\n         ((ClassName) target).setPropertyName((type) value);" +
               "\n         return true;" +
               "\n      }" +
               "\n" 
               );

         String typePlaceholder = "type";
         String type = CGUtil.shortClassName(partnerRole.getClazz().getFullName());

         CGUtil.replaceAll(text, 
            typePlaceholder, type, 
            "ClassName", CGUtil.shortClassName(clazz.getName()),
            "PropertyName", StrUtil.upFirstChar(partnerRole.getName()),
            "PROPERTY_NAME", "PROPERTY_" + partnerRole.getName().toUpperCase()
            );

         parser.insert(lastIfEndPos, text.toString());
         
         getGenerator(clazz).insertImport(parser, partnerRole.getClazz().getFullName());
      }
   }
   
   public String toString()
   {
      return "gen " + model.toString();
   }
}
