package de.uniks.networkparser.interfaces;

/*
 NetworkParser
 Copyright (c) 2011 - 2015, Stefan Lindel
 All rights reserved.

 Licensed under the EUPL, Version 1.1 or (as soon they
 will be approved by the European Commission) subsequent
 versions of the EUPL (the "Licence");
 You may not use this work except in compliance with the Licence.
 You may obtain a copy of the Licence at:

 http://ec.europa.eu/idabc/eupl5

 Unless required by applicable law or agreed to in
 writing, software distributed under the Licence is
 distributed on an "AS IS" basis,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 express or implied.
 See the Licence for the specific language governing
 permissions and limitations under the Licence.
*/
/**
 * INterface for Buffer For Tokener to parse some Values
 *
 */

public interface Buffer {
	/**
	 * @return the length of the buffer
	 */
	public int length();

	public byte byteAt(int index);

	public char charAt(int index);

	public char getChar();

	/**
	 * @param start
	 *            startindex for parsing
	 * @param length
	 *            the length of Substring
	 * @return the Substring
	 */
	public String substring(int start, int length);

	public Buffer withLength(int length);

	public int position();

	public int remaining();

	public void back();

	public boolean isEnd();

	public Buffer withPosition(int index);

	@Override
	public String toString();

	public String toText();

	public byte[] toArray();

	public boolean isCache();
}
