/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.asm.util;

import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import scala.tools.asm.AnnotationVisitor;
import scala.tools.asm.Attribute;
import scala.tools.asm.ClassReader;
import scala.tools.asm.ClassVisitor;
import scala.tools.asm.FieldVisitor;
import scala.tools.asm.Label;
import scala.tools.asm.MethodVisitor;
import scala.tools.asm.Type;
import scala.tools.asm.tree.ClassNode;
import scala.tools.asm.tree.MethodNode;
import scala.tools.asm.tree.analysis.Analyzer;
import scala.tools.asm.tree.analysis.BasicValue;
import scala.tools.asm.tree.analysis.Frame;
import scala.tools.asm.tree.analysis.SimpleVerifier;
import scala.tools.asm.util.CheckAnnotationAdapter;
import scala.tools.asm.util.CheckFieldAdapter;
import scala.tools.asm.util.CheckMethodAdapter;
import scala.tools.asm.util.Textifier;
import scala.tools.asm.util.TraceMethodVisitor;

public class CheckClassAdapter
extends ClassVisitor {
    private int version;
    private boolean start;
    private boolean source;
    private boolean outer;
    private boolean end;
    private Map<Label, Integer> labels = new HashMap<Label, Integer>();
    private boolean checkDataFlow;

    public static void main(String[] args2) throws Exception {
        if (args2.length != 1) {
            System.err.println("Verifies the given class.");
            System.err.println("Usage: CheckClassAdapter <fully qualified class name or class file name>");
            return;
        }
        ClassReader cr = args2[0].endsWith(".class") ? new ClassReader(new FileInputStream(args2[0])) : new ClassReader(args2[0]);
        CheckClassAdapter.verify(cr, false, new PrintWriter(System.err));
    }

    public static void verify(ClassReader cr, ClassLoader loader, boolean dump, PrintWriter pw) {
        ClassNode cn = new ClassNode();
        cr.accept(new CheckClassAdapter(cn, false), 2);
        Type syperType = cn.superName == null ? null : Type.getObjectType(cn.superName);
        List<MethodNode> methods2 = cn.methods;
        ArrayList<Type> interfaces2 = new ArrayList<Type>();
        Iterator<String> i = cn.interfaces.iterator();
        while (i.hasNext()) {
            interfaces2.add(Type.getObjectType(i.next().toString()));
        }
        for (int i2 = 0; i2 < methods2.size(); ++i2) {
            MethodNode method = methods2.get(i2);
            SimpleVerifier verifier = new SimpleVerifier(Type.getObjectType(cn.name), syperType, interfaces2, (cn.access & 0x200) != 0);
            Analyzer<BasicValue> a = new Analyzer<BasicValue>(verifier);
            if (loader != null) {
                verifier.setClassLoader(loader);
            }
            try {
                a.analyze(cn.name, method);
                if (!dump) {
                    continue;
                }
            }
            catch (Exception e) {
                e.printStackTrace(pw);
            }
            CheckClassAdapter.printAnalyzerResult(method, a, pw);
        }
        pw.flush();
    }

    public static void verify(ClassReader cr, boolean dump, PrintWriter pw) {
        CheckClassAdapter.verify(cr, null, dump, pw);
    }

    static void printAnalyzerResult(MethodNode method, Analyzer<BasicValue> a, PrintWriter pw) {
        int j;
        Frame<BasicValue>[] frames = a.getFrames();
        Textifier t = new Textifier();
        TraceMethodVisitor mv = new TraceMethodVisitor(t);
        pw.println(method.name + method.desc);
        for (j = 0; j < method.instructions.size(); ++j) {
            method.instructions.get(j).accept(mv);
            StringBuffer s = new StringBuffer();
            Frame<BasicValue> f2 = frames[j];
            if (f2 == null) {
                s.append('?');
            } else {
                int k;
                for (k = 0; k < f2.getLocals(); ++k) {
                    s.append(CheckClassAdapter.getShortName(f2.getLocal(k).toString())).append(' ');
                }
                s.append(" : ");
                for (k = 0; k < f2.getStackSize(); ++k) {
                    s.append(CheckClassAdapter.getShortName(f2.getStack(k).toString())).append(' ');
                }
            }
            while (s.length() < method.maxStack + method.maxLocals + 1) {
                s.append(' ');
            }
            pw.print(Integer.toString(j + 100000).substring(1));
            pw.print(" " + s + " : " + t.text.get(t.text.size() - 1));
        }
        for (j = 0; j < method.tryCatchBlocks.size(); ++j) {
            method.tryCatchBlocks.get(j).accept(mv);
            pw.print(" " + t.text.get(t.text.size() - 1));
        }
        pw.println();
    }

    private static String getShortName(String name) {
        int n = name.lastIndexOf(47);
        int k = name.length();
        if (name.charAt(k - 1) == ';') {
            --k;
        }
        return n == -1 ? name : name.substring(n + 1, k);
    }

    public CheckClassAdapter(ClassVisitor cv) {
        this(cv, true);
    }

    public CheckClassAdapter(ClassVisitor cv, boolean checkDataFlow) {
        this(262144, cv, checkDataFlow);
    }

    protected CheckClassAdapter(int api, ClassVisitor cv, boolean checkDataFlow) {
        super(api, cv);
        this.checkDataFlow = checkDataFlow;
    }

    @Override
    public void visit(int version, int access2, String name, String signature2, String superName, String[] interfaces2) {
        if (this.start) {
            throw new IllegalStateException("visit must be called only once");
        }
        this.start = true;
        this.checkState();
        CheckClassAdapter.checkAccess(access2, 423473);
        if (name == null || !name.endsWith("package-info")) {
            CheckMethodAdapter.checkInternalName(name, "class name");
        }
        if ("java/lang/Object".equals(name)) {
            if (superName != null) {
                throw new IllegalArgumentException("The super class name of the Object class must be 'null'");
            }
        } else {
            CheckMethodAdapter.checkInternalName(superName, "super class name");
        }
        if (signature2 != null) {
            CheckClassAdapter.checkClassSignature(signature2);
        }
        if ((access2 & 0x200) != 0 && !"java/lang/Object".equals(superName)) {
            throw new IllegalArgumentException("The super class name of interfaces must be 'java/lang/Object'");
        }
        if (interfaces2 != null) {
            for (int i = 0; i < interfaces2.length; ++i) {
                CheckMethodAdapter.checkInternalName(interfaces2[i], "interface name at index " + i);
            }
        }
        this.version = version;
        super.visit(version, access2, name, signature2, superName, interfaces2);
    }

    @Override
    public void visitSource(String file, String debug) {
        this.checkState();
        if (this.source) {
            throw new IllegalStateException("visitSource can be called only once.");
        }
        this.source = true;
        super.visitSource(file, debug);
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        this.checkState();
        if (this.outer) {
            throw new IllegalStateException("visitOuterClass can be called only once.");
        }
        this.outer = true;
        if (owner == null) {
            throw new IllegalArgumentException("Illegal outer class owner");
        }
        if (desc != null) {
            CheckMethodAdapter.checkMethodDesc(desc);
        }
        super.visitOuterClass(owner, name, desc);
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access2) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(name, "class name");
        if (outerName != null) {
            CheckMethodAdapter.checkInternalName(outerName, "outer class name");
        }
        if (innerName != null) {
            CheckMethodAdapter.checkIdentifier(innerName, "inner class name");
        }
        CheckClassAdapter.checkAccess(access2, 30239);
        super.visitInnerClass(name, outerName, innerName, access2);
    }

    @Override
    public FieldVisitor visitField(int access2, String name, String desc, String signature2, Object value) {
        this.checkState();
        CheckClassAdapter.checkAccess(access2, 413919);
        CheckMethodAdapter.checkUnqualifiedName(this.version, name, "field name");
        CheckMethodAdapter.checkDesc(desc, false);
        if (signature2 != null) {
            CheckClassAdapter.checkFieldSignature(signature2);
        }
        if (value != null) {
            CheckMethodAdapter.checkConstant(value);
        }
        FieldVisitor av = super.visitField(access2, name, desc, signature2, value);
        return new CheckFieldAdapter(av);
    }

    @Override
    public MethodVisitor visitMethod(int access2, String name, String desc, String signature2, String[] exceptions) {
        this.checkState();
        CheckClassAdapter.checkAccess(access2, 400895);
        if (!"<init>".equals(name) && !"<clinit>".equals(name)) {
            CheckMethodAdapter.checkMethodIdentifier(this.version, name, "method name");
        }
        CheckMethodAdapter.checkMethodDesc(desc);
        if (signature2 != null) {
            CheckClassAdapter.checkMethodSignature(signature2);
        }
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                CheckMethodAdapter.checkInternalName(exceptions[i], "exception name at index " + i);
            }
        }
        CheckMethodAdapter cma = this.checkDataFlow ? new CheckMethodAdapter(access2, name, desc, super.visitMethod(access2, name, desc, signature2, exceptions), this.labels) : new CheckMethodAdapter(super.visitMethod(access2, name, desc, signature2, exceptions), this.labels);
        cma.version = this.version;
        return cma;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.checkState();
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(desc, visible));
    }

    @Override
    public void visitAttribute(Attribute attr) {
        this.checkState();
        if (attr == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttribute(attr);
    }

    @Override
    public void visitEnd() {
        this.checkState();
        this.end = true;
        super.visitEnd();
    }

    private void checkState() {
        if (!this.start) {
            throw new IllegalStateException("Cannot visit member before visit has been called.");
        }
        if (this.end) {
            throw new IllegalStateException("Cannot visit member after visitEnd has been called.");
        }
    }

    static void checkAccess(int access2, int possibleAccess) {
        int abs;
        int pro;
        if ((access2 & ~possibleAccess) != 0) {
            throw new IllegalArgumentException("Invalid access flags: " + access2);
        }
        int pub = (access2 & 1) == 0 ? 0 : 1;
        int pri = (access2 & 2) == 0 ? 0 : 1;
        int n = pro = (access2 & 4) == 0 ? 0 : 1;
        if (pub + pri + pro > 1) {
            throw new IllegalArgumentException("public private and protected are mutually exclusive: " + access2);
        }
        int fin = (access2 & 0x10) == 0 ? 0 : 1;
        int n2 = abs = (access2 & 0x400) == 0 ? 0 : 1;
        if (fin + abs > 1) {
            throw new IllegalArgumentException("final and abstract are mutually exclusive: " + access2);
        }
    }

    public static void checkClassSignature(String signature2) {
        int pos = 0;
        if (CheckClassAdapter.getChar(signature2, 0) == '<') {
            pos = CheckClassAdapter.checkFormalTypeParameters(signature2, pos);
        }
        pos = CheckClassAdapter.checkClassTypeSignature(signature2, pos);
        while (CheckClassAdapter.getChar(signature2, pos) == 'L') {
            pos = CheckClassAdapter.checkClassTypeSignature(signature2, pos);
        }
        if (pos != signature2.length()) {
            throw new IllegalArgumentException(signature2 + ": error at index " + pos);
        }
    }

    public static void checkMethodSignature(String signature2) {
        int pos = 0;
        if (CheckClassAdapter.getChar(signature2, 0) == '<') {
            pos = CheckClassAdapter.checkFormalTypeParameters(signature2, pos);
        }
        pos = CheckClassAdapter.checkChar('(', signature2, pos);
        while ("ZCBSIFJDL[T".indexOf(CheckClassAdapter.getChar(signature2, pos)) != -1) {
            pos = CheckClassAdapter.checkTypeSignature(signature2, pos);
        }
        pos = CheckClassAdapter.getChar(signature2, pos = CheckClassAdapter.checkChar(')', signature2, pos)) == 'V' ? ++pos : CheckClassAdapter.checkTypeSignature(signature2, pos);
        while (CheckClassAdapter.getChar(signature2, pos) == '^') {
            if (CheckClassAdapter.getChar(signature2, ++pos) == 'L') {
                pos = CheckClassAdapter.checkClassTypeSignature(signature2, pos);
                continue;
            }
            pos = CheckClassAdapter.checkTypeVariableSignature(signature2, pos);
        }
        if (pos != signature2.length()) {
            throw new IllegalArgumentException(signature2 + ": error at index " + pos);
        }
    }

    public static void checkFieldSignature(String signature2) {
        int pos = CheckClassAdapter.checkFieldTypeSignature(signature2, 0);
        if (pos != signature2.length()) {
            throw new IllegalArgumentException(signature2 + ": error at index " + pos);
        }
    }

    private static int checkFormalTypeParameters(String signature2, int pos) {
        pos = CheckClassAdapter.checkChar('<', signature2, pos);
        pos = CheckClassAdapter.checkFormalTypeParameter(signature2, pos);
        while (CheckClassAdapter.getChar(signature2, pos) != '>') {
            pos = CheckClassAdapter.checkFormalTypeParameter(signature2, pos);
        }
        return pos + 1;
    }

    private static int checkFormalTypeParameter(String signature2, int pos) {
        pos = CheckClassAdapter.checkIdentifier(signature2, pos);
        if ("L[T".indexOf(CheckClassAdapter.getChar(signature2, pos = CheckClassAdapter.checkChar(':', signature2, pos))) != -1) {
            pos = CheckClassAdapter.checkFieldTypeSignature(signature2, pos);
        }
        while (CheckClassAdapter.getChar(signature2, pos) == ':') {
            pos = CheckClassAdapter.checkFieldTypeSignature(signature2, pos + 1);
        }
        return pos;
    }

    private static int checkFieldTypeSignature(String signature2, int pos) {
        switch (CheckClassAdapter.getChar(signature2, pos)) {
            case 'L': {
                return CheckClassAdapter.checkClassTypeSignature(signature2, pos);
            }
            case '[': {
                return CheckClassAdapter.checkTypeSignature(signature2, pos + 1);
            }
        }
        return CheckClassAdapter.checkTypeVariableSignature(signature2, pos);
    }

    private static int checkClassTypeSignature(String signature2, int pos) {
        pos = CheckClassAdapter.checkChar('L', signature2, pos);
        pos = CheckClassAdapter.checkIdentifier(signature2, pos);
        while (CheckClassAdapter.getChar(signature2, pos) == '/') {
            pos = CheckClassAdapter.checkIdentifier(signature2, pos + 1);
        }
        if (CheckClassAdapter.getChar(signature2, pos) == '<') {
            pos = CheckClassAdapter.checkTypeArguments(signature2, pos);
        }
        while (CheckClassAdapter.getChar(signature2, pos) == '.') {
            if (CheckClassAdapter.getChar(signature2, pos = CheckClassAdapter.checkIdentifier(signature2, pos + 1)) != '<') continue;
            pos = CheckClassAdapter.checkTypeArguments(signature2, pos);
        }
        return CheckClassAdapter.checkChar(';', signature2, pos);
    }

    private static int checkTypeArguments(String signature2, int pos) {
        pos = CheckClassAdapter.checkChar('<', signature2, pos);
        pos = CheckClassAdapter.checkTypeArgument(signature2, pos);
        while (CheckClassAdapter.getChar(signature2, pos) != '>') {
            pos = CheckClassAdapter.checkTypeArgument(signature2, pos);
        }
        return pos + 1;
    }

    private static int checkTypeArgument(String signature2, int pos) {
        char c = CheckClassAdapter.getChar(signature2, pos);
        if (c == '*') {
            return pos + 1;
        }
        if (c == '+' || c == '-') {
            ++pos;
        }
        return CheckClassAdapter.checkFieldTypeSignature(signature2, pos);
    }

    private static int checkTypeVariableSignature(String signature2, int pos) {
        pos = CheckClassAdapter.checkChar('T', signature2, pos);
        pos = CheckClassAdapter.checkIdentifier(signature2, pos);
        return CheckClassAdapter.checkChar(';', signature2, pos);
    }

    private static int checkTypeSignature(String signature2, int pos) {
        switch (CheckClassAdapter.getChar(signature2, pos)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return pos + 1;
            }
        }
        return CheckClassAdapter.checkFieldTypeSignature(signature2, pos);
    }

    private static int checkIdentifier(String signature2, int pos) {
        if (!Character.isJavaIdentifierStart(CheckClassAdapter.getChar(signature2, pos))) {
            throw new IllegalArgumentException(signature2 + ": identifier expected at index " + pos);
        }
        ++pos;
        while (Character.isJavaIdentifierPart(CheckClassAdapter.getChar(signature2, pos))) {
            ++pos;
        }
        return pos;
    }

    private static int checkChar(char c, String signature2, int pos) {
        if (CheckClassAdapter.getChar(signature2, pos) == c) {
            return pos + 1;
        }
        throw new IllegalArgumentException(signature2 + ": '" + c + "' expected at index " + pos);
    }

    private static char getChar(String signature2, int pos) {
        return pos < signature2.length() ? signature2.charAt(pos) : (char)'\u0000';
    }
}

