/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.UnicastProcessor;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableWindow<T>
extends AbstractFlowableWithUpstream<T, Flowable<T>> {
    final long size;
    final long skip;
    final int bufferSize;

    public FlowableWindow(Flowable<T> source, long size, long skip, int bufferSize) {
        super(source);
        this.size = size;
        this.skip = skip;
        this.bufferSize = bufferSize;
    }

    @Override
    public void subscribeActual(Subscriber<? super Flowable<T>> s) {
        if (this.skip == this.size) {
            this.source.subscribe(new WindowExactSubscriber(s, this.size, this.bufferSize));
        } else if (this.skip > this.size) {
            this.source.subscribe(new WindowSkipSubscriber(s, this.size, this.skip, this.bufferSize));
        } else {
            this.source.subscribe(new WindowOverlapSubscriber(s, this.size, this.skip, this.bufferSize));
        }
    }

    static final class WindowOverlapSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = 2428527070996323976L;
        final Subscriber<? super Flowable<T>> downstream;
        final SpscLinkedArrayQueue<UnicastProcessor<T>> queue;
        final long size;
        final long skip;
        final ArrayDeque<UnicastProcessor<T>> windows;
        final AtomicBoolean once;
        final AtomicBoolean firstRequest;
        final AtomicLong requested;
        final AtomicInteger wip;
        final int bufferSize;
        long index;
        long produced;
        Subscription upstream;
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;

        WindowOverlapSubscriber(Subscriber<? super Flowable<T>> actual, long size, long skip, int bufferSize) {
            super(1);
            this.downstream = actual;
            this.size = size;
            this.skip = skip;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.windows = new ArrayDeque();
            this.once = new AtomicBoolean();
            this.firstRequest = new AtomicBoolean();
            this.requested = new AtomicLong();
            this.wip = new AtomicInteger();
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            long i = this.index;
            if (i == 0L && !this.cancelled) {
                this.getAndIncrement();
                UnicastProcessor w = UnicastProcessor.create(this.bufferSize, this);
                this.windows.offer(w);
                this.queue.offer(w);
                this.drain();
            }
            ++i;
            for (Processor processor : this.windows) {
                processor.onNext(t);
            }
            long p = this.produced + 1L;
            if (p == this.size) {
                this.produced = p - this.skip;
                Processor w = this.windows.poll();
                if (w != null) {
                    w.onComplete();
                }
            } else {
                this.produced = p;
            }
            this.index = i == this.skip ? 0L : i;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            for (Processor processor : this.windows) {
                processor.onError(t);
            }
            this.windows.clear();
            this.error = t;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            for (Processor processor : this.windows) {
                processor.onComplete();
            }
            this.windows.clear();
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            Subscriber<Flowable<UnicastProcessor<T>>> a = this.downstream;
            SpscLinkedArrayQueue<UnicastProcessor<T>> q = this.queue;
            int missed = 1;
            do {
                long e;
                long r = this.requested.get();
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    boolean d = this.done;
                    UnicastProcessor<T> t = q.poll();
                    boolean bl = empty = t == null;
                    if (this.checkTerminated(d, empty, a, q)) {
                        return;
                    }
                    if (empty) break;
                    a.onNext(t);
                }
                if (e == r && this.checkTerminated(this.done, q.isEmpty(), a, q)) {
                    return;
                }
                if (e == 0L || r == Long.MAX_VALUE) continue;
                this.requested.addAndGet(-e);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a, SpscLinkedArrayQueue<?> q) {
            if (this.cancelled) {
                q.clear();
                return true;
            }
            if (d) {
                Throwable e = this.error;
                if (e != null) {
                    q.clear();
                    a.onError(e);
                    return true;
                }
                if (empty) {
                    a.onComplete();
                    return true;
                }
            }
            return false;
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                if (!this.firstRequest.get() && this.firstRequest.compareAndSet(false, true)) {
                    long u = BackpressureHelper.multiplyCap(this.skip, n - 1L);
                    long v = BackpressureHelper.addCap(this.size, u);
                    this.upstream.request(v);
                } else {
                    long u = BackpressureHelper.multiplyCap(this.skip, n);
                    this.upstream.request(u);
                }
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            if (this.once.compareAndSet(false, true)) {
                this.run();
            }
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.cancel();
            }
        }
    }

    static final class WindowSkipSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = -8792836352386833856L;
        final Subscriber<? super Flowable<T>> downstream;
        final long size;
        final long skip;
        final AtomicBoolean once;
        final AtomicBoolean firstRequest;
        final int bufferSize;
        long index;
        Subscription upstream;
        UnicastProcessor<T> window;

        WindowSkipSubscriber(Subscriber<? super Flowable<T>> actual, long size, long skip, int bufferSize) {
            super(1);
            this.downstream = actual;
            this.size = size;
            this.skip = skip;
            this.once = new AtomicBoolean();
            this.firstRequest = new AtomicBoolean();
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            long i = this.index;
            UnicastProcessor<T> w = this.window;
            if (i == 0L) {
                this.getAndIncrement();
                w = UnicastProcessor.create(this.bufferSize, this);
                this.window = w;
                this.downstream.onNext(w);
            }
            ++i;
            if (w != null) {
                w.onNext(t);
            }
            if (i == this.size) {
                this.window = null;
                w.onComplete();
            }
            this.index = i == this.skip ? 0L : i;
        }

        @Override
        public void onError(Throwable t) {
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onError(t);
            }
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onComplete();
            }
            this.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                if (!this.firstRequest.get() && this.firstRequest.compareAndSet(false, true)) {
                    long u = BackpressureHelper.multiplyCap(this.size, n);
                    long v = BackpressureHelper.multiplyCap(this.skip - this.size, n - 1L);
                    long w = BackpressureHelper.addCap(u, v);
                    this.upstream.request(w);
                } else {
                    long u = BackpressureHelper.multiplyCap(this.skip, n);
                    this.upstream.request(u);
                }
            }
        }

        @Override
        public void cancel() {
            if (this.once.compareAndSet(false, true)) {
                this.run();
            }
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.cancel();
            }
        }
    }

    static final class WindowExactSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = -2365647875069161133L;
        final Subscriber<? super Flowable<T>> downstream;
        final long size;
        final AtomicBoolean once;
        final int bufferSize;
        long index;
        Subscription upstream;
        UnicastProcessor<T> window;

        WindowExactSubscriber(Subscriber<? super Flowable<T>> actual, long size, int bufferSize) {
            super(1);
            this.downstream = actual;
            this.size = size;
            this.once = new AtomicBoolean();
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            long i = this.index;
            UnicastProcessor<T> w = this.window;
            if (i == 0L) {
                this.getAndIncrement();
                w = UnicastProcessor.create(this.bufferSize, this);
                this.window = w;
                this.downstream.onNext(w);
            }
            w.onNext(t);
            if (++i == this.size) {
                this.index = 0L;
                this.window = null;
                w.onComplete();
            } else {
                this.index = i;
            }
        }

        @Override
        public void onError(Throwable t) {
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onError(t);
            }
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onComplete();
            }
            this.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                long u = BackpressureHelper.multiplyCap(this.size, n);
                this.upstream.request(u);
            }
        }

        @Override
        public void cancel() {
            if (this.once.compareAndSet(false, true)) {
                this.run();
            }
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.cancel();
            }
        }
    }
}

