/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.fuseable.HasUpstreamPublisher;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowablePublish<T>
extends ConnectableFlowable<T>
implements HasUpstreamPublisher<T> {
    static final long CANCELLED = Long.MIN_VALUE;
    final Flowable<T> source;
    final AtomicReference<PublishSubscriber<T>> current;
    final int bufferSize;
    final Publisher<T> onSubscribe;

    public static <T> ConnectableFlowable<T> create(Flowable<T> source, int bufferSize) {
        AtomicReference curr = new AtomicReference();
        FlowablePublisher onSubscribe = new FlowablePublisher(curr, bufferSize);
        return RxJavaPlugins.onAssembly(new FlowablePublish(onSubscribe, source, curr, bufferSize));
    }

    private FlowablePublish(Publisher<T> onSubscribe, Flowable<T> source, AtomicReference<PublishSubscriber<T>> current, int bufferSize) {
        this.onSubscribe = onSubscribe;
        this.source = source;
        this.current = current;
        this.bufferSize = bufferSize;
    }

    @Override
    public Publisher<T> source() {
        return this.source;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.onSubscribe.subscribe(s);
    }

    @Override
    public void connect(Consumer<? super Disposable> connection) {
        PublishSubscriber<T> ps;
        while ((ps = this.current.get()) == null || ps.isDisposed()) {
            PublishSubscriber<T> u = new PublishSubscriber<T>(this.current, this.bufferSize);
            if (!this.current.compareAndSet(ps, u)) continue;
            ps = u;
            break;
        }
        boolean doConnect = !ps.shouldConnect.get() && ps.shouldConnect.compareAndSet(false, true);
        try {
            connection.accept(ps);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        if (doConnect) {
            this.source.subscribe(ps);
        }
    }

    static final class FlowablePublisher<T>
    implements Publisher<T> {
        private final AtomicReference<PublishSubscriber<T>> curr;
        private final int bufferSize;

        FlowablePublisher(AtomicReference<PublishSubscriber<T>> curr, int bufferSize) {
            this.curr = curr;
            this.bufferSize = bufferSize;
        }

        @Override
        public void subscribe(Subscriber<? super T> child) {
            PublishSubscriber<Object> r;
            InnerSubscriber<T> inner = new InnerSubscriber<T>(child);
            child.onSubscribe(inner);
            while (true) {
                if ((r = this.curr.get()) == null || r.isDisposed()) {
                    PublishSubscriber<T> u = new PublishSubscriber<T>(this.curr, this.bufferSize);
                    if (!this.curr.compareAndSet(r, u)) continue;
                    r = u;
                }
                if (r.add(inner)) break;
            }
            if (inner.get() == Long.MIN_VALUE) {
                r.remove(inner);
            } else {
                inner.parent = r;
            }
            r.dispatch();
        }
    }

    static final class InnerSubscriber<T>
    extends AtomicLong
    implements Subscription {
        private static final long serialVersionUID = -4453897557930727610L;
        final Subscriber<? super T> child;
        volatile PublishSubscriber<T> parent;
        long emitted;

        InnerSubscriber(Subscriber<? super T> child) {
            this.child = child;
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.addCancel(this, n);
                PublishSubscriber<T> p = this.parent;
                if (p != null) {
                    p.dispatch();
                }
            }
        }

        @Override
        public void cancel() {
            PublishSubscriber<T> p;
            long r = this.get();
            if (r != Long.MIN_VALUE && (r = this.getAndSet(Long.MIN_VALUE)) != Long.MIN_VALUE && (p = this.parent) != null) {
                p.remove(this);
                p.dispatch();
            }
        }
    }

    static final class PublishSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Disposable {
        private static final long serialVersionUID = -202316842419149694L;
        static final InnerSubscriber[] EMPTY = new InnerSubscriber[0];
        static final InnerSubscriber[] TERMINATED = new InnerSubscriber[0];
        final AtomicReference<PublishSubscriber<T>> current;
        final int bufferSize;
        final AtomicReference<InnerSubscriber<T>[]> subscribers;
        final AtomicBoolean shouldConnect;
        final AtomicReference<Subscription> upstream = new AtomicReference();
        volatile Object terminalEvent;
        int sourceMode;
        volatile SimpleQueue<T> queue;

        PublishSubscriber(AtomicReference<PublishSubscriber<T>> current, int bufferSize) {
            this.subscribers = new AtomicReference<InnerSubscriber[]>(EMPTY);
            this.current = current;
            this.shouldConnect = new AtomicBoolean();
            this.bufferSize = bufferSize;
        }

        @Override
        public void dispose() {
            InnerSubscriber[] ps;
            if (this.subscribers.get() != TERMINATED && (ps = this.subscribers.getAndSet(TERMINATED)) != TERMINATED) {
                this.current.compareAndSet(this, null);
                SubscriptionHelper.cancel(this.upstream);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.subscribers.get() == TERMINATED;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this.upstream, s)) {
                if (s instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s;
                    int m = qs.requestFusion(7);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.terminalEvent = NotificationLite.complete();
                        this.dispatch();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qs;
                        s.request(this.bufferSize);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.bufferSize);
                s.request(this.bufferSize);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.sourceMode == 0 && !this.queue.offer(t)) {
                this.onError(new MissingBackpressureException("Prefetch queue is full?!"));
                return;
            }
            this.dispatch();
        }

        @Override
        public void onError(Throwable e) {
            if (this.terminalEvent == null) {
                this.terminalEvent = NotificationLite.error(e);
                this.dispatch();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (this.terminalEvent == null) {
                this.terminalEvent = NotificationLite.complete();
                this.dispatch();
            }
        }

        boolean add(InnerSubscriber<T> producer) {
            InnerSubscriber[] u;
            InnerSubscriber<T>[] c;
            do {
                if ((c = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int len = c.length;
                u = new InnerSubscriber[len + 1];
                System.arraycopy(c, 0, u, 0, len);
                u[len] = producer;
            } while (!this.subscribers.compareAndSet(c, u));
            return true;
        }

        void remove(InnerSubscriber<T> producer) {
            InnerSubscriber<T>[] c;
            int len;
            while ((len = (c = this.subscribers.get()).length) != 0) {
                InnerSubscriber[] u;
                int j = -1;
                for (int i = 0; i < len; ++i) {
                    if (!c[i].equals(producer)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (len == 1) {
                    u = EMPTY;
                } else {
                    u = new InnerSubscriber[len - 1];
                    System.arraycopy(c, 0, u, 0, j);
                    System.arraycopy(c, j + 1, u, j, len - j - 1);
                }
                if (!this.subscribers.compareAndSet(c, u)) continue;
                break;
            }
        }

        boolean checkTerminated(Object term, boolean empty) {
            if (term != null) {
                if (NotificationLite.isComplete(term)) {
                    if (empty) {
                        this.current.compareAndSet(this, null);
                        for (InnerSubscriber ip : this.subscribers.getAndSet(TERMINATED)) {
                            ip.child.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable t = NotificationLite.getError(term);
                    this.current.compareAndSet(this, null);
                    InnerSubscriber[] a = this.subscribers.getAndSet(TERMINATED);
                    if (a.length != 0) {
                        for (InnerSubscriber ip : a) {
                            ip.child.onError(t);
                        }
                    } else {
                        RxJavaPlugins.onError(t);
                    }
                    return true;
                }
            }
            return false;
        }

        void dispatch() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            AtomicReference<InnerSubscriber<T>[]> subscribers = this.subscribers;
            InnerSubscriber<T>[] ps = subscribers.get();
            block4: while (true) {
                boolean empty;
                Object term = this.terminalEvent;
                SimpleQueue<T> q = this.queue;
                boolean bl = empty = q == null || q.isEmpty();
                if (this.checkTerminated(term, empty)) {
                    return;
                }
                if (!empty) {
                    int len = ps.length;
                    long maxRequested = Long.MAX_VALUE;
                    int cancelled = 0;
                    for (InnerSubscriber<T> ip : ps) {
                        long r = ip.get();
                        if (r != Long.MIN_VALUE) {
                            maxRequested = Math.min(maxRequested, r - ip.emitted);
                            continue;
                        }
                        ++cancelled;
                    }
                    if (len == cancelled) {
                        T v;
                        term = this.terminalEvent;
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.upstream.get().cancel();
                            this.terminalEvent = term = NotificationLite.error(ex);
                            v = null;
                        }
                        if (this.checkTerminated(term, v == null)) {
                            return;
                        }
                        if (this.sourceMode == 1) continue;
                        this.upstream.get().request(1L);
                        continue;
                    }
                    int d = 0;
                    while ((long)d < maxRequested) {
                        T v;
                        term = this.terminalEvent;
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.upstream.get().cancel();
                            this.terminalEvent = term = NotificationLite.error(ex);
                            v = null;
                        }
                        boolean bl2 = empty = v == null;
                        if (this.checkTerminated(term, empty)) {
                            return;
                        }
                        if (empty) break;
                        Object value = NotificationLite.getValue(v);
                        boolean subscribersChanged = false;
                        for (InnerSubscriber<T> ip : ps) {
                            long ipr = ip.get();
                            if (ipr != Long.MIN_VALUE) {
                                if (ipr != Long.MAX_VALUE) {
                                    ++ip.emitted;
                                }
                                ip.child.onNext(value);
                                continue;
                            }
                            subscribersChanged = true;
                        }
                        ++d;
                        InnerSubscriber<T>[] freshArray = subscribers.get();
                        if (!subscribersChanged && freshArray == ps) continue;
                        ps = freshArray;
                        if (d == 0 || this.sourceMode == 1) continue block4;
                        this.upstream.get().request(d);
                        continue block4;
                    }
                    if (d != 0 && this.sourceMode != 1) {
                        this.upstream.get().request(d);
                    }
                    if (maxRequested != 0L && !empty) continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
                ps = subscribers.get();
            }
        }
    }
}

