/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DocCommentTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.AccessLevel;
import lombok.ConfigurationKeys;
import lombok.Data;
import lombok.Getter;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.ReferenceFieldAugment;
import lombok.core.TypeResolver;
import lombok.core.configuration.NullCheckExceptionType;
import lombok.core.handlers.HandlerUtil;
import lombok.delombok.LombokOptionsFactory;
import lombok.experimental.Accessors;
import lombok.javac.Javac;
import lombok.javac.JavacAST;
import lombok.javac.JavacNode;
import lombok.javac.JavacTreeMaker;
import lombok.javac.handlers.HandleGetter;

public class JavacHandlerUtil {
    private static ReferenceFieldAugment<JCTree, JCTree> generatedNodes = ReferenceFieldAugment.augmentWeakField(JCTree.class, JCTree.class, "lombok$generatedNodes");
    private static final Pattern SECTION_FINDER = Pattern.compile("^\\s*\\**\\s*[-*][-*]+\\s*([GS]ETTER|WITHER)\\s*[-*][-*]+\\s*\\**\\s*$", 10);

    private JavacHandlerUtil() {
    }

    public static boolean inNetbeansEditor(JavacNode node) {
        return JavacHandlerUtil.inNetbeansEditor(node.getContext());
    }

    private static boolean inNetbeansEditor(Context context) {
        Options options = Options.instance(context);
        return options.keySet().contains("ide") && !options.keySet().contains("backgroundCompilation");
    }

    public static JCTree getGeneratedBy(JCTree node) {
        return generatedNodes.get(node);
    }

    public static boolean isGenerated(JCTree node) {
        return JavacHandlerUtil.getGeneratedBy(node) != null;
    }

    public static <T extends JCTree> T recursiveSetGeneratedBy(T node, JCTree source, Context context) {
        if (node == null) {
            return null;
        }
        JavacHandlerUtil.setGeneratedBy(node, source, context);
        node.accept(new MarkingScanner(source, context));
        return node;
    }

    public static <T extends JCTree> T setGeneratedBy(T node, JCTree source, Context context) {
        if (node == null) {
            return null;
        }
        if (source == null) {
            generatedNodes.clear(node);
        } else {
            generatedNodes.set(node, source);
        }
        if (source != null && (!JavacHandlerUtil.inNetbeansEditor(context) || node instanceof JCTree.JCVariableDecl && (((JCTree.JCVariableDecl)node).mods.flags & 0x200000000L) != 0L)) {
            node.pos = source.pos;
        }
        return node;
    }

    public static boolean hasAnnotation(Class<? extends Annotation> type, JavacNode node) {
        return JavacHandlerUtil.hasAnnotation(type, node, false);
    }

    public static boolean hasAnnotationAndDeleteIfNeccessary(Class<? extends Annotation> type, JavacNode node) {
        return JavacHandlerUtil.hasAnnotation(type, node, true);
    }

    private static boolean hasAnnotation(Class<? extends Annotation> type, JavacNode node, boolean delete) {
        if (node == null) {
            return false;
        }
        if (type == null) {
            return false;
        }
        switch (node.getKind()) {
            case ARGUMENT: 
            case FIELD: 
            case LOCAL: 
            case TYPE: 
            case METHOD: {
                for (JavacNode child : node.down()) {
                    if (!JavacHandlerUtil.annotationTypeMatches(type, child)) continue;
                    if (delete) {
                        JavacHandlerUtil.deleteAnnotationIfNeccessary(child, type);
                    }
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public static boolean annotationTypeMatches(Class<? extends Annotation> type, JavacNode node) {
        if (node.getKind() != AST.Kind.ANNOTATION) {
            return false;
        }
        return JavacHandlerUtil.typeMatches(type, node, ((JCTree.JCAnnotation)node.get()).annotationType);
    }

    public static boolean typeMatches(Class<?> type, JavacNode node, JCTree typeNode) {
        String typeName = typeNode.toString();
        TypeResolver resolver = new TypeResolver(node.getImportList());
        return resolver.typeMatches(node, type.getName(), typeName);
    }

    public static boolean isFieldDeprecated(JavacNode field) {
        JCTree.JCVariableDecl fieldNode = (JCTree.JCVariableDecl)field.get();
        if ((fieldNode.mods.flags & 0x20000L) != 0L) {
            return true;
        }
        for (JavacNode child : field.down()) {
            if (!JavacHandlerUtil.annotationTypeMatches(Deprecated.class, child)) continue;
            return true;
        }
        return false;
    }

    public static boolean nodeHasDeprecatedFlag(JCTree node) {
        if (node instanceof JCTree.JCVariableDecl) {
            return (((JCTree.JCVariableDecl)node).mods.flags & 0x20000L) != 0L;
        }
        if (node instanceof JCTree.JCMethodDecl) {
            return (((JCTree.JCMethodDecl)node).mods.flags & 0x20000L) != 0L;
        }
        if (node instanceof JCTree.JCClassDecl) {
            return (((JCTree.JCClassDecl)node).mods.flags & 0x20000L) != 0L;
        }
        return false;
    }

    public static <A extends Annotation> AnnotationValues<A> createAnnotation(Class<A> type, final JavacNode node) {
        HashMap<String, AnnotationValues.AnnotationValue> values = new HashMap<String, AnnotationValues.AnnotationValue>();
        JCTree.JCAnnotation anno = (JCTree.JCAnnotation)node.get();
        java.util.List arguments = anno.getArguments();
        for (Method m : type.getDeclaredMethods()) {
            if (!Modifier.isPublic(m.getModifiers())) continue;
            String name = m.getName();
            ArrayList<String> raws = new ArrayList<String>();
            ArrayList<Object> guesses = new ArrayList<Object>();
            ArrayList<JCTree.JCExpression> expressions = new ArrayList<JCTree.JCExpression>();
            final ArrayList<JCDiagnostic.DiagnosticPosition> positions = new ArrayList<JCDiagnostic.DiagnosticPosition>();
            boolean isExplicit = false;
            for (JCTree.JCExpression arg : arguments) {
                JCTree.JCExpression rhs;
                String mName;
                if (arg instanceof JCTree.JCAssign) {
                    JCTree.JCAssign assign = (JCTree.JCAssign)arg;
                    mName = assign.lhs.toString();
                    rhs = assign.rhs;
                } else {
                    rhs = arg;
                    mName = "value";
                }
                if (!mName.equals(name)) continue;
                isExplicit = true;
                if (rhs instanceof JCTree.JCNewArray) {
                    List<JCTree.JCExpression> elems = ((JCTree.JCNewArray)rhs).elems;
                    for (JCTree.JCExpression inner : elems) {
                        raws.add(inner.toString());
                        expressions.add(inner);
                        guesses.add(Javac.calculateGuess(inner));
                        positions.add(inner.pos());
                    }
                    continue;
                }
                raws.add(rhs.toString());
                expressions.add(rhs);
                guesses.add(Javac.calculateGuess(rhs));
                positions.add(rhs.pos());
            }
            values.put(name, new AnnotationValues.AnnotationValue(node, raws, expressions, guesses, isExplicit){

                @Override
                public void setError(String message, int valueIdx) {
                    if (valueIdx < 0) {
                        node.addError(message);
                    } else {
                        node.addError(message, (JCDiagnostic.DiagnosticPosition)positions.get(valueIdx));
                    }
                }

                @Override
                public void setWarning(String message, int valueIdx) {
                    if (valueIdx < 0) {
                        node.addWarning(message);
                    } else {
                        node.addWarning(message, (JCDiagnostic.DiagnosticPosition)positions.get(valueIdx));
                    }
                }
            });
        }
        return new AnnotationValues<A>(type, values, node);
    }

    public static void deleteAnnotationIfNeccessary(JavacNode annotation, Class<? extends Annotation> annotationType) {
        JavacHandlerUtil.deleteAnnotationIfNeccessary0(annotation, annotationType);
    }

    public static void deleteAnnotationIfNeccessary(JavacNode annotation, Class<? extends Annotation> annotationType1, Class<? extends Annotation> annotationType2) {
        JavacHandlerUtil.deleteAnnotationIfNeccessary0(annotation, annotationType1, annotationType2);
    }

    private static void deleteAnnotationIfNeccessary0(JavacNode annotation, Class<? extends Annotation> ... annotationTypes) {
        if (JavacHandlerUtil.inNetbeansEditor(annotation)) {
            return;
        }
        if (!annotation.shouldDeleteLombokAnnotations()) {
            return;
        }
        JavacNode parentNode = (JavacNode)annotation.directUp();
        switch (parentNode.getKind()) {
            case ARGUMENT: 
            case FIELD: 
            case LOCAL: {
                JCTree.JCVariableDecl variable = (JCTree.JCVariableDecl)parentNode.get();
                variable.mods.annotations = JavacHandlerUtil.filterList(variable.mods.annotations, (JCTree)annotation.get());
                break;
            }
            case METHOD: {
                JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)parentNode.get();
                method.mods.annotations = JavacHandlerUtil.filterList(method.mods.annotations, (JCTree)annotation.get());
                break;
            }
            case TYPE: {
                try {
                    JCTree.JCClassDecl type = (JCTree.JCClassDecl)parentNode.get();
                    type.mods.annotations = JavacHandlerUtil.filterList(type.mods.annotations, (JCTree)annotation.get());
                }
                catch (ClassCastException e) {}
                break;
            }
            default: {
                return;
            }
        }
        ((JavacAST)parentNode.getAst()).setChanged();
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            JavacHandlerUtil.deleteImportFromCompilationUnit(annotation, annotationType.getName());
        }
    }

    public static void deleteImportFromCompilationUnit(JavacNode node, String name) {
        if (JavacHandlerUtil.inNetbeansEditor(node)) {
            return;
        }
        if (!node.shouldDeleteLombokAnnotations()) {
            return;
        }
        ListBuffer<JCTree> newDefs = new ListBuffer<JCTree>();
        JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)((JavacNode)node.top()).get();
        for (JCTree def : unit.defs) {
            boolean delete = false;
            if (def instanceof JCTree.JCImport) {
                JCTree.JCImport imp0rt = (JCTree.JCImport)def;
                boolean bl = delete = !imp0rt.staticImport && imp0rt.qualid.toString().equals(name);
            }
            if (delete) continue;
            newDefs.append(def);
        }
        unit.defs = newDefs.toList();
    }

    private static List<JCTree.JCAnnotation> filterList(List<JCTree.JCAnnotation> annotations, JCTree jcTree) {
        ListBuffer<JCTree.JCAnnotation> newAnnotations = new ListBuffer<JCTree.JCAnnotation>();
        for (JCTree.JCAnnotation ann : annotations) {
            if (jcTree == ann) continue;
            newAnnotations.append(ann);
        }
        return newAnnotations.toList();
    }

    public static java.util.List<String> toAllGetterNames(JavacNode field) {
        return HandlerUtil.toAllGetterNames(field.getAst(), JavacHandlerUtil.getAccessorsForField(field), field.getName(), JavacHandlerUtil.isBoolean(field));
    }

    public static String toGetterName(JavacNode field) {
        return HandlerUtil.toGetterName(field.getAst(), JavacHandlerUtil.getAccessorsForField(field), field.getName(), JavacHandlerUtil.isBoolean(field));
    }

    public static java.util.List<String> toAllSetterNames(JavacNode field) {
        return HandlerUtil.toAllSetterNames(field.getAst(), JavacHandlerUtil.getAccessorsForField(field), field.getName(), JavacHandlerUtil.isBoolean(field));
    }

    public static String toSetterName(JavacNode field) {
        return HandlerUtil.toSetterName(field.getAst(), JavacHandlerUtil.getAccessorsForField(field), field.getName(), JavacHandlerUtil.isBoolean(field));
    }

    public static java.util.List<String> toAllWitherNames(JavacNode field) {
        return HandlerUtil.toAllWitherNames(field.getAst(), JavacHandlerUtil.getAccessorsForField(field), field.getName(), JavacHandlerUtil.isBoolean(field));
    }

    public static String toWitherName(JavacNode field) {
        return HandlerUtil.toWitherName(field.getAst(), JavacHandlerUtil.getAccessorsForField(field), field.getName(), JavacHandlerUtil.isBoolean(field));
    }

    public static boolean shouldReturnThis(JavacNode field) {
        if ((((JCTree.JCVariableDecl)field.get()).mods.flags & 8L) != 0L) {
            return false;
        }
        AnnotationValues<Accessors> accessors = JavacHandlerUtil.getAccessorsForField(field);
        return HandlerUtil.shouldReturnThis0(accessors, field.getAst());
    }

    public static JCTree.JCExpression cloneSelfType(JavacNode field) {
        JavacNode typeNode;
        JavacTreeMaker maker = field.getTreeMaker();
        for (typeNode = field; typeNode != null && typeNode.getKind() != AST.Kind.TYPE; typeNode = (JavacNode)typeNode.up()) {
        }
        if (typeNode != null && typeNode.get() instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl type = (JCTree.JCClassDecl)typeNode.get();
            ListBuffer<JCTree.JCIdent> typeArgs = new ListBuffer<JCTree.JCIdent>();
            if (!type.typarams.isEmpty()) {
                for (JCTree.JCTypeParameter tp : type.typarams) {
                    typeArgs.append(maker.Ident(tp.name));
                }
                return maker.TypeApply(maker.Ident(type.name), typeArgs.toList());
            }
            return maker.Ident(type.name);
        }
        return null;
    }

    public static boolean isBoolean(JavacNode field) {
        JCTree.JCExpression varType = ((JCTree.JCVariableDecl)field.get()).vartype;
        return JavacHandlerUtil.isBoolean(varType);
    }

    public static boolean isBoolean(JCTree.JCExpression varType) {
        return varType != null && varType.toString().equals("boolean");
    }

    public static Name removePrefixFromField(JavacNode field) {
        CharSequence newName;
        java.util.List<String> prefixes = null;
        for (JavacNode node : field.down()) {
            if (!JavacHandlerUtil.annotationTypeMatches(Accessors.class, node)) continue;
            AnnotationValues<Accessors> ann = JavacHandlerUtil.createAnnotation(Accessors.class, node);
            if (!ann.isExplicit("prefix")) break;
            prefixes = Arrays.asList(ann.getInstance().prefix());
            break;
        }
        if (prefixes == null) {
            block1: for (JavacNode current = (JavacNode)field.up(); current != null; current = (JavacNode)current.up()) {
                for (JavacNode node : current.down()) {
                    if (!JavacHandlerUtil.annotationTypeMatches(Accessors.class, node)) continue;
                    AnnotationValues<Accessors> ann = JavacHandlerUtil.createAnnotation(Accessors.class, node);
                    if (!ann.isExplicit("prefix")) break block1;
                    prefixes = Arrays.asList(ann.getInstance().prefix());
                    break block1;
                }
            }
        }
        if (prefixes == null) {
            prefixes = ((JavacAST)field.getAst()).readConfiguration(ConfigurationKeys.ACCESSORS_PREFIX);
        }
        if (!prefixes.isEmpty() && (newName = HandlerUtil.removePrefix(field.getName(), prefixes)) != null) {
            return field.toName(newName.toString());
        }
        return ((JCTree.JCVariableDecl)field.get()).name;
    }

    public static AnnotationValues<Accessors> getAccessorsForField(JavacNode field) {
        for (JavacNode node : field.down()) {
            if (!JavacHandlerUtil.annotationTypeMatches(Accessors.class, node)) continue;
            return JavacHandlerUtil.createAnnotation(Accessors.class, node);
        }
        for (JavacNode current = (JavacNode)field.up(); current != null; current = (JavacNode)current.up()) {
            for (JavacNode node : current.down()) {
                if (!JavacHandlerUtil.annotationTypeMatches(Accessors.class, node)) continue;
                return JavacHandlerUtil.createAnnotation(Accessors.class, node);
            }
        }
        return AnnotationValues.of(Accessors.class, field);
    }

    public static MemberExistsResult fieldExists(String fieldName, JavacNode node) {
        if ((node = JavacHandlerUtil.upToTypeNode(node)) != null && node.get() instanceof JCTree.JCClassDecl) {
            for (JCTree def : ((JCTree.JCClassDecl)node.get()).defs) {
                if (!(def instanceof JCTree.JCVariableDecl) || !((JCTree.JCVariableDecl)def).name.contentEquals(fieldName)) continue;
                return JavacHandlerUtil.getGeneratedBy(def) == null ? MemberExistsResult.EXISTS_BY_USER : MemberExistsResult.EXISTS_BY_LOMBOK;
            }
        }
        return MemberExistsResult.NOT_EXISTS;
    }

    public static MemberExistsResult methodExists(String methodName, JavacNode node, int params) {
        return JavacHandlerUtil.methodExists(methodName, node, true, params);
    }

    public static MemberExistsResult methodExists(String methodName, JavacNode node, boolean caseSensitive, int params) {
        if ((node = JavacHandlerUtil.upToTypeNode(node)) != null && node.get() instanceof JCTree.JCClassDecl) {
            for (JCTree def : ((JCTree.JCClassDecl)node.get()).defs) {
                if (!(def instanceof JCTree.JCMethodDecl)) continue;
                JCTree.JCMethodDecl md = (JCTree.JCMethodDecl)def;
                String name = md.name.toString();
                boolean matches = caseSensitive ? name.equals(methodName) : name.equalsIgnoreCase(methodName);
                if (!matches) continue;
                if (params > -1) {
                    List<JCTree.JCVariableDecl> ps = md.params;
                    int minArgs = 0;
                    int maxArgs = 0;
                    if (ps != null && ps.length() > 0) {
                        minArgs = ps.length();
                        if ((ps.last().mods.flags & 0x400000000L) != 0L) {
                            maxArgs = Integer.MAX_VALUE;
                            --minArgs;
                        } else {
                            maxArgs = minArgs;
                        }
                    }
                    if (params < minArgs || params > maxArgs) continue;
                }
                return JavacHandlerUtil.getGeneratedBy(def) == null ? MemberExistsResult.EXISTS_BY_USER : MemberExistsResult.EXISTS_BY_LOMBOK;
            }
        }
        return MemberExistsResult.NOT_EXISTS;
    }

    public static MemberExistsResult constructorExists(JavacNode node) {
        if ((node = JavacHandlerUtil.upToTypeNode(node)) != null && node.get() instanceof JCTree.JCClassDecl) {
            for (JCTree def : ((JCTree.JCClassDecl)node.get()).defs) {
                if (!(def instanceof JCTree.JCMethodDecl) || !((JCTree.JCMethodDecl)def).name.contentEquals("<init>") || (((JCTree.JCMethodDecl)def).mods.flags & 0x1000000000L) != 0L) continue;
                return JavacHandlerUtil.getGeneratedBy(def) == null ? MemberExistsResult.EXISTS_BY_USER : MemberExistsResult.EXISTS_BY_LOMBOK;
            }
        }
        return MemberExistsResult.NOT_EXISTS;
    }

    public static boolean isConstructorCall(JCTree.JCStatement statement) {
        if (!(statement instanceof JCTree.JCExpressionStatement)) {
            return false;
        }
        JCTree.JCExpression expr = ((JCTree.JCExpressionStatement)statement).expr;
        if (!(expr instanceof JCTree.JCMethodInvocation)) {
            return false;
        }
        JCTree.JCExpression invocation = ((JCTree.JCMethodInvocation)expr).meth;
        String name = invocation instanceof JCTree.JCFieldAccess ? ((JCTree.JCFieldAccess)invocation).name.toString() : (invocation instanceof JCTree.JCIdent ? ((JCTree.JCIdent)invocation).name.toString() : "");
        return "super".equals(name) || "this".equals(name);
    }

    public static int toJavacModifier(AccessLevel accessLevel) {
        switch (accessLevel) {
            case MODULE: 
            case PACKAGE: {
                return 0;
            }
            default: {
                return 1;
            }
            case NONE: 
            case PRIVATE: {
                return 2;
            }
            case PROTECTED: 
        }
        return 4;
    }

    private static GetterMethod findGetter(JavacNode field) {
        JavacNode containingType;
        JCTree.JCVariableDecl decl = (JCTree.JCVariableDecl)field.get();
        JavacNode typeNode = (JavacNode)field.up();
        for (String potentialGetterName : JavacHandlerUtil.toAllGetterNames(field)) {
            for (JavacNode potentialGetter : typeNode.down()) {
                if (potentialGetter.getKind() != AST.Kind.METHOD) continue;
                JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)potentialGetter.get();
                if (!method.name.toString().equalsIgnoreCase(potentialGetterName) || (method.mods.flags & 8L) != 0L || method.params != null && method.params.size() > 0) continue;
                return new GetterMethod(method.name, method.restype);
            }
        }
        boolean hasGetterAnnotation = false;
        for (JavacNode child : field.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !JavacHandlerUtil.annotationTypeMatches(Getter.class, child)) continue;
            AnnotationValues<Getter> ann = JavacHandlerUtil.createAnnotation(Getter.class, child);
            if (ann.getInstance().value() == AccessLevel.NONE) {
                return null;
            }
            hasGetterAnnotation = true;
        }
        if (!hasGetterAnnotation && new HandleGetter().fieldQualifiesForGetterGeneration(field) && (containingType = (JavacNode)field.up()) != null) {
            for (JavacNode child : containingType.down()) {
                if (child.getKind() == AST.Kind.ANNOTATION && JavacHandlerUtil.annotationTypeMatches(Data.class, child)) {
                    hasGetterAnnotation = true;
                }
                if (child.getKind() != AST.Kind.ANNOTATION || !JavacHandlerUtil.annotationTypeMatches(Getter.class, child)) continue;
                AnnotationValues<Getter> ann = JavacHandlerUtil.createAnnotation(Getter.class, child);
                if (ann.getInstance().value() == AccessLevel.NONE) {
                    return null;
                }
                hasGetterAnnotation = true;
            }
        }
        if (hasGetterAnnotation) {
            String getterName = JavacHandlerUtil.toGetterName(field);
            if (getterName == null) {
                return null;
            }
            return new GetterMethod(field.toName(getterName), decl.vartype);
        }
        return null;
    }

    static boolean lookForGetter(JavacNode field, FieldAccess fieldAccess) {
        if (fieldAccess == FieldAccess.GETTER) {
            return true;
        }
        if (fieldAccess == FieldAccess.ALWAYS_FIELD) {
            return false;
        }
        for (JavacNode child : field.down()) {
            AnnotationValues<Getter> ann;
            if (child.getKind() != AST.Kind.ANNOTATION || !JavacHandlerUtil.annotationTypeMatches(Getter.class, child) || !(ann = JavacHandlerUtil.createAnnotation(Getter.class, child)).getInstance().lazy()) continue;
            return true;
        }
        return false;
    }

    static JCTree.JCExpression getFieldType(JavacNode field, FieldAccess fieldAccess) {
        GetterMethod getter;
        boolean lookForGetter = JavacHandlerUtil.lookForGetter(field, fieldAccess);
        GetterMethod getterMethod = getter = lookForGetter ? JavacHandlerUtil.findGetter(field) : null;
        if (getter == null) {
            return ((JCTree.JCVariableDecl)field.get()).vartype;
        }
        return getter.type;
    }

    static JCTree.JCExpression createFieldAccessor(JavacTreeMaker maker, JavacNode field, FieldAccess fieldAccess) {
        return JavacHandlerUtil.createFieldAccessor(maker, field, fieldAccess, null);
    }

    static JCTree.JCExpression createFieldAccessor(JavacTreeMaker maker, JavacNode field, FieldAccess fieldAccess, JCTree.JCExpression receiver) {
        boolean lookForGetter = JavacHandlerUtil.lookForGetter(field, fieldAccess);
        GetterMethod getter = lookForGetter ? JavacHandlerUtil.findGetter(field) : null;
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)field.get();
        if (getter == null) {
            if (receiver == null) {
                if ((fieldDecl.mods.flags & 8L) == 0L) {
                    receiver = maker.Ident(field.toName("this"));
                } else {
                    JavacNode containerNode = (JavacNode)field.up();
                    if (containerNode != null && containerNode.get() instanceof JCTree.JCClassDecl) {
                        JCTree.JCClassDecl container = (JCTree.JCClassDecl)((JavacNode)field.up()).get();
                        receiver = maker.Ident(container.name);
                    }
                }
            }
            return receiver == null ? maker.Ident(fieldDecl.name) : maker.Select(receiver, fieldDecl.name);
        }
        if (receiver == null) {
            receiver = maker.Ident(field.toName("this"));
        }
        JCTree.JCMethodInvocation call = maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select(receiver, getter.name), List.<JCTree.JCExpression>nil());
        return call;
    }

    public static void injectFieldSuppressWarnings(JavacNode typeNode, JCTree.JCVariableDecl field) {
        JavacHandlerUtil.injectField(typeNode, field, true);
    }

    public static JavacNode injectField(JavacNode typeNode, JCTree.JCVariableDecl field) {
        return JavacHandlerUtil.injectField(typeNode, field, false);
    }

    private static JavacNode injectField(JavacNode typeNode, JCTree.JCVariableDecl field, boolean addSuppressWarnings) {
        JCTree.JCVariableDecl f;
        JCTree.JCClassDecl type = (JCTree.JCClassDecl)typeNode.get();
        if (addSuppressWarnings) {
            JavacHandlerUtil.addSuppressWarningsAll(field.mods, typeNode, field.pos, JavacHandlerUtil.getGeneratedBy(field), typeNode.getContext());
        }
        List<JCTree> insertAfter = null;
        List<JCTree> insertBefore = type.defs;
        while (insertBefore.tail != null && insertBefore.head instanceof JCTree.JCVariableDecl && (JavacHandlerUtil.isEnumConstant(f = (JCTree.JCVariableDecl)insertBefore.head) || JavacHandlerUtil.isGenerated(f))) {
            insertAfter = insertBefore;
            insertBefore = insertBefore.tail;
        }
        List<JCTree.JCVariableDecl> fieldEntry = List.of(field);
        fieldEntry.tail = insertBefore;
        if (insertAfter == null) {
            type.defs = fieldEntry;
        } else {
            insertAfter.tail = fieldEntry;
        }
        return (JavacNode)typeNode.add(field, AST.Kind.FIELD);
    }

    public static boolean isEnumConstant(JCTree.JCVariableDecl field) {
        return (field.mods.flags & 0x4000L) != 0L;
    }

    public static void injectMethod(JavacNode typeNode, JCTree.JCMethodDecl method) {
        JCTree.JCClassDecl type = (JCTree.JCClassDecl)typeNode.get();
        if (method.getName().contentEquals("<init>")) {
            int idx = 0;
            for (JCTree def : type.defs) {
                if (def instanceof JCTree.JCMethodDecl && (((JCTree.JCMethodDecl)def).mods.flags & 0x1000000000L) != 0L) {
                    JavacNode tossMe = (JavacNode)typeNode.getNodeFor(def);
                    if (tossMe != null) {
                        ((JavacNode)tossMe.up()).removeChild(tossMe);
                    }
                    type.defs = JavacHandlerUtil.addAllButOne(type.defs, idx);
                    if (type.sym == null || type.sym.members_field == null) break;
                    type.sym.members_field.remove(((JCTree.JCMethodDecl)def).sym);
                    break;
                }
                ++idx;
            }
        }
        JavacHandlerUtil.addSuppressWarningsAll(method.mods, typeNode, method.pos, JavacHandlerUtil.getGeneratedBy(method), typeNode.getContext());
        type.defs = type.defs.append(method);
        typeNode.add(method, AST.Kind.METHOD);
    }

    public static JavacNode injectType(JavacNode typeNode, JCTree.JCClassDecl type) {
        JCTree.JCClassDecl typeDecl = (JCTree.JCClassDecl)typeNode.get();
        JavacHandlerUtil.addSuppressWarningsAll(type.mods, typeNode, type.pos, JavacHandlerUtil.getGeneratedBy(type), typeNode.getContext());
        typeDecl.defs = typeDecl.defs.append(type);
        return (JavacNode)typeNode.add(type, AST.Kind.TYPE);
    }

    public static long addFinalIfNeeded(long flags, Context context) {
        boolean addFinal = LombokOptionsFactory.getDelombokOptions(context).getFormatPreferences().generateFinalParams();
        if (addFinal) {
            flags |= 0x10L;
        }
        return flags;
    }

    public static JCTree.JCExpression genTypeRef(JavacNode node, String complexName) {
        String[] parts = complexName.split("\\.");
        if (parts.length > 2 && parts[0].equals("java") && parts[1].equals("lang")) {
            String[] subParts = new String[parts.length - 2];
            System.arraycopy(parts, 2, subParts, 0, subParts.length);
            return JavacHandlerUtil.genJavaLangTypeRef(node, subParts);
        }
        return JavacHandlerUtil.chainDots(node, parts);
    }

    public static JCTree.JCExpression genJavaLangTypeRef(JavacNode node, String ... simpleNames) {
        if (LombokOptionsFactory.getDelombokOptions(node.getContext()).getFormatPreferences().javaLangAsFqn()) {
            return JavacHandlerUtil.chainDots(node, "java", "lang", simpleNames);
        }
        return JavacHandlerUtil.chainDots(node, null, null, simpleNames);
    }

    public static JCTree.JCExpression genJavaLangTypeRef(JavacNode node, int pos, String ... simpleNames) {
        if (LombokOptionsFactory.getDelombokOptions(node.getContext()).getFormatPreferences().javaLangAsFqn()) {
            return JavacHandlerUtil.chainDots(node, pos, "java", "lang", simpleNames);
        }
        return JavacHandlerUtil.chainDots(node, pos, null, null, simpleNames);
    }

    public static void addSuppressWarningsAll(JCTree.JCModifiers mods, JavacNode node, int pos, JCTree source, Context context) {
        if (!LombokOptionsFactory.getDelombokOptions(context).getFormatPreferences().generateSuppressWarnings()) {
            return;
        }
        for (JCTree.JCAnnotation ann : mods.annotations) {
            JCTree annType = ann.getAnnotationType();
            Name lastPart = null;
            if (annType instanceof JCTree.JCIdent) {
                lastPart = ((JCTree.JCIdent)annType).name;
            } else if (annType instanceof JCTree.JCFieldAccess) {
                lastPart = ((JCTree.JCFieldAccess)annType).name;
            }
            if (lastPart == null || !lastPart.contentEquals("SuppressWarnings")) continue;
            return;
        }
        JavacTreeMaker maker = node.getTreeMaker();
        JCTree.JCExpression suppressWarningsType = JavacHandlerUtil.genJavaLangTypeRef(node, "SuppressWarnings");
        JCTree.JCLiteral allLiteral = maker.Literal("all");
        suppressWarningsType.pos = pos;
        allLiteral.pos = pos;
        JCTree.JCAnnotation annotation = JavacHandlerUtil.recursiveSetGeneratedBy(maker.Annotation(suppressWarningsType, List.of(allLiteral)), source, context);
        annotation.pos = pos;
        mods.annotations = mods.annotations.append(annotation);
    }

    private static List<JCTree> addAllButOne(List<JCTree> defs, int idx) {
        ListBuffer<JCTree> out = new ListBuffer<JCTree>();
        int i = 0;
        for (JCTree def : defs) {
            if (i++ == idx) continue;
            out.append(def);
        }
        return out.toList();
    }

    public static JCTree.JCExpression chainDots(JavacNode node, String elem1, String elem2, String ... elems) {
        return JavacHandlerUtil.chainDots(node, -1, elem1, elem2, elems);
    }

    public static JCTree.JCExpression chainDots(JavacNode node, String[] elems) {
        return JavacHandlerUtil.chainDots(node, -1, null, null, elems);
    }

    public static JCTree.JCExpression chainDots(JavacNode node, int pos, String elem1, String elem2, String ... elems) {
        assert (elems != null);
        JavacTreeMaker maker = node.getTreeMaker();
        if (pos != -1) {
            maker = maker.at(pos);
        }
        JCTree.JCIdent e = null;
        if (elem1 != null) {
            e = maker.Ident(node.toName(elem1));
        }
        if (elem2 != null) {
            e = e == null ? maker.Ident(node.toName(elem2)) : maker.Select(e, node.toName(elem2));
        }
        for (int i = 0; i < elems.length; ++i) {
            e = e == null ? maker.Ident(node.toName(elems[i])) : maker.Select(e, node.toName(elems[i]));
        }
        assert (e != null);
        return e;
    }

    public static JCTree.JCExpression chainDotsString(JavacNode node, String elems) {
        return JavacHandlerUtil.chainDots(node, null, null, elems.split("\\."));
    }

    public static List<JCTree.JCAnnotation> findAnnotations(JavacNode fieldNode, Pattern namePattern) {
        ListBuffer<JCTree.JCAnnotation> result = new ListBuffer<JCTree.JCAnnotation>();
        for (JavacNode child : fieldNode.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION) continue;
            JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)child.get();
            String name = annotation.annotationType.toString();
            int idx = name.lastIndexOf(".");
            String suspect = idx == -1 ? name : name.substring(idx + 1);
            if (!namePattern.matcher(suspect).matches()) continue;
            result.append(annotation);
        }
        return result.toList();
    }

    public static JCTree.JCStatement generateNullCheck(JavacTreeMaker maker, JavacNode variable, JavacNode source) {
        NullCheckExceptionType exceptionType = ((JavacAST)source.getAst()).readConfiguration(ConfigurationKeys.NON_NULL_EXCEPTION_TYPE);
        if (exceptionType == null) {
            exceptionType = NullCheckExceptionType.NULL_POINTER_EXCEPTION;
        }
        JCTree.JCVariableDecl varDecl = (JCTree.JCVariableDecl)variable.get();
        if (Javac.isPrimitive(varDecl.vartype)) {
            return null;
        }
        Name fieldName = varDecl.name;
        JCTree.JCExpression exType = JavacHandlerUtil.genTypeRef(variable, exceptionType.getExceptionType());
        JCTree.JCNewClass exception = maker.NewClass(null, List.<JCTree.JCExpression>nil(), exType, List.of(maker.Literal(exceptionType.toExceptionMessage(fieldName.toString()))), null);
        JCTree.JCThrow throwStatement = maker.Throw(exception);
        JCTree.JCBlock throwBlock = maker.Block(0L, List.of(throwStatement));
        return maker.If(maker.Binary(Javac.CTC_EQUAL, maker.Ident(fieldName), maker.Literal(Javac.CTC_BOT, null)), throwBlock, null);
    }

    public static List<Integer> createListOfNonExistentFields(List<String> list, JavacNode type, boolean excludeStandard, boolean excludeTransient) {
        boolean[] matched = new boolean[list.size()];
        for (JavacNode child : type.down()) {
            int idx;
            if (list.isEmpty()) break;
            if (child.getKind() != AST.Kind.FIELD) continue;
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)child.get();
            if (excludeStandard && ((field.mods.flags & 8L) != 0L || field.name.toString().startsWith("$")) || excludeTransient && (field.mods.flags & 0x80L) != 0L || (idx = list.indexOf(child.getName())) <= -1) continue;
            matched[idx] = true;
        }
        ListBuffer<Integer> problematic = new ListBuffer<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            if (matched[i]) continue;
            problematic.append(i);
        }
        return problematic.toList();
    }

    static List<JCTree.JCAnnotation> unboxAndRemoveAnnotationParameter(JCTree.JCAnnotation ast, String parameterName, String errorName, JavacNode annotationNode) {
        ListBuffer<JCTree.JCExpression> params = new ListBuffer<JCTree.JCExpression>();
        ListBuffer<JCTree.JCAnnotation> result = new ListBuffer<JCTree.JCAnnotation>();
        try {
            for (JCTree.JCExpression arg : ast.args) {
                String argName = "value";
                if (arg instanceof JCTree.JCAssign) {
                    JCTree.JCAssign as = (JCTree.JCAssign)arg;
                    argName = as.lhs.toString();
                }
                if (argName.equals(parameterName)) continue;
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        block3: for (JCTree.JCExpression param : ast.args) {
            String nameOfParam = "value";
            JCTree.JCExpression valueOfParam = null;
            if (param instanceof JCTree.JCAssign) {
                JCTree.JCAssign assign = (JCTree.JCAssign)param;
                if (assign.lhs instanceof JCTree.JCIdent) {
                    JCTree.JCIdent ident = (JCTree.JCIdent)assign.lhs;
                    nameOfParam = ident.name.toString();
                }
                valueOfParam = assign.rhs;
            }
            if (!parameterName.equals(nameOfParam)) {
                params.append(param);
                continue;
            }
            int endPos = Javac.getEndPosition(param.pos(), (JCTree.JCCompilationUnit)((JavacNode)annotationNode.top()).get());
            ((JavacAST)annotationNode.getAst()).removeFromDeferredDiagnostics(param.pos, endPos);
            if (valueOfParam instanceof JCTree.JCAnnotation) {
                String dummyAnnotationName = ((JCTree.JCAnnotation)valueOfParam).annotationType.toString();
                if ((dummyAnnotationName = dummyAnnotationName.replace("_", "").replace("$", "").replace("x", "").replace("X", "")).length() > 0) {
                    annotationNode.addError("The correct format is " + errorName + "@__({@SomeAnnotation, @SomeOtherAnnotation}))");
                    continue;
                }
                for (JCTree.JCExpression expr : ((JCTree.JCAnnotation)valueOfParam).args) {
                    if (expr instanceof JCTree.JCAssign && ((JCTree.JCAssign)expr).lhs instanceof JCTree.JCIdent) {
                        JCTree.JCIdent id = (JCTree.JCIdent)((JCTree.JCAssign)expr).lhs;
                        if ("value".equals(id.name.toString())) {
                            expr = ((JCTree.JCAssign)expr).rhs;
                        } else {
                            annotationNode.addError("The correct format is " + errorName + "@__({@SomeAnnotation, @SomeOtherAnnotation}))");
                            continue block3;
                        }
                    }
                    if (expr instanceof JCTree.JCAnnotation) {
                        result.append((JCTree.JCAnnotation)expr);
                        continue;
                    }
                    if (expr instanceof JCTree.JCNewArray) {
                        for (JCTree.JCExpression expr2 : ((JCTree.JCNewArray)expr).elems) {
                            if (expr2 instanceof JCTree.JCAnnotation) {
                                result.append((JCTree.JCAnnotation)expr2);
                                continue;
                            }
                            annotationNode.addError("The correct format is " + errorName + "@__({@SomeAnnotation, @SomeOtherAnnotation}))");
                            continue block3;
                        }
                        continue;
                    }
                    annotationNode.addError("The correct format is " + errorName + "@__({@SomeAnnotation, @SomeOtherAnnotation}))");
                    continue block3;
                }
                continue;
            }
            if (valueOfParam instanceof JCTree.JCNewArray && ((JCTree.JCNewArray)valueOfParam).elems.isEmpty()) continue;
            annotationNode.addError("The correct format is " + errorName + "@__({@SomeAnnotation, @SomeOtherAnnotation}))");
        }
        ast.args = params.toList();
        return result.toList();
    }

    public static List<JCTree.JCTypeParameter> copyTypeParams(JavacTreeMaker maker, List<JCTree.JCTypeParameter> params) {
        if (params == null || params.isEmpty()) {
            return params;
        }
        ListBuffer<JCTree.JCTypeParameter> out = new ListBuffer<JCTree.JCTypeParameter>();
        for (JCTree.JCTypeParameter tp : params) {
            out.append(maker.TypeParameter(tp.name, tp.bounds));
        }
        return out.toList();
    }

    public static JCTree.JCExpression namePlusTypeParamsToTypeReference(JavacTreeMaker maker, Name typeName, List<JCTree.JCTypeParameter> params) {
        ListBuffer<JCTree.JCIdent> typeArgs = new ListBuffer<JCTree.JCIdent>();
        if (!params.isEmpty()) {
            for (JCTree.JCTypeParameter param : params) {
                typeArgs.append(maker.Ident(param.name));
            }
            return maker.TypeApply(maker.Ident(typeName), typeArgs.toList());
        }
        return maker.Ident(typeName);
    }

    public static void sanityCheckForMethodGeneratingAnnotationsOnBuilderClass(JavacNode typeNode, JavacNode errorNode) {
        List<String> disallowed = List.nil();
        for (JavacNode child : typeNode.down()) {
            for (Class<? extends Annotation> annType : HandlerUtil.INVALID_ON_BUILDERS) {
                if (!JavacHandlerUtil.annotationTypeMatches(annType, child)) continue;
                disallowed = disallowed.append(annType.getSimpleName());
            }
        }
        int size = disallowed.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            errorNode.addError("@" + (String)disallowed.head + " is not allowed on builder classes.");
            return;
        }
        StringBuilder out = new StringBuilder();
        for (String a : disallowed) {
            out.append("@").append(a).append(", ");
        }
        out.setLength(out.length() - 2);
        errorNode.addError(out.append(" are not allowed on builder classes.").toString());
    }

    static List<JCTree.JCAnnotation> copyAnnotations(List<? extends JCTree.JCExpression> in) {
        ListBuffer<JCTree.JCAnnotation> out = new ListBuffer<JCTree.JCAnnotation>();
        for (JCTree.JCExpression jCExpression : in) {
            if (!(jCExpression instanceof JCTree.JCAnnotation)) continue;
            out.append((JCTree.JCAnnotation)jCExpression.clone());
        }
        return out.toList();
    }

    static boolean isClass(JavacNode typeNode) {
        return JavacHandlerUtil.isClassAndDoesNotHaveFlags(typeNode, 25088);
    }

    static boolean isClassOrEnum(JavacNode typeNode) {
        return JavacHandlerUtil.isClassAndDoesNotHaveFlags(typeNode, 8704);
    }

    public static boolean isClassAndDoesNotHaveFlags(JavacNode typeNode, int flags) {
        JCTree.JCClassDecl typeDecl = null;
        if (!(typeNode.get() instanceof JCTree.JCClassDecl)) {
            return false;
        }
        typeDecl = (JCTree.JCClassDecl)typeNode.get();
        long typeDeclflags = typeDecl == null ? 0L : typeDecl.mods.flags;
        return (typeDeclflags & (long)flags) == 0L;
    }

    public static JavacNode upToTypeNode(JavacNode node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        while (node != null && !(node.get() instanceof JCTree.JCClassDecl)) {
            node = (JavacNode)node.up();
        }
        return node;
    }

    public static JCTree.JCExpression cloneType(JavacTreeMaker maker, JCTree.JCExpression in, JCTree source, Context context) {
        JCTree.JCExpression out = JavacHandlerUtil.cloneType0(maker, in);
        if (out != null) {
            JavacHandlerUtil.recursiveSetGeneratedBy(out, source, context);
        }
        return out;
    }

    private static JCTree.JCExpression cloneType0(JavacTreeMaker maker, JCTree in) {
        if (in == null) {
            return null;
        }
        if (in instanceof JCTree.JCPrimitiveTypeTree) {
            return (JCTree.JCExpression)in;
        }
        if (in instanceof JCTree.JCIdent) {
            return maker.Ident(((JCTree.JCIdent)in).name);
        }
        if (in instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fa = (JCTree.JCFieldAccess)in;
            return maker.Select(JavacHandlerUtil.cloneType0(maker, fa.selected), fa.name);
        }
        if (in instanceof JCTree.JCArrayTypeTree) {
            JCTree.JCArrayTypeTree att = (JCTree.JCArrayTypeTree)in;
            return maker.TypeArray(JavacHandlerUtil.cloneType0(maker, att.elemtype));
        }
        if (in instanceof JCTree.JCTypeApply) {
            JCTree.JCTypeApply ta = (JCTree.JCTypeApply)in;
            ListBuffer<JCTree.JCExpression> lb = new ListBuffer<JCTree.JCExpression>();
            for (JCTree.JCExpression typeArg : ta.arguments) {
                lb.append(JavacHandlerUtil.cloneType0(maker, typeArg));
            }
            return maker.TypeApply(JavacHandlerUtil.cloneType0(maker, ta.clazz), lb.toList());
        }
        if (in instanceof JCTree.JCWildcard) {
            JCTree.TypeBoundKind newKind;
            JCTree.JCWildcard w = (JCTree.JCWildcard)in;
            JCTree.JCExpression newInner = JavacHandlerUtil.cloneType0(maker, w.inner);
            switch (w.getKind()) {
                case SUPER_WILDCARD: {
                    newKind = maker.TypeBoundKind(BoundKind.SUPER);
                    break;
                }
                case EXTENDS_WILDCARD: {
                    newKind = maker.TypeBoundKind(BoundKind.EXTENDS);
                    break;
                }
                default: {
                    newKind = maker.TypeBoundKind(BoundKind.UNBOUND);
                }
            }
            return maker.Wildcard(newKind, newInner);
        }
        return (JCTree.JCExpression)in;
    }

    public static String stripLinesWithTagFromJavadoc(String javadoc, String regexpFragment) {
        Pattern p = Pattern.compile("^\\s*\\**\\s*" + regexpFragment + "\\s*\\**\\s*$", 10);
        Matcher m = p.matcher(javadoc);
        return m.replaceAll("");
    }

    public static String stripSectionsFromJavadoc(String javadoc) {
        Matcher m = SECTION_FINDER.matcher(javadoc);
        if (!m.find()) {
            return javadoc;
        }
        return javadoc.substring(0, m.start());
    }

    public static String[] splitJavadocOnSectionIfPresent(String javadoc, String sectionName) {
        Matcher m = SECTION_FINDER.matcher(javadoc);
        int getterSectionHeaderStart = -1;
        int getterSectionStart = -1;
        int getterSectionEnd = -1;
        while (m.find()) {
            if (m.group(1).equalsIgnoreCase(sectionName)) {
                getterSectionStart = m.end() + 1;
                getterSectionHeaderStart = m.start();
                continue;
            }
            if (getterSectionStart == -1) continue;
            getterSectionEnd = m.start();
        }
        if (getterSectionStart != -1) {
            if (getterSectionEnd != -1) {
                return new String[]{javadoc.substring(getterSectionStart, getterSectionEnd), javadoc.substring(0, getterSectionHeaderStart) + javadoc.substring(getterSectionEnd)};
            }
            return new String[]{javadoc.substring(getterSectionStart), javadoc.substring(0, getterSectionHeaderStart)};
        }
        return null;
    }

    public static void copyJavadoc(JavacNode from, JCTree to, CopyJavadoc copyMode) {
        if (copyMode == null) {
            copyMode = CopyJavadoc.VERBATIM;
        }
        try {
            JCTree.JCCompilationUnit cu = (JCTree.JCCompilationUnit)((JavacNode)from.top()).get();
            Object dc = Javac.getDocComments(cu);
            if (dc instanceof Map) {
                JavacHandlerUtil.copyJavadoc_jdk6_7(from, to, copyMode, dc);
            } else if (Javac.instanceOfDocCommentTable(dc)) {
                CopyJavadoc_8.copyJavadoc(from, to, copyMode, dc);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void copyJavadoc_jdk6_7(JavacNode from, JCTree to, CopyJavadoc copyMode, Object dc) {
        Map docComments = (Map)dc;
        String javadoc = (String)docComments.get(from.get());
        if (javadoc != null) {
            String[] filtered = copyMode.split(javadoc);
            docComments.put(to, filtered[0]);
            docComments.put(from.get(), filtered[1]);
        }
    }

    private static class CopyJavadoc_8 {
        private CopyJavadoc_8() {
        }

        static void copyJavadoc(JavacNode from, JCTree to, CopyJavadoc copyMode, Object dc) {
            DocCommentTable dct = (DocCommentTable)dc;
            Tokens.Comment javadoc = dct.getComment((JCTree)from.get());
            if (javadoc != null) {
                String[] filtered = copyMode.split(javadoc.getText());
                dct.putComment(to, CopyJavadoc_8.createJavadocComment(filtered[0], from));
                dct.putComment((JCTree)from.get(), CopyJavadoc_8.createJavadocComment(filtered[1], from));
            }
        }

        private static Tokens.Comment createJavadocComment(final String text, final JavacNode field) {
            return new Tokens.Comment(){

                @Override
                public String getText() {
                    return text;
                }

                @Override
                public int getSourcePos(int index) {
                    return -1;
                }

                @Override
                public Tokens.Comment.CommentStyle getStyle() {
                    return Tokens.Comment.CommentStyle.JAVADOC;
                }

                @Override
                public boolean isDeprecated() {
                    return text.contains("@deprecated") && field.getKind() == AST.Kind.FIELD && JavacHandlerUtil.isFieldDeprecated(field);
                }
            };
        }
    }

    public static enum CopyJavadoc {
        VERBATIM,
        GETTER{

            @Override
            public String[] split(String javadoc) {
                String[] out = JavacHandlerUtil.splitJavadocOnSectionIfPresent(javadoc, "GETTER");
                if (out != null) {
                    return out;
                }
                String copy = javadoc;
                javadoc = JavacHandlerUtil.stripLinesWithTagFromJavadoc(javadoc, "@returns?\\s+.*");
                copy = JavacHandlerUtil.stripLinesWithTagFromJavadoc(copy, "@param(?:eter)?\\s+.*");
                copy = JavacHandlerUtil.stripSectionsFromJavadoc(copy);
                return new String[]{copy, javadoc};
            }
        }
        ,
        SETTER{

            @Override
            public String[] split(String javadoc) {
                return CopyJavadoc.splitForSetters(javadoc, "SETTER");
            }
        }
        ,
        WITHER{

            @Override
            public String[] split(String javadoc) {
                return CopyJavadoc.splitForSetters(javadoc, "WITHER");
            }
        };


        private static String[] splitForSetters(String javadoc, String sectionName) {
            String[] out = JavacHandlerUtil.splitJavadocOnSectionIfPresent(javadoc, sectionName);
            if (out != null) {
                return out;
            }
            String copy = javadoc;
            javadoc = JavacHandlerUtil.stripLinesWithTagFromJavadoc(javadoc, "@param(?:eter)?\\s+.*");
            copy = JavacHandlerUtil.stripLinesWithTagFromJavadoc(copy, "@returns?\\s+.*");
            copy = JavacHandlerUtil.stripSectionsFromJavadoc(copy);
            return new String[]{copy, javadoc};
        }

        public String[] split(String javadoc) {
            return new String[]{javadoc, javadoc};
        }
    }

    public static enum FieldAccess {
        GETTER,
        PREFER_FIELD,
        ALWAYS_FIELD;

    }

    private static class GetterMethod {
        private final Name name;
        private final JCTree.JCExpression type;

        GetterMethod(Name name, JCTree.JCExpression type) {
            this.name = name;
            this.type = type;
        }
    }

    public static enum MemberExistsResult {
        NOT_EXISTS,
        EXISTS_BY_LOMBOK,
        EXISTS_BY_USER;

    }

    private static class MarkingScanner
    extends TreeScanner {
        private final JCTree source;
        private final Context context;

        MarkingScanner(JCTree source, Context context) {
            this.source = source;
            this.context = context;
        }

        @Override
        public void scan(JCTree tree) {
            if (tree == null) {
                return;
            }
            JavacHandlerUtil.setGeneratedBy(tree, this.source, this.context);
            super.scan(tree);
        }
    }
}

