/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import lombok.core.ReferenceFieldAugment;
import lombok.javac.CommentInfo;
import lombok.javac.Javac;

public class CommentCatcher {
    private final JavaCompiler compiler;
    private final ReferenceFieldAugment<JCTree.JCCompilationUnit, List<CommentInfo>> commentsField;

    public static CommentCatcher create(Context context) {
        CommentCatcher.registerCommentsCollectingScannerFactory(context);
        JavaCompiler compiler = new JavaCompiler(context);
        ReferenceFieldAugment<JCTree.JCCompilationUnit, List<CommentInfo>> comments = ReferenceFieldAugment.augment(JCTree.JCCompilationUnit.class, List.class, "lombok$comments");
        CommentCatcher.setInCompiler(compiler, context, comments);
        compiler.keepComments = true;
        compiler.genEndPos = true;
        return new CommentCatcher(compiler, comments);
    }

    private CommentCatcher(JavaCompiler compiler, ReferenceFieldAugment<JCTree.JCCompilationUnit, List<CommentInfo>> commentsField) {
        this.compiler = compiler;
        this.commentsField = commentsField;
    }

    public JavaCompiler getCompiler() {
        return this.compiler;
    }

    public void setComments(JCTree.JCCompilationUnit ast, List<CommentInfo> comments) {
        if (comments != null) {
            this.commentsField.set(ast, comments);
        } else {
            this.commentsField.clear(ast);
        }
    }

    public List<CommentInfo> getComments(JCTree.JCCompilationUnit ast) {
        List<CommentInfo> list = this.commentsField.get(ast);
        return list == null ? Collections.emptyList() : list;
    }

    private static void registerCommentsCollectingScannerFactory(Context context) {
        try {
            int javaCompilerVersion = Javac.getJavaCompilerVersion();
            Class<?> scannerFactory = javaCompilerVersion <= 6 ? Class.forName("lombok.javac.java6.CommentCollectingScannerFactory") : (javaCompilerVersion == 7 ? Class.forName("lombok.javac.java7.CommentCollectingScannerFactory") : Class.forName("lombok.javac.java8.CommentCollectingScannerFactory"));
            scannerFactory.getMethod("preRegister", Context.class).invoke(null, context);
        }
        catch (InvocationTargetException e) {
            throw Javac.sneakyThrow(e.getCause());
        }
        catch (Exception e) {
            throw Javac.sneakyThrow(e);
        }
    }

    private static void setInCompiler(JavaCompiler compiler, Context context, ReferenceFieldAugment<JCTree.JCCompilationUnit, List<CommentInfo>> commentsField) {
        try {
            int javaCompilerVersion = Javac.getJavaCompilerVersion();
            Class<?> parserFactory = javaCompilerVersion <= 6 ? Class.forName("lombok.javac.java6.CommentCollectingParserFactory") : (javaCompilerVersion == 7 ? Class.forName("lombok.javac.java7.CommentCollectingParserFactory") : Class.forName("lombok.javac.java8.CommentCollectingParserFactory"));
            parserFactory.getMethod("setInCompiler", JavaCompiler.class, Context.class, ReferenceFieldAugment.class).invoke(null, compiler, context, commentsField);
        }
        catch (InvocationTargetException e) {
            throw Javac.sneakyThrow(e.getCause());
        }
        catch (Exception e) {
            throw Javac.sneakyThrow(e);
        }
    }
}

