/*
 * Decompiled with CFR 0.152.
 */
package lombok.core;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReferenceFieldAugment<T, F> {
    public static <T, F> ReferenceFieldAugment<T, F> augment(Class<T> type, Class<? super F> fieldType, String name) {
        return new MapFieldAugment();
    }

    public static <T, F> ReferenceFieldAugment<T, F> augmentWeakField(Class<T> type, Class<? super F> fieldType, String name) {
        return new MapWeakFieldAugment();
    }

    private ReferenceFieldAugment() {
    }

    public abstract F get(T var1);

    public final void set(T object, F value) {
        this.getAndSet(object, value);
    }

    public abstract F getAndSet(T var1, F var2);

    public abstract F clear(T var1);

    public abstract F compareAndClear(T var1, F var2);

    public abstract F setIfAbsent(T var1, F var2);

    public abstract F compareAndSet(T var1, F var2, F var3);

    private static <T> T checkNotNull(T object, String name) {
        if (object == null) {
            throw new NullPointerException(name);
        }
        return object;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapWeakFieldAugment<T, F>
    extends MapFieldAugment<T, F> {
        MapWeakFieldAugment() {
        }

        @Override
        F read(T object) {
            WeakReference read = (WeakReference)this.values.get(object);
            if (read == null) {
                return null;
            }
            Object result = read.get();
            if (result == null) {
                this.values.remove(object);
            }
            return (F)result;
        }

        @Override
        void write(T object, F value) {
            this.values.put(object, new WeakReference<F>(value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapFieldAugment<T, F>
    extends ReferenceFieldAugment<T, F> {
        final Map<T, Object> values = new WeakHashMap<T, Object>();

        private MapFieldAugment() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public F get(T object) {
            ReferenceFieldAugment.checkNotNull(object, "object");
            Map<T, Object> map = this.values;
            synchronized (map) {
                return this.read(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public F getAndSet(T object, F value) {
            ReferenceFieldAugment.checkNotNull(object, "object");
            ReferenceFieldAugment.checkNotNull(value, "value");
            Map<T, Object> map = this.values;
            synchronized (map) {
                F result = this.read(object);
                this.write(object, value);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public F clear(T object) {
            ReferenceFieldAugment.checkNotNull(object, "object");
            Map<T, Object> map = this.values;
            synchronized (map) {
                F result = this.read(object);
                this.values.remove(object);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public F compareAndClear(T object, F expected) {
            ReferenceFieldAugment.checkNotNull(object, "object");
            ReferenceFieldAugment.checkNotNull(expected, "expected");
            Map<T, Object> map = this.values;
            synchronized (map) {
                F result = this.read(object);
                if (result == null) {
                    return null;
                }
                if (!expected.equals(result)) {
                    return result;
                }
                this.values.remove(object);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public F setIfAbsent(T object, F value) {
            ReferenceFieldAugment.checkNotNull(object, "object");
            ReferenceFieldAugment.checkNotNull(value, "value");
            Map<T, Object> map = this.values;
            synchronized (map) {
                F result = this.read(object);
                if (result != null) {
                    return result;
                }
                this.write(object, value);
                return value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public F compareAndSet(T object, F expected, F value) {
            ReferenceFieldAugment.checkNotNull(object, "object");
            ReferenceFieldAugment.checkNotNull(expected, "expected");
            ReferenceFieldAugment.checkNotNull(value, "value");
            Map<T, Object> map = this.values;
            synchronized (map) {
                F result = this.read(object);
                if (!expected.equals(result)) {
                    return result;
                }
                this.write(object, value);
                return value;
            }
        }

        F read(T object) {
            return (F)this.values.get(object);
        }

        void write(T object, F value) {
            this.values.put(object, value);
        }
    }
}

