/*
 * Decompiled with CFR 0.152.
 */
package lombok.core;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BooleanFieldAugment<T> {
    public static <T> BooleanFieldAugment<T> augment(Class<T> type, String name) {
        BooleanFieldAugment.checkNotNull(type, "type");
        BooleanFieldAugment.checkNotNull(name, "name");
        Field booleanField = BooleanFieldAugment.getBooleanField(type, name);
        if (booleanField == null) {
            return new MapFieldAugment();
        }
        return new ExistingFieldAugment(booleanField);
    }

    private BooleanFieldAugment() {
    }

    private static Field getBooleanField(Class<?> type, String name) {
        try {
            Field result = type.getDeclaredField(name);
            if (Modifier.isStatic(result.getModifiers()) || result.getType() != Boolean.TYPE) {
                return null;
            }
            result.setAccessible(true);
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public abstract boolean set(T var1);

    public abstract boolean clear(T var1);

    public abstract boolean get(T var1);

    private static <T> T checkNotNull(T object, String name) {
        if (object == null) {
            throw new NullPointerException(name);
        }
        return object;
    }

    private static RuntimeException sneakyThrow(Throwable t) {
        if (t == null) {
            throw new NullPointerException("t");
        }
        BooleanFieldAugment.sneakyThrow0(t);
        return null;
    }

    private static <T extends Throwable> void sneakyThrow0(Throwable t) throws T {
        throw t;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExistingFieldAugment<T>
    extends BooleanFieldAugment<T> {
        private final Object lock = new Object();
        private final Field booleanField;

        private ExistingFieldAugment(Field booleanField) {
            this.booleanField = booleanField;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean set(T object) {
            BooleanFieldAugment.checkNotNull(object, "object");
            try {
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean result = this.booleanField.getBoolean(object);
                    this.booleanField.setBoolean(object, true);
                    return result;
                }
            }
            catch (IllegalAccessException e) {
                throw BooleanFieldAugment.sneakyThrow(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean clear(T object) {
            BooleanFieldAugment.checkNotNull(object, "object");
            try {
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean result = this.booleanField.getBoolean(object);
                    this.booleanField.setBoolean(object, false);
                    return result;
                }
            }
            catch (IllegalAccessException e) {
                throw BooleanFieldAugment.sneakyThrow(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean get(T object) {
            BooleanFieldAugment.checkNotNull(object, "object");
            try {
                Object object2 = this.lock;
                synchronized (object2) {
                    return this.booleanField.getBoolean(object);
                }
            }
            catch (IllegalAccessException e) {
                throw BooleanFieldAugment.sneakyThrow(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapFieldAugment<T>
    extends BooleanFieldAugment<T> {
        private static final Object MARKER = new Object();
        private final Map<T, Object> values = new WeakHashMap<T, Object>();

        private MapFieldAugment() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean set(T object) {
            BooleanFieldAugment.checkNotNull(object, "object");
            Map<T, Object> map = this.values;
            synchronized (map) {
                return this.values.put(object, MARKER) != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean clear(T object) {
            BooleanFieldAugment.checkNotNull(object, "object");
            Map<T, Object> map = this.values;
            synchronized (map) {
                return this.values.remove(object) != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean get(T object) {
            BooleanFieldAugment.checkNotNull(object, "object");
            Map<T, Object> map = this.values;
            synchronized (map) {
                return this.values.get(object) != null;
            }
        }
    }
}

