/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import lombok.javac.CommentInfo;
import lombok.javac.Javac;

public class CommentCatcher {
    private final JavaCompiler compiler;
    private final Map<JCTree.JCCompilationUnit, List<CommentInfo>> commentsMap;

    public static CommentCatcher create(Context context) {
        CommentCatcher.registerCommentsCollectingScannerFactory(context);
        JavaCompiler compiler = new JavaCompiler(context);
        WeakHashMap<JCTree.JCCompilationUnit, List<CommentInfo>> commentsMap = new WeakHashMap<JCTree.JCCompilationUnit, List<CommentInfo>>();
        CommentCatcher.setInCompiler(compiler, context, commentsMap);
        compiler.keepComments = true;
        compiler.genEndPos = true;
        return new CommentCatcher(compiler, commentsMap);
    }

    private CommentCatcher(JavaCompiler compiler, Map<JCTree.JCCompilationUnit, List<CommentInfo>> commentsMap) {
        this.compiler = compiler;
        this.commentsMap = commentsMap;
    }

    public JavaCompiler getCompiler() {
        return this.compiler;
    }

    public void setComments(JCTree.JCCompilationUnit ast, List<CommentInfo> comments) {
        if (comments != null) {
            this.commentsMap.put(ast, comments);
        } else {
            this.commentsMap.remove(ast);
        }
    }

    public List<CommentInfo> getComments(JCTree.JCCompilationUnit ast) {
        List<CommentInfo> list = this.commentsMap.get(ast);
        return list == null ? Collections.emptyList() : list;
    }

    private static void registerCommentsCollectingScannerFactory(Context context) {
        try {
            int javaCompilerVersion = Javac.getJavaCompilerVersion();
            Class<?> scannerFactory = javaCompilerVersion <= 6 ? Class.forName("lombok.javac.java6.CommentCollectingScannerFactory") : (javaCompilerVersion == 7 ? Class.forName("lombok.javac.java7.CommentCollectingScannerFactory") : Class.forName("lombok.javac.java8.CommentCollectingScannerFactory"));
            scannerFactory.getMethod("preRegister", Context.class).invoke(null, context);
        }
        catch (InvocationTargetException e) {
            throw Javac.sneakyThrow(e.getCause());
        }
        catch (Exception e) {
            throw Javac.sneakyThrow(e);
        }
    }

    private static void setInCompiler(JavaCompiler compiler, Context context, Map<JCTree.JCCompilationUnit, List<CommentInfo>> commentsMap) {
        try {
            int javaCompilerVersion = Javac.getJavaCompilerVersion();
            Class<?> parserFactory = javaCompilerVersion <= 6 ? Class.forName("lombok.javac.java6.CommentCollectingParserFactory") : (javaCompilerVersion == 7 ? Class.forName("lombok.javac.java7.CommentCollectingParserFactory") : Class.forName("lombok.javac.java8.CommentCollectingParserFactory"));
            parserFactory.getMethod("setInCompiler", JavaCompiler.class, Context.class, Map.class).invoke(null, compiler, context, commentsMap);
        }
        catch (InvocationTargetException e) {
            throw Javac.sneakyThrow(e.getCause());
        }
        catch (Exception e) {
            throw Javac.sneakyThrow(e);
        }
    }
}

