/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.configuration.support;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.powermock.configuration.Configuration;
import org.powermock.configuration.ConfigurationType;
import org.powermock.configuration.support.ValueAliases;
import org.powermock.core.PowerMockInternalException;

class ConfigurationMapper<T extends Configuration> {
    private final Class<T> configurationClass;
    private final T configuration;
    private final ValueAliases aliases;

    ConfigurationMapper(Class<T> configurationClass, T configuration, ValueAliases aliases) {
        this.configurationClass = configurationClass;
        this.configuration = configuration;
        this.aliases = aliases;
    }

    public void map(Properties properties) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo info = Introspector.getBeanInfo(this.configurationClass, Object.class);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = info.getPropertyDescriptors()) {
                if (propertyDescriptor.getWriteMethod() == null) continue;
                this.mapProperty(propertyDescriptor, properties);
            }
        }
        catch (Exception e) {
            throw new PowerMockInternalException(e);
        }
    }

    private void mapProperty(PropertyDescriptor propertyDescriptor, Properties properties) throws IllegalAccessException, InvocationTargetException {
        ConfigurationKey key = new ConfigurationKey(ConfigurationType.forClass(this.configurationClass), propertyDescriptor.getName());
        String value = this.aliases.findValue((String)properties.get(key.toString()));
        PropertyWriter.forProperty(propertyDescriptor).writeProperty(propertyDescriptor, this.configuration, value);
    }

    private static enum PropertyWriter {
        ArrayWriter{

            @Override
            public void writeProperty(PropertyDescriptor propertyDescriptor, Object target, String value) {
                try {
                    if (value != null) {
                        String[] array = value.split(",");
                        propertyDescriptor.getWriteMethod().invoke(target, new Object[]{array});
                    }
                }
                catch (Exception e) {
                    throw new PowerMockInternalException(e);
                }
            }
        }
        ,
        StringWriter{

            @Override
            public void writeProperty(PropertyDescriptor propertyDescriptor, Object target, String value) {
                try {
                    if (value != null) {
                        propertyDescriptor.getWriteMethod().invoke(target, value);
                    }
                }
                catch (Exception e) {
                    throw new PowerMockInternalException(e);
                }
            }
        };


        public static PropertyWriter forProperty(PropertyDescriptor propertyDescriptor) {
            if (String[].class.isAssignableFrom(propertyDescriptor.getPropertyType())) {
                return ArrayWriter;
            }
            return StringWriter;
        }

        public abstract void writeProperty(PropertyDescriptor var1, Object var2, String var3);
    }

    private static class ConfigurationKey {
        private final ConfigurationType configurationType;
        private final String name;

        private ConfigurationKey(ConfigurationType configurationType, String name) {
            this.configurationType = configurationType;
            this.name = name;
        }

        public String toString() {
            StringBuilder key = new StringBuilder();
            if (this.configurationType.getPrefix() != null) {
                key.append(this.configurationType.getPrefix());
                key.append(".");
            }
            for (int i = 0; i < this.name.length(); ++i) {
                char c = this.name.charAt(i);
                if (Character.isUpperCase(c)) {
                    key.append('-');
                    key.append(Character.toLowerCase(c));
                    continue;
                }
                key.append(c);
            }
            return key.toString();
        }
    }
}

