/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.classloading;

import com.thoughtworks.xstream.XStream;
import org.powermock.classloading.SingleClassloaderExecutor;
import org.powermock.classloading.spi.DeepClonerSPI;

public class DeepCloner
implements DeepClonerSPI {
    private final XStream xStream = new XStream();

    public DeepCloner(ClassLoader classLoader) {
        this.disableSecurity();
        this.xStream.omitField(SingleClassloaderExecutor.class, "classloader");
        this.xStream.setClassLoader(classLoader);
    }

    private void disableSecurity() {
        XStream.setupDefaultSecurity((XStream)this.xStream);
        this.xStream.allowTypesByRegExp(new String[]{".*"});
    }

    public DeepCloner() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public <T> T clone(T objectToClone) {
        String serialized = this.xStream.toXML(objectToClone);
        return (T)this.xStream.fromXML(serialized);
    }
}

