/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.extension.reporter;

import org.powermock.core.reporter.MockingFrameworkReporter;
import org.powermock.core.reporter.MockingFrameworkReporterFactory;
import org.powermock.reflect.Whitebox;

public abstract class AbstractMockingFrameworkReporterFactory
implements MockingFrameworkReporterFactory {
    public MockingFrameworkReporter create() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return this.getInstanceForClassLoader(classLoader);
    }

    private MockingFrameworkReporter getInstanceForClassLoader(ClassLoader classLoader) {
        Class<MockingFrameworkReporter> frameworkReporterClass = this.getMockingFrameworkReporterClass(classLoader);
        return (MockingFrameworkReporter)Whitebox.newInstance(frameworkReporterClass);
    }

    private Class<MockingFrameworkReporter> getMockingFrameworkReporterClass(ClassLoader classLoader) {
        Class<MockingFrameworkReporter> frameworkReporterClass;
        try {
            frameworkReporterClass = classLoader.loadClass(this.getImplementerClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return frameworkReporterClass;
    }

    protected abstract String getImplementerClassName();
}

