/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.mockcreation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.cglib.proxy.MethodInterceptor;
import org.mockito.internal.MockHandler;
import org.mockito.internal.MockitoInvocationHandler;
import org.mockito.internal.configuration.GlobalConfiguration;
import org.mockito.internal.creation.MethodInterceptorFilter;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.creation.jmock.ClassImposterizer;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.internal.util.reflection.LenientCopyTool;
import org.powermock.api.mockito.internal.invocationcontrol.MockitoMethodInvocationControl;
import org.powermock.api.support.ClassLoaderUtil;
import org.powermock.core.ClassReplicaCreator;
import org.powermock.core.DefaultFieldValueGenerator;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.MethodInvocationControl;
import org.powermock.reflect.Whitebox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockCreator {
    public static <T> T mock(Class<T> type, boolean isStatic, boolean isSpy, Object delegator, MockSettings mockSettings, Method ... methods) {
        if (type == null) {
            throw new IllegalArgumentException("The class to mock cannot be null");
        }
        Object mock = null;
        String mockName = MockCreator.toInstanceName(type);
        MockRepository.addAfterMethodRunner((Runnable)new MockitoStateCleaner());
        Class typeToMock = MockCreator.isFinalJavaSystemClass(type) ? new ClassReplicaCreator().createClassReplica(type) : type;
        MockData<T> mockData = MockCreator.createMethodInvocationControl(mockName, typeToMock, methods, isSpy, delegator, mockSettings);
        mock = mockData.getMock();
        if (MockCreator.isFinalJavaSystemClass(type) && !isStatic) {
            mock = Whitebox.newInstance((Class)type);
            DefaultFieldValueGenerator.fillWithDefaultValues((Object)mock);
        }
        if (isStatic) {
            MockRepository.putStaticMethodInvocationControl((Class)type, (MethodInvocationControl)mockData.getMethodInvocationControl());
        } else {
            MockRepository.putInstanceMethodInvocationControl((Object)mock, (MethodInvocationControl)mockData.getMethodInvocationControl());
        }
        if (isSpy) {
            new LenientCopyTool().copyToMock(delegator, mock);
        }
        return (T)mock;
    }

    private static <T> boolean isFinalJavaSystemClass(Class<T> type) {
        return type.getName().startsWith("java.") && Modifier.isFinal(type.getModifiers());
    }

    private static <T> MockData<T> createMethodInvocationControl(String mockName, Class<T> type, Method[] methods, boolean isSpy, Object delegator, MockSettings mockSettings) {
        MockSettingsImpl settings = mockSettings == null ? (MockSettingsImpl)Mockito.withSettings() : (MockSettingsImpl)mockSettings;
        if (isSpy) {
            settings.defaultAnswer(Mockito.CALLS_REAL_METHODS);
        }
        settings.initiateMockName(type);
        MockHandler mockHandler = new MockHandler(settings);
        MethodInterceptorFilter filter = new MethodInterceptorFilter((MockitoInvocationHandler)mockHandler, settings);
        Object mock = ClassImposterizer.INSTANCE.imposterise((MethodInterceptor)filter, type, new Class[0]);
        MockitoMethodInvocationControl invocationControl = new MockitoMethodInvocationControl(filter, isSpy && delegator == null ? new Object() : delegator, mock, methods);
        return new MockData<Object>(invocationControl, mock);
    }

    private static String toInstanceName(Class<?> clazz) {
        String className = clazz.getSimpleName();
        if (className.length() == 0) {
            return clazz.getName();
        }
        return className.substring(0, 1).toLowerCase() + className.substring(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MockitoStateCleaner
    implements Runnable {
        private MockitoStateCleaner() {
        }

        @Override
        public void run() {
            this.clearMockProgress();
            this.clearConfiguration();
        }

        private void clearMockProgress() {
            this.clearThreadLocalIn(ThreadSafeMockingProgress.class);
        }

        private void clearConfiguration() {
            this.clearThreadLocalIn(GlobalConfiguration.class);
        }

        private void clearThreadLocalIn(Class<?> cls) {
            ((ThreadLocal)Whitebox.getInternalState(cls, ThreadLocal.class)).set(null);
            Class clazz = ClassLoaderUtil.loadClass(cls, (ClassLoader)ClassLoader.getSystemClassLoader());
            ((ThreadLocal)Whitebox.getInternalState((Object)clazz, ThreadLocal.class)).set(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MockData<T> {
        private final MockitoMethodInvocationControl methodInvocationControl;
        private final T mock;

        MockData(MockitoMethodInvocationControl methodInvocationControl, T mock) {
            this.methodInvocationControl = methodInvocationControl;
            this.mock = mock;
        }

        public MockitoMethodInvocationControl getMethodInvocationControl() {
            return this.methodInvocationControl;
        }

        public T getMock() {
            return this.mock;
        }
    }
}

