/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.extension.listener;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.powermock.api.extension.listener.MockMetadata;

class AnnotationGlobalMetadata {
    private final List<MockMetadata> qualifiedInjections = new ArrayList<MockMetadata>(5);
    private final List<MockMetadata> unqualifiedInjections = new ArrayList<MockMetadata>(5);
    private final Set<String> qualifiers = new HashSet<String>();

    AnnotationGlobalMetadata() {
    }

    public List<MockMetadata> getQualifiedInjections() {
        return this.qualifiedInjections;
    }

    public List<MockMetadata> getUnqualifiedInjections() {
        return this.unqualifiedInjections;
    }

    public void add(List<MockMetadata> mocksMetadata) {
        for (MockMetadata mockMetadata : mocksMetadata) {
            this.add(mockMetadata);
        }
    }

    private void add(MockMetadata mockMetadata) {
        String qualifier = mockMetadata.getQualifier();
        if (qualifier.length() != 0) {
            this.blockDuplicateQualifiers(qualifier);
            this.qualifiedInjections.add(mockMetadata);
        } else {
            this.unqualifiedInjections.add(mockMetadata);
        }
    }

    private void blockDuplicateQualifiers(String qualifier) {
        if (!this.qualifiers.add(qualifier)) {
            throw new RuntimeException(String.format("At least two mocks have fieldName qualifier '%s'", qualifier));
        }
    }
}

