/*
 * Decompiled with CFR 0.152.
 */
package org.pacesys.reflect.types;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.pacesys.reflect.types.Predicate;

public class Predicates {
    public static <T extends AccessibleObject> Predicate<T> findByAnnotations(Class<? extends Annotation> ... annotations) {
        return new AnnotatedPredicate(annotations);
    }

    public static <T extends AccessibleObject> Predicate<T> findByAnnotations(Set<Class<? extends Annotation>> annotations) {
        return new AnnotatedPredicate(annotations);
    }

    public static <T extends AccessibleObject> Predicate<T> publicAccess() {
        return new PublicAccessPredicate();
    }

    public static Predicate<Field> fieldName(String search) {
        return new FieldByNamePredicate(search);
    }

    static class AnnotatedPredicate<T extends AccessibleObject>
    implements Predicate<T> {
        Set<Class<? extends Annotation>> annotations;

        AnnotatedPredicate(Class<? extends Annotation> ... annotations) {
            this.annotations = new HashSet<Class<? extends Annotation>>(Arrays.asList(annotations));
        }

        AnnotatedPredicate(Set<Class<? extends Annotation>> annotations) {
            this.annotations = annotations;
        }

        @Override
        public boolean apply(T input) {
            for (Annotation a : ((AccessibleObject)input).getAnnotations()) {
                if (!this.annotations.contains(a.annotationType())) continue;
                return true;
            }
            return false;
        }
    }

    static class PublicAccessPredicate<T extends AccessibleObject>
    implements Predicate<T> {
        PublicAccessPredicate() {
        }

        @Override
        public boolean apply(T input) {
            return Modifier.isPublic(input instanceof Field ? ((Field)input).getModifiers() : ((Method)input).getModifiers());
        }
    }

    static class FieldByNamePredicate
    implements Predicate<Field> {
        String search;

        FieldByNamePredicate(String search) {
            this.search = search;
        }

        @Override
        public boolean apply(Field input) {
            return input.getName().equalsIgnoreCase(this.search);
        }
    }
}

