/*
 * Decompiled with CFR 0.152.
 */
package org.pacesys.reflect;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ReflectionException;
import org.pacesys.reflect.types.Predicate;
import org.pacesys.reflect.types.Predicates;
import org.pacesys.reflect.types.Transient;

public final class Reflect {
    private static final String PREFIX_SET = "set";
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_IS = "is";
    final Class<?> type;

    private Reflect(Class<?> type) {
        this.type = type;
    }

    public static Reflect on(Class<?> type) {
        return new Reflect(type);
    }

    public static ReflectMethodInvoker on(Method m) {
        return new ReflectMethodInvoker(m);
    }

    public FieldFinder fields() {
        return new FieldFinder();
    }

    public MethodFinder methods(boolean isStaticOnly) {
        return new MethodFinder(isStaticOnly);
    }

    public MethodFinder methods() {
        return new MethodFinder(Boolean.FALSE);
    }

    private static List<Method> methodsFor(Class<?> type, boolean isStaticOnly, Predicate<Method> predicate) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : type.getDeclaredMethods()) {
            if (isStaticOnly && !Modifier.isStatic(m.getModifiers()) || predicate != null && !predicate.apply(m)) continue;
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            methods.add(m);
        }
        return methods;
    }

    private static List<Method> methodsForRecursive(Class<?> type, boolean isStaticOnly, Predicate<Method> predicate) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> t = type; t != null && t != Object.class; t = t.getSuperclass()) {
            for (Method m : t.getDeclaredMethods()) {
                if (isStaticOnly && !Modifier.isStatic(m.getModifiers()) || predicate != null && !predicate.apply(m)) continue;
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                methods.add(m);
            }
        }
        return methods;
    }

    public static AccessorMutatorType isMethodMutatorOrAccessor(Method m) {
        if (m == null) {
            return AccessorMutatorType.NA;
        }
        if (m.getName().startsWith(PREFIX_GET) || m.getName().startsWith(PREFIX_IS)) {
            return AccessorMutatorType.ACCESSOR;
        }
        if (m.getName().startsWith(PREFIX_SET)) {
            return AccessorMutatorType.MUTATOR;
        }
        return AccessorMutatorType.NA;
    }

    public static String formatMutatorAccessor(Method m) {
        if (m == null) {
            return null;
        }
        if (m.getName().startsWith(PREFIX_GET) || m.getName().startsWith(PREFIX_SET)) {
            return Introspector.decapitalize(m.getName().substring(3));
        }
        if (m.getName().startsWith(PREFIX_IS)) {
            return Introspector.decapitalize(m.getName().substring(2));
        }
        return m.getName();
    }

    private static List<Field> fieldsFor(Class<?> type, Predicate<Field> predicate) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> t = type; t != null && t != Object.class; t = t.getSuperclass()) {
            for (Field f : t.getDeclaredFields()) {
                if (predicate != null && !predicate.apply(f)) continue;
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                fields.add(f);
            }
        }
        return fields;
    }

    private static void acessorsFor(Class<?> type, Map<String, Method> accessors) {
        Class<?> superClass = type.getSuperclass();
        if (superClass != Object.class) {
            Reflect.acessorsFor(superClass, accessors);
        }
        for (Method method : type.getDeclaredMethods()) {
            if (method.getParameterTypes().length != 0 || method.isAnnotationPresent(Transient.class)) continue;
            String methodName = method.getName();
            if (methodName.startsWith(PREFIX_GET)) {
                accessors.put(Introspector.decapitalize(methodName.substring(3)), method);
                continue;
            }
            if (!methodName.startsWith(PREFIX_IS)) continue;
            accessors.put(Introspector.decapitalize(methodName.substring(2)), method);
        }
    }

    private static void mutatorsFor(Class<?> type, Map<String, Method> mutators) {
        Class<?> superClass = type.getSuperclass();
        if (superClass != Object.class) {
            Reflect.mutatorsFor(superClass, mutators);
        }
        for (Method method : type.getDeclaredMethods()) {
            String methodName;
            if (method.getParameterTypes().length != 1 || !(methodName = method.getName()).startsWith(PREFIX_SET)) continue;
            mutators.put(Introspector.decapitalize(methodName.substring(3)), method);
        }
    }

    abstract class MemberFinder<T extends AccessibleObject> {
        MemberFinder() {
        }

        public abstract List<T> match(Predicate<T> var1);

        public abstract List<T> annotatedWith(Class<? extends Annotation> ... var1);

        public abstract List<T> annotatedWith(Set<Class<? extends Annotation>> var1);

        public List<T> all() {
            return this.match(null);
        }

        public List<T> publicOnly() {
            return this.match(Predicates.publicAccess());
        }
    }

    public class MethodFinder
    extends MemberFinder<Method> {
        boolean isStaticOnly;

        MethodFinder(boolean isStaticOnly) {
            this.isStaticOnly = isStaticOnly;
        }

        @Override
        public List<Method> match(Predicate<Method> predicate) {
            return Reflect.methodsFor(Reflect.this.type, this.isStaticOnly, predicate);
        }

        @Override
        public List<Method> annotatedWith(Class<? extends Annotation> ... annotation) {
            return Reflect.methodsFor(Reflect.this.type, this.isStaticOnly, Predicates.findByAnnotations(annotation));
        }

        public List<Method> annotatedWithRecursive(Class<? extends Annotation> ... annotation) {
            return Reflect.methodsForRecursive(Reflect.this.type, this.isStaticOnly, Predicates.findByAnnotations(annotation));
        }

        @Override
        public List<Method> annotatedWith(Set<Class<? extends Annotation>> annotations) {
            return Reflect.methodsFor(Reflect.this.type, this.isStaticOnly, Predicates.findByAnnotations(annotations));
        }

        public Map<String, Method> accessors() {
            LinkedHashMap<String, Method> results = new LinkedHashMap<String, Method>();
            Reflect.acessorsFor(Reflect.this.type, results);
            return results;
        }

        public Map<String, Method> mutators() {
            LinkedHashMap<String, Method> results = new LinkedHashMap<String, Method>();
            Reflect.mutatorsFor(Reflect.this.type, results);
            return results;
        }
    }

    public class FieldFinder
    extends MemberFinder<Field> {
        @Override
        public List<Field> match(Predicate<Field> predicate) {
            return Reflect.fieldsFor(Reflect.this.type, predicate);
        }

        public Field named(String fieldName) {
            List fields = Reflect.fieldsFor(Reflect.this.type, Predicates.fieldName(fieldName));
            if (fields != null && !fields.isEmpty()) {
                return (Field)fields.get(0);
            }
            return null;
        }

        @Override
        public List<Field> annotatedWith(Class<? extends Annotation> ... annotation) {
            return Reflect.fieldsFor(Reflect.this.type, Predicates.findByAnnotations(annotation));
        }

        @Override
        public List<Field> annotatedWith(Set<Class<? extends Annotation>> annotations) {
            return Reflect.fieldsFor(Reflect.this.type, Predicates.findByAnnotations(annotations));
        }
    }

    public static class ReflectMethodInvoker {
        Method m;
        Object instance;

        ReflectMethodInvoker(Method m) {
            this.m = m;
        }

        public ReflectMethodInvoker against(Object instance) {
            this.instance = instance;
            return this;
        }

        public <T> T call(Object ... args) throws ReflectionException {
            try {
                return (T)this.m.invoke(this.instance, args);
            }
            catch (Exception e) {
                throw new ReflectionException(e);
            }
        }
    }

    public static enum AccessorMutatorType {
        ACCESSOR,
        MUTATOR,
        NA;

    }
}

