/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.Collection;
import java.util.Iterator;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.E;
import org.osgl.util.SequenceBase;
import org.osgl.util.ZippedIterator;

class ZippedSeq<A, B>
extends SequenceBase<Lang.Binary<A, B>> {
    private Iterable<A> a;
    private Iterable<B> b;
    private Lang.Option<A> defA = $.none();
    private Lang.Option<B> defB = $.none();

    ZippedSeq(Iterable<A> a, Iterable<B> b) {
        E.NPE(a, b);
        this.a = a;
        this.b = b;
    }

    ZippedSeq(Iterable<A> a, Iterable<B> b, A defA, B defB) {
        this(a, b);
        this.defA = $.some(defA);
        this.defB = $.some(defB);
    }

    @Override
    public int size() throws UnsupportedOperationException {
        if (this.a instanceof Collection && this.b instanceof Collection) {
            int szA = ((Collection)this.a).size();
            int szB = ((Collection)this.b).size();
            if (this.defA.isDefined()) {
                return Math.max(szA, szB);
            }
            return Math.min(szA, szB);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Lang.Binary<A, B>> iterator() {
        Iterator<A> ia = this.a.iterator();
        Iterator<B> ib = this.b.iterator();
        if (this.defA.isDefined()) {
            return new ZippedIterator<A, B>(ia, ib, this.defA.get(), this.defB.get());
        }
        return new ZippedIterator<A, B>(ia, ib);
    }
}

