/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.E;

public class ZippedListIterator<A, B>
implements ListIterator<Lang.Binary<A, B>> {
    private ListIterator<A> a;
    private ListIterator<B> b;
    private Lang.Option<A> defA = $.none();
    private Lang.Option<B> defB = $.none();

    ZippedListIterator(ListIterator<A> a, ListIterator<B> b) {
        E.NPE(a, b);
        this.a = a;
        this.b = b;
    }

    ZippedListIterator(ListIterator<A> a, ListIterator<B> b, A defA, B defB) {
        this(a, b);
        this.defA = $.some(defA);
        this.defB = $.some(defB);
    }

    @Override
    public boolean hasNext() {
        boolean hasA = this.a.hasNext();
        boolean hasB = this.b.hasNext();
        if (hasA && hasB) {
            return true;
        }
        if (this.defA.isDefined()) {
            return hasA || hasB;
        }
        return false;
    }

    @Override
    public boolean hasPrevious() {
        boolean hasA = this.a.hasPrevious();
        boolean hasB = this.b.hasPrevious();
        if (hasA && hasB) {
            return true;
        }
        if (this.defA.isDefined()) {
            return hasA || hasB;
        }
        return false;
    }

    @Override
    public Lang.T2<A, B> next() {
        boolean hasA = this.a.hasNext();
        boolean hasB = this.b.hasNext();
        if (hasA && hasB) {
            return $.T2(this.a.next(), this.b.next());
        }
        if (this.defA.isDefined()) {
            if (hasA) {
                return $.T2(this.a.next(), this.defB.get());
            }
            if (hasB) {
                return $.T2(this.defA.get(), this.b.next());
            }
            throw new NoSuchElementException();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Lang.T2<A, B> previous() {
        boolean hasA = this.a.hasPrevious();
        boolean hasB = this.b.hasPrevious();
        if (hasA && hasB) {
            return $.T2(this.a.previous(), this.b.previous());
        }
        if (this.defA.isDefined()) {
            if (hasA) {
                return $.T2(this.a.previous(), this.defB.get());
            }
            if (hasB) {
                return $.T2(this.defA.get(), this.b.previous());
            }
            throw new NoSuchElementException();
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        int idA = this.a.nextIndex();
        int idB = this.b.nextIndex();
        if (this.defA.isDefined()) {
            return Math.max(idA, idB);
        }
        return Math.min(idA, idB);
    }

    @Override
    public int previousIndex() {
        int idA = this.a.previousIndex();
        int idB = this.b.previousIndex();
        if (this.defA.isDefined()) {
            return Math.max(idA, idB);
        }
        return Math.min(idA, idB);
    }

    @Override
    public void set(Lang.Binary<A, B> abt2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Lang.Binary<A, B> abt2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

