/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.Map;
import org.osgl.$;
import org.osgl.util.BigDecimalValueObjectCodec;
import org.osgl.util.BigIntegerValueObjectCodec;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.KeywordValueObjectCodec;
import org.osgl.util.S;

public class ValueObject
implements Serializable {
    private static final long serialVersionUID = -6103505642730947577L;
    private static Map<Class, Codec> codecRegistry = C.newMap(new Object[0]);
    private transient Type type;
    private Boolean blVal;
    private Byte byVal;
    private Character chVal;
    private Short shVal;
    private Integer iVal;
    private Float fVal;
    private Long lVal;
    private Double dVal;
    private String sVal;
    private Enum eVal;
    private Object udf;

    public ValueObject() {
        this("");
    }

    public ValueObject(boolean b) {
        this.blVal = b;
        this.type = Type.BOOL;
    }

    public ValueObject(byte b) {
        this.byVal = b;
        this.type = Type.BYTE;
    }

    public ValueObject(char c) {
        this.chVal = Character.valueOf(c);
        this.type = Type.CHAR;
    }

    public ValueObject(short s) {
        this.shVal = s;
        this.type = Type.SHORT;
    }

    public ValueObject(int i) {
        this.iVal = i;
        this.type = Type.INT;
    }

    public ValueObject(float f2) {
        this.fVal = Float.valueOf(f2);
        this.type = Type.FLOAT;
    }

    public ValueObject(long l) {
        this.lVal = l;
        this.type = Type.LONG;
    }

    public ValueObject(double d) {
        this.dVal = d;
        this.type = Type.DOUBLE;
    }

    public ValueObject(String s) {
        this.sVal = $.notNull(s);
        this.type = Type.STRING;
    }

    public ValueObject(CharSequence s) {
        this.sVal = s.toString();
        this.type = Type.STRING;
    }

    public ValueObject(Enum e) {
        this.eVal = e;
        this.type = Type.ENUM;
    }

    public ValueObject(Object o) {
        if (o instanceof ValueObject) {
            ValueObject that = (ValueObject)o;
            this.type = that.type();
            this.type.set(that.value(), this);
        } else {
            this.type = ValueObject.typeOf(o);
            this.type.set(o, this);
        }
    }

    public ValueObject(ValueObject copy) {
        this.type = copy.type();
        this.type.set(copy.value(), this);
    }

    public boolean booleanValue() {
        return this.blVal;
    }

    public byte byteValue() {
        return this.byVal;
    }

    public char charValue() {
        return this.chVal.charValue();
    }

    public short shortValue() {
        return this.shVal;
    }

    public int intValue() {
        return this.iVal;
    }

    public float floatValue() {
        return this.fVal.floatValue();
    }

    public long longValue() {
        return this.lVal;
    }

    public double doubleValue() {
        return this.dVal;
    }

    public String stringValue() {
        return $.notNull(this.sVal);
    }

    public <T extends Enum> T enumValue() {
        return (T)((Enum)$.cast(this.eVal));
    }

    public <T> T value() {
        return this.type().get(this);
    }

    public boolean isUDF() {
        Type type = this.type();
        return type == Type.UDF || type == Type.ENUM;
    }

    public int hashCode() {
        return $.hc(this.type().get(this));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ValueObject) {
            ValueObject that = (ValueObject)obj;
            return $.eq(that.type().get(that), this.type().get(this));
        }
        return false;
    }

    public String toString() {
        return this.type().toString(this);
    }

    public String toJSONString() {
        return this.type().toJSONString(this);
    }

    public static void register(Codec codec) {
        codecRegistry.put(codec.targetClass(), codec);
    }

    public static void unregister(Codec codec) {
        codecRegistry.remove(codec.targetClass());
    }

    public static <T> T decode(String string, Class<T> targetType) {
        Type type = ValueObject.typeOf(targetType);
        return type.decode(string, targetType);
    }

    public static String encode(Object o) {
        Type type = ValueObject.typeOf(o);
        return type.encode(o);
    }

    public static ValueObject of(Object o) {
        if (o instanceof ValueObject) {
            return (ValueObject)$.cast(o);
        }
        return new ValueObject(o);
    }

    private Type type() {
        if (null == this.type) {
            this.type = this.findType();
        }
        return this.type;
    }

    private Type findType() {
        if (this.sVal != null) {
            this.type = Type.STRING;
        }
        if (this.iVal != null) {
            return Type.INT;
        }
        if (this.dVal != null) {
            return Type.DOUBLE;
        }
        if (this.eVal != null) {
            return Type.ENUM;
        }
        if (this.lVal != null) {
            return Type.LONG;
        }
        if (this.fVal != null) {
            return Type.FLOAT;
        }
        if (this.blVal != null) {
            return Type.BOOL;
        }
        if (this.byVal != null) {
            return Type.BYTE;
        }
        if (this.chVal != null) {
            return Type.CHAR;
        }
        if (this.shVal != null) {
            return Type.SHORT;
        }
        return Type.UDF;
    }

    private static Type typeOf(Object o) {
        if (null == o) {
            return Type.STRING;
        }
        if (o instanceof CharSequence) {
            return Type.STRING;
        }
        if (o instanceof Integer) {
            return Type.INT;
        }
        if (o instanceof Boolean) {
            return Type.BOOL;
        }
        if (o instanceof Enum) {
            return Type.ENUM;
        }
        if (o instanceof Double) {
            return Type.DOUBLE;
        }
        if (o instanceof Long) {
            return Type.LONG;
        }
        if (o instanceof Float) {
            return Type.FLOAT;
        }
        if (o instanceof Character) {
            return Type.CHAR;
        }
        if (o instanceof Byte) {
            return Type.BYTE;
        }
        if (o instanceof Short) {
            return Type.SHORT;
        }
        return Type.UDF;
    }

    private static Type typeOf(Class c) {
        E.NPE(c);
        if (String.class.isAssignableFrom(c)) {
            return Type.STRING;
        }
        if (Integer.class.isAssignableFrom(c) || Integer.TYPE.isAssignableFrom(c)) {
            return Type.INT;
        }
        if (Boolean.class.isAssignableFrom(c) || Boolean.TYPE.isAssignableFrom(c)) {
            return Type.BOOL;
        }
        if (Enum.class.isAssignableFrom(c)) {
            return Type.ENUM;
        }
        if (Double.class.isAssignableFrom(c) || Double.TYPE.isAssignableFrom(c)) {
            return Type.DOUBLE;
        }
        if (Long.class.isAssignableFrom(c) || Long.TYPE.isAssignableFrom(c)) {
            return Type.LONG;
        }
        if (Character.class.isAssignableFrom(c) || Character.TYPE.isAssignableFrom(c)) {
            return Type.CHAR;
        }
        if (Byte.class.isAssignableFrom(c) || Byte.TYPE.isAssignableFrom(c)) {
            return Type.BYTE;
        }
        if (Short.class.isAssignableFrom(c) || Short.TYPE.isAssignableFrom(c)) {
            return Type.SHORT;
        }
        return Type.UDF;
    }

    static {
        ValueObject.register(BigDecimalValueObjectCodec.INSTANCE);
        ValueObject.register(BigIntegerValueObjectCodec.INSTANCE);
        ValueObject.register(KeywordValueObjectCodec.INSTANCE);
        try {
            Class kvCodec = $.classForName("org.osgl.util.KVCodec");
            ValueObject.register((Codec)$.newInstance(kvCodec));
        }
        catch (Exception kvCodec) {
            // empty catch block
        }
        try {
            Class jsonObjectCodec = $.classForName("org.osgl.util.FastJsonObjectCodec");
            ValueObject.register((Codec)$.newInstance(jsonObjectCodec));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static enum Type {
        BOOL{

            @Override
            <T> T get(ValueObject vo) {
                return (T)vo.blVal;
            }

            @Override
            void set(Object o, ValueObject vo) {
                vo.blVal = (Boolean)$.cast(o);
            }

            @Override
            <T> T decode(String s, Class<T> type) {
                E.illegalArgumentIf(Boolean.TYPE != type || Boolean.class != type);
                return (T)Boolean.valueOf(s);
            }
        }
        ,
        BYTE{

            @Override
            <T> T get(ValueObject vo) {
                return (T)vo.byVal;
            }

            @Override
            void set(Object o, ValueObject vo) {
                vo.byVal = (Byte)$.cast(o);
            }

            @Override
            <T> T decode(String s, Class<T> type) {
                E.illegalArgumentIf(Byte.TYPE != type || Byte.class != type);
                return (T)Byte.valueOf(s);
            }
        }
        ,
        CHAR{

            @Override
            <T> T get(ValueObject vo) {
                return (T)vo.chVal;
            }

            @Override
            void set(Object o, ValueObject vo) {
                vo.chVal = (Character)$.cast(o);
            }

            @Override
            String toJSONString(ValueObject vo) {
                return S.builder("\"").append(this.toString(vo)).append("\"").toString();
            }

            @Override
            <T> T decode(String s, Class<T> type) {
                E.illegalArgumentIf(Character.TYPE != type || Character.class != type);
                return (T)Character.valueOf(s.charAt(0));
            }
        }
        ,
        SHORT{

            @Override
            <T> T get(ValueObject vo) {
                return (T)vo.shVal;
            }

            @Override
            void set(Object o, ValueObject vo) {
                vo.shVal = (Short)$.cast(o);
            }

            @Override
            <T> T decode(String s, Class<T> type) {
                E.illegalArgumentIf(Short.TYPE != type || Short.class != type);
                return (T)Short.valueOf(s);
            }
        }
        ,
        INT{

            @Override
            <T> T get(ValueObject vo) {
                return (T)vo.iVal;
            }

            @Override
            void set(Object o, ValueObject vo) {
                vo.iVal = (Integer)$.cast(o);
            }

            @Override
            <T> T decode(String s, Class<T> type) {
                E.illegalArgumentIf(Integer.TYPE != type || Integer.class != type);
                return (T)Integer.valueOf(s);
            }
        }
        ,
        FLOAT{

            @Override
            <T> T get(ValueObject vo) {
                return (T)vo.fVal;
            }

            @Override
            void set(Object o, ValueObject vo) {
                vo.fVal = (Float)$.cast(o);
            }

            @Override
            <T> T decode(String s, Class<T> type) {
                E.illegalArgumentIf(Float.TYPE != type || Float.class != type);
                return (T)Float.valueOf(s);
            }
        }
        ,
        LONG{

            @Override
            <T> T get(ValueObject vo) {
                return (T)vo.lVal;
            }

            @Override
            void set(Object o, ValueObject vo) {
                vo.lVal = (Long)$.cast(o);
            }

            @Override
            <T> T decode(String s, Class<T> type) {
                E.illegalArgumentIf(Long.TYPE != type || Long.class != type);
                return (T)Long.valueOf(s);
            }
        }
        ,
        DOUBLE{

            @Override
            <T> T get(ValueObject vo) {
                return (T)vo.dVal;
            }

            @Override
            void set(Object o, ValueObject vo) {
                vo.dVal = (Double)$.cast(o);
            }

            @Override
            <T> T decode(String s, Class<T> type) {
                E.illegalArgumentIf(Double.TYPE != type || Double.class != type);
                return (T)Double.valueOf(s);
            }
        }
        ,
        STRING{

            @Override
            <T> T get(ValueObject vo) {
                return (T)vo.sVal;
            }

            @Override
            void set(Object o, ValueObject vo) {
                vo.sVal = S.string(o);
            }

            @Override
            String toJSONString(ValueObject vo) {
                String string = this.toString(vo);
                if (string == null || string.length() == 0) {
                    return "\"\"";
                }
                int len = string.length();
                StringBuilder sb = new StringBuilder(len + 4);
                sb.append('\"');
                block9: for (int i = 0; i < len; ++i) {
                    char c = string.charAt(i);
                    switch (c) {
                        case '\"': 
                        case '\\': {
                            sb.append('\\');
                            sb.append(c);
                            continue block9;
                        }
                        case '/': {
                            sb.append('\\');
                            sb.append(c);
                            continue block9;
                        }
                        case '\b': {
                            sb.append("\\b");
                            continue block9;
                        }
                        case '\t': {
                            sb.append("\\t");
                            continue block9;
                        }
                        case '\n': {
                            sb.append("\\n");
                            continue block9;
                        }
                        case '\f': {
                            sb.append("\\f");
                            continue block9;
                        }
                        case '\r': {
                            sb.append("\\r");
                            continue block9;
                        }
                        default: {
                            if (c < ' ') {
                                String t = "000" + Integer.toHexString(c);
                                sb.append("\\u" + t.substring(t.length() - 4));
                                continue block9;
                            }
                            sb.append(c);
                        }
                    }
                }
                sb.append('\"');
                return sb.toString();
            }

            @Override
            <T> T decode(String s, Class<T> type) {
                E.illegalArgumentIf(String.class != type);
                return (T)s;
            }
        }
        ,
        ENUM{

            @Override
            <T> T get(ValueObject vo) {
                return (T)vo.eVal;
            }

            @Override
            void set(Object o, ValueObject vo) {
                vo.eVal = (Enum)$.cast(o);
            }

            @Override
            String toJSONString(ValueObject vo) {
                return S.builder("\"").append(this.toString(vo)).append("\"").toString();
            }

            @Override
            <T> T decode(String s, Class<T> type) {
                E.illegalArgumentIf(!Enum.class.isAssignableFrom(type));
                Class typedType = (Class)$.cast(type);
                return Enum.valueOf(typedType, s);
            }
        }
        ,
        UDF{

            @Override
            <T> T get(ValueObject vo) {
                return $.cast(vo.udf);
            }

            @Override
            void set(Object o, ValueObject vo) {
                vo.udf = o;
            }

            @Override
            <T> T decode(String s, Class<T> type) {
                Codec codec = this.findCodec(type);
                return (T)(null == codec ? JSON.parseObject((String)s, type) : codec.parse(s));
            }

            @Override
            String encode(Object o) {
                Codec codec = this.findCodec(o.getClass());
                return null == codec ? JSON.toJSONString((Object)o) : codec.toString(o);
            }

            @Override
            String toString(ValueObject vo) {
                Class<?> objType = vo.udf.getClass();
                Codec codec = this.findCodec(objType);
                return null != codec ? codec.toString(vo.udf) : super.toString(vo);
            }

            @Override
            String toJSONString(ValueObject vo) {
                Class<?> objType = vo.udf.getClass();
                Codec codec = this.findCodec(objType);
                return null != codec ? codec.toJSONString(vo.udf) : super.toJSONString(vo);
            }

            private Codec findCodec(Class c) {
                Class sc;
                Codec codec = (Codec)codecRegistry.get(c);
                if (null != codec) {
                    return codec;
                }
                Class<?>[] ifs = c.getInterfaces();
                if (null != ifs) {
                    for (Class<?> c0 : ifs) {
                        codec = this.findCodec(c0);
                        if (null == codec) continue;
                        return codec;
                    }
                }
                return null == (sc = c.getSuperclass()) ? null : this.findCodec(sc);
            }
        };


        abstract <T> T get(ValueObject var1);

        abstract void set(Object var1, ValueObject var2);

        String toString(ValueObject vo) {
            return S.string(this.get(vo));
        }

        String toJSONString(ValueObject vo) {
            return this.toString(vo);
        }

        abstract <T> T decode(String var1, Class<T> var2);

        String encode(Object o) {
            return S.string(o);
        }
    }

    public static interface Codec<T> {
        public Class<T> targetClass();

        public T parse(String var1);

        public String toString(T var1);

        public String toJSONString(T var1);
    }
}

