/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.ListIterator;
import java.util.NoSuchElementException;

public class SingletonListIterator<T>
implements ListIterator<T> {
    private final T t_;
    private volatile boolean consumed_;

    public SingletonListIterator(T t) {
        this.t_ = t;
    }

    @Override
    public boolean hasNext() {
        return !this.consumed_;
    }

    @Override
    public boolean hasPrevious() {
        return this.consumed_;
    }

    @Override
    public T next() {
        if (this.consumed_) {
            throw new NoSuchElementException();
        }
        this.consumed_ = true;
        return this.t_;
    }

    @Override
    public T previous() {
        if (!this.consumed_) {
            throw new NoSuchElementException();
        }
        this.consumed_ = false;
        return this.t_;
    }

    @Override
    public int nextIndex() {
        return this.consumed_ ? 1 : 0;
    }

    @Override
    public int previousIndex() {
        return this.consumed_ ? 0 : -1;
    }

    @Override
    public void set(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

