/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.EnumSet;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.C;
import org.osgl.util.ImmutableSet;
import org.osgl.util.ListBuilder;
import org.osgl.util.Nil;

public abstract class SetBase<T>
extends AbstractSet<T>
implements C.Set<T> {
    private volatile EnumSet<C.Feature> features_;

    @Override
    public C.Set<T> parallel() {
        this.setFeature(C.Feature.PARALLEL);
        return this;
    }

    @Override
    public C.Set<T> sequential() {
        this.unsetFeature(C.Feature.PARALLEL);
        return this;
    }

    @Override
    public C.Set<T> lazy() {
        this.setFeature(C.Feature.LAZY);
        return this;
    }

    @Override
    public C.Set<T> eager() {
        this.unsetFeature(C.Feature.LAZY);
        return this;
    }

    @Override
    public C.Set<T> filter(Lang.Function<? super T, Boolean> predicate) {
        boolean immutable = this.isImmutable();
        int sz = this.size();
        if (immutable) {
            if (0 == sz) {
                return Nil.set();
            }
            ListBuilder lb = new ListBuilder(sz);
            this.forEach((Lang.Visitor)$.visitor($.predicate(predicate).ifThen(C.F.addTo(lb))));
            return lb.toSet();
        }
        if (0 == sz) {
            return C.newSet();
        }
        C.Set set = C.newSet();
        this.forEach((Lang.Visitor)$.visitor($.predicate(predicate).ifThen(C.F.addTo(set))));
        return set;
    }

    @Override
    public SetBase<T> accept(Lang.Visitor<? super T> visitor) {
        return this.forEach((Lang.Visitor)visitor);
    }

    @Override
    public <R> C.Traversable<R> map(Lang.Function<? super T, ? extends R> mapper) {
        boolean immutable = this.isImmutable();
        int sz = this.size();
        if (immutable) {
            if (0 == sz) {
                return Nil.set();
            }
            ListBuilder lb = new ListBuilder(sz);
            this.forEach((Lang.Visitor)$.visitor($.f1(mapper).andThen(C.F.addTo(lb))));
            return lb.toList();
        }
        if (0 == sz) {
            return C.newSet();
        }
        C.List l = C.newSizedList(sz);
        this.forEach((Lang.Visitor)$.visitor($.f1(mapper).andThen(C.F.addTo(l))));
        return l;
    }

    @Override
    public <R> C.Traversable<R> flatMap(Lang.Function<? super T, ? extends Iterable<? extends R>> mapper) {
        C.List list = C.newList();
        for (Object t : this) {
            Iterable<? extends R> iterable = mapper.apply(t);
            list.addAll(C.list(iterable));
        }
        return list;
    }

    @Override
    public <R> C.Traversable<R> collect(String path) {
        C.List list = C.newList();
        for (Object t : this) {
            list.add($.getProperty(t, path));
        }
        return list;
    }

    @Override
    public <R> R reduce(R identity, Lang.Func2<R, T, R> accumulator) {
        return null;
    }

    @Override
    public Lang.Option<T> reduce(Lang.Func2<T, T, T> accumulator) {
        return null;
    }

    @Override
    public boolean allMatch(Lang.Function<? super T, Boolean> predicate) {
        return false;
    }

    @Override
    public boolean anyMatch(Lang.Function<? super T, Boolean> predicate) {
        return false;
    }

    @Override
    public boolean noneMatch(Lang.Function<? super T, Boolean> predicate) {
        return false;
    }

    @Override
    public Lang.Option<T> findOne(Lang.Function<? super T, Boolean> predicate) {
        return null;
    }

    protected final boolean isLazy() {
        return this.is(C.Feature.LAZY);
    }

    protected final boolean isImmutable() {
        return this.is(C.Feature.IMMUTABLE);
    }

    protected final boolean isReadOnly() {
        return this.is(C.Feature.READONLY);
    }

    protected final boolean isMutable() {
        return !this.isImmutable() && !this.isReadOnly();
    }

    @Override
    public SetBase<T> forEach(Lang.Visitor<? super T> visitor) throws Lang.Break {
        for (Object t : this) {
            try {
                visitor.apply(t);
            }
            catch (NotAppliedException notAppliedException) {}
        }
        return this;
    }

    @Override
    public SetBase<T> each(Lang.Visitor<? super T> visitor) {
        return this.forEach((Lang.Visitor)visitor);
    }

    @Override
    public C.Set<T> onlyIn(Collection<? extends T> col) {
        C.Set<T> others = C.newSet(col);
        others.removeAll(this);
        if (this.isImmutable()) {
            return ImmutableSet.of(others);
        }
        return others;
    }

    @Override
    public C.Set<T> withIn(Collection<? extends T> col) {
        C.Set<T> others = C.newSet(col);
        others.retainAll(this);
        if (this.isImmutable()) {
            return ImmutableSet.of(others);
        }
        return others;
    }

    @Override
    public C.Set<T> without(Collection<? super T> col) {
        C.Set copy = C.newSet(this);
        copy.removeAll(col);
        if (this.isImmutable()) {
            return ImmutableSet.of(copy);
        }
        return copy;
    }

    @Override
    public C.Set<T> with(Collection<? extends T> col) {
        C.Set copy = C.newSet(this);
        copy.addAll(col);
        if (this.isImmutable()) {
            return ImmutableSet.of(copy);
        }
        return copy;
    }

    @Override
    public C.Set<T> with(T element) {
        C.Set copy = C.newSet(this);
        copy.add(element);
        return copy;
    }

    @Override
    public C.Set<T> with(T element, T ... elements) {
        C.Set copy = C.newSet(this);
        copy.add(element);
        copy.addAll(C.listOf(elements));
        return copy;
    }

    @Override
    public C.Set<T> without(T element) {
        return null;
    }

    @Override
    public C.Set<T> without(T element, T ... elements) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final EnumSet<C.Feature> features_() {
        if (null == this.features_) {
            SetBase setBase = this;
            synchronized (setBase) {
                if (null == this.features_) {
                    this.features_ = this.initFeatures();
                    assert (null != this.features_);
                }
            }
        }
        return this.features_;
    }

    protected abstract EnumSet<C.Feature> initFeatures();

    @Override
    public final EnumSet<C.Feature> features() {
        return EnumSet.copyOf(this.features_());
    }

    @Override
    public final boolean is(C.Feature feature) {
        return this.features_().contains((Object)feature);
    }

    protected SetBase<T> setFeature(C.Feature feature) {
        this.features_().add(feature);
        return this;
    }

    protected SetBase<T> unsetFeature(C.Feature feature) {
        this.features_().remove((Object)feature);
        return this;
    }
}

