/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.File;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.OsglConfig;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.C;
import org.osgl.util.Charsets;
import org.osgl.util.Codec;
import org.osgl.util.DelegatingStringList;
import org.osgl.util.E;
import org.osgl.util.ImmutableStringList;
import org.osgl.util.Keyword;
import org.osgl.util.ListBuilder;
import org.osgl.util.N;
import org.osgl.util.Nil;
import org.osgl.util.Str;
import org.osgl.util.Unsafe;
import org.osgl.util.algo.StringReplace;

public class S {
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final String HSEP = "\u0000";
    public static final String HIDDEN_SEPARATOR = "\u0000";
    public static final char HSEP_CHAR = '\u0000';
    public static final char HIDDEN_SEPARATOR_CHAR = '\u0000';
    public static final String COMMON_SEP = "[,;:\\s]+";
    public static final Pattern PATTERN_COMMON_SEP = Pattern.compile("[,;:\\s]+");
    public static final String FILE_SEP = File.separator;
    public static final char FILE_SEP_CHAR = File.separatorChar;
    public static final String PATH_SEP = File.pathSeparator;
    public static final char PATH_SEP_CHAR = File.pathSeparatorChar;
    public static final String SINGLE_QUOTE = ",";
    public static final String DOUBLE_QUOTE = "\"";
    public static final char SINGLE_QUOTE_CHAR = '\'';
    public static final char DOUBLE_QUOTE_CHAR = '\"';
    public static final Pair DOUBLE_QUOTES = S.pair("\"", "\"");
    public static final Pair SINGLE_QUOTES = S.pair(",", ",");
    public static final Pair PARENTHESES = S.pair("(", ")");
    public static final Pair BRACKETS;
    public static final Pair SQUARE_BRACKETS;
    public static final Pair BRACES;
    public static final Pair CURLY_BRACES;
    public static final Pair DIAMOND;
    public static final Pair ANGLE_BRACKETS;
    public static final Pair SINGLE_ANGLE_QUOTATION_MARK;
    public static final Pair DOUBLE_ANGLE_QUOTATION_MARK;
    public static final Pair \u4e66\u540d\u53f7;
    public static final Pair SHU_MING_HAO;
    public static final int IGNORECASE = 4096;
    public static final int IGNORESPACE = 8192;
    static final char[] _COMMON_CHARS_;
    static final int _COMMON_CHARS_LEN_;
    private static final ThreadLocal<Buffer> _buf;
    static int BUFFER_RETENTION_LIMIT;
    static int BUFFER_INIT_SIZE;
    private static final ThreadLocal<StringBuilder> _sb;
    public static final List EMPTY_LIST;

    S() {
    }

    public static String getCommonSep() {
        return COMMON_SEP;
    }

    public static final String fmt(String tmpl) {
        return tmpl;
    }

    public static final String fmt(String tmpl, Object ... args) {
        if (0 == args.length) {
            return tmpl;
        }
        return String.format(tmpl, args);
    }

    public static String msgFmt(String template) {
        return S.string(template);
    }

    public static String msgFmt(String template, Object ... args) {
        if (0 == args.length) {
            return template;
        }
        if (null == template) {
            return "";
        }
        return MessageFormat.format(template, args);
    }

    public static boolean isEmpty(String s) {
        return S.empty(s);
    }

    public static boolean isEmpty(CharSequence csq) {
        return null == csq || 0 == csq.length();
    }

    public static boolean empty(String s) {
        return null == s || "".equals(s);
    }

    public static boolean empty(CharSequence csq) {
        return null == csq || 0 == csq.length();
    }

    public static boolean blank(String s) {
        return null == s || "".equals(s.trim());
    }

    public static boolean isBlank(String s) {
        return S.blank(s);
    }

    public static boolean isNotEmpty(String s) {
        return S.notEmpty(s);
    }

    public static boolean notEmpty(String s) {
        return !S.empty(s);
    }

    public static boolean notBlank(String s) {
        return !S.blank(s);
    }

    public static boolean isNotBlank(String s) {
        return !S.blank(s);
    }

    public static boolean isAllEmpty(String ... sa) {
        return S.allEmpty(sa);
    }

    public static boolean allEmpty(String ... sa) {
        for (String s : sa) {
            if (S.empty(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllBlank(String ... sa) {
        return S.allBlank(sa);
    }

    public static boolean allBlank(String ... sa) {
        for (String s : sa) {
            if (S.blank(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyEmpty(String ... sa) {
        return S.anyEmpty(sa);
    }

    public static boolean anyEmpty(String ... sa) {
        for (String s : sa) {
            if (!S.empty(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyBlank(String ... sa) {
        return S.anyBlank(sa);
    }

    public static boolean anyBlank(String ... sa) {
        for (String s : sa) {
            if (!S.blank(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean noEmpty(String ... sa) {
        return !S.anyEmpty(sa);
    }

    public static boolean noBlank(String ... sa) {
        return !S.anyBlank(sa);
    }

    public static boolean isIntOrLong(String s) {
        return N.isInt(s);
    }

    public static boolean isInt(String s) {
        return N.isInt(s);
    }

    public static boolean isNumeric(String s) {
        return N.isNumeric(s);
    }

    public static String requireNotBlank(String s) {
        E.illegalArgumentIf(S.isBlank(s));
        return s;
    }

    public static String requireNotEmpty(String s) {
        E.illegalArgumentIf(S.isEmpty(s));
        return s;
    }

    public static String first(String s, int n) {
        if (n < 0) {
            return S.last(s, n * -1);
        }
        if (n >= s.length()) {
            return s;
        }
        return s.substring(0, n);
    }

    public static int len(String s1) {
        return null == s1 ? 0 : s1.length();
    }

    public static int len(String s1, String ... sa) {
        int len = S.len(s1);
        for (String s : sa) {
            len += S.len(s);
        }
        return len;
    }

    public static T2 binarySplit(String string, char separator) {
        int pos = string.indexOf(separator);
        if (pos < 0) {
            return new T2(string, "");
        }
        return new T2(string.substring(0, pos), string.substring(pos + 1, string.length()));
    }

    public static T3 tripleSplit(String string, char separator) {
        int pos = string.indexOf(separator);
        if (pos < 0) {
            return new T3(string, "", "");
        }
        int pos2 = string.indexOf(separator, pos + 1);
        if (pos2 < 0) {
            return new T3(string.substring(0, pos), string.substring(pos + 1, string.length()), "");
        }
        return new T3(string.substring(0, pos), string.substring(pos + 1, pos2), string.substring(pos2 + 1, string.length()));
    }

    public static List fastSplit(String string, String separator) {
        E.illegalArgumentIf(S.isEmpty(separator), "seperator must not be empty string or null");
        if (S.isEmpty(string)) {
            return ImmutableStringList.of(EMPTY_ARRAY);
        }
        ListBuilder<String> lb = ListBuilder.create();
        int lastPos = 0;
        int gap = separator.length();
        int len = string.length();
        while (true) {
            int pos;
            String part;
            if (S.notEmpty(part = string.substring(lastPos, (pos = string.indexOf(separator, lastPos)) < 0 ? len : pos))) {
                lb.add(part);
            }
            if (pos < 0) break;
            lastPos = pos + gap;
        }
        return ImmutableStringList.of(lb);
    }

    public static List split(CharSequence csq, String regex) {
        return S.isEmpty(csq) ? S.list() : S.listOf(csq.toString().split(regex));
    }

    public static List split(CharSequence csq, Pattern regex) {
        return S.isEmpty(csq) ? S.list() : S.listOf(regex.split(csq));
    }

    public static List split(String string, char separator) {
        if (S.isEmpty(string)) {
            return ImmutableStringList.of(EMPTY_ARRAY);
        }
        ListBuilder<String> lb = ListBuilder.create();
        int lastPos = 0;
        int len = string.length();
        while (true) {
            int pos;
            String part;
            if (S.notEmpty(part = string.substring(lastPos, (pos = string.indexOf(separator, lastPos)) < 0 ? len : pos))) {
                lb.add(part);
            }
            if (pos < 0) break;
            lastPos = pos + 1;
            while (++lastPos < len && separator == string.charAt(lastPos)) {
            }
            --lastPos;
        }
        return ImmutableStringList.of(lb);
    }

    public static String concat(String s1, String s2) {
        return S.buffer().append(s1).append(s2).toString();
    }

    public static String concat(Object o1, Object o2) {
        return S.concat(S.string(o1), S.string(o2));
    }

    public static String concat(String s1, String s2, String s3) {
        return S.buffer().append(s1).append(s2).append(s3).toString();
    }

    public static String concat(Object o1, Object o2, Object o3) {
        return S.concat(S.string(o1), S.string(o2), S.string(o3));
    }

    public static String concat(String s1, String s2, String s3, String s4) {
        return S.buffer().append(s1).append(s2).append(s3).append(s4).toString();
    }

    public static String concat(Object o1, Object o2, Object o3, Object o4) {
        return S.concat(S.string(o1), S.string(o2), S.string(o3), S.string(o4));
    }

    public static String concat(String s1, String s2, String s3, String s4, String s5) {
        return S.buffer(s1).append(s2).append(s3).append(s4).append(s5).toString();
    }

    public static String concat(Object o1, Object o2, Object o3, Object o4, Object o5) {
        return S.concat(S.string(o1), S.string(o2), S.string(o3), S.string(o4), S.string(o5));
    }

    public static String concat(String s1, String s2, String s3, String s4, String s5, String ... extra) {
        Buffer sb = S.buffer(s1).a(s2).a(s3).a(s4).a(s5);
        for (String s : extra) {
            sb.a(s);
        }
        return sb.toString();
    }

    public static String concat(Object o1, Object o2, Object o3, Object o4, Object o5, Object ... extra) {
        int len = extra.length;
        String[] sa = new String[len];
        for (int i = 0; i < len; ++i) {
            sa[i] = S.string(extra[i]);
        }
        return S.concat(S.string(o1), S.string(o2), S.string(o3), S.string(o4), S.string(o5), sa);
    }

    public static String concat(String[] sa) {
        int len = sa.length;
        Buffer buf = S.sizedBuffer(len * 8);
        for (int i = 0; i < len; ++i) {
            buf.a(sa[i]);
        }
        return buf.toString();
    }

    public static String concat(Object[] oa) {
        int len = oa.length;
        Buffer buf = S.sizedBuffer(len * 8);
        for (int i = 0; i < len; ++i) {
            buf.a(oa[i]);
        }
        return buf.toString();
    }

    public static _Is is(Object content) {
        return new _Is(content);
    }

    public static boolean endsWith(String string, String suffix) {
        return S.string(string).endsWith(suffix);
    }

    public static boolean endsWith(String string, char suffix) {
        String s = S.string(string);
        return !s.isEmpty() && s.charAt(string.length() - 1) == suffix;
    }

    public static boolean startsWith(String string, String prefix) {
        return S.string(string).startsWith(prefix);
    }

    public static boolean startsWith(String string, char prefix) {
        String s = S.string(string);
        return !s.isEmpty() && s.charAt(0) == prefix;
    }

    public static _Ensure ensure(Object object) {
        return new _Ensure(object);
    }

    public static String ensureStartsWith(String string, String prefix) {
        return S.startsWith(string, prefix) ? string : S.concat(prefix, string);
    }

    public static String ensureStartsWith(String string, char prefix) {
        return S.startsWith(string, prefix) ? string : S.newSizedBuffer(string.length() + 1).append(prefix).append(string).toString();
    }

    public static String ensureEndsWith(String string, String suffix) {
        return S.endsWith(string, suffix) ? string : S.concat(string, suffix);
    }

    public static String ensureEndsWith(String string, char suffix) {
        return S.endsWith(string, suffix) ? string : S.newSizedBuffer(string.length() + 1).append(string).append(suffix).toString();
    }

    public static String ensureWrappedWith(String string, String left, String right) {
        String retVal = S.string(string);
        if (!retVal.startsWith(left)) {
            retVal = left + retVal;
        }
        if (!retVal.endsWith(right)) {
            retVal = retVal + right;
        }
        return retVal;
    }

    public static String ensureWrappedWith(String string, Lang.Tuple<String, String> wrapper) {
        return S.ensureWrappedWith(string, wrapper.left(), wrapper.right());
    }

    public static String ensureStrippedOff(String string, String left, String right) {
        String retVal = S.string(string);
        if (retVal.startsWith(left)) {
            retVal = retVal.substring(left.length());
        }
        if (retVal.endsWith(right)) {
            retVal = retVal.substring(0, retVal.length() - right.length());
        }
        return retVal;
    }

    public static String ensureStrippedOff(String string, Lang.Tuple<String, String> wrapper) {
        return S.ensureStrippedOff(string, wrapper.left(), wrapper.right());
    }

    public static _SplitStage split(CharSequence csq) {
        return new _SplitStage(csq);
    }

    public static _Have have(char[] ca) {
        return new _Have(ca);
    }

    public static _Have have(Object o) {
        return new _Have(o);
    }

    public static _Have have(String s) {
        return new _Have(s);
    }

    public static _Have take(Object o) {
        return new _Have(o);
    }

    public static _Have take(String s) {
        return new _Have(s);
    }

    public static _Have given(Object o) {
        return new _Have(o);
    }

    public static _Have given(String s) {
        return new _Have(s);
    }

    public static _ReplaceStage replace(Pattern pattern) {
        return new _ReplaceStage(pattern);
    }

    public static _ReplaceStage replace(Object keyword) {
        if (keyword instanceof Pattern) {
            return new _ReplaceStage((Pattern)keyword);
        }
        return new _ReplaceStage(S.string(keyword));
    }

    public static _ReplaceStage replace(String keyword) {
        return new _ReplaceStage(null == keyword ? "" : keyword);
    }

    public static _ReplaceCharStage replace(char c) {
        return new _ReplaceCharStage(c);
    }

    public static String pathConcat(String prefix, char sep, String suffix) {
        boolean prefixHasSep = S.endsWith(prefix, sep);
        boolean suffixHasSep = S.startsWith(suffix, sep);
        int prefixLen = S.len(prefix);
        int suffixLen = S.len(suffix);
        int len = prefixLen + suffixLen + 1;
        Buffer buffer = S.sizedBuffer(len).append(prefix);
        if (prefixHasSep && suffixHasSep) {
            return buffer.deleteCharAt(prefixLen - 1).append(suffix).toString();
        }
        if (prefixHasSep || suffixHasSep) {
            return buffer.append(suffix).toString();
        }
        return buffer.append(sep).append(suffix).toString();
    }

    public static String join(String separator, Iterable<?> iterable) {
        return S.join(separator, null, null, iterable);
    }

    public static String join(String separator, String prefix, String suffix, Iterable<?> iterable) {
        return S.join(separator, prefix, suffix, iterable, false, true);
    }

    public static String join(String separator, String prefix, String suffix, Iterable<?> iterable, boolean quoted, boolean separateFixes) {
        Iterator<?> itr;
        Buffer sb = S.buffer();
        if (null != prefix) {
            sb.append(prefix);
            if (separateFixes) {
                sb.append(separator);
            }
        }
        if ((itr = iterable.iterator()).hasNext()) {
            sb.append(S.string(itr.next(), quoted));
        }
        while (itr.hasNext()) {
            sb.append(separator).append(S.string(itr.next(), quoted));
        }
        if (null != suffix) {
            if (separateFixes) {
                sb.append(separator);
            }
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static _IterableJoiner join(Iterable<?> iterable) {
        return new _IterableJoiner(iterable);
    }

    public static _IterableJoiner join(byte[] array) {
        return new _IterableJoiner(C.listOf(array));
    }

    public static _IterableJoiner join(short[] array) {
        return new _IterableJoiner(C.listOf(array));
    }

    public static _IterableJoiner join(int[] array) {
        return new _IterableJoiner(C.listOf(array));
    }

    public static _IterableJoiner join(long[] array) {
        return new _IterableJoiner(C.listOf(array));
    }

    public static _IterableJoiner join(float[] array) {
        return new _IterableJoiner(C.listOf(array));
    }

    public static _IterableJoiner join(double[] array) {
        return new _IterableJoiner(C.listOf(array));
    }

    public static _IterableJoiner join(Object[] array) {
        return new _IterableJoiner(C.listOf(array));
    }

    public static _StringRepeater repeat(String content) {
        return new _StringRepeater(content);
    }

    public static String join(String separator, String ... list) {
        Buffer sb = S.buffer();
        if (list.length > 0) {
            sb.append(list[0]);
            for (int i = 1; i < list.length; ++i) {
                sb.append(separator).append(list[i]);
            }
        }
        return sb.toString();
    }

    public static String join(String separator, String s, int times) {
        E.illegalArgumentIf(times < 0, "times must not be negative");
        switch (times) {
            case 0: {
                return "";
            }
            case 1: {
                return s;
            }
        }
        int slen = s.length();
        int len = (slen + S.len(separator)) * times;
        StringBuilder sb = len > 100 ? S.builder() : S.newSizedBuilder(len);
        sb.append(s);
        for (int i = 1; i < times; ++i) {
            sb.append(separator).append(s);
        }
        return sb.toString();
    }

    public static String join(String s, int times) {
        E.illegalArgumentIf(times < 0, "times must not be negative");
        switch (times) {
            case 0: {
                return "";
            }
            case 1: {
                return s;
            }
        }
        int slen = s.length();
        int len = slen * times;
        StringBuilder sb = len > 100 ? S.builder() : S.newSizedBuilder(len);
        for (int i = 0; i < times; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String times(String s, int times) {
        return S.join(s, times);
    }

    public static _CharRepeater repeat(char c) {
        return new _CharRepeater(c);
    }

    public static String times(char c, int times) {
        char[] ca = new char[times];
        for (int i = 0; i < times; ++i) {
            ca[i] = c;
        }
        return new String(ca);
    }

    public static _WrapStringBuilder wrap(Object content) {
        return new _WrapStringBuilder(S.string(content));
    }

    public static _WrapStringBuilder wrap(String content) {
        return new _WrapStringBuilder(content);
    }

    public static String wrap(Object content, char symbol) {
        return S.wrap(content, symbol, symbol);
    }

    public static String wrap(String text, char symbol) {
        return S.wrap(text, symbol, symbol);
    }

    public static String wrap(Object content, char left, char right) {
        return S.wrap(S.string(content), left, right);
    }

    public static String wrap(String text, char left, char right) {
        if (null == text) {
            return String.valueOf(new char[]{left, right});
        }
        int textLen = text.length();
        char[] ca = new char[textLen + 2];
        ca[0] = left;
        ca[textLen + 1] = right;
        System.arraycopy(text.toCharArray(), 0, ca, 1, textLen);
        return String.valueOf(ca);
    }

    public static String wrap(Object content, String left, String right) {
        return S.wrap(S.string(content), left, right);
    }

    public static String wrap(String text, String left, String right) {
        return S.concat(left, text, right);
    }

    public static String wrap(Object content, Lang.Tuple<String, String> wrapper) {
        return S.concat(wrapper._1, content, wrapper._2);
    }

    public static String wrap(String text, Lang.Tuple<String, String> wrapper) {
        return S.concat((String)wrapper._1, text, (String)wrapper._2);
    }

    public static String wrap(Object content, String wrapper) {
        return S.wrap(S.string(content), wrapper);
    }

    public static String wrap(String text, String wrapper) {
        return S.quote(text, wrapper);
    }

    @Deprecated
    public static String quote(Object content, char mark) {
        return S.quote(S.string(content), mark);
    }

    @Deprecated
    public static String quote(String content, char mark) {
        if (null == content) {
            return String.valueOf(new char[]{mark, mark});
        }
        return S.sizedBuffer(content.length() + 2).append(mark).append(content).append(mark).toString();
    }

    @Deprecated
    public static String quote(Object content, String mark) {
        return S.quote(S.string(content), mark);
    }

    @Deprecated
    public static String quote(String s, String mark) {
        if (null == s) {
            return S.times(mark, 2);
        }
        return S.concat(mark, s, mark);
    }

    public static _Cut cut(Object object) {
        return new _Cut(object);
    }

    public static String cutOff(String s, int max) {
        return S.maxLength(s, max);
    }

    public static String maxLength(String s, int max) {
        if (null == s) {
            return "";
        }
        if (s.length() < max - 3) {
            return s;
        }
        String s0 = s.substring(0, max);
        return s0 + "...";
    }

    public static String last(String s, int n) {
        if (n < 0) {
            return S.first(s, n * -1);
        }
        int len = s.length();
        if (n >= len) {
            return s;
        }
        return s.substring(len - n, s.length());
    }

    public static String after(String s0, String search) {
        return S.after(s0, search, false);
    }

    public static String after(String s0, String search, boolean first) {
        if (first) {
            return S.afterFirst(s0, search);
        }
        return S.afterLast(s0, search);
    }

    public static String afterLast(String s0, String search) {
        if (null == s0) {
            return "";
        }
        int i = s0.lastIndexOf(search);
        if (i == -1) {
            return "";
        }
        return s0.substring(i + search.length(), s0.length());
    }

    public static String afterFirst(String s0, String search) {
        if (null == s0) {
            return "";
        }
        int i = s0.indexOf(search);
        if (i == -1) {
            return "";
        }
        return s0.substring(i + search.length(), s0.length());
    }

    public static String before(String s0, String search) {
        return S.before(s0, search, false);
    }

    public static String before(String s0, String search, boolean last) {
        if (last) {
            return S.beforeLast(s0, search);
        }
        return S.beforeFirst(s0, search);
    }

    public static String beforeFirst(String s0, String search) {
        if (null == s0) {
            return "";
        }
        int i = s0.indexOf(search);
        if (i == -1) {
            return "";
        }
        return s0.substring(0, i);
    }

    public static final String beforeLast(String s0, String search) {
        if (null == s0) {
            return "";
        }
        int i = s0.lastIndexOf(search);
        if (i == -1) {
            return "";
        }
        return s0.substring(0, i);
    }

    public static String trim(String s) {
        return null == s ? "" : s.trim();
    }

    public static _CountStage count(String search) {
        return new _CountStage(search);
    }

    public static int count(String s, String search) {
        return S.count(s, search, false);
    }

    public static int count(String s, String search, boolean overlap) {
        int n = 0;
        int l = search.length();
        int i;
        while (-1 != (i = s.indexOf(search))) {
            ++n;
            if (overlap) {
                s = s.substring(i + 1);
                continue;
            }
            s = s.substring(i + l);
        }
        return n;
    }

    public static String camelCase(CharSequence s) {
        return Keyword.of(s).camelCase();
    }

    public static String underscore(CharSequence s) {
        return Keyword.of(s).underscore();
    }

    public static String dashed(CharSequence s) {
        return Keyword.of(s).dashed();
    }

    public static String hyphenated(CharSequence s) {
        return S.dashed(s);
    }

    public static String dotted(CharSequence s) {
        return Keyword.of(s).dotted();
    }

    public static String capFirst(String s) {
        if (null == s || "" == s) {
            return "";
        }
        return ("" + s.charAt(0)).toUpperCase() + s.substring(1);
    }

    public static String lowerFirst(String s) {
        if (null == s || "" == s) {
            return "";
        }
        return ("" + s.charAt(0)).toLowerCase() + s.substring(1);
    }

    public static String unsafeCapFirst(String s) {
        if (null == s) {
            return "";
        }
        try {
            char[] buf = Unsafe.bufOf(s);
            char[] newBuf = S.unsafeCapFirst(buf, 0, buf.length);
            if (newBuf == buf) {
                return s;
            }
            return Unsafe.stringOf(newBuf);
        }
        catch (Exception e) {
            return S.capFirst(s);
        }
    }

    static char[] unsafeCapFirst(char[] buf, int begin, int end) {
        int sz = end - begin;
        if (begin == end) {
            return buf;
        }
        char c = buf[begin];
        if (Character.isUpperCase(c)) {
            return buf;
        }
        char[] newBuf = new char[sz];
        newBuf[begin] = Character.toUpperCase(c);
        if (sz == begin + 1) {
            return newBuf;
        }
        System.arraycopy(buf, begin + 1, newBuf, 1, sz - begin - 1);
        return newBuf;
    }

    static final int codePointAt(char[] value, int index) {
        if (index < 0 || index >= value.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return S.codePointAtImpl(value, index, value.length);
    }

    private static int codePointAtImpl(char[] a, int index, int limit) {
        char c2;
        char c1;
        if (Character.isHighSurrogate(c1 = a[index++]) && index < limit && Character.isLowSurrogate(c2 = a[index])) {
            return Character.toCodePoint(c1, c2);
        }
        return c1;
    }

    public static boolean eq(String s1, String s2) {
        return S.equal(s1, s2, 0);
    }

    public static boolean eq(String s1, String s2, int modifier) {
        return S.equal(s1, s2, modifier);
    }

    public static boolean neq(String s1, String s2) {
        return !S.equal(s1, s2);
    }

    public static boolean neq(String s1, String s2, int modifier) {
        return !S.equal(s1, s2, modifier);
    }

    public static boolean equal(String s1, String s2) {
        return S.equal(s1, s2, 0);
    }

    public static boolean notEqual(String s1, String s2) {
        return !S.equal(s1, s2, 0);
    }

    public static boolean isEqual(String s1, String s2) {
        return S.isEqual(s1, s2, 0);
    }

    public static boolean equal(String s1, String s2, int modifier) {
        if (null == s1) {
            return s2 == null;
        }
        if (null == s2) {
            return false;
        }
        if ((modifier & 0x2000) != 0) {
            s1 = s1.trim();
            s2 = s2.trim();
        }
        if ((modifier & 0x1000) != 0) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    public static boolean equal(int modifier, String ... sa) {
        int len = sa.length;
        if (len < 2) {
            throw new IllegalArgumentException("At least 2 strings required");
        }
        String s = sa[0];
        for (int i = 1; i < len; ++i) {
            String s1 = sa[i];
            if (S.equal(s, s1, modifier)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(String s1, String s2, int modifier) {
        return S.equal(s1, s2, modifier);
    }

    public static _StripStage strip(Object o) {
        return new _StripStage(o);
    }

    public static String strip(Object o, String prefix, String suffix) {
        if (null == o) {
            return "";
        }
        String s = o.toString();
        if ((s = s.trim()).startsWith(prefix)) {
            s = s.substring(prefix.length());
        }
        if (s.endsWith(suffix)) {
            s = s.substring(0, s.length() - suffix.length());
        }
        return s;
    }

    public static String strip(Object o, Lang.Tuple<String, String> wrapper) {
        return S.strip(o, wrapper.left(), wrapper.right());
    }

    public static String padLeft(String s, char c, int number) {
        return S.concat(S.times(c, number), s);
    }

    public static String padLeft(String s, int number) {
        return S.padLeft(s, ' ', number);
    }

    public static String lpad(String s, char c, int number) {
        return S.padLeft(s, c, number);
    }

    public static String lpad(String s, int number) {
        return S.padLeft(s, ' ', number);
    }

    public static String padRight(String s, char c, int number) {
        return S.concat(s, S.times(c, number));
    }

    public static String padRight(String s, int number) {
        return S.padRight(s, ' ', number);
    }

    public static String rpad(String s, char c, int number) {
        return S.padLeft(s, c, number);
    }

    public static String rpad(String s, int number) {
        return S.padLeft(s, ' ', number);
    }

    public static String center(String s, int length) {
        return S.center(s, length, ' ');
    }

    public static String center(String s, int length, char padChar) {
        int sLen;
        if (null == s) {
            s = "";
        }
        if (length < 0) {
            length = 0;
        }
        if ((sLen = s.length()) >= length) {
            return s;
        }
        int left = (length - sLen) / 2;
        int right = length - sLen - left;
        return S.concat(S.times(padChar, left), s, S.times(padChar, right));
    }

    public static String reversed(String s) {
        return S.buffer(s).reverse().toString();
    }

    public static String decodeBASE64(String str) {
        return new String(Codec.decodeBase64(str), Charsets.UTF_8);
    }

    public static String decodeBase64(String string) {
        return S.decodeBASE64(string);
    }

    public static String encodeBASE64(String str) {
        return Codec.encodeBase64(str);
    }

    public static String encodeBase64(String str) {
        return S.encodeBASE64(str);
    }

    public static String urlEncode(String s) {
        if (null == s) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "utf-8");
        }
        catch (Exception e) {
            throw E.unexpected(e);
        }
    }

    public static String urlDecode(String s) {
        if (null == s) {
            return "";
        }
        try {
            return URLDecoder.decode(s, "utf-8");
        }
        catch (Exception e) {
            throw E.unexpected(e);
        }
    }

    public static String dos2unix(String s) {
        return s.replace("\n\r", "\n");
    }

    public static String unix2dos(String s) {
        return S.dos2unix(s).replace("\n", "\n\r");
    }

    public static String fileExtension(String fileName) {
        return S.after(fileName, ".");
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String random(int len) {
        return S.random(len, ThreadLocalRandom.current());
    }

    public static String random() {
        return S.random(8);
    }

    public static String secureRandom(int len) {
        return S.random(len, new SecureRandom());
    }

    public static String secureRandom() {
        return S.secureRandom(8);
    }

    private static String random(int len, Random r) {
        char[] chars = _COMMON_CHARS_;
        int charsLen = _COMMON_CHARS_LEN_;
        StringBuilder sb = new StringBuilder(len);
        while (len-- > 0) {
            int i = r.nextInt(charsLen);
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    public static final String string(Object o, boolean quoted) {
        String s = S.string(o);
        return quoted ? S.wrap(s, '\"') : s;
    }

    public static String string(Object o) {
        if (null == o) {
            return "";
        }
        return o.toString();
    }

    public static String string(char c) {
        return String.valueOf(c);
    }

    public static String string(char[] ca) {
        return String.valueOf(ca);
    }

    public static String string(int n) {
        return String.valueOf(n);
    }

    public static String string(long l) {
        return String.valueOf(l);
    }

    public static String string(float f2) {
        return String.valueOf(f2);
    }

    public static String string(double d) {
        return String.valueOf(d);
    }

    public static Str str(Object o) {
        if (null == o) {
            return Str.EMPTY_STR;
        }
        return Str.of(o.toString());
    }

    public static Str str(char ... ca) {
        return Str.of(ca);
    }

    public static Buffer newSizedBuffer(int size) {
        return new Buffer(size);
    }

    public static Buffer sizedBuffer(int size) {
        return size > 100 ? S.buffer() : S.newSizedBuffer(size);
    }

    public static Buffer newBuffer() {
        return new Buffer();
    }

    public static Buffer newBuffer(byte o) {
        return S.newBuffer().append(o);
    }

    public static Buffer newBuffer(short o) {
        return S.newBuffer().append(o);
    }

    public static Buffer newBuffer(char o) {
        return S.newBuffer().append(o);
    }

    public static Buffer newBuffer(int o) {
        return S.newBuffer().append(o);
    }

    public static Buffer newBuffer(float o) {
        return S.newBuffer().append(o);
    }

    public static Buffer newBuffer(long o) {
        return S.newBuffer().append(o);
    }

    public static Buffer newBuffer(double o) {
        return S.newBuffer().append(o);
    }

    public static Buffer newBuffer(Object o) {
        return S.newBuffer().append(o);
    }

    public static Buffer newBuffer(String s) {
        return S.newBuffer().append(s);
    }

    public static Buffer buffer() {
        Buffer sb = _buf.get();
        if (!sb.consumed() || sb.capacity() > BUFFER_RETENTION_LIMIT) {
            sb = new Buffer(BUFFER_INIT_SIZE);
            _buf.set(sb);
            return sb;
        }
        sb.reset();
        return sb;
    }

    public static Buffer buffer(boolean o) {
        return S.buffer().append(o);
    }

    public static Buffer buffer(byte o) {
        return S.buffer().append(o);
    }

    public static Buffer buffer(short o) {
        return S.buffer().append(o);
    }

    public static Buffer buffer(char o) {
        return S.buffer().append(o);
    }

    public static Buffer buffer(int o) {
        return S.buffer().append(o);
    }

    public static Buffer buffer(float o) {
        return S.buffer().append(o);
    }

    public static Buffer buffer(long o) {
        return S.buffer().append(o);
    }

    public static Buffer buffer(double o) {
        return S.buffer().append(o);
    }

    public static Buffer buffer(char[] ca) {
        return S.buffer().append(ca);
    }

    public static Buffer buffer(Object o) {
        if (null == o) {
            return S.buffer();
        }
        Class<?> clz = o.getClass();
        if (clz == char[].class) {
            return S.buffer().append((char[])o);
        }
        if (clz == Character[].class) {
            Character[] ca = (Character[])o;
            Buffer buf = S.buffer();
            for (Character c : ca) {
                buf.append(c);
            }
            return buf;
        }
        return S.buffer().append(o);
    }

    public static Buffer buffer(String s) {
        return S.buffer().append(s);
    }

    public static StringBuilder newBuilder() {
        return new StringBuilder();
    }

    public static StringBuilder newBuilder(byte o) {
        return S.newBuilder().append(o);
    }

    public static StringBuilder newBuilder(short o) {
        return S.newBuilder().append(o);
    }

    public static StringBuilder newBuilder(char o) {
        return S.newBuilder().append(o);
    }

    public static StringBuilder newBuilder(int o) {
        return S.newBuilder().append(o);
    }

    public static StringBuilder newBuilder(float o) {
        return S.newBuilder().append(o);
    }

    public static StringBuilder newBuilder(long o) {
        return S.newBuilder().append(o);
    }

    public static StringBuilder newBuilder(double o) {
        return S.newBuilder().append(o);
    }

    public static StringBuilder newBuilder(Object o) {
        return S.newBuilder().append(o);
    }

    public static StringBuilder newBuilder(String s) {
        return S.newBuilder().append(s);
    }

    public static StringBuilder builder() {
        StringBuilder sb = _sb.get();
        sb.setLength(0);
        return sb;
    }

    public static StringBuilder builder(boolean o) {
        return S.builder().append(o);
    }

    public static StringBuilder builder(byte o) {
        return S.builder().append(o);
    }

    public static StringBuilder builder(short o) {
        return S.builder().append(o);
    }

    public static StringBuilder builder(char o) {
        return S.builder().append(o);
    }

    public static StringBuilder builder(int o) {
        return S.builder().append(o);
    }

    public static StringBuilder builder(float o) {
        return S.builder().append(o);
    }

    public static StringBuilder builder(long o) {
        return S.builder().append(o);
    }

    public static StringBuilder builder(double o) {
        return S.builder().append(o);
    }

    public static StringBuilder builder(Object o) {
        return S.builder().append(o);
    }

    public static StringBuilder builder(String s) {
        return S.builder().append(s);
    }

    @Deprecated
    public static StringBuilder sizedBuilder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static StringBuilder newSizedBuilder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static T2 pair(Lang.T2<String, String> t2) {
        return new T2(t2);
    }

    public static T2 pair(String left, String right) {
        return new T2(left, right);
    }

    public static T2 pair(char left, char right) {
        return new T2(String.valueOf(left), String.valueOf(right));
    }

    public static T2 binary(Lang.T2<String, String> t2) {
        return new T2(t2);
    }

    public static T2 binary(String left, String right) {
        return new T2(left, right);
    }

    public static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    static int count(char[] source, int sourceOffset, int sourceCount, char[] search, int searchOffset, int searchCount, boolean overlap) {
        int n = 0;
        int i;
        while ((i = S.indexOf(source, sourceOffset, sourceCount, search, searchOffset, searchCount, 0)) >= 0) {
            ++n;
            if (overlap) {
                ++sourceOffset;
                continue;
            }
            sourceOffset += searchCount;
        }
        return n;
    }

    static int lastIndexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        int start;
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        char strLastChar = target[strLastIndex];
        int min = sourceOffset + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && source[i] != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (source[j--] == target[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - sourceOffset + 1;
    }

    static char[] bufOf(String s) {
        try {
            return Unsafe.bufOf(s);
        }
        catch (Exception e) {
            return s.toCharArray();
        }
    }

    public static List list() {
        return EMPTY_LIST;
    }

    public static List list(String s) {
        return S.val(s);
    }

    public static List list(String s1, String s2) {
        return ImmutableStringList.of(new String[]{s1, s2});
    }

    public static List list(String s1, String s2, String ... sa) {
        return ImmutableStringList.of($.concat(new String[]{s1, s2}, sa));
    }

    public static List list(Iterable<String> iterable) {
        return ImmutableStringList.of(iterable);
    }

    public static List listOf(String ... sa) {
        return ImmutableStringList.of(sa);
    }

    public static List newList() {
        return new DelegatingStringList(10);
    }

    public static List newList(Iterable<String> iterable) {
        return new DelegatingStringList((Iterable<? extends String>)iterable);
    }

    public static List newList(String string) {
        DelegatingStringList list = new DelegatingStringList(10);
        list.add(string);
        return list;
    }

    public static List newList(String s1, String s2) {
        DelegatingStringList list = new DelegatingStringList(10);
        list.add(s1);
        list.add(s2);
        return list;
    }

    public static List newList(String s1, String s2, String s3) {
        DelegatingStringList list = new DelegatingStringList(10);
        list.add(s1);
        list.add(s2);
        list.add(s3);
        return list;
    }

    public static List newList(String s1, String s2, String s3, String ... sa) {
        List list = S.newList(s1, s2, s3);
        for (String s : sa) {
            list.add(s);
        }
        return list;
    }

    public static List newListOf(String[] sa) {
        DelegatingStringList list = new DelegatingStringList(sa.length);
        for (String s : sa) {
            list.add(s);
        }
        return list;
    }

    public static Var var(String s) {
        return new Var(s);
    }

    public static Val val(String s) {
        return new Val(s);
    }

    public static void main(String[] args) {
        System.out.println(S.join(new int[]{1, 2, 3}).by("-").get());
    }

    static {
        SQUARE_BRACKETS = BRACKETS = S.pair("[", "]");
        CURLY_BRACES = BRACES = S.pair("{", "}");
        ANGLE_BRACKETS = DIAMOND = S.pair("<", ">");
        SINGLE_ANGLE_QUOTATION_MARK = S.pair("\u2039", "\u203a");
        DOUBLE_ANGLE_QUOTATION_MARK = S.pair("\u00ab", "\u00bb");
        SHU_MING_HAO = \u4e66\u540d\u53f7 = S.pair("\u300a", "\u300b");
        _COMMON_CHARS_ = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '$', '#', '^', '&', '_', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '~', '!', '@'};
        _COMMON_CHARS_LEN_ = _COMMON_CHARS_.length;
        _buf = new ThreadLocal<Buffer>(){

            @Override
            protected Buffer initialValue() {
                Buffer buf = new Buffer();
                buf.consumed = true;
                return buf;
            }
        };
        BUFFER_RETENTION_LIMIT = 1024;
        BUFFER_INIT_SIZE = 512;
        _sb = new ThreadLocal<StringBuilder>(){

            @Override
            protected StringBuilder initialValue() {
                return new StringBuilder();
            }
        };
        EMPTY_LIST = new Nil.EmptyStringList();
    }

    public static class Var
    extends Lang.Var<String>
    implements List {
        public Var(String value) {
            super(value);
        }
    }

    public static class Val
    extends Lang.Val<String>
    implements List {
        public Val(String value) {
            super(value);
        }
    }

    public static interface List
    extends C.List<String> {
    }

    public static class T5
    extends Quintuple {
        public T5(String _1, String _2, String _3, String _4, String _5) {
            super(_1, _2, _3, _4, _5);
        }

        public T5(Lang.Quintuple<String, String, String, String, String> t5) {
            super(t5);
        }
    }

    public static class Quintuple
    extends Lang.T5<String, String, String, String, String> {
        public Quintuple(String _1, String _2, String _3, String _4, String _5) {
            super(_1, _2, _3, _4, _5);
        }

        public Quintuple(Lang.Quintuple<String, String, String, String, String> t5) {
            super(t5._1, t5._2, t5._3, t5._4, t5._5);
        }
    }

    public static class T4
    extends Quadruple {
        public T4(String _1, String _2, String _3, String _4) {
            super(_1, _2, _3, _4);
        }

        public T4(Lang.Quadruple<String, String, String, String> t4) {
            super(t4);
        }
    }

    public static class Quadruple
    extends Lang.T4<String, String, String, String> {
        public Quadruple(String _1, String _2, String _3, String _4) {
            super(_1, _2, _3, _4);
        }

        public Quadruple(Lang.Quadruple<String, String, String, String> t4) {
            super(t4._1, t4._2, t4._3, t4._4);
        }
    }

    public static class T3
    extends Triple {
        public T3(String _1, String _2, String _3) {
            super(_1, _2, _3);
        }

        public T3(Lang.Triple<String, String, String> t3) {
            super(t3);
        }
    }

    public static class Triple
    extends Lang.T3<String, String, String> {
        public Triple(String _1, String _2, String _3) {
            super(_1, _2, _3);
        }

        public Triple(Lang.Triple<String, String, String> t3) {
            super(t3._1, t3._2, t3._3);
        }
    }

    public static class T2
    extends Pair {
        public T2(String _1, String _2) {
            super(_1, _2);
        }

        public T2(Lang.T2<String, String> t2) {
            super(t2);
        }
    }

    public static class Pair
    extends Binary {
        public Pair(String _1, String _2) {
            super(_1, _2);
        }

        public Pair(Lang.Tuple<String, String> tuple) {
            super(tuple);
        }
    }

    public static class Binary
    extends Lang.T2<String, String> {
        public Binary(String _1, String _2) {
            super(_1, _2);
        }

        public Binary(Lang.Tuple<String, String> t2) {
            super(t2._1, t2._2);
        }
    }

    public static class Buffer
    extends Writer
    implements Appendable,
    CharSequence {
        private char[] value;
        private int count;
        private boolean consumed;
        private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
        static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
        static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

        public Buffer() {
            this(16);
        }

        public Buffer(int capacity) {
            this.value = new char[capacity];
            this.consumed = false;
        }

        public final boolean consumed() {
            return this.consumed;
        }

        private Buffer consume() {
            this.consumed = true;
            return this;
        }

        public Buffer reset() {
            this.setLength(0);
            this.consumed = false;
            return this;
        }

        public Buffer clear() {
            this.setLength(0);
            return this;
        }

        @Override
        public int length() {
            return this.count;
        }

        @Override
        public boolean isEmpty() {
            return 0 == this.count;
        }

        public int capacity() {
            return this.value.length;
        }

        public void ensureCapacity(int minimumCapacity) {
            if (minimumCapacity > 0) {
                this.ensureCapacityInternal(minimumCapacity);
            }
        }

        public void trimToSize() {
            if (this.count < this.value.length) {
                this.value = Arrays.copyOf(this.value, this.count);
            }
        }

        public void setLength(int newLength) {
            if (newLength < 0) {
                throw new StringIndexOutOfBoundsException(newLength);
            }
            this.ensureCapacityInternal(newLength);
            if (this.count < newLength) {
                Arrays.fill(this.value, this.count, newLength, '\u0000');
            }
            this.count = newLength;
        }

        @Override
        public char charAt(int index) {
            if (index < 0 || index >= this.count) {
                throw new StringIndexOutOfBoundsException(index);
            }
            return this.value[index];
        }

        public char get(int index) {
            return this.charAt(index);
        }

        public int codePointAt(int index) {
            if (index < 0 || index >= this.count) {
                throw new StringIndexOutOfBoundsException(index);
            }
            return Character.codePointAt(this.value, index, this.count);
        }

        public int codePointBefore(int index) {
            int i = index - 1;
            if (i < 0 || i >= this.count) {
                throw new StringIndexOutOfBoundsException(index);
            }
            return Character.codePointBefore(this.value, index, 0);
        }

        public int codePointCount(int beginIndex, int endIndex) {
            if (beginIndex < 0 || endIndex > this.count || beginIndex > endIndex) {
                throw new IndexOutOfBoundsException();
            }
            return Character.codePointCount(this.value, beginIndex, endIndex - beginIndex);
        }

        public int offsetByCodePoints(int index, int codePointOffset) {
            if (index < 0 || index > this.count) {
                throw new IndexOutOfBoundsException();
            }
            return Character.offsetByCodePoints(this.value, 0, this.count, index, codePointOffset);
        }

        public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
            if (srcBegin < 0) {
                throw new StringIndexOutOfBoundsException(srcBegin);
            }
            if (srcEnd < 0 || srcEnd > this.count) {
                throw new StringIndexOutOfBoundsException(srcEnd);
            }
            if (srcBegin > srcEnd) {
                throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
            }
            System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
        }

        public void setCharAt(int index, char ch) {
            if (index < 0 || index >= this.count) {
                throw new StringIndexOutOfBoundsException(index);
            }
            this.value[index] = ch;
        }

        public void set(int index, char ch) {
            this.setCharAt(index, ch);
        }

        public Buffer append(Object obj) {
            return this.append(S.string(obj));
        }

        public Buffer a(Object obj) {
            return this.append(obj);
        }

        public Buffer prepend(Object obj) {
            return this.prepend(String.valueOf(obj));
        }

        public Buffer p(Object obj) {
            return this.prepend(obj);
        }

        public Buffer append(String str) {
            if (str == null) {
                return this.appendNull();
            }
            int len = str.length();
            this.ensureCapacityInternal(this.count + len);
            str.getChars(0, len, this.value, this.count);
            this.count += len;
            return this;
        }

        public Buffer a(String str) {
            return this.append(str);
        }

        public Buffer prepend(String str) {
            if (null == str) {
                return this.prependNull();
            }
            int len = str.length();
            this.ensureCapacityInternal(this.count + len);
            System.arraycopy(this.value, 0, this.value, len, this.count);
            str.getChars(0, len, this.value, 0);
            this.count += len;
            return this;
        }

        public Buffer p(String str) {
            return this.prepend(str);
        }

        public Buffer append(StringBuffer sb) {
            if (sb == null) {
                return this.appendNull();
            }
            int len = sb.length();
            this.ensureCapacityInternal(this.count + len);
            sb.getChars(0, len, this.value, this.count);
            this.count += len;
            return this;
        }

        public Buffer a(StringBuffer sb) {
            return this.append(sb);
        }

        public Buffer prepend(StringBuffer sb) {
            if (sb == null) {
                return this.appendNull();
            }
            int len = sb.length();
            this.ensureCapacityInternal(this.count + len);
            System.arraycopy(this.value, 0, this.value, len, this.count);
            sb.getChars(0, len, this.value, 0);
            this.count += len;
            return this;
        }

        public Buffer p(StringBuffer sb) {
            return this.prepend(sb);
        }

        public Buffer append(StringBuilder sb) {
            if (sb == null) {
                return this.appendNull();
            }
            int len = sb.length();
            this.ensureCapacityInternal(this.count + len);
            sb.getChars(0, len, this.value, this.count);
            this.count += len;
            return this;
        }

        public Buffer a(StringBuilder sb) {
            return this.append(sb);
        }

        public Buffer prepend(StringBuilder sb) {
            if (sb == null) {
                return this.prependNull();
            }
            int len = sb.length();
            this.ensureCapacityInternal(this.count + len);
            System.arraycopy(this.value, 0, this.value, len, this.count);
            sb.getChars(0, len, this.value, 0);
            this.count += len;
            return this;
        }

        public Buffer p(StringBuilder sb) {
            return this.prepend(sb);
        }

        public Buffer append(Buffer asb) {
            if (asb == null) {
                return this.appendNull();
            }
            int len = asb.length();
            this.ensureCapacityInternal(this.count + len);
            asb.getChars(0, len, this.value, this.count);
            this.count += len;
            return this;
        }

        public Buffer a(Buffer asb) {
            return this.append(asb);
        }

        public Buffer prepend(Buffer asb) {
            if (asb == null) {
                return this.prependNull();
            }
            int len = asb.length();
            this.ensureCapacityInternal(this.count + len);
            System.arraycopy(this.value, 0, this.value, len, this.count);
            asb.getChars(0, len, this.value, 0);
            this.count += len;
            return this;
        }

        public Buffer p(Buffer asb) {
            return this.prepend(asb);
        }

        @Override
        public Buffer append(CharSequence s) {
            if (s == null) {
                return this.appendNull();
            }
            if (s instanceof String) {
                return this.append((String)s);
            }
            if (s instanceof Buffer) {
                return this.append((Buffer)s);
            }
            return this.append(s, 0, s.length());
        }

        public Buffer a(CharSequence s) {
            return this.append(s);
        }

        public Buffer prepend(CharSequence s) {
            if (s == null) {
                return this.prependNull();
            }
            if (s instanceof String) {
                return this.prepend((String)s);
            }
            if (s instanceof Buffer) {
                return this.prepend((Buffer)s);
            }
            if (s instanceof StringBuffer) {
                return this.prepend((StringBuffer)s);
            }
            if (s instanceof StringBuilder) {
                return this.prepend((StringBuilder)s);
            }
            return this.append(s, 0, s.length());
        }

        public Buffer p(CharSequence s) {
            return this.prepend(s);
        }

        private Buffer appendNull() {
            return this;
        }

        private Buffer prependNull() {
            return this;
        }

        @Override
        public Buffer append(CharSequence s, int start, int end) {
            if (s == null) {
                s = "null";
            }
            if (start < 0 || start > end || end > s.length()) {
                throw new IndexOutOfBoundsException("start " + start + ", end " + end + ", s.length() " + s.length());
            }
            int len = end - start;
            this.ensureCapacityInternal(this.count + len);
            int i = start;
            int j = this.count;
            while (i < end) {
                this.value[j] = s.charAt(i);
                ++i;
                ++j;
            }
            this.count += len;
            return this;
        }

        public Buffer append(char[] str) {
            int len = str.length;
            this.ensureCapacityInternal(this.count + len);
            System.arraycopy(str, 0, this.value, this.count, len);
            this.count += len;
            return this;
        }

        public Buffer a(char[] str) {
            return this.append(str);
        }

        public Buffer prepend(char[] str) {
            int len = str.length;
            this.ensureCapacityInternal(this.count + len);
            System.arraycopy(this.value, 0, this.value, this.count, this.count);
            System.arraycopy(str, 0, this.value, this.count, 0);
            this.count += len;
            return this;
        }

        public Buffer p(char[] str) {
            return this.prepend(str);
        }

        public Buffer append(char[] str, int offset, int len) {
            if (len > 0) {
                this.ensureCapacityInternal(this.count + len);
            }
            System.arraycopy(str, offset, this.value, this.count, len);
            this.count += len;
            return this;
        }

        public Buffer prepend(boolean b) {
            if (b) {
                this.ensureCapacityInternal(this.count + 4);
                System.arraycopy(this.value, 0, this.value, 4, this.count);
                int cursor = 0;
                this.value[cursor++] = 116;
                this.value[cursor++] = 114;
                this.value[cursor++] = 117;
                this.value[cursor++] = 101;
                this.count += 4;
            } else {
                this.ensureCapacityInternal(this.count + 5);
                System.arraycopy(this.value, 0, this.value, 5, this.count);
                int cursor = 0;
                this.value[cursor++] = 102;
                this.value[cursor++] = 97;
                this.value[cursor++] = 108;
                this.value[cursor++] = 115;
                this.value[cursor++] = 101;
                this.count += 5;
            }
            return this;
        }

        public Buffer p(boolean b) {
            return this.prepend(b);
        }

        public Buffer append(boolean b) {
            if (b) {
                this.ensureCapacityInternal(this.count + 4);
                this.value[this.count++] = 116;
                this.value[this.count++] = 114;
                this.value[this.count++] = 117;
                this.value[this.count++] = 101;
            } else {
                this.ensureCapacityInternal(this.count + 5);
                this.value[this.count++] = 102;
                this.value[this.count++] = 97;
                this.value[this.count++] = 108;
                this.value[this.count++] = 115;
                this.value[this.count++] = 101;
            }
            return this;
        }

        public Buffer a(boolean b) {
            return this.append(b);
        }

        @Override
        public Buffer append(char c) {
            this.ensureCapacityInternal(this.count + 1);
            this.value[this.count++] = c;
            return this;
        }

        public Buffer a(char c) {
            return this.append(c);
        }

        public Buffer prepend(char c) {
            this.ensureCapacityInternal(this.count + 1);
            System.arraycopy(this.value, 0, this.value, 1, this.count);
            this.value[0] = c;
            return this;
        }

        public Buffer p(char c) {
            return this.prepend(c);
        }

        public Buffer append(int i) {
            if (i == Integer.MIN_VALUE) {
                this.append("-2147483648");
                return this;
            }
            int appendedLength = i < 0 ? Buffer.stringSize(-i) + 1 : Buffer.stringSize(i);
            int spaceNeeded = this.count + appendedLength;
            this.ensureCapacityInternal(spaceNeeded);
            Buffer.getChars(i, spaceNeeded, this.value);
            this.count = spaceNeeded;
            return this;
        }

        public Buffer a(int i) {
            return this.append(i);
        }

        public Buffer prepend(int i) {
            if (i == Integer.MIN_VALUE) {
                this.prepend("-2147483648");
                return this;
            }
            int appendedLength = i < 0 ? Buffer.stringSize(-i) + 1 : Buffer.stringSize(i);
            int spaceNeeded = this.count + appendedLength;
            this.ensureCapacityInternal(spaceNeeded);
            System.arraycopy(this.value, 0, this.value, appendedLength, this.count);
            Buffer.getChars(i, appendedLength, this.value);
            this.count = spaceNeeded;
            return this;
        }

        public Buffer p(int i) {
            return this.prepend(i);
        }

        public Buffer append(long l) {
            if (l == Long.MIN_VALUE) {
                this.append("-9223372036854775808");
                return this;
            }
            int appendedLength = l < 0L ? Buffer.stringSize(-l) + 1 : Buffer.stringSize(l);
            int spaceNeeded = this.count + appendedLength;
            this.ensureCapacityInternal(spaceNeeded);
            Buffer.getChars(l, spaceNeeded, this.value);
            this.count = spaceNeeded;
            return this;
        }

        public Buffer a(long l) {
            return this.append(l);
        }

        public Buffer prepend(long l) {
            if (l == Long.MIN_VALUE) {
                this.append("-9223372036854775808");
                return this;
            }
            int appendedLength = l < 0L ? Buffer.stringSize(-l) + 1 : Buffer.stringSize(l);
            int spaceNeeded = this.count + appendedLength;
            this.ensureCapacityInternal(spaceNeeded);
            System.arraycopy(this.value, 0, this.value, appendedLength, this.count);
            Buffer.getChars(l, appendedLength, this.value);
            this.count = spaceNeeded;
            return this;
        }

        public Buffer p(long l) {
            return this.prepend(l);
        }

        public Buffer append(float f2) {
            return this.append(String.valueOf(f2));
        }

        public Buffer a(float f2) {
            return this.append(f2);
        }

        public Buffer prepend(float f2) {
            return this.prepend(String.valueOf(f2));
        }

        public Buffer p(float f2) {
            return this.prepend(f2);
        }

        public Buffer append(double d) {
            return this.append(String.valueOf(d));
        }

        public Buffer a(double d) {
            return this.append(d);
        }

        public Buffer prepend(double d) {
            return this.prepend(String.valueOf(d));
        }

        public Buffer p(double d) {
            return this.prepend(d);
        }

        public Buffer delete(int start, int end) {
            if (start < 0) {
                throw new StringIndexOutOfBoundsException(start);
            }
            if (end > this.count) {
                end = this.count;
            }
            if (start > end) {
                throw new StringIndexOutOfBoundsException();
            }
            int len = end - start;
            if (len > 0) {
                System.arraycopy(this.value, start + len, this.value, start, this.count - end);
                this.count -= len;
            }
            return this;
        }

        public Buffer appendCodePoint(int codePoint) {
            int count = this.count;
            if (Character.isBmpCodePoint(codePoint)) {
                this.ensureCapacityInternal(count + 1);
                this.value[count] = (char)codePoint;
                this.count = count + 1;
            } else if (Character.isValidCodePoint(codePoint)) {
                this.ensureCapacityInternal(count + 2);
                Buffer.toSurrogates(codePoint, this.value, count);
                this.count = count + 2;
            } else {
                throw new IllegalArgumentException();
            }
            return this;
        }

        public Buffer deleteCharAt(int index) {
            if (index < 0 || index >= this.count) {
                throw new StringIndexOutOfBoundsException(index);
            }
            System.arraycopy(this.value, index + 1, this.value, index, this.count - index - 1);
            --this.count;
            return this;
        }

        public Buffer replace(int start, int end, String str) {
            if (start < 0) {
                throw new StringIndexOutOfBoundsException(start);
            }
            if (start > this.count) {
                throw new StringIndexOutOfBoundsException("start > length()");
            }
            if (start > end) {
                throw new StringIndexOutOfBoundsException("start > end");
            }
            if (end > this.count) {
                end = this.count;
            }
            int len = str.length();
            int newCount = this.count + len - (end - start);
            this.ensureCapacityInternal(newCount);
            System.arraycopy(this.value, end, this.value, start + len, this.count - end);
            char[] strVal = str.toCharArray();
            System.arraycopy(this.value, 0, strVal, start, this.value.length);
            this.count = newCount;
            return this;
        }

        public String substring(int start) {
            return this.substring(start, this.count);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.substring(start, end);
        }

        public String substring(int start, int end) {
            if (start < 0) {
                throw new StringIndexOutOfBoundsException(start);
            }
            if (end > this.count) {
                throw new StringIndexOutOfBoundsException(end);
            }
            if (start > end) {
                throw new StringIndexOutOfBoundsException(end - start);
            }
            return new String(this.value, start, end - start);
        }

        public Buffer insert(int index, char[] str, int offset, int len) {
            if (index < 0 || index > this.length()) {
                throw new StringIndexOutOfBoundsException(index);
            }
            if (offset < 0 || len < 0 || offset > str.length - len) {
                throw new StringIndexOutOfBoundsException("offset " + offset + ", len " + len + ", str.length " + str.length);
            }
            this.ensureCapacityInternal(this.count + len);
            System.arraycopy(this.value, index, this.value, index + len, this.count - index);
            System.arraycopy(str, offset, this.value, index, len);
            this.count += len;
            return this;
        }

        public Buffer insert(int offset, Object obj) {
            return this.insert(offset, String.valueOf(obj));
        }

        public Buffer insert(int offset, String str) {
            if (offset < 0 || offset > this.length()) {
                throw new StringIndexOutOfBoundsException(offset);
            }
            if (str == null) {
                str = "null";
            }
            int len = str.length();
            this.ensureCapacityInternal(this.count + len);
            System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
            char[] strVal = str.toCharArray();
            System.arraycopy(this.value, 0, strVal, offset, this.value.length);
            this.count += len;
            return this;
        }

        public Buffer insert(int offset, char[] str) {
            if (offset < 0 || offset > this.length()) {
                throw new StringIndexOutOfBoundsException(offset);
            }
            int len = str.length;
            this.ensureCapacityInternal(this.count + len);
            System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
            System.arraycopy(str, 0, this.value, offset, len);
            this.count += len;
            return this;
        }

        public Buffer insert(int dstOffset, CharSequence s) {
            if (s == null) {
                s = "null";
            }
            if (s instanceof String) {
                return this.insert(dstOffset, (String)s);
            }
            return this.insert(dstOffset, s, 0, s.length());
        }

        public Buffer insert(int dstOffset, CharSequence s, int start, int end) {
            if (s == null) {
                s = "null";
            }
            if (dstOffset < 0 || dstOffset > this.length()) {
                throw new IndexOutOfBoundsException("dstOffset " + dstOffset);
            }
            if (start < 0 || end < 0 || start > end || end > s.length()) {
                throw new IndexOutOfBoundsException("start " + start + ", end " + end + ", s.length() " + s.length());
            }
            int len = end - start;
            this.ensureCapacityInternal(this.count + len);
            System.arraycopy(this.value, dstOffset, this.value, dstOffset + len, this.count - dstOffset);
            for (int i = start; i < end; ++i) {
                this.value[dstOffset++] = s.charAt(i);
            }
            this.count += len;
            return this;
        }

        public Buffer insert(int offset, boolean b) {
            return this.insert(offset, String.valueOf(b));
        }

        public Buffer insert(int offset, char c) {
            this.ensureCapacityInternal(this.count + 1);
            System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
            this.value[offset] = c;
            ++this.count;
            return this;
        }

        public Buffer insert(int offset, int i) {
            return this.insert(offset, String.valueOf(i));
        }

        public Buffer insert(int offset, long l) {
            return this.insert(offset, String.valueOf(l));
        }

        public Buffer insert(int offset, float f2) {
            return this.insert(offset, String.valueOf(f2));
        }

        public Buffer insert(int offset, double d) {
            return this.insert(offset, String.valueOf(d));
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            this.append(cbuf, off, len);
        }

        @Override
        public void write(int c) {
            this.append((char)c);
        }

        @Override
        public void write(char[] cbuf) {
            this.write(cbuf, 0, cbuf.length);
        }

        @Override
        public void write(String str) {
            this.write(str, 0, str.length());
        }

        @Override
        public void write(String str, int off, int len) {
            this.append(str, off, off + len);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        public int indexOf(String str) {
            return this.indexOf(str, 0);
        }

        public int indexOf(String str, int fromIndex) {
            char[] buf = str.toCharArray();
            return S.indexOf(this.value, 0, this.count, buf, 0, buf.length, fromIndex);
        }

        public int lastIndexOf(String str) {
            return this.lastIndexOf(str, this.count);
        }

        public int lastIndexOf(String str, int fromIndex) {
            char[] buf = str.toCharArray();
            return S.lastIndexOf(this.value, 0, this.count, buf, 0, buf.length, fromIndex);
        }

        public Buffer reverse() {
            boolean hasSurrogates = false;
            int n = this.count - 1;
            for (int j = n - 1 >> 1; j >= 0; --j) {
                char ck;
                int k = n - j;
                char cj = this.value[j];
                this.value[j] = ck = this.value[k];
                this.value[k] = cj;
                if (!Character.isSurrogate(cj) && !Character.isSurrogate(ck)) continue;
                hasSurrogates = true;
            }
            if (hasSurrogates) {
                this.reverseAllValidSurrogatePairs();
            }
            return this;
        }

        private void ensureCapacityInternal(int minimumCapacity) {
            if (minimumCapacity - this.value.length > 0) {
                this.value = Arrays.copyOf(this.value, this.newCapacity(minimumCapacity));
            }
        }

        private int newCapacity(int minCapacity) {
            int newCapacity = (this.value.length << 1) + 2;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            return newCapacity <= 0 || 0x7FFFFFF7 - newCapacity < 0 ? this.hugeCapacity(minCapacity) : newCapacity;
        }

        private int hugeCapacity(int minCapacity) {
            if (Integer.MAX_VALUE - minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            return minCapacity > 0x7FFFFFF7 ? minCapacity : 0x7FFFFFF7;
        }

        private void reverseAllValidSurrogatePairs() {
            for (int i = 0; i < this.count - 1; ++i) {
                char c1;
                char c2 = this.value[i];
                if (!Character.isLowSurrogate(c2) || !Character.isHighSurrogate(c1 = this.value[i + 1])) continue;
                this.value[i++] = c1;
                this.value[i] = c2;
            }
        }

        @Override
        public String toString() {
            String retval = new String(this.value, 0, this.count);
            this.consume();
            return retval;
        }

        final char[] getValue() {
            return this.value;
        }

        static int stringSize(int x) {
            int i = 0;
            while (x > sizeTable[i]) {
                ++i;
            }
            return i + 1;
        }

        static void getChars(int i, int index, char[] buf) {
            int r;
            int q;
            int charPos = index;
            int sign = 0;
            if (i < 0) {
                sign = 45;
                i = -i;
            }
            while (i >= 65536) {
                q = i / 100;
                r = i - ((q << 6) + (q << 5) + (q << 2));
                i = q;
                buf[--charPos] = DigitOnes[r];
                buf[--charPos] = DigitTens[r];
            }
            do {
                q = i * 52429 >>> 19;
                r = i - ((q << 3) + (q << 1));
                buf[--charPos] = digits[r];
            } while ((i = q) != 0);
            if (sign != 0) {
                buf[--charPos] = sign;
            }
        }

        static int stringSize(long x) {
            long p = 10L;
            for (int i = 1; i < 19; ++i) {
                if (x < p) {
                    return i;
                }
                p = 10L * p;
            }
            return 19;
        }

        static void getChars(long i, int index, char[] buf) {
            int q2;
            int r;
            int charPos = index;
            int sign = 0;
            if (i < 0L) {
                sign = 45;
                i = -i;
            }
            while (i > Integer.MAX_VALUE) {
                long q = i / 100L;
                r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
                i = q;
                buf[--charPos] = DigitOnes[r];
                buf[--charPos] = DigitTens[r];
            }
            int i2 = (int)i;
            while (i2 >= 65536) {
                q2 = i2 / 100;
                r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
                i2 = q2;
                buf[--charPos] = DigitOnes[r];
                buf[--charPos] = DigitTens[r];
            }
            do {
                q2 = i2 * 52429 >>> 19;
                r = i2 - ((q2 << 3) + (q2 << 1));
                buf[--charPos] = digits[r];
            } while ((i2 = q2) != 0);
            if (sign != 0) {
                buf[--charPos] = sign;
            }
        }

        static void toSurrogates(int codePoint, char[] dst, int index) {
            dst[index + 1] = Character.lowSurrogate(codePoint);
            dst[index] = Character.highSurrogate(codePoint);
        }
    }

    public static enum F {

        public static Lang.F2<String, String, Boolean> STARTS_WITH = new Lang.F2<String, String, Boolean>(){

            @Override
            public Boolean apply(String s, String s2) throws NotAppliedException, Lang.Break {
                return s.startsWith(s2);
            }
        };
        public static Lang.F2<String, String, Boolean> ENDS_WITH = new Lang.F2<String, String, Boolean>(){

            @Override
            public Boolean apply(String s, String s2) throws NotAppliedException, Lang.Break {
                return s.endsWith(s2);
            }
        };
        public static Lang.F2<String, String, Boolean> CONTAINS = new Lang.F2<String, String, Boolean>(){

            @Override
            public Boolean apply(String s, String s2) throws NotAppliedException, Lang.Break {
                return s.contains(s2);
            }
        };
        public static Lang.F1<String, String> TO_UPPERCASE = new Lang.F1<String, String>(){

            @Override
            public String apply(String s) throws NotAppliedException, Lang.Break {
                return s.toUpperCase();
            }
        };
        public static Lang.F1<String, String> TO_LOWERCASE = new Lang.F1<String, String>(){

            @Override
            public String apply(String s) throws NotAppliedException, Lang.Break {
                return s.toLowerCase();
            }
        };
        public static Lang.Transformer<String, String> NULL_SAFE = new Lang.Transformer<String, String>(){

            @Override
            public String transform(String s) {
                return null == s ? "" : s;
            }
        };
        public static Lang.F1<String, String> TRIM = new Lang.F1<String, String>(){

            @Override
            public String apply(String s) throws NotAppliedException, Lang.Break {
                return s.trim();
            }
        };
        public static Lang.F1<String, String> CAP_FIRST = new Lang.F1<String, String>(){

            @Override
            public String apply(String s) throws NotAppliedException, Lang.Break {
                return S.capFirst(s);
            }
        };
        public static Lang.Predicate<String> IS_EMPTY = new Lang.Predicate<String>(){

            @Override
            public boolean test(String s) throws NotAppliedException, Lang.Break {
                return S.isEmpty(s);
            }
        };
        public static Lang.Predicate<String> IS_BLANK = new Lang.Predicate<String>(){

            @Override
            public boolean test(String s) {
                return S.isBlank(s);
            }
        };
        public static Lang.Predicate<String> NOT_EMPTY = IS_EMPTY.negate();
        public static Lang.F2<String, Integer, String> MAX_LENGTH = new Lang.F2<String, Integer, String>(){

            @Override
            public String apply(String s, Integer n) throws NotAppliedException, Lang.Break {
                return S.maxLength(s, n);
            }
        };
        public static Lang.F1<String, List> SPLIT = F.split("[,;:\\s]+");
        public static Lang.F2<String, Integer, String> LAST = new Lang.F2<String, Integer, String>(){

            @Override
            public String apply(String s, Integer n) throws NotAppliedException, Lang.Break {
                return S.last(s, n);
            }
        };
        public static Lang.F2<String, Integer, String> FIRST = new Lang.F2<String, Integer, String>(){

            @Override
            public String apply(String s, Integer n) throws NotAppliedException, Lang.Break {
                return S.first(s, n);
            }
        };
        public static Lang.F0<String> RANDOM = new Lang.F0<String>(){

            @Override
            public String apply() throws NotAppliedException, Lang.Break {
                return S.random();
            }
        };
        public static Lang.F1<Integer, String> RANDOM_N = new Lang.F1<Integer, String>(){

            @Override
            public String apply(Integer n) throws NotAppliedException, Lang.Break {
                return S.random(n);
            }
        };
        public static Lang.F1<String, Integer> LENGTH = new Lang.F1<String, Integer>(){

            @Override
            public Integer apply(String s) throws NotAppliedException, Lang.Break {
                return s.length();
            }
        };

        public static Lang.Predicate<String> startsWith(String prefix) {
            return $.predicate(STARTS_WITH.curry(prefix));
        }

        public static Lang.Predicate<String> endsWith(String suffix) {
            return $.predicate(ENDS_WITH.curry(suffix));
        }

        public static Lang.Predicate<String> contains(String search) {
            return $.predicate(CONTAINS.curry(search));
        }

        public static Lang.F1<String, List> split(final String sep) {
            return new Lang.F1<String, List>(){

                @Override
                public List apply(String s) throws NotAppliedException, Lang.Break {
                    return ImmutableStringList.of(s.split(sep));
                }
            };
        }

        public static Lang.F1<String, String> maxLength(int n) {
            return MAX_LENGTH.curry(n);
        }

        public static Lang.F1<String, String> last(int n) {
            return LAST.curry(n);
        }

        public static Lang.F1<String, String> first(int n) {
            return FIRST.curry(n);
        }

        public static Lang.F0<String> random() {
            return RANDOM;
        }

        public static Lang.F0<String> random(int n) {
            return RANDOM_N.curry(n);
        }

        public static Lang.F1<String, String> append(final String appendix) {
            return new Lang.F1<String, String>(){

                @Override
                public String apply(String s) throws NotAppliedException, Lang.Break {
                    return S.newBuilder(s).append(appendix).toString();
                }
            };
        }

        public static Lang.F1<String, String> prepend(final String prependix) {
            return new Lang.F1<String, String>(){

                @Override
                public String apply(String s) throws NotAppliedException, Lang.Break {
                    return S.newBuilder(prependix).append(s).toString();
                }
            };
        }

        public static Lang.Transformer<String, String> wrapper(final String left, final String right) {
            return new Lang.Transformer<String, String>(){

                @Override
                public String transform(String s) throws Lang.Break, NotAppliedException {
                    return left + s + right;
                }
            };
        }

        public static Lang.Transformer<String, String> wrapper(String wrapper) {
            return F.wrapper(wrapper, wrapper);
        }

        public static Lang.Transformer<String, String> wrapper(Lang.Tuple<String, String> wrapper) {
            return F.wrapper(wrapper.left(), wrapper.right());
        }

        public static Lang.Transformer<String, String> strip(String wrapper) {
            return F.strip(wrapper, wrapper);
        }

        public static Lang.Transformer<String, String> strip(final String left, final String right) {
            return new Lang.Transformer<String, String>(){

                @Override
                public String transform(String s) {
                    return S.strip(s, left, right);
                }
            };
        }

        public static Lang.Transformer<String, String> strip(Lang.Tuple<String, String> wrapper) {
            return F.strip(wrapper.left(), wrapper.right());
        }
    }

    public static class _StripStage {
        private String content;

        private _StripStage(Object o) {
            this.content = S.string(o);
        }

        public String of(Lang.Tuple<String, String> wrapper) {
            return S.strip(this.content, wrapper);
        }

        public String of(String left, String right) {
            return S.strip(this.content, left, right);
        }

        public String of(String wrapper) {
            return S.strip(this.content, wrapper, wrapper);
        }
    }

    public static class _CountStage {
        private String search;
        private boolean overlap;

        private _CountStage(String search) {
            this.search = S.requireNotEmpty(search);
        }

        public _CountStage withOverlap() {
            this.overlap = true;
            return this;
        }

        public int in(String text) {
            return S.count(text, this.search, this.overlap);
        }
    }

    public static class _Cut {
        private String s;

        private _Cut(Object object) {
            this.s = S.string(object);
        }

        public String by(int chars) {
            return this.first(chars);
        }

        public String first(int chars) {
            return this.s.substring(0, chars);
        }

        public String last(int chars) {
            return S.last(this.s, chars);
        }

        public String before(String search) {
            return S.before(this.s, search);
        }

        public String beforeFirst(String search) {
            return S.before(this.s, search, false);
        }

        public String beforeLast(String search) {
            return S.before(this.s, search, true);
        }

        public String after(String search) {
            return S.after(this.s, search);
        }

        public String afterFirst(String search) {
            return S.after(this.s, search, true);
        }

        public String afterLast(String search) {
            return S.after(this.s, search, false);
        }
    }

    public static class _WrapStringBuilder {
        private String content;

        private _WrapStringBuilder(String content) {
            this.content = content;
        }

        private _WrapStringBuilder(Object content) {
            this.content = S.string(content);
        }

        public String with(String wrapper) {
            return S.wrap(this.content, wrapper);
        }

        public String with(String left, String right) {
            return S.wrap(this.content, left, right);
        }

        public String with(Lang.Tuple<String, String> wrapper) {
            return S.wrap(this.content, wrapper);
        }

        public String toString() {
            return this.content;
        }
    }

    public static class _CharRepeater {
        private char c;

        private _CharRepeater(char c) {
            this.c = c;
        }

        public String times(int times) {
            return S.times(this.c, times);
        }

        public String x(int times) {
            return S.times(this.c, times);
        }

        public String forOneTime() {
            return String.valueOf(this.c);
        }

        public String forTwoTimes() {
            return this.x(2);
        }

        public String forThreeTimes() {
            return this.x(3);
        }

        public String forFourTimes() {
            return this.x(4);
        }

        public String forFiveTimes() {
            return this.x(5);
        }

        public String forTimes(int times) {
            return this.x(times);
        }
    }

    public static class _StringRepeater {
        private String content;
        private String separator;
        private Lang.Tuple<String, String> wrapper;

        private _StringRepeater(String content) {
            this.content = content;
        }

        public _StringRepeater joinedBy(String separator) {
            this.separator = separator;
            return this;
        }

        public _StringRepeater wrapWith(Lang.Tuple<String, String> wrapper) {
            this.wrapper = wrapper;
            return this;
        }

        public _StringRepeater wrapWith(String wrapper) {
            this.wrapper = S.binary(wrapper, wrapper);
            return this;
        }

        public _StringRepeater wrapWith(String left, String right) {
            this.wrapper = S.binary(left, right);
            return this;
        }

        public String times(int times) {
            String content = null == this.wrapper ? this.content : S.wrap(this.content, this.wrapper);
            return null == this.separator ? S.times(content, times) : S.join(this.separator, content, times);
        }

        public String x(int times) {
            return this.times(times);
        }

        public String forOneTime() {
            return this.content;
        }

        public String forTwoTimes() {
            return this.x(2);
        }

        public String forThreeTimes() {
            return this.x(3);
        }

        public String forFourTimes() {
            return this.x(4);
        }

        public String forFiveTimes() {
            return this.x(5);
        }

        public String forTimes(int times) {
            return this.x(times);
        }
    }

    public static class _IterableJoiner {
        private Iterable<?> iterable;
        private String separator;
        private String prefix;
        private String suffix;
        private Lang.Tuple<String, String> wrapper;
        private Lang.Predicate<String> filter;
        private boolean separateFix;

        private _IterableJoiner(Iterable<?> iterable) {
            this.iterable = $.requireNotNull(iterable);
        }

        public _IterableJoiner by(String separator) {
            this.separator = separator;
            return this;
        }

        public _IterableJoiner withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public _IterableJoiner withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public _IterableJoiner wrapElementWith(String wrapper) {
            this.wrapper = S.binary(wrapper, wrapper);
            return this;
        }

        public _IterableJoiner wrapElementWith(String left, String right) {
            this.wrapper = S.binary(left, right);
            return this;
        }

        public _IterableJoiner wrapElementWith(Lang.Tuple<String, String> wrapper) {
            this.wrapper = wrapper;
            return this;
        }

        public _IterableJoiner filter(Lang.Predicate<String> filter) {
            this.filter = $.requireNotNull(filter);
            return this;
        }

        public _IterableJoiner ignoreEmptyElement() {
            this.filter = F.NOT_EMPTY;
            return this;
        }

        public _IterableJoiner separatorWithPrefixAndSuffix() {
            this.separateFix = true;
            return this;
        }

        public String get() {
            return this.toString();
        }

        public String join() {
            return this.toString();
        }

        public String toString() {
            Iterator<?> itr;
            Buffer sb = S.buffer();
            if (null != this.prefix) {
                sb.append(this.prefix);
                if (this.separateFix) {
                    sb.append(this.separator);
                }
            }
            if ((itr = this.iterable.iterator()).hasNext()) {
                this.append(sb, null, itr.next(), this.wrapper, this.filter);
            }
            while (itr.hasNext()) {
                this.append(sb, this.separator, itr.next(), this.wrapper, this.filter);
            }
            if (null != this.suffix) {
                if (this.separateFix) {
                    sb.append(this.separator);
                }
                sb.append(this.suffix);
            }
            return sb.toString();
        }

        private void append(Buffer sb, String separator, Object o, Lang.Tuple<String, String> wrapper, Lang.Predicate<String> filter) {
            String s;
            String string = s = null == o ? null : o.toString();
            if (null != filter && !filter.test(s)) {
                return;
            }
            if (null != wrapper) {
                s = S.wrap(s, (String)wrapper._1, (String)wrapper._2);
                if (null != filter && !filter.test(s)) {
                    return;
                }
            }
            if (null != separator) {
                sb.append(separator);
            }
            sb.append(s);
        }
    }

    public static class _Have {
        private String s;

        private _Have(Object s) {
            this.s = S.string(s);
        }

        private _Have(char[] ca) {
            this.s = new String(ca);
        }

        private _Have(String s) {
            this.s = null == s ? "" : s;
        }

        public _Replace replace(String literal) {
            return new _Replace(this.s, literal);
        }

        public _Replace replace(Pattern pattern) {
            return new _Replace(this.s, pattern);
        }

        public _ReplaceChar replace(char c) {
            return new _ReplaceChar(this.s, c);
        }
    }

    public static class _ReplaceStage {
        private String keyword;
        private Pattern pattern;

        private _ReplaceStage(String keyword) {
            this.keyword = keyword;
        }

        private _ReplaceStage(Pattern pattern) {
            this.pattern = pattern;
        }

        public _Replace in(String text) {
            return null == this.pattern ? new _Replace(text, this.keyword) : new _Replace(text, this.pattern);
        }

        public _Replace2 with(String replacement) {
            return null == this.pattern ? new _Replace2(this.keyword, replacement) : new _Replace2(this.pattern, replacement);
        }
    }

    public static class _ReplaceCharStage {
        private char search;
        private char replacement;

        public _ReplaceCharStage(char search) {
            this.search = search;
        }

        public _ReplaceCharStage with(char replacement) {
            this.replacement = replacement;
            return this;
        }

        public String in(String text) {
            return text.replace(this.search, this.replacement);
        }
    }

    public static class _ReplaceChar {
        private String text;
        private char toBeReplaced;

        private _ReplaceChar(String s, char toBeReplaced) {
            this.text = S.string(s);
            this.toBeReplaced = toBeReplaced;
        }

        public String with(char replacement) {
            return this.text.replace(this.toBeReplaced, replacement);
        }
    }

    public static class _WrapReplace
    extends _Replace {
        public _WrapReplace(String text, String keyword) {
            super(text, keyword);
        }

        public String with(Lang.Tuple<String, String> wrapper) {
            return this.with(F.wrapper(wrapper));
        }

        public String with(String left, String right) {
            return this.with(F.wrapper(left, right));
        }

        @Override
        public String with(Lang.Function<String, String> replacement) {
            E.illegalStateIf(null != this.pattern, "Replace with function doesnot support regex search");
            return super.with(replacement.apply(this.keyword));
        }

        @Override
        public String with(String wrapper) {
            return this.with(wrapper, wrapper);
        }
    }

    public static class _Replace {
        private String text;
        protected String keyword;
        protected Pattern pattern;
        private StringReplace replacer = OsglConfig.DEF_STRING_REPLACE;

        private _Replace(String text, String keyword) {
            this.text = text;
            this.keyword = keyword;
        }

        private _Replace(String text, Pattern pattern) {
            this.text = text;
            this.pattern = pattern;
        }

        public _Replace usingRegEx() {
            this.pattern = Pattern.compile(this.keyword);
            return this;
        }

        public _Replace replacer(Lang.Func4<char[], char[], char[], Integer, char[]> replacer) {
            this.replacer = StringReplace.wrap(replacer);
            return this;
        }

        public String with(Lang.Function<String, String> replacement) {
            E.illegalStateIf(null != this.pattern, "Replace with function doesnot support regex search");
            return this.with(replacement.apply(this.keyword));
        }

        public String with(String replacement) {
            char[] replace;
            char[] target;
            if (null != this.pattern) {
                return this.pattern.matcher(this.text).replaceAll(replacement);
            }
            if (this.text.length() < this.keyword.length()) {
                return this.text;
            }
            int firstId = this.text.indexOf(this.keyword);
            if (firstId < 0) {
                return this.text;
            }
            char[] text = Unsafe.bufOf(this.text);
            char[] result = this.replacer.replace(text, target = this.keyword.toCharArray(), replace = replacement.toCharArray(), firstId);
            return result == text ? this.text : Unsafe.stringOf(result);
        }
    }

    public static class _Replace2 {
        private String replacement;
        private Lang.Function<String, String> replacementFunction;
        protected String keyword;
        protected Pattern pattern;
        private StringReplace replacer = OsglConfig.DEF_STRING_REPLACE;

        private _Replace2(String keyword, String replacement) {
            this.keyword = keyword;
            this.replacement = replacement;
        }

        private _Replace2(Pattern pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }

        private _Replace2(String keyword, Lang.Function<String, String> replacement) {
            this.keyword = keyword;
            this.replacementFunction = replacement;
        }

        public _Replace2 usingRegEx() {
            this.pattern = Pattern.compile(this.keyword);
            return this;
        }

        public _Replace2 replacer(Lang.Func4<char[], char[], char[], Integer, char[]> replacer) {
            this.replacer = StringReplace.wrap(replacer);
            return this;
        }

        public String in(String text) {
            char[] replace;
            char[] target;
            if (null != this.replacementFunction) {
                E.illegalStateIf(null != this.pattern, "Replace with function doesnot support regex search");
                this.replacement = this.replacementFunction.apply(this.keyword);
            }
            if (null != this.pattern) {
                return this.pattern.matcher(text).replaceAll(this.replacement);
            }
            if (text.length() < this.keyword.length()) {
                return text;
            }
            int firstId = text.indexOf(this.keyword);
            if (firstId < 0) {
                return text;
            }
            char[] textArray = Unsafe.bufOf(text);
            char[] result = this.replacer.replace(textArray, target = this.keyword.toCharArray(), replace = this.replacement.toCharArray(), firstId);
            return result == textArray ? text : Unsafe.stringOf(result);
        }
    }

    public static class _SplitStage {
        private CharSequence s;
        private String separator;
        private Pattern pattern;
        private boolean useRegex;
        private Lang.Tuple<String, String> elementWrapper;

        private _SplitStage(CharSequence s) {
            this.s = s;
        }

        public _SplitStage by(String separator) {
            if (this.useRegex) {
                this.pattern = Pattern.compile(separator);
            } else {
                this.separator = S.requireNotEmpty(separator);
            }
            return this;
        }

        public _SplitStage by(Pattern pattern) {
            this.pattern = $.requireNotNull(pattern);
            return this;
        }

        public _SplitStage stripElementWrapper(Lang.Tuple<String, String> wrapper) {
            this.elementWrapper = $.requireNotNull(wrapper);
            return this;
        }

        public _SplitStage stripElementWrapper(String prefix, String suffix) {
            this.elementWrapper = S.pair(prefix, suffix);
            return this;
        }

        public _SplitStage useRegex() {
            this.useRegex = true;
            if (null == this.pattern && S.isNotEmpty(this.separator)) {
                this.pattern = Pattern.compile(this.separator);
            }
            return this;
        }

        public C.List<String> get() {
            C.List<String> list;
            if (S.isEmpty(this.s)) {
                return S.list();
            }
            E.illegalStateIf($.allNull(this.separator, this.pattern));
            if (this.useRegex && null == this.pattern) {
                this.pattern = Pattern.compile(this.separator);
                list = S.split(this.s, this.pattern);
            } else {
                list = S.fastSplit(this.s.toString(), this.separator);
            }
            if (null != this.elementWrapper) {
                list = list.map(F.strip(this.elementWrapper));
            }
            return list;
        }
    }

    public static class _Ensure {
        private String s;

        private _Ensure(Object object) {
            this.s = S.string(object);
        }

        public String startWith(String prefix) {
            return S.ensureStartsWith(this.s, prefix);
        }

        public String startWith(char prefix) {
            return S.ensureStartsWith(this.s, prefix);
        }

        public String endWith(String suffix) {
            return S.ensureEndsWith(this.s, suffix);
        }

        public String endWith(char suffix) {
            return S.ensureEndsWith(this.s, suffix);
        }

        public String wrappedWith(String left, String right) {
            return S.ensureWrappedWith(this.s, left, right);
        }

        public String wrappedWith(String wrapper) {
            return S.ensureWrappedWith(this.s, wrapper, wrapper);
        }

        public String wrappedWith(Lang.Tuple<String, String> wrapper) {
            return S.ensureWrappedWith(this.s, wrapper);
        }

        public String strippedOff(String left, String right) {
            return S.ensureStrippedOff(this.s, left, right);
        }

        public String strippedOff(String wrapper) {
            return S.ensureStrippedOff(this.s, wrapper, wrapper);
        }

        public String strippedOff(Lang.Tuple<String, String> wrapper) {
            return S.ensureStrippedOff(this.s, wrapper);
        }
    }

    public static class _Is {
        private String s;

        private _Is(Object object) {
            this.s = S.string(object);
        }

        public boolean empty() {
            return this.s.isEmpty();
        }

        public boolean blank() {
            return this.s.trim().isEmpty();
        }

        public boolean contains(CharSequence content) {
            return this.s.contains(content);
        }

        public boolean startsWith(String prefix, int toffset) {
            return this.s.startsWith(prefix, toffset);
        }

        public boolean startsWith(String prefix) {
            return this.s.startsWith(prefix);
        }

        public boolean endsWith(String suffix) {
            return this.s.endsWith(suffix);
        }

        public boolean equalsTo(CharSequence content) {
            return null == content ? S.isEmpty(this.s) : this.s.contentEquals(content);
        }

        public boolean numeric() {
            return N.isNumeric(this.s);
        }

        public boolean integer() {
            return N.isInt(this.s);
        }

        public boolean wrappedWith(String left, String right) {
            return this.s.length() >= left.length() + right.length() && this.s.startsWith(left) && this.s.endsWith(right);
        }

        public boolean wrappedWith(Lang.Tuple<String, String> wrapper) {
            return this.wrappedWith(wrapper.left(), wrapper.right());
        }
    }
}

