/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.DelegatingList;
import org.osgl.util.Nil;
import org.osgl.util.ReverseListIterator;

class ReverseList<T>
extends DelegatingList<T>
implements C.List<T> {
    private ReverseList(C.List<T> list) {
        super(true);
        this.data = list;
    }

    C.List<T> data() {
        return (C.List)this.data;
    }

    @Override
    protected EnumSet<C.Feature> initFeatures() {
        EnumSet<C.Feature> fs = this.data().features();
        fs.add(C.Feature.READONLY);
        return fs;
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new ReverseListIterator(this.data().listIterator(this.size() - index));
    }

    @Override
    public T get(int index) {
        return (T)this.data.get(this.size() - index - 1);
    }

    @Override
    protected void forEachLeft(Lang.Visitor<? super T> visitor) throws Lang.Break {
        this.data().acceptRight(visitor);
    }

    @Override
    protected void forEachRight(Lang.Visitor<? super T> visitor) throws Lang.Break {
        this.data().acceptLeft(visitor);
    }

    @Override
    public <R> R reduceLeft(R identity, Lang.Func2<R, T, R> accumulator) {
        return this.data().reduceRight(identity, accumulator);
    }

    @Override
    public Lang.Option<T> reduceLeft(Lang.Func2<T, T, T> accumulator) {
        return this.data().reduceRight(accumulator);
    }

    @Override
    public <R> R reduceRight(R identity, Lang.Func2<R, T, R> accumulator) {
        return this.data().reduceLeft(identity, accumulator);
    }

    @Override
    public Lang.Option<T> reduceRight(Lang.Func2<T, T, T> accumulator) {
        return this.data().reduceLeft(accumulator);
    }

    @Override
    public T head() throws NoSuchElementException {
        return this.data().last();
    }

    @Override
    public T last() throws NoSuchElementException {
        return this.data().head();
    }

    @Override
    public Iterator<T> reverseIterator() {
        return this.data().iterator();
    }

    @Override
    public C.List<T> reverse() {
        return this.data();
    }

    @Override
    public C.List<T> subList(int fromIndex, int toIndex) {
        return this.data().subList(toIndex - 1, fromIndex - 1);
    }

    static <T> C.List<T> wrap(C.List<T> list) {
        if (list instanceof ReverseList) {
            return ((ReverseList)list).data();
        }
        if (list.size() == 0 && list.is(C.Feature.IMMUTABLE)) {
            return Nil.list();
        }
        return new ReverseList<T>(list);
    }
}

