/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.osgl.util.C;
import org.osgl.util.CursorBase;
import org.osgl.util.E;

class ListIteratorCursor<T>
extends CursorBase<T>
implements C.List.Cursor<T> {
    private final ListIterator<T> itr_;
    private boolean parked = false;

    ListIteratorCursor(ListIterator<T> itr) {
        E.NPE(itr);
        this.itr_ = itr;
    }

    @Override
    public T next() {
        return this.itr_.next();
    }

    @Override
    public T previous() {
        return this.itr_.previous();
    }

    @Override
    public void update(T t) throws IndexOutOfBoundsException, NullPointerException {
        this.itr_.previous();
        this.itr_.set(t);
    }

    @Override
    public void remove() throws NoSuchElementException {
        this.itr_.remove();
    }

    @Override
    public void add(T t) throws IndexOutOfBoundsException {
        this.itr_.add(t);
    }

    @Override
    public int index() {
        return this.itr_.previousIndex();
    }

    @Override
    public boolean hasNext() {
        return this.itr_.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.itr_.hasPrevious();
    }

    @Override
    public C.List.Cursor<T> parkLeft() {
        while (this.itr_.hasPrevious()) {
            this.itr_.previous();
        }
        this.parked = true;
        return this;
    }

    @Override
    public C.List.Cursor<T> parkRight() {
        while (this.itr_.hasNext()) {
            this.itr_.nextIndex();
        }
        this.parked = true;
        return this;
    }
}

